from torchaudio._internal.module_utils import dropping_class_support

from ._multi_channel import MVDR, PSD, RTFMVDR, SoudenMVDR
from ._transforms import (
    AddNoise,
    AmplitudeToDB,
    ComputeDeltas,
    Convolve,
    Deemphasis,
    Fade,
    FFTConvolve,
    FrequencyMasking,
    GriffinLim,
    InverseMelScale,
    InverseSpectrogram,
    LFCC,
    Loudness,
    MelScale,
    MelSpectrogram,
    MFCC,
    MuLawDecoding,
    MuLawEncoding,
    PitchShift,
    Preemphasis,
    Resample,
    RNNTLoss as _RNNTLoss,
    SlidingWindowCmn,
    SpecAugment,
    SpectralCentroid,
    Spectrogram,
    Speed,
    SpeedPerturbation,
    TimeMasking,
    TimeStretch,
    Vad,
    Vol,
)

RNNTLoss = dropping_class_support(_RNNTLoss)

__all__ = [
    "AddNoise",
    "AmplitudeToDB",
    "ComputeDeltas",
    "Convolve",
    "Deemphasis",
    "Fade",
    "FFTConvolve",
    "FrequencyMasking",
    "GriffinLim",
    "InverseMelScale",
    "InverseSpectrogram",
    "LFCC",
    "Loudness",
    "MFCC",
    "MVDR",
    "MelScale",
    "MelSpectrogram",
    "MuLawDecoding",
    "MuLawEncoding",
    "PSD",
    "PitchShift",
    "Preemphasis",
    "RNNTLoss",
    "RTFMVDR",
    "Resample",
    "SlidingWindowCmn",
    "SoudenMVDR",
    "SpecAugment",
    "SpectralCentroid",
    "Spectrogram",
    "Speed",
    "SpeedPerturbation",
    "TimeMasking",
    "TimeStretch",
    "Vad",
    "Vol",
]
