# SPDX-FileCopyrightText: Copyright (c) 2025 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
#
# SPDX-License-Identifier: LicenseRef-NVIDIA-SOFTWARE-LICENSE
#
# This code was automatically generated across versions from 12.9.1 to 13.1.0. Do not modify it directly.

cimport cython  # NOQA
from cython cimport view
cimport cpython

from ._internal.utils cimport (get_buffer_pointer, get_nested_resource_ptr,
                               nested_resource)

from enum import IntEnum as _IntEnum

from cuda.bindings.cydriver cimport CUDA_VERSION


from libc.stdlib cimport calloc, free, malloc
from cython cimport view
cimport cpython.buffer
cimport cpython.memoryview
from libc.string cimport memcmp, memcpy
import numpy as _numpy


cdef __from_data(data, dtype_name, expected_dtype, lowpp_type):
    # _numpy.recarray is a subclass of _numpy.ndarray, so implicitly handled here.
    if isinstance(data, lowpp_type):
        return data
    if not isinstance(data, _numpy.ndarray):
        raise TypeError("data argument must be a NumPy ndarray")
    if data.size != 1:
        raise ValueError("data array must have a size of 1")
    if data.dtype != expected_dtype:
        raise ValueError(f"data array must be of dtype {dtype_name}")
    return lowpp_type.from_ptr(data.ctypes.data, not data.flags.writeable, data)


###############################################################################
# Enum
###############################################################################

class BridgeChipType(_IntEnum):
    """See `nvmlBridgeChipType_t`."""
    BRIDGE_CHIP_PLX = NVML_BRIDGE_CHIP_PLX
    BRIDGE_CHIP_BRO4 = NVML_BRIDGE_CHIP_BRO4

class NvLinkUtilizationCountUnits(_IntEnum):
    """See `nvmlNvLinkUtilizationCountUnits_t`."""
    NVLINK_COUNTER_UNIT_CYCLES = NVML_NVLINK_COUNTER_UNIT_CYCLES
    NVLINK_COUNTER_UNIT_PACKETS = NVML_NVLINK_COUNTER_UNIT_PACKETS
    NVLINK_COUNTER_UNIT_BYTES = NVML_NVLINK_COUNTER_UNIT_BYTES
    NVLINK_COUNTER_UNIT_RESERVED = NVML_NVLINK_COUNTER_UNIT_RESERVED
    NVLINK_COUNTER_UNIT_COUNT = NVML_NVLINK_COUNTER_UNIT_COUNT

class NvLinkUtilizationCountPktTypes(_IntEnum):
    """See `nvmlNvLinkUtilizationCountPktTypes_t`."""
    NVLINK_COUNTER_PKTFILTER_NOP = NVML_NVLINK_COUNTER_PKTFILTER_NOP
    NVLINK_COUNTER_PKTFILTER_READ = NVML_NVLINK_COUNTER_PKTFILTER_READ
    NVLINK_COUNTER_PKTFILTER_WRITE = NVML_NVLINK_COUNTER_PKTFILTER_WRITE
    NVLINK_COUNTER_PKTFILTER_RATOM = NVML_NVLINK_COUNTER_PKTFILTER_RATOM
    NVLINK_COUNTER_PKTFILTER_NRATOM = NVML_NVLINK_COUNTER_PKTFILTER_NRATOM
    NVLINK_COUNTER_PKTFILTER_FLUSH = NVML_NVLINK_COUNTER_PKTFILTER_FLUSH
    NVLINK_COUNTER_PKTFILTER_RESPDATA = NVML_NVLINK_COUNTER_PKTFILTER_RESPDATA
    NVLINK_COUNTER_PKTFILTER_RESPNODATA = NVML_NVLINK_COUNTER_PKTFILTER_RESPNODATA
    NVLINK_COUNTER_PKTFILTER_ALL = NVML_NVLINK_COUNTER_PKTFILTER_ALL

class NvLinkCapability(_IntEnum):
    """See `nvmlNvLinkCapability_t`."""
    NVLINK_CAP_P2P_SUPPORTED = NVML_NVLINK_CAP_P2P_SUPPORTED
    NVLINK_CAP_SYSMEM_ACCESS = NVML_NVLINK_CAP_SYSMEM_ACCESS
    NVLINK_CAP_P2P_ATOMICS = NVML_NVLINK_CAP_P2P_ATOMICS
    NVLINK_CAP_SYSMEM_ATOMICS = NVML_NVLINK_CAP_SYSMEM_ATOMICS
    NVLINK_CAP_SLI_BRIDGE = NVML_NVLINK_CAP_SLI_BRIDGE
    NVLINK_CAP_VALID = NVML_NVLINK_CAP_VALID
    NVLINK_CAP_COUNT = NVML_NVLINK_CAP_COUNT

class NvLinkErrorCounter(_IntEnum):
    """See `nvmlNvLinkErrorCounter_t`."""
    NVLINK_ERROR_DL_REPLAY = NVML_NVLINK_ERROR_DL_REPLAY
    NVLINK_ERROR_DL_RECOVERY = NVML_NVLINK_ERROR_DL_RECOVERY
    NVLINK_ERROR_DL_CRC_FLIT = NVML_NVLINK_ERROR_DL_CRC_FLIT
    NVLINK_ERROR_DL_CRC_DATA = NVML_NVLINK_ERROR_DL_CRC_DATA
    NVLINK_ERROR_DL_ECC_DATA = NVML_NVLINK_ERROR_DL_ECC_DATA
    NVLINK_ERROR_COUNT = NVML_NVLINK_ERROR_COUNT

class IntNvLinkDeviceType(_IntEnum):
    """See `nvmlIntNvLinkDeviceType_t`."""
    NVLINK_DEVICE_TYPE_GPU = NVML_NVLINK_DEVICE_TYPE_GPU
    NVLINK_DEVICE_TYPE_IBMNPU = NVML_NVLINK_DEVICE_TYPE_IBMNPU
    NVLINK_DEVICE_TYPE_SWITCH = NVML_NVLINK_DEVICE_TYPE_SWITCH
    NVLINK_DEVICE_TYPE_UNKNOWN = NVML_NVLINK_DEVICE_TYPE_UNKNOWN

class GpuTopologyLevel(_IntEnum):
    """See `nvmlGpuTopologyLevel_t`."""
    TOPOLOGY_INTERNAL = NVML_TOPOLOGY_INTERNAL
    TOPOLOGY_SINGLE = NVML_TOPOLOGY_SINGLE
    TOPOLOGY_MULTIPLE = NVML_TOPOLOGY_MULTIPLE
    TOPOLOGY_HOSTBRIDGE = NVML_TOPOLOGY_HOSTBRIDGE
    TOPOLOGY_NODE = NVML_TOPOLOGY_NODE
    TOPOLOGY_SYSTEM = NVML_TOPOLOGY_SYSTEM

class GpuP2PStatus(_IntEnum):
    """See `nvmlGpuP2PStatus_t`."""
    P2P_STATUS_OK = NVML_P2P_STATUS_OK
    P2P_STATUS_CHIPSET_NOT_SUPPORED = NVML_P2P_STATUS_CHIPSET_NOT_SUPPORED
    P2P_STATUS_CHIPSET_NOT_SUPPORTED = NVML_P2P_STATUS_CHIPSET_NOT_SUPPORTED
    P2P_STATUS_GPU_NOT_SUPPORTED = NVML_P2P_STATUS_GPU_NOT_SUPPORTED
    P2P_STATUS_IOH_TOPOLOGY_NOT_SUPPORTED = NVML_P2P_STATUS_IOH_TOPOLOGY_NOT_SUPPORTED
    P2P_STATUS_DISABLED_BY_REGKEY = NVML_P2P_STATUS_DISABLED_BY_REGKEY
    P2P_STATUS_NOT_SUPPORTED = NVML_P2P_STATUS_NOT_SUPPORTED
    P2P_STATUS_UNKNOWN = NVML_P2P_STATUS_UNKNOWN

class GpuP2PCapsIndex(_IntEnum):
    """See `nvmlGpuP2PCapsIndex_t`."""
    P2P_CAPS_INDEX_READ = NVML_P2P_CAPS_INDEX_READ
    P2P_CAPS_INDEX_WRITE = NVML_P2P_CAPS_INDEX_WRITE
    P2P_CAPS_INDEX_NVLINK = NVML_P2P_CAPS_INDEX_NVLINK
    P2P_CAPS_INDEX_ATOMICS = NVML_P2P_CAPS_INDEX_ATOMICS
    P2P_CAPS_INDEX_PCI = NVML_P2P_CAPS_INDEX_PCI
    P2P_CAPS_INDEX_PROP = NVML_P2P_CAPS_INDEX_PROP
    P2P_CAPS_INDEX_UNKNOWN = NVML_P2P_CAPS_INDEX_UNKNOWN

class SamplingType(_IntEnum):
    """See `nvmlSamplingType_t`."""
    TOTAL_POWER_SAMPLES = NVML_TOTAL_POWER_SAMPLES
    GPU_UTILIZATION_SAMPLES = NVML_GPU_UTILIZATION_SAMPLES
    MEMORY_UTILIZATION_SAMPLES = NVML_MEMORY_UTILIZATION_SAMPLES
    ENC_UTILIZATION_SAMPLES = NVML_ENC_UTILIZATION_SAMPLES
    DEC_UTILIZATION_SAMPLES = NVML_DEC_UTILIZATION_SAMPLES
    PROCESSOR_CLK_SAMPLES = NVML_PROCESSOR_CLK_SAMPLES
    MEMORY_CLK_SAMPLES = NVML_MEMORY_CLK_SAMPLES
    MODULE_POWER_SAMPLES = NVML_MODULE_POWER_SAMPLES
    JPG_UTILIZATION_SAMPLES = NVML_JPG_UTILIZATION_SAMPLES
    OFA_UTILIZATION_SAMPLES = NVML_OFA_UTILIZATION_SAMPLES
    SAMPLINGTYPE_COUNT = NVML_SAMPLINGTYPE_COUNT

class PcieUtilCounter(_IntEnum):
    """See `nvmlPcieUtilCounter_t`."""
    PCIE_UTIL_TX_BYTES = NVML_PCIE_UTIL_TX_BYTES
    PCIE_UTIL_RX_BYTES = NVML_PCIE_UTIL_RX_BYTES
    PCIE_UTIL_COUNT = NVML_PCIE_UTIL_COUNT

class ValueType(_IntEnum):
    """See `nvmlValueType_t`."""
    DOUBLE = NVML_VALUE_TYPE_DOUBLE
    UNSIGNED_INT = NVML_VALUE_TYPE_UNSIGNED_INT
    UNSIGNED_LONG = NVML_VALUE_TYPE_UNSIGNED_LONG
    UNSIGNED_LONG_LONG = NVML_VALUE_TYPE_UNSIGNED_LONG_LONG
    SIGNED_LONG_LONG = NVML_VALUE_TYPE_SIGNED_LONG_LONG
    SIGNED_INT = NVML_VALUE_TYPE_SIGNED_INT
    UNSIGNED_SHORT = NVML_VALUE_TYPE_UNSIGNED_SHORT
    COUNT = NVML_VALUE_TYPE_COUNT

class PerfPolicyType(_IntEnum):
    """See `nvmlPerfPolicyType_t`."""
    PERF_POLICY_POWER = NVML_PERF_POLICY_POWER
    PERF_POLICY_THERMAL = NVML_PERF_POLICY_THERMAL
    PERF_POLICY_SYNC_BOOST = NVML_PERF_POLICY_SYNC_BOOST
    PERF_POLICY_BOARD_LIMIT = NVML_PERF_POLICY_BOARD_LIMIT
    PERF_POLICY_LOW_UTILIZATION = NVML_PERF_POLICY_LOW_UTILIZATION
    PERF_POLICY_RELIABILITY = NVML_PERF_POLICY_RELIABILITY
    PERF_POLICY_TOTAL_APP_CLOCKS = NVML_PERF_POLICY_TOTAL_APP_CLOCKS
    PERF_POLICY_TOTAL_BASE_CLOCKS = NVML_PERF_POLICY_TOTAL_BASE_CLOCKS
    PERF_POLICY_COUNT = NVML_PERF_POLICY_COUNT

class ThermalTarget(_IntEnum):
    """See `nvmlThermalTarget_t`."""
    NONE = NVML_THERMAL_TARGET_NONE
    GPU = NVML_THERMAL_TARGET_GPU
    MEMORY = NVML_THERMAL_TARGET_MEMORY
    POWER_SUPPLY = NVML_THERMAL_TARGET_POWER_SUPPLY
    BOARD = NVML_THERMAL_TARGET_BOARD
    VCD_BOARD = NVML_THERMAL_TARGET_VCD_BOARD
    VCD_INLET = NVML_THERMAL_TARGET_VCD_INLET
    VCD_OUTLET = NVML_THERMAL_TARGET_VCD_OUTLET
    ALL = NVML_THERMAL_TARGET_ALL
    UNKNOWN = NVML_THERMAL_TARGET_UNKNOWN

class ThermalController(_IntEnum):
    """See `nvmlThermalController_t`."""
    NONE = NVML_THERMAL_CONTROLLER_NONE
    GPU_INTERNAL = NVML_THERMAL_CONTROLLER_GPU_INTERNAL
    ADM1032 = NVML_THERMAL_CONTROLLER_ADM1032
    ADT7461 = NVML_THERMAL_CONTROLLER_ADT7461
    MAX6649 = NVML_THERMAL_CONTROLLER_MAX6649
    MAX1617 = NVML_THERMAL_CONTROLLER_MAX1617
    LM99 = NVML_THERMAL_CONTROLLER_LM99
    LM89 = NVML_THERMAL_CONTROLLER_LM89
    LM64 = NVML_THERMAL_CONTROLLER_LM64
    G781 = NVML_THERMAL_CONTROLLER_G781
    ADT7473 = NVML_THERMAL_CONTROLLER_ADT7473
    SBMAX6649 = NVML_THERMAL_CONTROLLER_SBMAX6649
    VBIOSEVT = NVML_THERMAL_CONTROLLER_VBIOSEVT
    OS = NVML_THERMAL_CONTROLLER_OS
    NVSYSCON_CANOAS = NVML_THERMAL_CONTROLLER_NVSYSCON_CANOAS
    NVSYSCON_E551 = NVML_THERMAL_CONTROLLER_NVSYSCON_E551
    MAX6649R = NVML_THERMAL_CONTROLLER_MAX6649R
    ADT7473S = NVML_THERMAL_CONTROLLER_ADT7473S
    UNKNOWN = NVML_THERMAL_CONTROLLER_UNKNOWN

class CoolerControl(_IntEnum):
    """See `nvmlCoolerControl_t`."""
    THERMAL_COOLER_SIGNAL_NONE = NVML_THERMAL_COOLER_SIGNAL_NONE
    THERMAL_COOLER_SIGNAL_TOGGLE = NVML_THERMAL_COOLER_SIGNAL_TOGGLE
    THERMAL_COOLER_SIGNAL_VARIABLE = NVML_THERMAL_COOLER_SIGNAL_VARIABLE
    THERMAL_COOLER_SIGNAL_COUNT = NVML_THERMAL_COOLER_SIGNAL_COUNT

class CoolerTarget(_IntEnum):
    """See `nvmlCoolerTarget_t`."""
    THERMAL_NONE = NVML_THERMAL_COOLER_TARGET_NONE
    THERMAL_GPU = NVML_THERMAL_COOLER_TARGET_GPU
    THERMAL_MEMORY = NVML_THERMAL_COOLER_TARGET_MEMORY
    THERMAL_POWER_SUPPLY = NVML_THERMAL_COOLER_TARGET_POWER_SUPPLY
    THERMAL_GPU_RELATED = NVML_THERMAL_COOLER_TARGET_GPU_RELATED

class UUIDType(_IntEnum):
    """See `nvmlUUIDType_t`."""
    NONE = NVML_UUID_TYPE_NONE
    ASCII = NVML_UUID_TYPE_ASCII
    BINARY = NVML_UUID_TYPE_BINARY

class EnableState(_IntEnum):
    """See `nvmlEnableState_t`."""
    FEATURE_DISABLED = NVML_FEATURE_DISABLED
    FEATURE_ENABLED = NVML_FEATURE_ENABLED

class BrandType(_IntEnum):
    """See `nvmlBrandType_t`."""
    BRAND_UNKNOWN = NVML_BRAND_UNKNOWN
    BRAND_QUADRO = NVML_BRAND_QUADRO
    BRAND_TESLA = NVML_BRAND_TESLA
    BRAND_NVS = NVML_BRAND_NVS
    BRAND_GRID = NVML_BRAND_GRID
    BRAND_GEFORCE = NVML_BRAND_GEFORCE
    BRAND_TITAN = NVML_BRAND_TITAN
    BRAND_NVIDIA_VAPPS = NVML_BRAND_NVIDIA_VAPPS
    BRAND_NVIDIA_VPC = NVML_BRAND_NVIDIA_VPC
    BRAND_NVIDIA_VCS = NVML_BRAND_NVIDIA_VCS
    BRAND_NVIDIA_VWS = NVML_BRAND_NVIDIA_VWS
    BRAND_NVIDIA_CLOUD_GAMING = NVML_BRAND_NVIDIA_CLOUD_GAMING
    BRAND_NVIDIA_VGAMING = NVML_BRAND_NVIDIA_VGAMING
    BRAND_QUADRO_RTX = NVML_BRAND_QUADRO_RTX
    BRAND_NVIDIA_RTX = NVML_BRAND_NVIDIA_RTX
    BRAND_NVIDIA = NVML_BRAND_NVIDIA
    BRAND_GEFORCE_RTX = NVML_BRAND_GEFORCE_RTX
    BRAND_TITAN_RTX = NVML_BRAND_TITAN_RTX
    BRAND_COUNT = NVML_BRAND_COUNT

class TemperatureThresholds(_IntEnum):
    """See `nvmlTemperatureThresholds_t`."""
    TEMPERATURE_THRESHOLD_SHUTDOWN = NVML_TEMPERATURE_THRESHOLD_SHUTDOWN
    TEMPERATURE_THRESHOLD_SLOWDOWN = NVML_TEMPERATURE_THRESHOLD_SLOWDOWN
    TEMPERATURE_THRESHOLD_MEM_MAX = NVML_TEMPERATURE_THRESHOLD_MEM_MAX
    TEMPERATURE_THRESHOLD_GPU_MAX = NVML_TEMPERATURE_THRESHOLD_GPU_MAX
    TEMPERATURE_THRESHOLD_ACOUSTIC_MIN = NVML_TEMPERATURE_THRESHOLD_ACOUSTIC_MIN
    TEMPERATURE_THRESHOLD_ACOUSTIC_CURR = NVML_TEMPERATURE_THRESHOLD_ACOUSTIC_CURR
    TEMPERATURE_THRESHOLD_ACOUSTIC_MAX = NVML_TEMPERATURE_THRESHOLD_ACOUSTIC_MAX
    TEMPERATURE_THRESHOLD_GPS_CURR = NVML_TEMPERATURE_THRESHOLD_GPS_CURR
    TEMPERATURE_THRESHOLD_COUNT = NVML_TEMPERATURE_THRESHOLD_COUNT

class TemperatureSensors(_IntEnum):
    """See `nvmlTemperatureSensors_t`."""
    TEMPERATURE_GPU = NVML_TEMPERATURE_GPU
    TEMPERATURE_COUNT = NVML_TEMPERATURE_COUNT

class ComputeMode(_IntEnum):
    """See `nvmlComputeMode_t`."""
    COMPUTEMODE_DEFAULT = NVML_COMPUTEMODE_DEFAULT
    COMPUTEMODE_EXCLUSIVE_THREAD = NVML_COMPUTEMODE_EXCLUSIVE_THREAD
    COMPUTEMODE_PROHIBITED = NVML_COMPUTEMODE_PROHIBITED
    COMPUTEMODE_EXCLUSIVE_PROCESS = NVML_COMPUTEMODE_EXCLUSIVE_PROCESS
    COMPUTEMODE_COUNT = NVML_COMPUTEMODE_COUNT

class MemoryErrorType(_IntEnum):
    """See `nvmlMemoryErrorType_t`."""
    CORRECTED = NVML_MEMORY_ERROR_TYPE_CORRECTED
    UNCORRECTED = NVML_MEMORY_ERROR_TYPE_UNCORRECTED
    COUNT = NVML_MEMORY_ERROR_TYPE_COUNT

class NvlinkVersion(_IntEnum):
    """See `nvmlNvlinkVersion_t`."""
    VERSION_INVALID = NVML_NVLINK_VERSION_INVALID
    VERSION_1_0 = NVML_NVLINK_VERSION_1_0
    VERSION_2_0 = NVML_NVLINK_VERSION_2_0
    VERSION_2_2 = NVML_NVLINK_VERSION_2_2
    VERSION_3_0 = NVML_NVLINK_VERSION_3_0
    VERSION_3_1 = NVML_NVLINK_VERSION_3_1
    VERSION_4_0 = NVML_NVLINK_VERSION_4_0
    VERSION_5_0 = NVML_NVLINK_VERSION_5_0

class EccCounterType(_IntEnum):
    """See `nvmlEccCounterType_t`."""
    VOLATILE_ECC = NVML_VOLATILE_ECC
    AGGREGATE_ECC = NVML_AGGREGATE_ECC
    COUNT = NVML_ECC_COUNTER_TYPE_COUNT

class ClockType(_IntEnum):
    """See `nvmlClockType_t`."""
    CLOCK_GRAPHICS = NVML_CLOCK_GRAPHICS
    CLOCK_SM = NVML_CLOCK_SM
    CLOCK_MEM = NVML_CLOCK_MEM
    CLOCK_VIDEO = NVML_CLOCK_VIDEO
    CLOCK_COUNT = NVML_CLOCK_COUNT

class ClockId(_IntEnum):
    """See `nvmlClockId_t`."""
    CURRENT = NVML_CLOCK_ID_CURRENT
    APP_CLOCK_TARGET = NVML_CLOCK_ID_APP_CLOCK_TARGET
    APP_CLOCK_DEFAULT = NVML_CLOCK_ID_APP_CLOCK_DEFAULT
    CUSTOMER_BOOST_MAX = NVML_CLOCK_ID_CUSTOMER_BOOST_MAX
    COUNT = NVML_CLOCK_ID_COUNT

class DriverModel(_IntEnum):
    """See `nvmlDriverModel_t`."""
    DRIVER_WDDM = NVML_DRIVER_WDDM
    DRIVER_WDM = NVML_DRIVER_WDM
    DRIVER_MCDM = NVML_DRIVER_MCDM

class Pstates(_IntEnum):
    """See `nvmlPstates_t`."""
    PSTATE_0 = NVML_PSTATE_0
    PSTATE_1 = NVML_PSTATE_1
    PSTATE_2 = NVML_PSTATE_2
    PSTATE_3 = NVML_PSTATE_3
    PSTATE_4 = NVML_PSTATE_4
    PSTATE_5 = NVML_PSTATE_5
    PSTATE_6 = NVML_PSTATE_6
    PSTATE_7 = NVML_PSTATE_7
    PSTATE_8 = NVML_PSTATE_8
    PSTATE_9 = NVML_PSTATE_9
    PSTATE_10 = NVML_PSTATE_10
    PSTATE_11 = NVML_PSTATE_11
    PSTATE_12 = NVML_PSTATE_12
    PSTATE_13 = NVML_PSTATE_13
    PSTATE_14 = NVML_PSTATE_14
    PSTATE_15 = NVML_PSTATE_15
    PSTATE_UNKNOWN = NVML_PSTATE_UNKNOWN

class GpuOperationMode(_IntEnum):
    """See `nvmlGpuOperationMode_t`."""
    GOM_ALL_ON = NVML_GOM_ALL_ON
    GOM_COMPUTE = NVML_GOM_COMPUTE
    GOM_LOW_DP = NVML_GOM_LOW_DP

class InforomObject(_IntEnum):
    """See `nvmlInforomObject_t`."""
    INFOROM_OEM = NVML_INFOROM_OEM
    INFOROM_ECC = NVML_INFOROM_ECC
    INFOROM_POWER = NVML_INFOROM_POWER
    INFOROM_DEN = NVML_INFOROM_DEN
    INFOROM_COUNT = NVML_INFOROM_COUNT

class Return(_IntEnum):
    """See `nvmlReturn_t`."""
    SUCCESS = NVML_SUCCESS
    ERROR_UNINITIALIZED = NVML_ERROR_UNINITIALIZED
    ERROR_INVALID_ARGUMENT = NVML_ERROR_INVALID_ARGUMENT
    ERROR_NOT_SUPPORTED = NVML_ERROR_NOT_SUPPORTED
    ERROR_NO_PERMISSION = NVML_ERROR_NO_PERMISSION
    ERROR_ALREADY_INITIALIZED = NVML_ERROR_ALREADY_INITIALIZED
    ERROR_NOT_FOUND = NVML_ERROR_NOT_FOUND
    ERROR_INSUFFICIENT_SIZE = NVML_ERROR_INSUFFICIENT_SIZE
    ERROR_INSUFFICIENT_POWER = NVML_ERROR_INSUFFICIENT_POWER
    ERROR_DRIVER_NOT_LOADED = NVML_ERROR_DRIVER_NOT_LOADED
    ERROR_TIMEOUT = NVML_ERROR_TIMEOUT
    ERROR_IRQ_ISSUE = NVML_ERROR_IRQ_ISSUE
    ERROR_LIBRARY_NOT_FOUND = NVML_ERROR_LIBRARY_NOT_FOUND
    ERROR_FUNCTION_NOT_FOUND = NVML_ERROR_FUNCTION_NOT_FOUND
    ERROR_CORRUPTED_INFOROM = NVML_ERROR_CORRUPTED_INFOROM
    ERROR_GPU_IS_LOST = NVML_ERROR_GPU_IS_LOST
    ERROR_RESET_REQUIRED = NVML_ERROR_RESET_REQUIRED
    ERROR_OPERATING_SYSTEM = NVML_ERROR_OPERATING_SYSTEM
    ERROR_LIB_RM_VERSION_MISMATCH = NVML_ERROR_LIB_RM_VERSION_MISMATCH
    ERROR_IN_USE = NVML_ERROR_IN_USE
    ERROR_MEMORY = NVML_ERROR_MEMORY
    ERROR_NO_DATA = NVML_ERROR_NO_DATA
    ERROR_VGPU_ECC_NOT_SUPPORTED = NVML_ERROR_VGPU_ECC_NOT_SUPPORTED
    ERROR_INSUFFICIENT_RESOURCES = NVML_ERROR_INSUFFICIENT_RESOURCES
    ERROR_FREQ_NOT_SUPPORTED = NVML_ERROR_FREQ_NOT_SUPPORTED
    ERROR_ARGUMENT_VERSION_MISMATCH = NVML_ERROR_ARGUMENT_VERSION_MISMATCH
    ERROR_DEPRECATED = NVML_ERROR_DEPRECATED
    ERROR_NOT_READY = NVML_ERROR_NOT_READY
    ERROR_GPU_NOT_FOUND = NVML_ERROR_GPU_NOT_FOUND
    ERROR_INVALID_STATE = NVML_ERROR_INVALID_STATE
    ERROR_RESET_TYPE_NOT_SUPPORTED = NVML_ERROR_RESET_TYPE_NOT_SUPPORTED
    ERROR_UNKNOWN = NVML_ERROR_UNKNOWN

class MemoryLocation(_IntEnum):
    """See `nvmlMemoryLocation_t`."""
    L1_CACHE = NVML_MEMORY_LOCATION_L1_CACHE
    L2_CACHE = NVML_MEMORY_LOCATION_L2_CACHE
    DRAM = NVML_MEMORY_LOCATION_DRAM
    DEVICE_MEMORY = NVML_MEMORY_LOCATION_DEVICE_MEMORY
    REGISTER_FILE = NVML_MEMORY_LOCATION_REGISTER_FILE
    TEXTURE_MEMORY = NVML_MEMORY_LOCATION_TEXTURE_MEMORY
    TEXTURE_SHM = NVML_MEMORY_LOCATION_TEXTURE_SHM
    CBU = NVML_MEMORY_LOCATION_CBU
    SRAM = NVML_MEMORY_LOCATION_SRAM
    COUNT = NVML_MEMORY_LOCATION_COUNT

class PageRetirementCause(_IntEnum):
    """See `nvmlPageRetirementCause_t`."""
    MULTIPLE_SINGLE_BIT_ECC_ERRORS = NVML_PAGE_RETIREMENT_CAUSE_MULTIPLE_SINGLE_BIT_ECC_ERRORS
    DOUBLE_BIT_ECC_ERROR = NVML_PAGE_RETIREMENT_CAUSE_DOUBLE_BIT_ECC_ERROR
    COUNT = NVML_PAGE_RETIREMENT_CAUSE_COUNT

class RestrictedAPI(_IntEnum):
    """See `nvmlRestrictedAPI_t`."""
    SET_APPLICATION_CLOCKS = NVML_RESTRICTED_API_SET_APPLICATION_CLOCKS
    SET_AUTO_BOOSTED_CLOCKS = NVML_RESTRICTED_API_SET_AUTO_BOOSTED_CLOCKS
    COUNT = NVML_RESTRICTED_API_COUNT

class GpuUtilizationDomainId(_IntEnum):
    """See `nvmlGpuUtilizationDomainId_t`."""
    GPU_UTILIZATION_DOMAIN_GPU = NVML_GPU_UTILIZATION_DOMAIN_GPU
    GPU_UTILIZATION_DOMAIN_FB = NVML_GPU_UTILIZATION_DOMAIN_FB
    GPU_UTILIZATION_DOMAIN_VID = NVML_GPU_UTILIZATION_DOMAIN_VID
    GPU_UTILIZATION_DOMAIN_BUS = NVML_GPU_UTILIZATION_DOMAIN_BUS

class GpuVirtualizationMode(_IntEnum):
    """See `nvmlGpuVirtualizationMode_t`."""
    NONE = NVML_GPU_VIRTUALIZATION_MODE_NONE
    PASSTHROUGH = NVML_GPU_VIRTUALIZATION_MODE_PASSTHROUGH
    VGPU = NVML_GPU_VIRTUALIZATION_MODE_VGPU
    HOST_VGPU = NVML_GPU_VIRTUALIZATION_MODE_HOST_VGPU
    HOST_VSGA = NVML_GPU_VIRTUALIZATION_MODE_HOST_VSGA

class HostVgpuMode(_IntEnum):
    """See `nvmlHostVgpuMode_t`."""
    NON_SRIOV = NVML_HOST_VGPU_MODE_NON_SRIOV
    SRIOV = NVML_HOST_VGPU_MODE_SRIOV

class VgpuVmIdType(_IntEnum):
    """See `nvmlVgpuVmIdType_t`."""
    VGPU_VM_ID_DOMAIN_ID = NVML_VGPU_VM_ID_DOMAIN_ID
    VGPU_VM_ID_UUID = NVML_VGPU_VM_ID_UUID

class VgpuGuestInfoState(_IntEnum):
    """See `nvmlVgpuGuestInfoState_t`."""
    VGPU_INSTANCE_GUEST_INFO_STATE_UNINITIALIZED = NVML_VGPU_INSTANCE_GUEST_INFO_STATE_UNINITIALIZED
    VGPU_INSTANCE_GUEST_INFO_STATE_INITIALIZED = NVML_VGPU_INSTANCE_GUEST_INFO_STATE_INITIALIZED

class GridLicenseFeatureCode(_IntEnum):
    """See `nvmlGridLicenseFeatureCode_t`."""
    UNKNOWN = NVML_GRID_LICENSE_FEATURE_CODE_UNKNOWN
    VGPU = NVML_GRID_LICENSE_FEATURE_CODE_VGPU
    NVIDIA_RTX = NVML_GRID_LICENSE_FEATURE_CODE_NVIDIA_RTX
    VWORKSTATION = NVML_GRID_LICENSE_FEATURE_CODE_VWORKSTATION
    GAMING = NVML_GRID_LICENSE_FEATURE_CODE_GAMING
    COMPUTE = NVML_GRID_LICENSE_FEATURE_CODE_COMPUTE

class VgpuCapability(_IntEnum):
    """See `nvmlVgpuCapability_t`."""
    VGPU_CAP_NVLINK_P2P = NVML_VGPU_CAP_NVLINK_P2P
    VGPU_CAP_GPUDIRECT = NVML_VGPU_CAP_GPUDIRECT
    VGPU_CAP_MULTI_VGPU_EXCLUSIVE = NVML_VGPU_CAP_MULTI_VGPU_EXCLUSIVE
    VGPU_CAP_EXCLUSIVE_TYPE = NVML_VGPU_CAP_EXCLUSIVE_TYPE
    VGPU_CAP_EXCLUSIVE_SIZE = NVML_VGPU_CAP_EXCLUSIVE_SIZE
    VGPU_CAP_COUNT = NVML_VGPU_CAP_COUNT

class VgpuDriverCapability(_IntEnum):
    """See `nvmlVgpuDriverCapability_t`."""
    VGPU_DRIVER_CAP_HETEROGENEOUS_MULTI_VGPU = NVML_VGPU_DRIVER_CAP_HETEROGENEOUS_MULTI_VGPU
    VGPU_DRIVER_CAP_WARM_UPDATE = NVML_VGPU_DRIVER_CAP_WARM_UPDATE
    VGPU_DRIVER_CAP_COUNT = NVML_VGPU_DRIVER_CAP_COUNT

class DeviceVgpuCapability(_IntEnum):
    """See `nvmlDeviceVgpuCapability_t`."""
    DEVICE_VGPU_CAP_FRACTIONAL_MULTI_VGPU = NVML_DEVICE_VGPU_CAP_FRACTIONAL_MULTI_VGPU
    DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_PROFILES = NVML_DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_PROFILES
    DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_SIZES = NVML_DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_SIZES
    DEVICE_VGPU_CAP_READ_DEVICE_BUFFER_BW = NVML_DEVICE_VGPU_CAP_READ_DEVICE_BUFFER_BW
    DEVICE_VGPU_CAP_WRITE_DEVICE_BUFFER_BW = NVML_DEVICE_VGPU_CAP_WRITE_DEVICE_BUFFER_BW
    DEVICE_VGPU_CAP_DEVICE_STREAMING = NVML_DEVICE_VGPU_CAP_DEVICE_STREAMING
    DEVICE_VGPU_CAP_MINI_QUARTER_GPU = NVML_DEVICE_VGPU_CAP_MINI_QUARTER_GPU
    DEVICE_VGPU_CAP_COMPUTE_MEDIA_ENGINE_GPU = NVML_DEVICE_VGPU_CAP_COMPUTE_MEDIA_ENGINE_GPU
    DEVICE_VGPU_CAP_WARM_UPDATE = NVML_DEVICE_VGPU_CAP_WARM_UPDATE
    DEVICE_VGPU_CAP_HOMOGENEOUS_PLACEMENTS = NVML_DEVICE_VGPU_CAP_HOMOGENEOUS_PLACEMENTS
    DEVICE_VGPU_CAP_MIG_TIMESLICING_SUPPORTED = NVML_DEVICE_VGPU_CAP_MIG_TIMESLICING_SUPPORTED
    DEVICE_VGPU_CAP_MIG_TIMESLICING_ENABLED = NVML_DEVICE_VGPU_CAP_MIG_TIMESLICING_ENABLED
    DEVICE_VGPU_CAP_COUNT = NVML_DEVICE_VGPU_CAP_COUNT

class DeviceGpuRecoveryAction(_IntEnum):
    """See `nvmlDeviceGpuRecoveryAction_t`."""
    GPU_RECOVERY_ACTION_NONE = NVML_GPU_RECOVERY_ACTION_NONE
    GPU_RECOVERY_ACTION_GPU_RESET = NVML_GPU_RECOVERY_ACTION_GPU_RESET
    GPU_RECOVERY_ACTION_NODE_REBOOT = NVML_GPU_RECOVERY_ACTION_NODE_REBOOT
    GPU_RECOVERY_ACTION_DRAIN_P2P = NVML_GPU_RECOVERY_ACTION_DRAIN_P2P
    GPU_RECOVERY_ACTION_DRAIN_AND_RESET = NVML_GPU_RECOVERY_ACTION_DRAIN_AND_RESET

class FanState(_IntEnum):
    """See `nvmlFanState_t`."""
    FAN_NORMAL = NVML_FAN_NORMAL
    FAN_FAILED = NVML_FAN_FAILED

class LedColor(_IntEnum):
    """See `nvmlLedColor_t`."""
    GREEN = NVML_LED_COLOR_GREEN
    AMBER = NVML_LED_COLOR_AMBER

class EncoderType(_IntEnum):
    """See `nvmlEncoderType_t`."""
    ENCODER_QUERY_H264 = NVML_ENCODER_QUERY_H264
    ENCODER_QUERY_HEVC = NVML_ENCODER_QUERY_HEVC
    ENCODER_QUERY_AV1 = NVML_ENCODER_QUERY_AV1
    ENCODER_QUERY_UNKNOWN = NVML_ENCODER_QUERY_UNKNOWN

class FBCSessionType(_IntEnum):
    """See `nvmlFBCSessionType_t`."""
    UNKNOWN = NVML_FBC_SESSION_TYPE_UNKNOWN
    TOSYS = NVML_FBC_SESSION_TYPE_TOSYS
    CUDA = NVML_FBC_SESSION_TYPE_CUDA
    VID = NVML_FBC_SESSION_TYPE_VID
    HWENC = NVML_FBC_SESSION_TYPE_HWENC

class DetachGpuState(_IntEnum):
    """See `nvmlDetachGpuState_t`."""
    DETACH_GPU_KEEP = NVML_DETACH_GPU_KEEP
    DETACH_GPU_REMOVE = NVML_DETACH_GPU_REMOVE

class PcieLinkState(_IntEnum):
    """See `nvmlPcieLinkState_t`."""
    PCIE_LINK_KEEP = NVML_PCIE_LINK_KEEP
    PCIE_LINK_SHUT_DOWN = NVML_PCIE_LINK_SHUT_DOWN

class ClockLimitId(_IntEnum):
    """See `nvmlClockLimitId_t`."""
    RANGE_START = NVML_CLOCK_LIMIT_ID_RANGE_START
    TDP = NVML_CLOCK_LIMIT_ID_TDP
    UNLIMITED = NVML_CLOCK_LIMIT_ID_UNLIMITED

class VgpuVmCompatibility(_IntEnum):
    """See `nvmlVgpuVmCompatibility_t`."""
    NONE = NVML_VGPU_VM_COMPATIBILITY_NONE
    COLD = NVML_VGPU_VM_COMPATIBILITY_COLD
    HIBERNATE = NVML_VGPU_VM_COMPATIBILITY_HIBERNATE
    SLEEP = NVML_VGPU_VM_COMPATIBILITY_SLEEP
    LIVE = NVML_VGPU_VM_COMPATIBILITY_LIVE

class VgpuPgpuCompatibilityLimitCode(_IntEnum):
    """See `nvmlVgpuPgpuCompatibilityLimitCode_t`."""
    VGPU_COMPATIBILITY_LIMIT_NONE = NVML_VGPU_COMPATIBILITY_LIMIT_NONE
    VGPU_COMPATIBILITY_LIMIT_HOST_DRIVER = NVML_VGPU_COMPATIBILITY_LIMIT_HOST_DRIVER
    VGPU_COMPATIBILITY_LIMIT_GUEST_DRIVER = NVML_VGPU_COMPATIBILITY_LIMIT_GUEST_DRIVER
    VGPU_COMPATIBILITY_LIMIT_GPU = NVML_VGPU_COMPATIBILITY_LIMIT_GPU
    VGPU_COMPATIBILITY_LIMIT_OTHER = NVML_VGPU_COMPATIBILITY_LIMIT_OTHER

class GpmMetricId(_IntEnum):
    """See `nvmlGpmMetricId_t`."""
    GPM_METRIC_GRAPHICS_UTIL = NVML_GPM_METRIC_GRAPHICS_UTIL
    GPM_METRIC_SM_UTIL = NVML_GPM_METRIC_SM_UTIL
    GPM_METRIC_SM_OCCUPANCY = NVML_GPM_METRIC_SM_OCCUPANCY
    GPM_METRIC_INTEGER_UTIL = NVML_GPM_METRIC_INTEGER_UTIL
    GPM_METRIC_ANY_TENSOR_UTIL = NVML_GPM_METRIC_ANY_TENSOR_UTIL
    GPM_METRIC_DFMA_TENSOR_UTIL = NVML_GPM_METRIC_DFMA_TENSOR_UTIL
    GPM_METRIC_HMMA_TENSOR_UTIL = NVML_GPM_METRIC_HMMA_TENSOR_UTIL
    GPM_METRIC_IMMA_TENSOR_UTIL = NVML_GPM_METRIC_IMMA_TENSOR_UTIL
    GPM_METRIC_DRAM_BW_UTIL = NVML_GPM_METRIC_DRAM_BW_UTIL
    GPM_METRIC_FP64_UTIL = NVML_GPM_METRIC_FP64_UTIL
    GPM_METRIC_FP32_UTIL = NVML_GPM_METRIC_FP32_UTIL
    GPM_METRIC_FP16_UTIL = NVML_GPM_METRIC_FP16_UTIL
    GPM_METRIC_PCIE_TX_PER_SEC = NVML_GPM_METRIC_PCIE_TX_PER_SEC
    GPM_METRIC_PCIE_RX_PER_SEC = NVML_GPM_METRIC_PCIE_RX_PER_SEC
    GPM_METRIC_NVDEC_0_UTIL = NVML_GPM_METRIC_NVDEC_0_UTIL
    GPM_METRIC_NVDEC_1_UTIL = NVML_GPM_METRIC_NVDEC_1_UTIL
    GPM_METRIC_NVDEC_2_UTIL = NVML_GPM_METRIC_NVDEC_2_UTIL
    GPM_METRIC_NVDEC_3_UTIL = NVML_GPM_METRIC_NVDEC_3_UTIL
    GPM_METRIC_NVDEC_4_UTIL = NVML_GPM_METRIC_NVDEC_4_UTIL
    GPM_METRIC_NVDEC_5_UTIL = NVML_GPM_METRIC_NVDEC_5_UTIL
    GPM_METRIC_NVDEC_6_UTIL = NVML_GPM_METRIC_NVDEC_6_UTIL
    GPM_METRIC_NVDEC_7_UTIL = NVML_GPM_METRIC_NVDEC_7_UTIL
    GPM_METRIC_NVJPG_0_UTIL = NVML_GPM_METRIC_NVJPG_0_UTIL
    GPM_METRIC_NVJPG_1_UTIL = NVML_GPM_METRIC_NVJPG_1_UTIL
    GPM_METRIC_NVJPG_2_UTIL = NVML_GPM_METRIC_NVJPG_2_UTIL
    GPM_METRIC_NVJPG_3_UTIL = NVML_GPM_METRIC_NVJPG_3_UTIL
    GPM_METRIC_NVJPG_4_UTIL = NVML_GPM_METRIC_NVJPG_4_UTIL
    GPM_METRIC_NVJPG_5_UTIL = NVML_GPM_METRIC_NVJPG_5_UTIL
    GPM_METRIC_NVJPG_6_UTIL = NVML_GPM_METRIC_NVJPG_6_UTIL
    GPM_METRIC_NVJPG_7_UTIL = NVML_GPM_METRIC_NVJPG_7_UTIL
    GPM_METRIC_NVOFA_0_UTIL = NVML_GPM_METRIC_NVOFA_0_UTIL
    GPM_METRIC_NVOFA_1_UTIL = NVML_GPM_METRIC_NVOFA_1_UTIL
    GPM_METRIC_NVLINK_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_TOTAL_RX_PER_SEC
    GPM_METRIC_NVLINK_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_TOTAL_TX_PER_SEC
    GPM_METRIC_NVLINK_L0_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L0_RX_PER_SEC
    GPM_METRIC_NVLINK_L0_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L0_TX_PER_SEC
    GPM_METRIC_NVLINK_L1_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L1_RX_PER_SEC
    GPM_METRIC_NVLINK_L1_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L1_TX_PER_SEC
    GPM_METRIC_NVLINK_L2_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L2_RX_PER_SEC
    GPM_METRIC_NVLINK_L2_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L2_TX_PER_SEC
    GPM_METRIC_NVLINK_L3_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L3_RX_PER_SEC
    GPM_METRIC_NVLINK_L3_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L3_TX_PER_SEC
    GPM_METRIC_NVLINK_L4_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L4_RX_PER_SEC
    GPM_METRIC_NVLINK_L4_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L4_TX_PER_SEC
    GPM_METRIC_NVLINK_L5_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L5_RX_PER_SEC
    GPM_METRIC_NVLINK_L5_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L5_TX_PER_SEC
    GPM_METRIC_NVLINK_L6_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L6_RX_PER_SEC
    GPM_METRIC_NVLINK_L6_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L6_TX_PER_SEC
    GPM_METRIC_NVLINK_L7_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L7_RX_PER_SEC
    GPM_METRIC_NVLINK_L7_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L7_TX_PER_SEC
    GPM_METRIC_NVLINK_L8_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L8_RX_PER_SEC
    GPM_METRIC_NVLINK_L8_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L8_TX_PER_SEC
    GPM_METRIC_NVLINK_L9_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L9_RX_PER_SEC
    GPM_METRIC_NVLINK_L9_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L9_TX_PER_SEC
    GPM_METRIC_NVLINK_L10_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L10_RX_PER_SEC
    GPM_METRIC_NVLINK_L10_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L10_TX_PER_SEC
    GPM_METRIC_NVLINK_L11_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L11_RX_PER_SEC
    GPM_METRIC_NVLINK_L11_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L11_TX_PER_SEC
    GPM_METRIC_NVLINK_L12_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L12_RX_PER_SEC
    GPM_METRIC_NVLINK_L12_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L12_TX_PER_SEC
    GPM_METRIC_NVLINK_L13_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L13_RX_PER_SEC
    GPM_METRIC_NVLINK_L13_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L13_TX_PER_SEC
    GPM_METRIC_NVLINK_L14_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L14_RX_PER_SEC
    GPM_METRIC_NVLINK_L14_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L14_TX_PER_SEC
    GPM_METRIC_NVLINK_L15_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L15_RX_PER_SEC
    GPM_METRIC_NVLINK_L15_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L15_TX_PER_SEC
    GPM_METRIC_NVLINK_L16_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L16_RX_PER_SEC
    GPM_METRIC_NVLINK_L16_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L16_TX_PER_SEC
    GPM_METRIC_NVLINK_L17_RX_PER_SEC = NVML_GPM_METRIC_NVLINK_L17_RX_PER_SEC
    GPM_METRIC_NVLINK_L17_TX_PER_SEC = NVML_GPM_METRIC_NVLINK_L17_TX_PER_SEC
    GPM_METRIC_C2C_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_DATA_TX_PER_SEC
    GPM_METRIC_C2C_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK0_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK0_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK0_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK0_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK0_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK0_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK0_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK0_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK1_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK1_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK1_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK1_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK1_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK1_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK1_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK1_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK2_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK2_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK2_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK2_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK2_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK2_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK2_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK2_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK3_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK3_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK3_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK3_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK3_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK3_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK3_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK3_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK4_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK4_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK4_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK4_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK4_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK4_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK4_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK4_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK5_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK5_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK5_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK5_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK5_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK5_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK5_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK5_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK6_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK6_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK6_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK6_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK6_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK6_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK6_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK6_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK7_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK7_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK7_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK7_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK7_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK7_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK7_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK7_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK8_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK8_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK8_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK8_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK8_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK8_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK8_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK8_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK9_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK9_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK9_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK9_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK9_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK9_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK9_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK9_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK10_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK10_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK10_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK10_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK10_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK10_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK10_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK10_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK11_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK11_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK11_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK11_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK11_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK11_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK11_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK11_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK12_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK12_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK12_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK12_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK12_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK12_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK12_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK12_DATA_RX_PER_SEC
    GPM_METRIC_C2C_LINK13_TOTAL_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK13_TOTAL_TX_PER_SEC
    GPM_METRIC_C2C_LINK13_TOTAL_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK13_TOTAL_RX_PER_SEC
    GPM_METRIC_C2C_LINK13_DATA_TX_PER_SEC = NVML_GPM_METRIC_C2C_LINK13_DATA_TX_PER_SEC
    GPM_METRIC_C2C_LINK13_DATA_RX_PER_SEC = NVML_GPM_METRIC_C2C_LINK13_DATA_RX_PER_SEC
    GPM_METRIC_HOSTMEM_CACHE_HIT = NVML_GPM_METRIC_HOSTMEM_CACHE_HIT
    GPM_METRIC_HOSTMEM_CACHE_MISS = NVML_GPM_METRIC_HOSTMEM_CACHE_MISS
    GPM_METRIC_PEERMEM_CACHE_HIT = NVML_GPM_METRIC_PEERMEM_CACHE_HIT
    GPM_METRIC_PEERMEM_CACHE_MISS = NVML_GPM_METRIC_PEERMEM_CACHE_MISS
    GPM_METRIC_DRAM_CACHE_HIT = NVML_GPM_METRIC_DRAM_CACHE_HIT
    GPM_METRIC_DRAM_CACHE_MISS = NVML_GPM_METRIC_DRAM_CACHE_MISS
    GPM_METRIC_NVENC_0_UTIL = NVML_GPM_METRIC_NVENC_0_UTIL
    GPM_METRIC_NVENC_1_UTIL = NVML_GPM_METRIC_NVENC_1_UTIL
    GPM_METRIC_NVENC_2_UTIL = NVML_GPM_METRIC_NVENC_2_UTIL
    GPM_METRIC_NVENC_3_UTIL = NVML_GPM_METRIC_NVENC_3_UTIL
    GPM_METRIC_GR0_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR0_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR0_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR0_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR0_CTXSW_REQUESTS = NVML_GPM_METRIC_GR0_CTXSW_REQUESTS
    GPM_METRIC_GR0_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR0_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR0_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR0_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR1_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR1_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR1_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR1_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR1_CTXSW_REQUESTS = NVML_GPM_METRIC_GR1_CTXSW_REQUESTS
    GPM_METRIC_GR1_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR1_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR1_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR1_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR2_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR2_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR2_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR2_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR2_CTXSW_REQUESTS = NVML_GPM_METRIC_GR2_CTXSW_REQUESTS
    GPM_METRIC_GR2_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR2_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR2_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR2_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR3_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR3_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR3_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR3_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR3_CTXSW_REQUESTS = NVML_GPM_METRIC_GR3_CTXSW_REQUESTS
    GPM_METRIC_GR3_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR3_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR3_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR3_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR4_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR4_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR4_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR4_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR4_CTXSW_REQUESTS = NVML_GPM_METRIC_GR4_CTXSW_REQUESTS
    GPM_METRIC_GR4_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR4_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR4_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR4_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR5_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR5_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR5_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR5_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR5_CTXSW_REQUESTS = NVML_GPM_METRIC_GR5_CTXSW_REQUESTS
    GPM_METRIC_GR5_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR5_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR5_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR5_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR6_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR6_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR6_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR6_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR6_CTXSW_REQUESTS = NVML_GPM_METRIC_GR6_CTXSW_REQUESTS
    GPM_METRIC_GR6_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR6_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR6_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR6_CTXSW_ACTIVE_PCT
    GPM_METRIC_GR7_CTXSW_CYCLES_ELAPSED = NVML_GPM_METRIC_GR7_CTXSW_CYCLES_ELAPSED
    GPM_METRIC_GR7_CTXSW_CYCLES_ACTIVE = NVML_GPM_METRIC_GR7_CTXSW_CYCLES_ACTIVE
    GPM_METRIC_GR7_CTXSW_REQUESTS = NVML_GPM_METRIC_GR7_CTXSW_REQUESTS
    GPM_METRIC_GR7_CTXSW_CYCLES_PER_REQ = NVML_GPM_METRIC_GR7_CTXSW_CYCLES_PER_REQ
    GPM_METRIC_GR7_CTXSW_ACTIVE_PCT = NVML_GPM_METRIC_GR7_CTXSW_ACTIVE_PCT
    GPM_METRIC_MAX = NVML_GPM_METRIC_MAX

class PowerProfileType(_IntEnum):
    """See `nvmlPowerProfileType_t`."""
    POWER_PROFILE_MAX_P = NVML_POWER_PROFILE_MAX_P
    POWER_PROFILE_MAX_Q = NVML_POWER_PROFILE_MAX_Q
    POWER_PROFILE_COMPUTE = NVML_POWER_PROFILE_COMPUTE
    POWER_PROFILE_MEMORY_BOUND = NVML_POWER_PROFILE_MEMORY_BOUND
    POWER_PROFILE_NETWORK = NVML_POWER_PROFILE_NETWORK
    POWER_PROFILE_BALANCED = NVML_POWER_PROFILE_BALANCED
    POWER_PROFILE_LLM_INFERENCE = NVML_POWER_PROFILE_LLM_INFERENCE
    POWER_PROFILE_LLM_TRAINING = NVML_POWER_PROFILE_LLM_TRAINING
    POWER_PROFILE_RBM = NVML_POWER_PROFILE_RBM
    POWER_PROFILE_DCPCIE = NVML_POWER_PROFILE_DCPCIE
    POWER_PROFILE_HMMA_SPARSE = NVML_POWER_PROFILE_HMMA_SPARSE
    POWER_PROFILE_HMMA_DENSE = NVML_POWER_PROFILE_HMMA_DENSE
    POWER_PROFILE_SYNC_BALANCED = NVML_POWER_PROFILE_SYNC_BALANCED
    POWER_PROFILE_HPC = NVML_POWER_PROFILE_HPC
    POWER_PROFILE_MIG = NVML_POWER_PROFILE_MIG
    POWER_PROFILE_MAX = NVML_POWER_PROFILE_MAX

class DeviceAddressingModeType(_IntEnum):
    """See `nvmlDeviceAddressingModeType_t`."""
    DEVICE_ADDRESSING_MODE_NONE = NVML_DEVICE_ADDRESSING_MODE_NONE
    DEVICE_ADDRESSING_MODE_HMM = NVML_DEVICE_ADDRESSING_MODE_HMM
    DEVICE_ADDRESSING_MODE_ATS = NVML_DEVICE_ADDRESSING_MODE_ATS

class PRMCounterId(_IntEnum):
    """See `nvmlPRMCounterId_t`."""
    NONE = NVML_PRM_COUNTER_ID_NONE
    PPCNT_PHYSICAL_LAYER_CTRS_LINK_DOWN_EVENTS = NVML_PRM_COUNTER_ID_PPCNT_PHYSICAL_LAYER_CTRS_LINK_DOWN_EVENTS
    PPCNT_PHYSICAL_LAYER_CTRS_SUCCESSFUL_RECOVERY_EVENTS = NVML_PRM_COUNTER_ID_PPCNT_PHYSICAL_LAYER_CTRS_SUCCESSFUL_RECOVERY_EVENTS
    PPCNT_RECOVERY_CTRS_TOTAL_SUCCESSFUL_RECOVERY_EVENTS = NVML_PRM_COUNTER_ID_PPCNT_RECOVERY_CTRS_TOTAL_SUCCESSFUL_RECOVERY_EVENTS
    PPCNT_RECOVERY_CTRS_TIME_SINCE_LAST_RECOVERY = NVML_PRM_COUNTER_ID_PPCNT_RECOVERY_CTRS_TIME_SINCE_LAST_RECOVERY
    PPCNT_RECOVERY_CTRS_TIME_BETWEEN_LAST_TWO_RECOVERIES = NVML_PRM_COUNTER_ID_PPCNT_RECOVERY_CTRS_TIME_BETWEEN_LAST_TWO_RECOVERIES
    PPCNT_PORTCOUNTERS_PORT_XMIT_WAIT = NVML_PRM_COUNTER_ID_PPCNT_PORTCOUNTERS_PORT_XMIT_WAIT
    PPCNT_PLR_RCV_CODES = NVML_PRM_COUNTER_ID_PPCNT_PLR_RCV_CODES
    PPCNT_PLR_RCV_CODE_ERR = NVML_PRM_COUNTER_ID_PPCNT_PLR_RCV_CODE_ERR
    PPCNT_PLR_RCV_UNCORRECTABLE_CODE = NVML_PRM_COUNTER_ID_PPCNT_PLR_RCV_UNCORRECTABLE_CODE
    PPCNT_PLR_XMIT_CODES = NVML_PRM_COUNTER_ID_PPCNT_PLR_XMIT_CODES
    PPCNT_PLR_XMIT_RETRY_CODES = NVML_PRM_COUNTER_ID_PPCNT_PLR_XMIT_RETRY_CODES
    PPCNT_PLR_XMIT_RETRY_EVENTS = NVML_PRM_COUNTER_ID_PPCNT_PLR_XMIT_RETRY_EVENTS
    PPCNT_PLR_SYNC_EVENTS = NVML_PRM_COUNTER_ID_PPCNT_PLR_SYNC_EVENTS
    PPRM_OPER_RECOVERY = NVML_PRM_COUNTER_ID_PPRM_OPER_RECOVERY

class PowerProfileOperation(_IntEnum):
    """See `nvmlPowerProfileOperation_t`."""
    CLEAR = NVML_POWER_PROFILE_OPERATION_CLEAR
    SET = NVML_POWER_PROFILE_OPERATION_SET
    SET_AND_OVERWRITE = NVML_POWER_PROFILE_OPERATION_SET_AND_OVERWRITE
    MAX = NVML_POWER_PROFILE_OPERATION_MAX


class AffinityScope(_IntEnum):
    NODE = 0     # Scope of NUMA node for affinity queries
    SOCKET = 1   # Scope of processor socket for affinity queries


class FI(_IntEnum):
    DEV_ECC_CURRENT =          1   # Current ECC mode. 1=Active. 0=Inactive
    DEV_ECC_PENDING =          2   # Pending ECC mode. 1=Active. 0=Inactive
    # ECC Count Totals
    DEV_ECC_SBE_VOL_TOTAL =    3   # Total single bit volatile ECC errors
    DEV_ECC_DBE_VOL_TOTAL =    4   # Total double bit volatile ECC errors
    DEV_ECC_SBE_AGG_TOTAL =    5   # Total single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_TOTAL =    6   # Total double bit aggregate (persistent) ECC errors
    # Individual ECC locations
    DEV_ECC_SBE_VOL_L1 =       7   # L1 cache single bit volatile ECC errors
    DEV_ECC_DBE_VOL_L1 =       8   # L1 cache double bit volatile ECC errors
    DEV_ECC_SBE_VOL_L2 =       9   # L2 cache single bit volatile ECC errors
    DEV_ECC_DBE_VOL_L2 =       10  # L2 cache double bit volatile ECC errors
    DEV_ECC_SBE_VOL_DEV =      11  # Device memory single bit volatile ECC errors
    DEV_ECC_DBE_VOL_DEV =      12  # Device memory double bit volatile ECC errors
    DEV_ECC_SBE_VOL_REG =      13  # Register file single bit volatile ECC errors
    DEV_ECC_DBE_VOL_REG =      14  # Register file double bit volatile ECC errors
    DEV_ECC_SBE_VOL_TEX =      15  # Texture memory single bit volatile ECC errors
    DEV_ECC_DBE_VOL_TEX =      16  # Texture memory double bit volatile ECC errors
    DEV_ECC_DBE_VOL_CBU =      17  # CBU double bit volatile ECC errors
    DEV_ECC_SBE_AGG_L1 =       18  # L1 cache single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_L1 =       19  # L1 cache double bit aggregate (persistent) ECC errors
    DEV_ECC_SBE_AGG_L2 =       20  # L2 cache single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_L2 =       21  # L2 cache double bit aggregate (persistent) ECC errors
    DEV_ECC_SBE_AGG_DEV =      22  # Device memory single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_DEV =      23  # Device memory double bit aggregate (persistent) ECC errors
    DEV_ECC_SBE_AGG_REG =      24  # Register File single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_REG =      25  # Register File double bit aggregate (persistent) ECC errors
    DEV_ECC_SBE_AGG_TEX =      26  # Texture memory single bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_TEX =      27  # Texture memory double bit aggregate (persistent) ECC errors
    DEV_ECC_DBE_AGG_CBU =      28  # CBU double bit aggregate ECC errors

    # Page Retirement
    DEV_RETIRED_SBE =          29  # Number of retired pages because of single bit errors
    DEV_RETIRED_DBE =          30  # Number of retired pages because of double bit errors
    DEV_RETIRED_PENDING =      31  # If any pages are pending retirement. 1=yes. 0=no.


    # NVLink Flit Error Counters
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L0 =   32 # NVLink flow control CRC  Error Counter for Lane 0
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L1 =   33 # NVLink flow control CRC  Error Counter for Lane 1
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L2 =   34 # NVLink flow control CRC  Error Counter for Lane 2
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L3 =   35 # NVLink flow control CRC  Error Counter for Lane 3
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L4 =   36 # NVLink flow control CRC  Error Counter for Lane 4
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L5 =   37 # NVLink flow control CRC  Error Counter for Lane 5
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_TOTAL =38 # NVLink flow control CRC  Error Counter total for all Lanes

    # NVLink CRC Data Error Counters
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L0 =   39 # NVLink data CRC Error Counter for Lane 0
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L1 =   40 # NVLink data CRC Error Counter for Lane 1
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L2 =   41 # NVLink data CRC Error Counter for Lane 2
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L3 =   42 # NVLink data CRC Error Counter for Lane 3
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L4 =   43 # NVLink data CRC Error Counter for Lane 4
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L5 =   44 # NVLink data CRC Error Counter for Lane 5
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_TOTAL =45 # NvLink data CRC Error Counter total for all Lanes


    # NVLink Replay Error Counters
    DEV_NVLINK_REPLAY_ERROR_COUNT_L0 =     46 # NVLink Replay Error Counter for Lane 0
    DEV_NVLINK_REPLAY_ERROR_COUNT_L1 =     47 # NVLink Replay Error Counter for Lane 1
    DEV_NVLINK_REPLAY_ERROR_COUNT_L2 =     48 # NVLink Replay Error Counter for Lane 2
    DEV_NVLINK_REPLAY_ERROR_COUNT_L3 =     49 # NVLink Replay Error Counter for Lane 3
    DEV_NVLINK_REPLAY_ERROR_COUNT_L4 =     50 # NVLink Replay Error Counter for Lane 4
    DEV_NVLINK_REPLAY_ERROR_COUNT_L5 =     51 # NVLink Replay Error Counter for Lane 5
    DEV_NVLINK_REPLAY_ERROR_COUNT_TOTAL =  52 # NVLink Replay Error Counter total for all Lanes

    # NVLink Recovery Error Counters
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L0 =   53 # NVLink Recovery Error Counter for Lane 0
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L1 =   54 # NVLink Recovery Error Counter for Lane 1
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L2 =   55 # NVLink Recovery Error Counter for Lane 2
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L3 =   56 # NVLink Recovery Error Counter for Lane 3
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L4 =   57 # NVLink Recovery Error Counter for Lane 4
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L5 =   58 # NVLink Recovery Error Counter for Lane 5
    DEV_NVLINK_RECOVERY_ERROR_COUNT_TOTAL =59 # NVLink Recovery Error Counter total for all Lanes

    # NvLink Bandwidth Counters
    DEV_NVLINK_BANDWIDTH_C0_L0 =    60 # NVLink Bandwidth Counter for Counter Set 0, Lane 0
    DEV_NVLINK_BANDWIDTH_C0_L1 =    61 # NVLink Bandwidth Counter for Counter Set 0, Lane 1
    DEV_NVLINK_BANDWIDTH_C0_L2 =    62 # NVLink Bandwidth Counter for Counter Set 0, Lane 2
    DEV_NVLINK_BANDWIDTH_C0_L3 =    63 # NVLink Bandwidth Counter for Counter Set 0, Lane 3
    DEV_NVLINK_BANDWIDTH_C0_L4 =    64 # NVLink Bandwidth Counter for Counter Set 0, Lane 4
    DEV_NVLINK_BANDWIDTH_C0_L5 =    65 # NVLink Bandwidth Counter for Counter Set 0, Lane 5
    DEV_NVLINK_BANDWIDTH_C0_TOTAL = 66 # NVLink Bandwidth Counter Total for Counter Set 0, All Lanes

    # NvLink Bandwidth Counters
    DEV_NVLINK_BANDWIDTH_C1_L0 =    67 # NVLink Bandwidth Counter for Counter Set 1, Lane 0
    DEV_NVLINK_BANDWIDTH_C1_L1 =    68 # NVLink Bandwidth Counter for Counter Set 1, Lane 1
    DEV_NVLINK_BANDWIDTH_C1_L2 =    69 # NVLink Bandwidth Counter for Counter Set 1, Lane 2
    DEV_NVLINK_BANDWIDTH_C1_L3 =    70 # NVLink Bandwidth Counter for Counter Set 1, Lane 3
    DEV_NVLINK_BANDWIDTH_C1_L4 =    71 # NVLink Bandwidth Counter for Counter Set 1, Lane 4
    DEV_NVLINK_BANDWIDTH_C1_L5 =    72 # NVLink Bandwidth Counter for Counter Set 1, Lane 5
    DEV_NVLINK_BANDWIDTH_C1_TOTAL = 73 # NVLink Bandwidth Counter Total for Counter Set 1, All Lanes

    # NVML Perf Policy Counters
    DEV_PERF_POLICY_POWER =             74   # Perf Policy Counter for Power Policy
    DEV_PERF_POLICY_THERMAL =           75   # Perf Policy Counter for Thermal Policy
    DEV_PERF_POLICY_SYNC_BOOST =        76   # Perf Policy Counter for Sync boost Policy
    DEV_PERF_POLICY_BOARD_LIMIT =       77   # Perf Policy Counter for Board Limit
    DEV_PERF_POLICY_LOW_UTILIZATION =   78   # Perf Policy Counter for Low GPU Utilization Policy
    DEV_PERF_POLICY_RELIABILITY =       79   # Perf Policy Counter for Reliability Policy
    DEV_PERF_POLICY_TOTAL_APP_CLOCKS =  80   # Perf Policy Counter for Total App Clock Policy
    DEV_PERF_POLICY_TOTAL_BASE_CLOCKS = 81   # Perf Policy Counter for Total Base Clocks Policy

    # Memory temperatures
    DEV_MEMORY_TEMP = 82 # Memory temperature for the device

    # Energy Counter
    DEV_TOTAL_ENERGY_CONSUMPTION =83 # Total energy consumption for the GPU in mJ since the driver was last reloaded

    # NVLink Speed
    DEV_NVLINK_SPEED_MBPS_L0 =    84  # NVLink Speed in MBps for Link 0
    DEV_NVLINK_SPEED_MBPS_L1 =    85  # NVLink Speed in MBps for Link 1
    DEV_NVLINK_SPEED_MBPS_L2 =    86  # NVLink Speed in MBps for Link 2
    DEV_NVLINK_SPEED_MBPS_L3 =    87  # NVLink Speed in MBps for Link 3
    DEV_NVLINK_SPEED_MBPS_L4 =    88  # NVLink Speed in MBps for Link 4
    DEV_NVLINK_SPEED_MBPS_L5 =    89  # NVLink Speed in MBps for Link 5
    DEV_NVLINK_SPEED_MBPS_COMMON =90  # Common NVLink Speed in MBps for active links

    DEV_NVLINK_LINK_COUNT =       91  # Number of NVLinks present on the device

    DEV_RETIRED_PENDING_SBE =     92  # If any pages are pending retirement due to SBE. 1=yes. 0=no.
    DEV_RETIRED_PENDING_DBE =     93  # If any pages are pending retirement due to DBE. 1=yes. 0=no.

    DEV_PCIE_REPLAY_COUNTER =            94  # PCIe replay counter
    DEV_PCIE_REPLAY_ROLLOVER_COUNTER =   95  # PCIe replay rollover counter

    # NVLink Flit Error Counters
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L6 =    96 # NVLink flow control CRC  Error Counter for Lane 6
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L7 =    97 # NVLink flow control CRC  Error Counter for Lane 7
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L8 =    98 # NVLink flow control CRC  Error Counter for Lane 8
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L9 =    99 # NVLink flow control CRC  Error Counter for Lane 9
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L10 =  100 # NVLink flow control CRC  Error Counter for Lane 10
    DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L11 =  101 # NVLink flow control CRC  Error Counter for Lane 11

    # NVLink CRC Data Error Counters
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L6 =   102 # NVLink data CRC Error Counter for Lane 6
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L7 =   103 # NVLink data CRC Error Counter for Lane 7
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L8 =   104 # NVLink data CRC Error Counter for Lane 8
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L9 =   105 # NVLink data CRC Error Counter for Lane 9
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L10 =  106 # NVLink data CRC Error Counter for Lane 10
    DEV_NVLINK_CRC_DATA_ERROR_COUNT_L11 =  107 # NVLink data CRC Error Counter for Lane 11

    # NVLink Replay Error Counters
    DEV_NVLINK_REPLAY_ERROR_COUNT_L6 =     108 # NVLink Replay Error Counter for Lane 6
    DEV_NVLINK_REPLAY_ERROR_COUNT_L7 =     109 # NVLink Replay Error Counter for Lane 7
    DEV_NVLINK_REPLAY_ERROR_COUNT_L8 =     110 # NVLink Replay Error Counter for Lane 8
    DEV_NVLINK_REPLAY_ERROR_COUNT_L9 =     111 # NVLink Replay Error Counter for Lane 9
    DEV_NVLINK_REPLAY_ERROR_COUNT_L10 =    112 # NVLink Replay Error Counter for Lane 10
    DEV_NVLINK_REPLAY_ERROR_COUNT_L11 =    113 # NVLink Replay Error Counter for Lane 11

    # NVLink Recovery Error Counters
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L6 =   114 # NVLink Recovery Error Counter for Lane 6
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L7 =   115 # NVLink Recovery Error Counter for Lane 7
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L8 =   116 # NVLink Recovery Error Counter for Lane 8
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L9 =   117 # NVLink Recovery Error Counter for Lane 9
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L10 =  118 # NVLink Recovery Error Counter for Lane 10
    DEV_NVLINK_RECOVERY_ERROR_COUNT_L11 =  119 # NVLink Recovery Error Counter for Lane 11

    # NvLink Bandwidth Counters */
    DEV_NVLINK_BANDWIDTH_C0_L6 =    120 # NVLink Bandwidth Counter for Counter Set 0, Lane 6
    DEV_NVLINK_BANDWIDTH_C0_L7 =    121 # NVLink Bandwidth Counter for Counter Set 0, Lane 7
    DEV_NVLINK_BANDWIDTH_C0_L8 =    122 # NVLink Bandwidth Counter for Counter Set 0, Lane 8
    DEV_NVLINK_BANDWIDTH_C0_L9 =    123 # NVLink Bandwidth Counter for Counter Set 0, Lane 9
    DEV_NVLINK_BANDWIDTH_C0_L10 =   124 # NVLink Bandwidth Counter for Counter Set 0, Lane 10
    DEV_NVLINK_BANDWIDTH_C0_L11 =   125 # NVLink Bandwidth Counter for Counter Set 0, Lane 11

    # NvLink Bandwidth Counters
    DEV_NVLINK_BANDWIDTH_C1_L6 =    126 # NVLink Bandwidth Counter for Counter Set 1, Lane 6
    DEV_NVLINK_BANDWIDTH_C1_L7 =    127 # NVLink Bandwidth Counter for Counter Set 1, Lane 7
    DEV_NVLINK_BANDWIDTH_C1_L8 =    128 # NVLink Bandwidth Counter for Counter Set 1, Lane 8
    DEV_NVLINK_BANDWIDTH_C1_L9 =    129 # NVLink Bandwidth Counter for Counter Set 1, Lane 9
    DEV_NVLINK_BANDWIDTH_C1_L10 =   130 # NVLink Bandwidth Counter for Counter Set 1, Lane 10
    DEV_NVLINK_BANDWIDTH_C1_L11 =   131 # NVLink Bandwidth Counter for Counter Set 1, Lane 11

    # NVLink Speed
    DEV_NVLINK_SPEED_MBPS_L6 =    132  # NVLink Speed in MBps for Link 6
    DEV_NVLINK_SPEED_MBPS_L7 =    133  # NVLink Speed in MBps for Link 7
    DEV_NVLINK_SPEED_MBPS_L8 =    134  # NVLink Speed in MBps for Link 8
    DEV_NVLINK_SPEED_MBPS_L9 =    135  # NVLink Speed in MBps for Link 9
    DEV_NVLINK_SPEED_MBPS_L10 =   136  # NVLink Speed in MBps for Link 10
    DEV_NVLINK_SPEED_MBPS_L11 =   137  # NVLink Speed in MBps for Link 11

    # NVLink throughput counters field values
    DEV_NVLINK_THROUGHPUT_DATA_TX =     138 # NVLink TX Data throughput in KiB
    DEV_NVLINK_THROUGHPUT_DATA_RX =     139 # NVLink RX Data throughput in KiB
    DEV_NVLINK_THROUGHPUT_RAW_TX =      140 # NVLink TX Data + protocol overhead in KiB
    DEV_NVLINK_THROUGHPUT_RAW_RX =      141 # NVLink RX Data + protocol overhead in KiB

    # Row Remapper
    DEV_REMAPPED_COR =       142 # Number of remapped rows due to correctable errors
    DEV_REMAPPED_UNC =       143 # Number of remapped rows due to uncorrectable errors
    DEV_REMAPPED_PENDING =   144 # If any rows are pending remapping. 1=yes 0=no
    DEV_REMAPPED_FAILURE =   145 # If any rows failed to be remapped 1=yes 0=no

    # Remote device NVLink ID
    DEV_NVLINK_REMOTE_NVLINK_ID =    146 # Remote device NVLink ID

    # NVSwitch: connected NVLink count
    DEV_NVSWITCH_CONNECTED_LINK_COUNT =  147  # Number of NVLinks connected to NVSwitch

    # NvLink ECC Data Error Counters
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L0 =   148 # NVLink data ECC Error Counter for Link 0
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L1 =   149 # NVLink data ECC Error Counter for Link 1
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L2 =   150 # NVLink data ECC Error Counter for Link 2
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L3 =   151 # NVLink data ECC Error Counter for Link 3
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L4 =   152 # NVLink data ECC Error Counter for Link 4
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L5 =   153 # NVLink data ECC Error Counter for Link 5
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L6 =   154 # NVLink data ECC Error Counter for Link 6
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L7 =   155 # NVLink data ECC Error Counter for Link 7
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L8 =   156 # NVLink data ECC Error Counter for Link 8
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L9 =   157 # NVLink data ECC Error Counter for Link 9
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L10 =  158 # NVLink data ECC Error Counter for Link 10
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_L11 =  159 # NVLink data ECC Error Counter for Link 11
    DEV_NVLINK_ECC_DATA_ERROR_COUNT_TOTAL =160 # NVLink data ECC Error Counter total for all Links

    # NVLink Error Replay
    DEV_NVLINK_ERROR_DL_REPLAY =           161 # NVLink Replay Error Counter

    # NVLink Recovery Error Counter
    DEV_NVLINK_ERROR_DL_RECOVERY =         162 # NVLink Recovery Error Counter

    # NVLink Recovery Error CRC Counter
    DEV_NVLINK_ERROR_DL_CRC =              163 # NVLink CRC Error Counter


    # NVLink Speed, State and Version field id 164, 165, and 166
    DEV_NVLINK_GET_SPEED =                 164 # NVLink Speed in MBps
    DEV_NVLINK_GET_STATE =                 165 # NVLink State - Active,Inactive
    DEV_NVLINK_GET_VERSION =               166 # NVLink Version

    DEV_NVLINK_GET_POWER_STATE =           167 # NVLink Power state. 0=HIGH_SPEED 1=LOW_SPEED
    DEV_NVLINK_GET_POWER_THRESHOLD =       168 # NVLink length of idle period (units can be found from
                                                       # DEV_NVLINK_GET_POWER_THRESHOLD_UNITS) before
                                                       # transitioning links to sleep state

    DEV_PCIE_L0_TO_RECOVERY_COUNTER =      169 # Device PEX error recovery counter

    DEV_C2C_LINK_COUNT =                   170 # Number of C2C Links present on the device
    DEV_C2C_LINK_GET_STATUS =              171 # C2C Link Status 0=INACTIVE 1=ACTIVE
    DEV_C2C_LINK_GET_MAX_BW =              172 # C2C Link Speed in MBps for active links

    DEV_PCIE_COUNT_CORRECTABLE_ERRORS =    173 # PCIe Correctable Errors Counter
    DEV_PCIE_COUNT_NAKS_RECEIVED =         174 # PCIe NAK Receive Counter
    DEV_PCIE_COUNT_RECEIVER_ERROR =        175 # PCIe Receiver Error Counter
    DEV_PCIE_COUNT_BAD_TLP =               176 # PCIe Bad TLP Counter
    DEV_PCIE_COUNT_NAKS_SENT =             177 # PCIe NAK Send Counter
    DEV_PCIE_COUNT_BAD_DLLP =              178 # PCIe Bad DLLP Counter
    DEV_PCIE_COUNT_NON_FATAL_ERROR =       179 # PCIe Non Fatal Error Counter
    DEV_PCIE_COUNT_FATAL_ERROR =           180 # PCIe Fatal Error Counter
    DEV_PCIE_COUNT_UNSUPPORTED_REQ =       181 # PCIe Unsupported Request Counter
    DEV_PCIE_COUNT_LCRC_ERROR =            182 # PCIe LCRC Error Counter
    DEV_PCIE_COUNT_LANE_ERROR =            183 # PCIe Per Lane Error Counter.

    DEV_IS_RESETLESS_MIG_SUPPORTED =       184 # Device's Restless MIG Capability

    DEV_POWER_AVERAGE =                    185 # GPU power averaged over 1 sec interval, supported on Ampere (except GA100) or newer architectures.
    DEV_POWER_INSTANT =                    186 # Current GPU power, supported on all architectures.
    DEV_POWER_MIN_LIMIT =                  187 # Minimum power limit in milliwatts.
    DEV_POWER_MAX_LIMIT =                  188 # Maximum power limit in milliwatts.
    DEV_POWER_DEFAULT_LIMIT =              189 # Default power limit in milliwatts (limit which device boots with).
    DEV_POWER_CURRENT_LIMIT =              190 # Limit currently enforced in milliwatts (This includes other limits set elsewhere. E.g. Out-of-band).
    DEV_ENERGY =                           191 # Total energy consumption (in mJ) since the driver was last reloaded. Same as \ref DEV_TOTAL_ENERGY_CONSUMPTION for the GPU.
    DEV_POWER_REQUESTED_LIMIT =            192 # Power limit requested by NVML or any other userspace client.

    # GPU T.Limit temperature thresholds in degree Celsius
    DEV_TEMPERATURE_SHUTDOWN_TLIMIT =      193 # T.Limit temperature after which GPU may shut down for HW protection
    DEV_TEMPERATURE_SLOWDOWN_TLIMIT =      194 # T.Limit temperature after which GPU may begin HW slowdown
    DEV_TEMPERATURE_MEM_MAX_TLIMIT =       195 # T.Limit temperature after which GPU may begin SW slowdown due to memory temperature
    DEV_TEMPERATURE_GPU_MAX_TLIMIT =       196 # T.Limit temperature after which GPU may be throttled below base clock

    DEV_PCIE_COUNT_TX_BYTES =              197 # PCIe transmit bytes. Value can be wrapped.
    DEV_PCIE_COUNT_RX_BYTES =              198 # PCIe receive bytes. Value can be wrapped.

    DEV_IS_MIG_MODE_INDEPENDENT_MIG_QUERY_CAPABLE =  199 # MIG mode independent, MIG query capable device. 1=yes. 0=no.

    DEV_NVLINK_GET_POWER_THRESHOLD_MAX =             200 # Max Nvlink Power Threshold. See DEV_NVLINK_GET_POWER_THRESHOLD


    # NVLink counter field id 201-225
    DEV_NVLINK_COUNT_XMIT_PACKETS =                   201 # Total Tx packets on the link in NVLink5
    DEV_NVLINK_COUNT_XMIT_BYTES =                     202 # Total Tx bytes on the link in NVLink5
    DEV_NVLINK_COUNT_RCV_PACKETS =                    203 # Total Rx packets on the link in NVLink5
    DEV_NVLINK_COUNT_RCV_BYTES =                      204 # Total Rx bytes on the link in NVLink5
    DEV_NVLINK_COUNT_VL15_DROPPED =                   205 # Deprecated, do not use
    DEV_NVLINK_COUNT_MALFORMED_PACKET_ERRORS =        206 # Number of packets Rx on a link where packets are malformed
    DEV_NVLINK_COUNT_BUFFER_OVERRUN_ERRORS =          207 # Number of packets that were discarded on Rx due to buffer overrun
    DEV_NVLINK_COUNT_RCV_ERRORS =                     208 # Total number of packets with errors Rx on a link
    DEV_NVLINK_COUNT_RCV_REMOTE_ERRORS =              209 # Total number of packets Rx - stomp/EBP marker
    DEV_NVLINK_COUNT_RCV_GENERAL_ERRORS =             210 # Total number of packets Rx with header mismatch
    DEV_NVLINK_COUNT_LOCAL_LINK_INTEGRITY_ERRORS =    211 # Total number of times that the count of local errors exceeded a threshold
    DEV_NVLINK_COUNT_XMIT_DISCARDS =                  212 # Total number of tx error packets that were discarded

    DEV_NVLINK_COUNT_LINK_RECOVERY_SUCCESSFUL_EVENTS =213 # Number of times link went from Up to recovery, succeeded and link came back up
    DEV_NVLINK_COUNT_LINK_RECOVERY_FAILED_EVENTS =    214 # Number of times link went from Up to recovery, failed and link was declared down
    DEV_NVLINK_COUNT_LINK_RECOVERY_EVENTS =           215 # Number of times link went from Up to recovery, irrespective of the result

    DEV_NVLINK_COUNT_RAW_BER_LANE0 =                  216 # Deprecated, do not use
    DEV_NVLINK_COUNT_RAW_BER_LANE1 =                  217 # Deprecated, do not use
    DEV_NVLINK_COUNT_RAW_BER =                        218 # Deprecated, do not use
    DEV_NVLINK_COUNT_EFFECTIVE_ERRORS =               219 # Sum of the number of errors in each Nvlink packet

    # NVLink Effective BER
    DEV_NVLINK_COUNT_EFFECTIVE_BER =                  220 # Effective BER for effective errors
    DEV_NVLINK_COUNT_SYMBOL_ERRORS =                  221 # Number of errors in rx symbols

    # NVLink Symbol BER
    DEV_NVLINK_COUNT_SYMBOL_BER =                     222 # BER for symbol errors

    DEV_NVLINK_GET_POWER_THRESHOLD_MIN =              223 # Min Nvlink Power Threshold. See DEV_NVLINK_GET_POWER_THRESHOLD
    DEV_NVLINK_GET_POWER_THRESHOLD_UNITS =            224 # Values are in the form NVML_NVLINK_LOW_POWER_THRESHOLD_UNIT_*
    DEV_NVLINK_GET_POWER_THRESHOLD_SUPPORTED =        225 # Determine if Nvlink Power Threshold feature is supported

    DEV_RESET_STATUS =                                226 # Depracated, do not use (use DEV_GET_GPU_RECOVERY_ACTION instead)
    DEV_DRAIN_AND_RESET_STATUS =                      227 # Deprecated, do not use (use DEV_GET_GPU_RECOVERY_ACTION instead)
    DEV_PCIE_OUTBOUND_ATOMICS_MASK =                  228
    DEV_PCIE_INBOUND_ATOMICS_MASK =                   229
    DEV_GET_GPU_RECOVERY_ACTION =                     230 # GPU Recovery action - None/Reset/Reboot/Drain P2P/Drain and Reset
    DEV_C2C_LINK_ERROR_INTR =                         231 # C2C Link CRC Error Counter
    DEV_C2C_LINK_ERROR_REPLAY =                       232 # C2C Link Replay Error Counter
    DEV_C2C_LINK_ERROR_REPLAY_B2B =                   233 # C2C Link Back to Back Replay Error Counter
    DEV_C2C_LINK_POWER_STATE =                        234 # C2C Link Power state. See NVML_C2C_POWER_STATE_*

    # NVLink counter field id 235-250
    DEV_NVLINK_COUNT_FEC_HISTORY_0 =                  235 # Count of symbol errors that are corrected - bin 0
    DEV_NVLINK_COUNT_FEC_HISTORY_1 =                  236 # Count of symbol errors that are corrected - bin 1
    DEV_NVLINK_COUNT_FEC_HISTORY_2 =                  237 # Count of symbol errors that are corrected - bin 2
    DEV_NVLINK_COUNT_FEC_HISTORY_3 =                  238 # Count of symbol errors that are corrected - bin 3
    DEV_NVLINK_COUNT_FEC_HISTORY_4 =                  239 # Count of symbol errors that are corrected - bin 4
    DEV_NVLINK_COUNT_FEC_HISTORY_5 =                  240 # Count of symbol errors that are corrected - bin 5
    DEV_NVLINK_COUNT_FEC_HISTORY_6 =                  241 # Count of symbol errors that are corrected - bin 6
    DEV_NVLINK_COUNT_FEC_HISTORY_7 =                  242 # Count of symbol errors that are corrected - bin 7
    DEV_NVLINK_COUNT_FEC_HISTORY_8 =                  243 # Count of symbol errors that are corrected - bin 8
    DEV_NVLINK_COUNT_FEC_HISTORY_9 =                  244 # Count of symbol errors that are corrected - bin 9
    DEV_NVLINK_COUNT_FEC_HISTORY_10 =                 245 # Count of symbol errors that are corrected - bin 10
    DEV_NVLINK_COUNT_FEC_HISTORY_11 =                 246 # Count of symbol errors that are corrected - bin 11
    DEV_NVLINK_COUNT_FEC_HISTORY_12 =                 247 # Count of symbol errors that are corrected - bin 12
    DEV_NVLINK_COUNT_FEC_HISTORY_13 =                 248 # Count of symbol errors that are corrected - bin 13
    DEV_NVLINK_COUNT_FEC_HISTORY_14 =                 249 # Count of symbol errors that are corrected - bin 14
    DEV_NVLINK_COUNT_FEC_HISTORY_15 =                 250 # Count of symbol errors that are corrected - bin 15

    # Power Smoothing
    PWR_SMOOTHING_ENABLED =                                  251 # Enablement (0/DISABLED or 1/ENABLED)
    PWR_SMOOTHING_PRIV_LVL =                                 252 # Current privilege level
    PWR_SMOOTHING_IMM_RAMP_DOWN_ENABLED =                    253 # Immediate ramp down enablement (0/DISABLED or 1/ENABLED)
    PWR_SMOOTHING_APPLIED_TMP_CEIL =                         254 # Applied TMP ceiling value in Watts
    PWR_SMOOTHING_APPLIED_TMP_FLOOR =                        255 # Applied TMP floor value in Watts
    PWR_SMOOTHING_MAX_PERCENT_TMP_FLOOR_SETTING =            256 # Max % TMP Floor value
    PWR_SMOOTHING_MIN_PERCENT_TMP_FLOOR_SETTING =            257 # Min % TMP Floor value
    PWR_SMOOTHING_HW_CIRCUITRY_PERCENT_LIFETIME_REMAINING =  258 # HW Circuitry % lifetime remaining
    PWR_SMOOTHING_MAX_NUM_PRESET_PROFILES =                  259 # Max number of preset profiles
    PWR_SMOOTHING_PROFILE_PERCENT_TMP_FLOOR =                260 # % TMP floor for a given profile
    PWR_SMOOTHING_PROFILE_RAMP_UP_RATE =                     261 # Ramp up rate in mW/s for a given profile
    PWR_SMOOTHING_PROFILE_RAMP_DOWN_RATE =                   262 # Ramp down rate in mW/s for a given profile
    PWR_SMOOTHING_PROFILE_RAMP_DOWN_HYST_VAL =               263 # Ramp down hysteresis value in ms for a given profile
    PWR_SMOOTHING_ACTIVE_PRESET_PROFILE =                    264 # Active preset profile number
    PWR_SMOOTHING_ADMIN_OVERRIDE_PERCENT_TMP_FLOOR =         265 # % TMP floor for a given profile
    PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_UP_RATE =              266 # Ramp up rate in mW/s for a given profile
    PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_RATE =            267 # Ramp down rate in mW/s for a given profile
    PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_HYST_VAL =        268 # Ramp down hysteresis value in ms for a given profile

    # Field values for Clock Throttle Reason Counters
    DEV_CLOCKS_EVENT_REASON_SW_POWER_CAP =            DEV_PERF_POLICY_POWER      # Throttling to not exceed currently set power limits in ns
    DEV_CLOCKS_EVENT_REASON_SYNC_BOOST =              DEV_PERF_POLICY_SYNC_BOOST # Throttling to match minimum possible clock across Sync Boost Group in ns
    DEV_CLOCKS_EVENT_REASON_SW_THERM_SLOWDOWN =       269 # Throttling to ensure ((GPU temp < GPU Max Operating Temp) && (Memory Temp < Memory Max Operating Temp)) in ns
    DEV_CLOCKS_EVENT_REASON_HW_THERM_SLOWDOWN =       270 # Throttling due to temperature being too high (reducing core clocks by a factor of 2 or more) in ns
    DEV_CLOCKS_EVENT_REASON_HW_POWER_BRAKE_SLOWDOWN = 271 # Throttling due to external power brake assertion trigger (reducing core clocks by a factor of 2 or more) in ns
    DEV_POWER_SYNC_BALANCING_FREQ =                   272 # Accumulated frequency of the GPU to be used for averaging
    DEV_POWER_SYNC_BALANCING_AF =                     273 # Accumulated activity factor of the GPU to be used for averaging
    DEV_EDPP_MULTIPLIER =                             274 # EDPp multiplier expressed as a percentage

    PWR_SMOOTHING_PRIMARY_POWER_FLOOR =               275 # Current primary power floor value in Watts
    PWR_SMOOTHING_SECONDARY_POWER_FLOOR =             276 # Current secondary power floor value in Watts
    PWR_SMOOTHING_MIN_PRIMARY_FLOOR_ACT_OFFSET =        277 # Minimum primary floor activation offset value in Watts
    PWR_SMOOTHING_MIN_PRIMARY_FLOOR_ACT_POINT =         278 # Minimum primary floor activation point value in Watts
    PWR_SMOOTHING_WINDOW_MULTIPLIER =                 279 # Window Multiplier value in ms
    PWR_SMOOTHING_DELAYED_PWR_SMOOTHING_SUPPORTED =   280 # Support (0/Not Supported or 1/Supported) for delayed power smoothing
    PWR_SMOOTHING_PROFILE_SECONDARY_POWER_FLOOR =     281 # Current secondary power floor value in Watts for a given profile
    PWR_SMOOTHING_PROFILE_PRIMARY_FLOOR_ACT_WIN_MULT = 282 # Current primary floor activation window multiplier value for a given profile
    PWR_SMOOTHING_PROFILE_PRIMARY_FLOOR_TAR_WIN_MULT = 283 # Current primary floor target window multiplier value for a given profile
    PWR_SMOOTHING_PROFILE_PRIMARY_FLOOR_ACT_OFFSET =   284 # Current primary floor activation offset value in Watts for a given profile
    PWR_SMOOTHING_ADMIN_OVERRIDE_SECONDARY_POWER_FLOOR =  285 # Current secondary power floor value in Watts for admin override
    PWR_SMOOTHING_ADMIN_OVERRIDE_PRIMARY_FLOOR_ACT_WIN_MULT = 286 # Current primary floor activation window multiplier value for admin override
    PWR_SMOOTHING_ADMIN_OVERRIDE_PRIMARY_FLOOR_TAR_WIN_MULT = 287 # Current primary floor target window multiplier value for admin override
    PWR_SMOOTHING_ADMIN_OVERRIDE_PRIMARY_FLOOR_ACT_OFFSET = 288 # Current primary floor activation offset value in Watts for admin override

    MAX = 289

NVLINK_MAX_LINKS = 18


class RUSD(_IntEnum):
    POLL_NONE = 0x0        # Disable RUSD polling on all metric groups
    POLL_CLOCK = 0x1       # Enable RUSD polling on clock group
    POLL_PERF = 0x2        # Enable RUSD polling on performance group
    POLL_MEMORY = 0x4      # Enable RUSD polling on memory group
    POLL_POWER = 0x8       # Enable RUSD polling on power group
    POLL_THERMAL = 0x10    # Enable RUSD polling on thermal group
    POLL_PCI = 0x20        # Enable RUSD polling on pci group
    POLL_FAN = 0x40        # Enable RUSD polling on fan group
    POLL_PROC_UTIL = 0x80  # Enable RUSD polling on process utilization group


###############################################################################
# Error handling
###############################################################################


class NvmlError(Exception):
    def __init__(self, status):
        self.status = status
        s = error_string(status)
        super(NvmlError, self).__init__(s)

    def __reduce__(self):
        return (type(self), (self.status,))


class UninitializedError(NvmlError):
    pass

class InvalidArgumentError(NvmlError):
    pass

class NotSupportedError(NvmlError):
    pass

class NoPermissionError(NvmlError):
    pass

class AlreadyInitializedError(NvmlError):
    pass

class NotFoundError(NvmlError):
    pass

class InsufficientSizeError(NvmlError):
    pass

class InsufficientPowerError(NvmlError):
    pass

class DriverNotLoadedError(NvmlError):
    pass

class TimeoutError(NvmlError):
    pass

class IrqIssueError(NvmlError):
    pass

class LibraryNotFoundError(NvmlError):
    pass

class FunctionNotFoundError(NvmlError):
    pass

class CorruptedInforomError(NvmlError):
    pass

class GpuIsLostError(NvmlError):
    pass

class ResetRequiredError(NvmlError):
    pass

class OperatingSystemError(NvmlError):
    pass

class LibRmVersionMismatchError(NvmlError):
    pass

class InUseError(NvmlError):
    pass

class MemoryError(NvmlError):
    pass

class NoDataError(NvmlError):
    pass

class VgpuEccNotSupportedError(NvmlError):
    pass

class InsufficientResourcesError(NvmlError):
    pass

class FreqNotSupportedError(NvmlError):
    pass

class ArgumentVersionMismatchError(NvmlError):
    pass

class DeprecatedError(NvmlError):
    pass

class NotReadyError(NvmlError):
    pass

class GpuNotFoundError(NvmlError):
    pass

class InvalidStateError(NvmlError):
    pass

class ResetTypeNotSupportedError(NvmlError):
    pass

class UnknownError(NvmlError):
    pass

cdef object _nvml_error_factory(int status):
    cdef object pystatus = status
    if status == 1:
        return UninitializedError(pystatus)
    elif status == 2:
        return InvalidArgumentError(pystatus)
    elif status == 3:
        return NotSupportedError(pystatus)
    elif status == 4:
        return NoPermissionError(pystatus)
    elif status == 5:
        return AlreadyInitializedError(pystatus)
    elif status == 6:
        return NotFoundError(pystatus)
    elif status == 7:
        return InsufficientSizeError(pystatus)
    elif status == 8:
        return InsufficientPowerError(pystatus)
    elif status == 9:
        return DriverNotLoadedError(pystatus)
    elif status == 10:
        return TimeoutError(pystatus)
    elif status == 11:
        return IrqIssueError(pystatus)
    elif status == 12:
        return LibraryNotFoundError(pystatus)
    elif status == 13:
        return FunctionNotFoundError(pystatus)
    elif status == 14:
        return CorruptedInforomError(pystatus)
    elif status == 15:
        return GpuIsLostError(pystatus)
    elif status == 16:
        return ResetRequiredError(pystatus)
    elif status == 17:
        return OperatingSystemError(pystatus)
    elif status == 18:
        return LibRmVersionMismatchError(pystatus)
    elif status == 19:
        return InUseError(pystatus)
    elif status == 20:
        return MemoryError(pystatus)
    elif status == 21:
        return NoDataError(pystatus)
    elif status == 22:
        return VgpuEccNotSupportedError(pystatus)
    elif status == 23:
        return InsufficientResourcesError(pystatus)
    elif status == 24:
        return FreqNotSupportedError(pystatus)
    elif status == 25:
        return ArgumentVersionMismatchError(pystatus)
    elif status == 26:
        return DeprecatedError(pystatus)
    elif status == 27:
        return NotReadyError(pystatus)
    elif status == 28:
        return GpuNotFoundError(pystatus)
    elif status == 29:
        return InvalidStateError(pystatus)
    elif status == 30:
        return ResetTypeNotSupportedError(pystatus)
    elif status == 999:
        return UnknownError(pystatus)
    return NvmlError(status)



@cython.profile(False)
cpdef int check_status(int status) except 1 nogil:
    if status != 0:
        with gil:
            raise _nvml_error_factory(status)
    return status != 0


@cython.profile(False)
cpdef int check_status_size(int status) except 1 nogil:
    if status == nvmlReturn_t.NVML_ERROR_INSUFFICIENT_SIZE:
        return 0
    return check_status(status)


###############################################################################
# Wrapper functions
###############################################################################


cdef _get_pci_info_ext_v1_dtype_offsets():
    cdef nvmlPciInfoExt_v1_t pod = nvmlPciInfoExt_v1_t()
    return _numpy.dtype({
        'names': ['version', 'domain', 'bus', 'device_', 'pci_device_id', 'pci_sub_system_id', 'base_class', 'sub_class', 'bus_id'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.domain)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bus)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.device)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pciDeviceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pciSubSystemId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.baseClass)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.subClass)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.busId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPciInfoExt_v1_t),
    })

pci_info_ext_v1_dtype = _get_pci_info_ext_v1_dtype_offsets()

cdef class PciInfoExt_v1:
    """Empty-initialize an instance of `nvmlPciInfoExt_v1_t`.


    .. seealso:: `nvmlPciInfoExt_v1_t`
    """
    cdef:
        nvmlPciInfoExt_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPciInfoExt_v1_t *>calloc(1, sizeof(nvmlPciInfoExt_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PciInfoExt_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPciInfoExt_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PciInfoExt_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PciInfoExt_v1 other_
        if not isinstance(other, PciInfoExt_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPciInfoExt_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPciInfoExt_v1_t *>malloc(sizeof(nvmlPciInfoExt_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PciInfoExt_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPciInfoExt_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def domain(self):
        """int: The PCI domain on which the device's bus resides, 0 to 0xffffffff."""
        return self._ptr[0].domain

    @domain.setter
    def domain(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].domain = val

    @property
    def bus(self):
        """int: The bus on which the device resides, 0 to 0xff."""
        return self._ptr[0].bus

    @bus.setter
    def bus(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].bus = val

    @property
    def device_(self):
        """int: The device's id on the bus, 0 to 31."""
        return self._ptr[0].device

    @device_.setter
    def device_(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].device = val

    @property
    def pci_device_id(self):
        """int: The combined 16-bit device id and 16-bit vendor id."""
        return self._ptr[0].pciDeviceId

    @pci_device_id.setter
    def pci_device_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].pciDeviceId = val

    @property
    def pci_sub_system_id(self):
        """int: The 32-bit Sub System Device ID."""
        return self._ptr[0].pciSubSystemId

    @pci_sub_system_id.setter
    def pci_sub_system_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].pciSubSystemId = val

    @property
    def base_class(self):
        """int: The 8-bit PCI base class code."""
        return self._ptr[0].baseClass

    @base_class.setter
    def base_class(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].baseClass = val

    @property
    def sub_class(self):
        """int: The 8-bit PCI sub class code."""
        return self._ptr[0].subClass

    @sub_class.setter
    def sub_class(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        self._ptr[0].subClass = val

    @property
    def bus_id(self):
        """~_numpy.int8: (array of length 32).The tuple domain:bus:device.function PCI identifier (& NULL terminator)"""
        return cpython.PyUnicode_FromString(self._ptr[0].busId)

    @bus_id.setter
    def bus_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfoExt_v1 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 32:
            raise ValueError("String too long for field bus_id, max length is 31")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].busId), <void *>ptr, 32)

    @staticmethod
    def from_data(data):
        """Create an PciInfoExt_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `pci_info_ext_v1_dtype` holding the data.
        """
        return __from_data(data, "pci_info_ext_v1_dtype", pci_info_ext_v1_dtype, PciInfoExt_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PciInfoExt_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PciInfoExt_v1 obj = PciInfoExt_v1.__new__(PciInfoExt_v1)
        if owner is None:
            obj._ptr = <nvmlPciInfoExt_v1_t *>malloc(sizeof(nvmlPciInfoExt_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PciInfoExt_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPciInfoExt_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPciInfoExt_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_pci_info_dtype_offsets():
    cdef nvmlPciInfo_t pod = nvmlPciInfo_t()
    return _numpy.dtype({
        'names': ['bus_id_legacy', 'domain', 'bus', 'device_', 'pci_device_id', 'pci_sub_system_id', 'bus_id'],
        'formats': [_numpy.int8, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.busIdLegacy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.domain)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bus)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.device)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pciDeviceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pciSubSystemId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.busId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPciInfo_t),
    })

pci_info_dtype = _get_pci_info_dtype_offsets()

cdef class PciInfo:
    """Empty-initialize an instance of `nvmlPciInfo_t`.


    .. seealso:: `nvmlPciInfo_t`
    """
    cdef:
        nvmlPciInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPciInfo_t *>calloc(1, sizeof(nvmlPciInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PciInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPciInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PciInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PciInfo other_
        if not isinstance(other, PciInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPciInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPciInfo_t *>malloc(sizeof(nvmlPciInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PciInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPciInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def bus_id_legacy(self):
        """~_numpy.int8: (array of length 16)."""
        return cpython.PyUnicode_FromString(self._ptr[0].busIdLegacy)

    @bus_id_legacy.setter
    def bus_id_legacy(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 16:
            raise ValueError("String too long for field bus_id_legacy, max length is 15")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].busIdLegacy), <void *>ptr, 16)

    @property
    def domain(self):
        """int: """
        return self._ptr[0].domain

    @domain.setter
    def domain(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        self._ptr[0].domain = val

    @property
    def bus(self):
        """int: """
        return self._ptr[0].bus

    @bus.setter
    def bus(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        self._ptr[0].bus = val

    @property
    def device_(self):
        """int: """
        return self._ptr[0].device

    @device_.setter
    def device_(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        self._ptr[0].device = val

    @property
    def pci_device_id(self):
        """int: """
        return self._ptr[0].pciDeviceId

    @pci_device_id.setter
    def pci_device_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        self._ptr[0].pciDeviceId = val

    @property
    def pci_sub_system_id(self):
        """int: """
        return self._ptr[0].pciSubSystemId

    @pci_sub_system_id.setter
    def pci_sub_system_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        self._ptr[0].pciSubSystemId = val

    @property
    def bus_id(self):
        """~_numpy.int8: (array of length 32)."""
        return cpython.PyUnicode_FromString(self._ptr[0].busId)

    @bus_id.setter
    def bus_id(self, val):
        if self._readonly:
            raise ValueError("This PciInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 32:
            raise ValueError("String too long for field bus_id, max length is 31")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].busId), <void *>ptr, 32)

    @staticmethod
    def from_data(data):
        """Create an PciInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `pci_info_dtype` holding the data.
        """
        return __from_data(data, "pci_info_dtype", pci_info_dtype, PciInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PciInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PciInfo obj = PciInfo.__new__(PciInfo)
        if owner is None:
            obj._ptr = <nvmlPciInfo_t *>malloc(sizeof(nvmlPciInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PciInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPciInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPciInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_utilization_dtype_offsets():
    cdef nvmlUtilization_t pod = nvmlUtilization_t()
    return _numpy.dtype({
        'names': ['gpu', 'memory'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.gpu)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memory)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlUtilization_t),
    })

utilization_dtype = _get_utilization_dtype_offsets()

cdef class Utilization:
    """Empty-initialize an instance of `nvmlUtilization_t`.


    .. seealso:: `nvmlUtilization_t`
    """
    cdef:
        nvmlUtilization_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlUtilization_t *>calloc(1, sizeof(nvmlUtilization_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating Utilization")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlUtilization_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.Utilization object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef Utilization other_
        if not isinstance(other, Utilization):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlUtilization_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlUtilization_t *>malloc(sizeof(nvmlUtilization_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating Utilization")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlUtilization_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def gpu(self):
        """int: """
        return self._ptr[0].gpu

    @gpu.setter
    def gpu(self, val):
        if self._readonly:
            raise ValueError("This Utilization instance is read-only")
        self._ptr[0].gpu = val

    @property
    def memory(self):
        """int: """
        return self._ptr[0].memory

    @memory.setter
    def memory(self, val):
        if self._readonly:
            raise ValueError("This Utilization instance is read-only")
        self._ptr[0].memory = val

    @staticmethod
    def from_data(data):
        """Create an Utilization instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `utilization_dtype` holding the data.
        """
        return __from_data(data, "utilization_dtype", utilization_dtype, Utilization)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an Utilization instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Utilization obj = Utilization.__new__(Utilization)
        if owner is None:
            obj._ptr = <nvmlUtilization_t *>malloc(sizeof(nvmlUtilization_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating Utilization")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlUtilization_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlUtilization_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_memory_dtype_offsets():
    cdef nvmlMemory_t pod = nvmlMemory_t()
    return _numpy.dtype({
        'names': ['total', 'free', 'used'],
        'formats': [_numpy.uint64, _numpy.uint64, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.total)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.free)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.used)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlMemory_t),
    })

memory_dtype = _get_memory_dtype_offsets()

cdef class Memory:
    """Empty-initialize an instance of `nvmlMemory_t`.


    .. seealso:: `nvmlMemory_t`
    """
    cdef:
        nvmlMemory_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlMemory_t *>calloc(1, sizeof(nvmlMemory_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating Memory")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlMemory_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.Memory object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef Memory other_
        if not isinstance(other, Memory):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlMemory_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlMemory_t *>malloc(sizeof(nvmlMemory_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating Memory")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlMemory_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def total(self):
        """int: """
        return self._ptr[0].total

    @total.setter
    def total(self, val):
        if self._readonly:
            raise ValueError("This Memory instance is read-only")
        self._ptr[0].total = val

    @property
    def free(self):
        """int: """
        return self._ptr[0].free

    @free.setter
    def free(self, val):
        if self._readonly:
            raise ValueError("This Memory instance is read-only")
        self._ptr[0].free = val

    @property
    def used(self):
        """int: """
        return self._ptr[0].used

    @used.setter
    def used(self, val):
        if self._readonly:
            raise ValueError("This Memory instance is read-only")
        self._ptr[0].used = val

    @staticmethod
    def from_data(data):
        """Create an Memory instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `memory_dtype` holding the data.
        """
        return __from_data(data, "memory_dtype", memory_dtype, Memory)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an Memory instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Memory obj = Memory.__new__(Memory)
        if owner is None:
            obj._ptr = <nvmlMemory_t *>malloc(sizeof(nvmlMemory_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating Memory")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlMemory_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlMemory_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_memory_v2_dtype_offsets():
    cdef nvmlMemory_v2_t pod = nvmlMemory_v2_t()
    return _numpy.dtype({
        'names': ['version', 'total', 'reserved', 'free', 'used'],
        'formats': [_numpy.uint32, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.total)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.reserved)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.free)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.used)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlMemory_v2_t),
    })

memory_v2_dtype = _get_memory_v2_dtype_offsets()

cdef class Memory_v2:
    """Empty-initialize an instance of `nvmlMemory_v2_t`.


    .. seealso:: `nvmlMemory_v2_t`
    """
    cdef:
        nvmlMemory_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlMemory_v2_t *>calloc(1, sizeof(nvmlMemory_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating Memory_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlMemory_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.Memory_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef Memory_v2 other_
        if not isinstance(other, Memory_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlMemory_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlMemory_v2_t *>malloc(sizeof(nvmlMemory_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating Memory_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlMemory_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This Memory_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def total(self):
        """int: """
        return self._ptr[0].total

    @total.setter
    def total(self, val):
        if self._readonly:
            raise ValueError("This Memory_v2 instance is read-only")
        self._ptr[0].total = val

    @property
    def free(self):
        """int: """
        return self._ptr[0].free

    @free.setter
    def free(self, val):
        if self._readonly:
            raise ValueError("This Memory_v2 instance is read-only")
        self._ptr[0].free = val

    @property
    def used(self):
        """int: """
        return self._ptr[0].used

    @used.setter
    def used(self, val):
        if self._readonly:
            raise ValueError("This Memory_v2 instance is read-only")
        self._ptr[0].used = val

    @staticmethod
    def from_data(data):
        """Create an Memory_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `memory_v2_dtype` holding the data.
        """
        return __from_data(data, "memory_v2_dtype", memory_v2_dtype, Memory_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an Memory_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Memory_v2 obj = Memory_v2.__new__(Memory_v2)
        if owner is None:
            obj._ptr = <nvmlMemory_v2_t *>malloc(sizeof(nvmlMemory_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating Memory_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlMemory_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlMemory_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_ba_r1memory_dtype_offsets():
    cdef nvmlBAR1Memory_t pod = nvmlBAR1Memory_t()
    return _numpy.dtype({
        'names': ['bar1total', 'bar1free', 'bar1_used'],
        'formats': [_numpy.uint64, _numpy.uint64, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.bar1Total)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bar1Free)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bar1Used)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlBAR1Memory_t),
    })

ba_r1memory_dtype = _get_ba_r1memory_dtype_offsets()

cdef class BAR1Memory:
    """Empty-initialize an instance of `nvmlBAR1Memory_t`.


    .. seealso:: `nvmlBAR1Memory_t`
    """
    cdef:
        nvmlBAR1Memory_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlBAR1Memory_t *>calloc(1, sizeof(nvmlBAR1Memory_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating BAR1Memory")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlBAR1Memory_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.BAR1Memory object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef BAR1Memory other_
        if not isinstance(other, BAR1Memory):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlBAR1Memory_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlBAR1Memory_t *>malloc(sizeof(nvmlBAR1Memory_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating BAR1Memory")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlBAR1Memory_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def bar1total(self):
        """int: """
        return self._ptr[0].bar1Total

    @bar1total.setter
    def bar1total(self, val):
        if self._readonly:
            raise ValueError("This BAR1Memory instance is read-only")
        self._ptr[0].bar1Total = val

    @property
    def bar1free(self):
        """int: """
        return self._ptr[0].bar1Free

    @bar1free.setter
    def bar1free(self, val):
        if self._readonly:
            raise ValueError("This BAR1Memory instance is read-only")
        self._ptr[0].bar1Free = val

    @property
    def bar1_used(self):
        """int: """
        return self._ptr[0].bar1Used

    @bar1_used.setter
    def bar1_used(self, val):
        if self._readonly:
            raise ValueError("This BAR1Memory instance is read-only")
        self._ptr[0].bar1Used = val

    @staticmethod
    def from_data(data):
        """Create an BAR1Memory instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `ba_r1memory_dtype` holding the data.
        """
        return __from_data(data, "ba_r1memory_dtype", ba_r1memory_dtype, BAR1Memory)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an BAR1Memory instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef BAR1Memory obj = BAR1Memory.__new__(BAR1Memory)
        if owner is None:
            obj._ptr = <nvmlBAR1Memory_t *>malloc(sizeof(nvmlBAR1Memory_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating BAR1Memory")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlBAR1Memory_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlBAR1Memory_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_process_info_dtype_offsets():
    cdef nvmlProcessInfo_t pod = nvmlProcessInfo_t()
    return _numpy.dtype({
        'names': ['pid', 'used_gpu_memory', 'gpu_instance_id', 'compute_instance_id'],
        'formats': [_numpy.uint32, _numpy.uint64, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.usedGpuMemory)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpuInstanceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.computeInstanceId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessInfo_t),
    })

process_info_dtype = _get_process_info_dtype_offsets()

cdef class ProcessInfo:
    """Empty-initialize an array of `nvmlProcessInfo_t`.

    The resulting object is of length `size` and of dtype `process_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlProcessInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=process_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlProcessInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlProcessInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ProcessInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ProcessInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ProcessInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def used_gpu_memory(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.used_gpu_memory[0])
        return self._data.used_gpu_memory

    @used_gpu_memory.setter
    def used_gpu_memory(self, val):
        self._data.used_gpu_memory = val

    @property
    def gpu_instance_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.gpu_instance_id[0])
        return self._data.gpu_instance_id

    @gpu_instance_id.setter
    def gpu_instance_id(self, val):
        self._data.gpu_instance_id = val

    @property
    def compute_instance_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.compute_instance_id[0])
        return self._data.compute_instance_id

    @compute_instance_id.setter
    def compute_instance_id(self, val):
        self._data.compute_instance_id = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ProcessInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == process_info_dtype:
            return ProcessInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ProcessInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `process_info_dtype` holding the data.
        """
        cdef ProcessInfo obj = ProcessInfo.__new__(ProcessInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != process_info_dtype:
            raise ValueError("data array must be of dtype process_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ProcessInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessInfo obj = ProcessInfo.__new__(ProcessInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlProcessInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=process_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_process_detail_v1_dtype_offsets():
    cdef nvmlProcessDetail_v1_t pod = nvmlProcessDetail_v1_t()
    return _numpy.dtype({
        'names': ['pid', 'used_gpu_memory', 'gpu_instance_id', 'compute_instance_id', 'used_gpu_cc_protected_memory'],
        'formats': [_numpy.uint32, _numpy.uint64, _numpy.uint32, _numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.usedGpuMemory)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpuInstanceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.computeInstanceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.usedGpuCcProtectedMemory)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessDetail_v1_t),
    })

process_detail_v1_dtype = _get_process_detail_v1_dtype_offsets()

cdef class ProcessDetail_v1:
    """Empty-initialize an array of `nvmlProcessDetail_v1_t`.

    The resulting object is of length `size` and of dtype `process_detail_v1_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlProcessDetail_v1_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=process_detail_v1_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlProcessDetail_v1_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlProcessDetail_v1_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ProcessDetail_v1_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ProcessDetail_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ProcessDetail_v1)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: Process ID."""
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def used_gpu_memory(self):
        """Union[~_numpy.uint64, int]: Amount of used GPU memory in bytes. Under WDDM, NVML_VALUE_NOT_AVAILABLE is always reported because Windows KMD manages all the memory and not the NVIDIA driver"""
        if self._data.size == 1:
            return int(self._data.used_gpu_memory[0])
        return self._data.used_gpu_memory

    @used_gpu_memory.setter
    def used_gpu_memory(self, val):
        self._data.used_gpu_memory = val

    @property
    def gpu_instance_id(self):
        """Union[~_numpy.uint32, int]: If MIG is enabled, stores a valid GPU instance ID. gpuInstanceId is."""
        if self._data.size == 1:
            return int(self._data.gpu_instance_id[0])
        return self._data.gpu_instance_id

    @gpu_instance_id.setter
    def gpu_instance_id(self, val):
        self._data.gpu_instance_id = val

    @property
    def compute_instance_id(self):
        """Union[~_numpy.uint32, int]: If MIG is enabled, stores a valid compute instance ID. computeInstanceId."""
        if self._data.size == 1:
            return int(self._data.compute_instance_id[0])
        return self._data.compute_instance_id

    @compute_instance_id.setter
    def compute_instance_id(self, val):
        self._data.compute_instance_id = val

    @property
    def used_gpu_cc_protected_memory(self):
        """Union[~_numpy.uint64, int]: Amount of used GPU conf compute protected memory in bytes."""
        if self._data.size == 1:
            return int(self._data.used_gpu_cc_protected_memory[0])
        return self._data.used_gpu_cc_protected_memory

    @used_gpu_cc_protected_memory.setter
    def used_gpu_cc_protected_memory(self, val):
        self._data.used_gpu_cc_protected_memory = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ProcessDetail_v1.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == process_detail_v1_dtype:
            return ProcessDetail_v1.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ProcessDetail_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `process_detail_v1_dtype` holding the data.
        """
        cdef ProcessDetail_v1 obj = ProcessDetail_v1.__new__(ProcessDetail_v1)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != process_detail_v1_dtype:
            raise ValueError("data array must be of dtype process_detail_v1_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ProcessDetail_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessDetail_v1 obj = ProcessDetail_v1.__new__(ProcessDetail_v1)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlProcessDetail_v1_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=process_detail_v1_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_device_attributes_dtype_offsets():
    cdef nvmlDeviceAttributes_t pod = nvmlDeviceAttributes_t()
    return _numpy.dtype({
        'names': ['multiprocessor_count', 'shared_copy_engine_count', 'shared_decoder_count', 'shared_encoder_count', 'shared_jpeg_count', 'shared_ofa_count', 'gpu_instance_slice_count', 'compute_instance_slice_count', 'memory_size_mb'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.multiprocessorCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedCopyEngineCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedDecoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedEncoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedJpegCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedOfaCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpuInstanceSliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.computeInstanceSliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memorySizeMB)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDeviceAttributes_t),
    })

device_attributes_dtype = _get_device_attributes_dtype_offsets()

cdef class DeviceAttributes:
    """Empty-initialize an instance of `nvmlDeviceAttributes_t`.


    .. seealso:: `nvmlDeviceAttributes_t`
    """
    cdef:
        nvmlDeviceAttributes_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDeviceAttributes_t *>calloc(1, sizeof(nvmlDeviceAttributes_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DeviceAttributes")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDeviceAttributes_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DeviceAttributes object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DeviceAttributes other_
        if not isinstance(other, DeviceAttributes):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDeviceAttributes_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDeviceAttributes_t *>malloc(sizeof(nvmlDeviceAttributes_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DeviceAttributes")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDeviceAttributes_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def multiprocessor_count(self):
        """int: """
        return self._ptr[0].multiprocessorCount

    @multiprocessor_count.setter
    def multiprocessor_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].multiprocessorCount = val

    @property
    def shared_copy_engine_count(self):
        """int: """
        return self._ptr[0].sharedCopyEngineCount

    @shared_copy_engine_count.setter
    def shared_copy_engine_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].sharedCopyEngineCount = val

    @property
    def shared_decoder_count(self):
        """int: """
        return self._ptr[0].sharedDecoderCount

    @shared_decoder_count.setter
    def shared_decoder_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].sharedDecoderCount = val

    @property
    def shared_encoder_count(self):
        """int: """
        return self._ptr[0].sharedEncoderCount

    @shared_encoder_count.setter
    def shared_encoder_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].sharedEncoderCount = val

    @property
    def shared_jpeg_count(self):
        """int: """
        return self._ptr[0].sharedJpegCount

    @shared_jpeg_count.setter
    def shared_jpeg_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].sharedJpegCount = val

    @property
    def shared_ofa_count(self):
        """int: """
        return self._ptr[0].sharedOfaCount

    @shared_ofa_count.setter
    def shared_ofa_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].sharedOfaCount = val

    @property
    def gpu_instance_slice_count(self):
        """int: """
        return self._ptr[0].gpuInstanceSliceCount

    @gpu_instance_slice_count.setter
    def gpu_instance_slice_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].gpuInstanceSliceCount = val

    @property
    def compute_instance_slice_count(self):
        """int: """
        return self._ptr[0].computeInstanceSliceCount

    @compute_instance_slice_count.setter
    def compute_instance_slice_count(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].computeInstanceSliceCount = val

    @property
    def memory_size_mb(self):
        """int: """
        return self._ptr[0].memorySizeMB

    @memory_size_mb.setter
    def memory_size_mb(self, val):
        if self._readonly:
            raise ValueError("This DeviceAttributes instance is read-only")
        self._ptr[0].memorySizeMB = val

    @staticmethod
    def from_data(data):
        """Create an DeviceAttributes instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_attributes_dtype` holding the data.
        """
        return __from_data(data, "device_attributes_dtype", device_attributes_dtype, DeviceAttributes)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DeviceAttributes instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DeviceAttributes obj = DeviceAttributes.__new__(DeviceAttributes)
        if owner is None:
            obj._ptr = <nvmlDeviceAttributes_t *>malloc(sizeof(nvmlDeviceAttributes_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DeviceAttributes")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDeviceAttributes_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDeviceAttributes_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_c2c_mode_info_v1_dtype_offsets():
    cdef nvmlC2cModeInfo_v1_t pod = nvmlC2cModeInfo_v1_t()
    return _numpy.dtype({
        'names': ['is_c2c_enabled'],
        'formats': [_numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.isC2cEnabled)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlC2cModeInfo_v1_t),
    })

c2c_mode_info_v1_dtype = _get_c2c_mode_info_v1_dtype_offsets()

cdef class C2cModeInfo_v1:
    """Empty-initialize an instance of `nvmlC2cModeInfo_v1_t`.


    .. seealso:: `nvmlC2cModeInfo_v1_t`
    """
    cdef:
        nvmlC2cModeInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlC2cModeInfo_v1_t *>calloc(1, sizeof(nvmlC2cModeInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating C2cModeInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlC2cModeInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.C2cModeInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef C2cModeInfo_v1 other_
        if not isinstance(other, C2cModeInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlC2cModeInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlC2cModeInfo_v1_t *>malloc(sizeof(nvmlC2cModeInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating C2cModeInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlC2cModeInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def is_c2c_enabled(self):
        """int: """
        return self._ptr[0].isC2cEnabled

    @is_c2c_enabled.setter
    def is_c2c_enabled(self, val):
        if self._readonly:
            raise ValueError("This C2cModeInfo_v1 instance is read-only")
        self._ptr[0].isC2cEnabled = val

    @staticmethod
    def from_data(data):
        """Create an C2cModeInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `c2c_mode_info_v1_dtype` holding the data.
        """
        return __from_data(data, "c2c_mode_info_v1_dtype", c2c_mode_info_v1_dtype, C2cModeInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an C2cModeInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef C2cModeInfo_v1 obj = C2cModeInfo_v1.__new__(C2cModeInfo_v1)
        if owner is None:
            obj._ptr = <nvmlC2cModeInfo_v1_t *>malloc(sizeof(nvmlC2cModeInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating C2cModeInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlC2cModeInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlC2cModeInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_row_remapper_histogram_values_dtype_offsets():
    cdef nvmlRowRemapperHistogramValues_t pod = nvmlRowRemapperHistogramValues_t()
    return _numpy.dtype({
        'names': ['max_', 'high', 'partial', 'low', 'none'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.max)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.high)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.partial)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.low)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.none)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlRowRemapperHistogramValues_t),
    })

row_remapper_histogram_values_dtype = _get_row_remapper_histogram_values_dtype_offsets()

cdef class RowRemapperHistogramValues:
    """Empty-initialize an instance of `nvmlRowRemapperHistogramValues_t`.


    .. seealso:: `nvmlRowRemapperHistogramValues_t`
    """
    cdef:
        nvmlRowRemapperHistogramValues_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlRowRemapperHistogramValues_t *>calloc(1, sizeof(nvmlRowRemapperHistogramValues_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating RowRemapperHistogramValues")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlRowRemapperHistogramValues_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.RowRemapperHistogramValues object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef RowRemapperHistogramValues other_
        if not isinstance(other, RowRemapperHistogramValues):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlRowRemapperHistogramValues_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlRowRemapperHistogramValues_t *>malloc(sizeof(nvmlRowRemapperHistogramValues_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating RowRemapperHistogramValues")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlRowRemapperHistogramValues_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def max_(self):
        """int: """
        return self._ptr[0].max

    @max_.setter
    def max_(self, val):
        if self._readonly:
            raise ValueError("This RowRemapperHistogramValues instance is read-only")
        self._ptr[0].max = val

    @property
    def high(self):
        """int: """
        return self._ptr[0].high

    @high.setter
    def high(self, val):
        if self._readonly:
            raise ValueError("This RowRemapperHistogramValues instance is read-only")
        self._ptr[0].high = val

    @property
    def partial(self):
        """int: """
        return self._ptr[0].partial

    @partial.setter
    def partial(self, val):
        if self._readonly:
            raise ValueError("This RowRemapperHistogramValues instance is read-only")
        self._ptr[0].partial = val

    @property
    def low(self):
        """int: """
        return self._ptr[0].low

    @low.setter
    def low(self, val):
        if self._readonly:
            raise ValueError("This RowRemapperHistogramValues instance is read-only")
        self._ptr[0].low = val

    @property
    def none(self):
        """int: """
        return self._ptr[0].none

    @none.setter
    def none(self, val):
        if self._readonly:
            raise ValueError("This RowRemapperHistogramValues instance is read-only")
        self._ptr[0].none = val

    @staticmethod
    def from_data(data):
        """Create an RowRemapperHistogramValues instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `row_remapper_histogram_values_dtype` holding the data.
        """
        return __from_data(data, "row_remapper_histogram_values_dtype", row_remapper_histogram_values_dtype, RowRemapperHistogramValues)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an RowRemapperHistogramValues instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef RowRemapperHistogramValues obj = RowRemapperHistogramValues.__new__(RowRemapperHistogramValues)
        if owner is None:
            obj._ptr = <nvmlRowRemapperHistogramValues_t *>malloc(sizeof(nvmlRowRemapperHistogramValues_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating RowRemapperHistogramValues")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlRowRemapperHistogramValues_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlRowRemapperHistogramValues_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_bridge_chip_info_dtype_offsets():
    cdef nvmlBridgeChipInfo_t pod = nvmlBridgeChipInfo_t()
    return _numpy.dtype({
        'names': ['type', 'fw_version'],
        'formats': [_numpy.int32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.type)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.fwVersion)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlBridgeChipInfo_t),
    })

bridge_chip_info_dtype = _get_bridge_chip_info_dtype_offsets()

cdef class BridgeChipInfo:
    """Empty-initialize an array of `nvmlBridgeChipInfo_t`.

    The resulting object is of length `size` and of dtype `bridge_chip_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlBridgeChipInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=bridge_chip_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlBridgeChipInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlBridgeChipInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.BridgeChipInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.BridgeChipInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, BridgeChipInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def type(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.type[0])
        return self._data.type

    @type.setter
    def type(self, val):
        self._data.type = val

    @property
    def fw_version(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.fw_version[0])
        return self._data.fw_version

    @fw_version.setter
    def fw_version(self, val):
        self._data.fw_version = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return BridgeChipInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == bridge_chip_info_dtype:
            return BridgeChipInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an BridgeChipInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `bridge_chip_info_dtype` holding the data.
        """
        cdef BridgeChipInfo obj = BridgeChipInfo.__new__(BridgeChipInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != bridge_chip_info_dtype:
            raise ValueError("data array must be of dtype bridge_chip_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an BridgeChipInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef BridgeChipInfo obj = BridgeChipInfo.__new__(BridgeChipInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlBridgeChipInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=bridge_chip_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


value_dtype = _numpy.dtype((
    _numpy.dtype((_numpy.void, sizeof(nvmlValue_t))),
    {
        "d_val": (_numpy.float64, 0),
        "si_val": (_numpy.int32, 0),
        "ui_val": (_numpy.uint32, 0),
        "ul_val": (_numpy.uint32, 0),
        "ull_val": (_numpy.uint64, 0),
        "sll_val": (_numpy.int64, 0),
        "us_val": (_numpy.uint16, 0),
    }
    ))


cdef class Value:
    """Empty-initialize an instance of `nvmlValue_t`.


    .. seealso:: `nvmlValue_t`
    """
    cdef:
        nvmlValue_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlValue_t *>calloc(1, sizeof(nvmlValue_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating Value")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlValue_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.Value object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef Value other_
        if not isinstance(other, Value):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlValue_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlValue_t *>malloc(sizeof(nvmlValue_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating Value")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlValue_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def d_val(self):
        """float: """
        return self._ptr[0].dVal

    @d_val.setter
    def d_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].dVal = val

    @property
    def si_val(self):
        """int: """
        return self._ptr[0].siVal

    @si_val.setter
    def si_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].siVal = val

    @property
    def ui_val(self):
        """int: """
        return self._ptr[0].uiVal

    @ui_val.setter
    def ui_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].uiVal = val

    @property
    def ul_val(self):
        """int: """
        return self._ptr[0].ulVal

    @ul_val.setter
    def ul_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].ulVal = val

    @property
    def ull_val(self):
        """int: """
        return self._ptr[0].ullVal

    @ull_val.setter
    def ull_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].ullVal = val

    @property
    def sll_val(self):
        """int: """
        return self._ptr[0].sllVal

    @sll_val.setter
    def sll_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].sllVal = val

    @property
    def us_val(self):
        """int: """
        return self._ptr[0].usVal

    @us_val.setter
    def us_val(self, val):
        if self._readonly:
            raise ValueError("This Value instance is read-only")
        self._ptr[0].usVal = val

    @staticmethod
    def from_data(data):
        """Create an Value instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `value_dtype` holding the data.
        """
        return __from_data(data, "value_dtype", value_dtype, Value)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an Value instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Value obj = Value.__new__(Value)
        if owner is None:
            obj._ptr = <nvmlValue_t *>malloc(sizeof(nvmlValue_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating Value")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlValue_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlValue_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get__py_anon_pod0_dtype_offsets():
    cdef _anon_pod0 pod = _anon_pod0()
    return _numpy.dtype({
        'names': ['controller', 'default_min_temp', 'default_max_temp', 'current_temp', 'target'],
        'formats': [_numpy.int32, _numpy.int32, _numpy.int32, _numpy.int32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.controller)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.defaultMinTemp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.defaultMaxTemp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.currentTemp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.target)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod0),
    })

_py_anon_pod0_dtype = _get__py_anon_pod0_dtype_offsets()

cdef class _py_anon_pod0:
    """Empty-initialize an instance of `_anon_pod0`.


    .. seealso:: `_anon_pod0`
    """
    cdef:
        _anon_pod0 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod0 *>calloc(1, sizeof(_anon_pod0))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod0")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod0 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod0 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod0 other_
        if not isinstance(other, _py_anon_pod0):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod0)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod0 *>malloc(sizeof(_anon_pod0))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod0")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod0))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def controller(self):
        """int: """
        return <int>(self._ptr[0].controller)

    @controller.setter
    def controller(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod0 instance is read-only")
        self._ptr[0].controller = <nvmlThermalController_t><int>val

    @property
    def default_min_temp(self):
        """int: """
        return self._ptr[0].defaultMinTemp

    @default_min_temp.setter
    def default_min_temp(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod0 instance is read-only")
        self._ptr[0].defaultMinTemp = val

    @property
    def default_max_temp(self):
        """int: """
        return self._ptr[0].defaultMaxTemp

    @default_max_temp.setter
    def default_max_temp(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod0 instance is read-only")
        self._ptr[0].defaultMaxTemp = val

    @property
    def current_temp(self):
        """int: """
        return self._ptr[0].currentTemp

    @current_temp.setter
    def current_temp(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod0 instance is read-only")
        self._ptr[0].currentTemp = val

    @property
    def target(self):
        """int: """
        return <int>(self._ptr[0].target)

    @target.setter
    def target(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod0 instance is read-only")
        self._ptr[0].target = <nvmlThermalTarget_t><int>val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod0 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod0_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod0_dtype", _py_anon_pod0_dtype, _py_anon_pod0)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod0 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod0 obj = _py_anon_pod0.__new__(_py_anon_pod0)
        if owner is None:
            obj._ptr = <_anon_pod0 *>malloc(sizeof(_anon_pod0))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod0")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod0))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod0 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_cooler_info_v1_dtype_offsets():
    cdef nvmlCoolerInfo_v1_t pod = nvmlCoolerInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'ind_ex', 'signal_type', 'target'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.int32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.index)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.signalType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.target)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlCoolerInfo_v1_t),
    })

cooler_info_v1_dtype = _get_cooler_info_v1_dtype_offsets()

cdef class CoolerInfo_v1:
    """Empty-initialize an instance of `nvmlCoolerInfo_v1_t`.


    .. seealso:: `nvmlCoolerInfo_v1_t`
    """
    cdef:
        nvmlCoolerInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlCoolerInfo_v1_t *>calloc(1, sizeof(nvmlCoolerInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating CoolerInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlCoolerInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.CoolerInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef CoolerInfo_v1 other_
        if not isinstance(other, CoolerInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlCoolerInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlCoolerInfo_v1_t *>malloc(sizeof(nvmlCoolerInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating CoolerInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlCoolerInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This CoolerInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def ind_ex(self):
        """int: the cooler index"""
        return self._ptr[0].index

    @ind_ex.setter
    def ind_ex(self, val):
        if self._readonly:
            raise ValueError("This CoolerInfo_v1 instance is read-only")
        self._ptr[0].index = val

    @property
    def signal_type(self):
        """int: OUT: the cooler's control signal characteristics."""
        return <int>(self._ptr[0].signalType)

    @signal_type.setter
    def signal_type(self, val):
        if self._readonly:
            raise ValueError("This CoolerInfo_v1 instance is read-only")
        self._ptr[0].signalType = <nvmlCoolerControl_t><int>val

    @property
    def target(self):
        """int: OUT: the target that cooler cools."""
        return <int>(self._ptr[0].target)

    @target.setter
    def target(self, val):
        if self._readonly:
            raise ValueError("This CoolerInfo_v1 instance is read-only")
        self._ptr[0].target = <nvmlCoolerTarget_t><int>val

    @staticmethod
    def from_data(data):
        """Create an CoolerInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `cooler_info_v1_dtype` holding the data.
        """
        return __from_data(data, "cooler_info_v1_dtype", cooler_info_v1_dtype, CoolerInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an CoolerInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef CoolerInfo_v1 obj = CoolerInfo_v1.__new__(CoolerInfo_v1)
        if owner is None:
            obj._ptr = <nvmlCoolerInfo_v1_t *>malloc(sizeof(nvmlCoolerInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating CoolerInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlCoolerInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlCoolerInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_margin_temperature_v1_dtype_offsets():
    cdef nvmlMarginTemperature_v1_t pod = nvmlMarginTemperature_v1_t()
    return _numpy.dtype({
        'names': ['version', 'margin_temperature'],
        'formats': [_numpy.uint32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.marginTemperature)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlMarginTemperature_v1_t),
    })

margin_temperature_v1_dtype = _get_margin_temperature_v1_dtype_offsets()

cdef class MarginTemperature_v1:
    """Empty-initialize an instance of `nvmlMarginTemperature_v1_t`.


    .. seealso:: `nvmlMarginTemperature_v1_t`
    """
    cdef:
        nvmlMarginTemperature_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlMarginTemperature_v1_t *>calloc(1, sizeof(nvmlMarginTemperature_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating MarginTemperature_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlMarginTemperature_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.MarginTemperature_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef MarginTemperature_v1 other_
        if not isinstance(other, MarginTemperature_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlMarginTemperature_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlMarginTemperature_v1_t *>malloc(sizeof(nvmlMarginTemperature_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating MarginTemperature_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlMarginTemperature_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This MarginTemperature_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def margin_temperature(self):
        """int: The margin temperature value."""
        return self._ptr[0].marginTemperature

    @margin_temperature.setter
    def margin_temperature(self, val):
        if self._readonly:
            raise ValueError("This MarginTemperature_v1 instance is read-only")
        self._ptr[0].marginTemperature = val

    @staticmethod
    def from_data(data):
        """Create an MarginTemperature_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `margin_temperature_v1_dtype` holding the data.
        """
        return __from_data(data, "margin_temperature_v1_dtype", margin_temperature_v1_dtype, MarginTemperature_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an MarginTemperature_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef MarginTemperature_v1 obj = MarginTemperature_v1.__new__(MarginTemperature_v1)
        if owner is None:
            obj._ptr = <nvmlMarginTemperature_v1_t *>malloc(sizeof(nvmlMarginTemperature_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating MarginTemperature_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlMarginTemperature_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlMarginTemperature_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_clk_mon_fault_info_dtype_offsets():
    cdef nvmlClkMonFaultInfo_t pod = nvmlClkMonFaultInfo_t()
    return _numpy.dtype({
        'names': ['clk_api_domain', 'clk_domain_fault_mask'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.clkApiDomain)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clkDomainFaultMask)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlClkMonFaultInfo_t),
    })

clk_mon_fault_info_dtype = _get_clk_mon_fault_info_dtype_offsets()

cdef class ClkMonFaultInfo:
    """Empty-initialize an array of `nvmlClkMonFaultInfo_t`.

    The resulting object is of length `size` and of dtype `clk_mon_fault_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlClkMonFaultInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=clk_mon_fault_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlClkMonFaultInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlClkMonFaultInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ClkMonFaultInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ClkMonFaultInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ClkMonFaultInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def clk_api_domain(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.clk_api_domain[0])
        return self._data.clk_api_domain

    @clk_api_domain.setter
    def clk_api_domain(self, val):
        self._data.clk_api_domain = val

    @property
    def clk_domain_fault_mask(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.clk_domain_fault_mask[0])
        return self._data.clk_domain_fault_mask

    @clk_domain_fault_mask.setter
    def clk_domain_fault_mask(self, val):
        self._data.clk_domain_fault_mask = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ClkMonFaultInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == clk_mon_fault_info_dtype:
            return ClkMonFaultInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ClkMonFaultInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `clk_mon_fault_info_dtype` holding the data.
        """
        cdef ClkMonFaultInfo obj = ClkMonFaultInfo.__new__(ClkMonFaultInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != clk_mon_fault_info_dtype:
            raise ValueError("data array must be of dtype clk_mon_fault_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ClkMonFaultInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ClkMonFaultInfo obj = ClkMonFaultInfo.__new__(ClkMonFaultInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlClkMonFaultInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=clk_mon_fault_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_clock_offset_v1_dtype_offsets():
    cdef nvmlClockOffset_v1_t pod = nvmlClockOffset_v1_t()
    return _numpy.dtype({
        'names': ['version', 'type', 'pstate', 'clock_offset_m_hz', 'min_clock_offset_m_hz', 'max_clock_offset_m_hz'],
        'formats': [_numpy.uint32, _numpy.int32, _numpy.int32, _numpy.int32, _numpy.int32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.type)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pstate)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clockOffsetMHz)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.minClockOffsetMHz)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxClockOffsetMHz)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlClockOffset_v1_t),
    })

clock_offset_v1_dtype = _get_clock_offset_v1_dtype_offsets()

cdef class ClockOffset_v1:
    """Empty-initialize an instance of `nvmlClockOffset_v1_t`.


    .. seealso:: `nvmlClockOffset_v1_t`
    """
    cdef:
        nvmlClockOffset_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlClockOffset_v1_t *>calloc(1, sizeof(nvmlClockOffset_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ClockOffset_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlClockOffset_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ClockOffset_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ClockOffset_v1 other_
        if not isinstance(other, ClockOffset_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlClockOffset_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlClockOffset_v1_t *>malloc(sizeof(nvmlClockOffset_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ClockOffset_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlClockOffset_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def type(self):
        """int: """
        return <int>(self._ptr[0].type)

    @type.setter
    def type(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].type = <nvmlClockType_t><int>val

    @property
    def pstate(self):
        """int: """
        return <int>(self._ptr[0].pstate)

    @pstate.setter
    def pstate(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].pstate = <nvmlPstates_t><int>val

    @property
    def clock_offset_m_hz(self):
        """int: """
        return self._ptr[0].clockOffsetMHz

    @clock_offset_m_hz.setter
    def clock_offset_m_hz(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].clockOffsetMHz = val

    @property
    def min_clock_offset_m_hz(self):
        """int: """
        return self._ptr[0].minClockOffsetMHz

    @min_clock_offset_m_hz.setter
    def min_clock_offset_m_hz(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].minClockOffsetMHz = val

    @property
    def max_clock_offset_m_hz(self):
        """int: """
        return self._ptr[0].maxClockOffsetMHz

    @max_clock_offset_m_hz.setter
    def max_clock_offset_m_hz(self, val):
        if self._readonly:
            raise ValueError("This ClockOffset_v1 instance is read-only")
        self._ptr[0].maxClockOffsetMHz = val

    @staticmethod
    def from_data(data):
        """Create an ClockOffset_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `clock_offset_v1_dtype` holding the data.
        """
        return __from_data(data, "clock_offset_v1_dtype", clock_offset_v1_dtype, ClockOffset_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ClockOffset_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ClockOffset_v1 obj = ClockOffset_v1.__new__(ClockOffset_v1)
        if owner is None:
            obj._ptr = <nvmlClockOffset_v1_t *>malloc(sizeof(nvmlClockOffset_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ClockOffset_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlClockOffset_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlClockOffset_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_fan_speed_info_v1_dtype_offsets():
    cdef nvmlFanSpeedInfo_v1_t pod = nvmlFanSpeedInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'fan', 'speed'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.fan)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.speed)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlFanSpeedInfo_v1_t),
    })

fan_speed_info_v1_dtype = _get_fan_speed_info_v1_dtype_offsets()

cdef class FanSpeedInfo_v1:
    """Empty-initialize an instance of `nvmlFanSpeedInfo_v1_t`.


    .. seealso:: `nvmlFanSpeedInfo_v1_t`
    """
    cdef:
        nvmlFanSpeedInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlFanSpeedInfo_v1_t *>calloc(1, sizeof(nvmlFanSpeedInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating FanSpeedInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlFanSpeedInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.FanSpeedInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef FanSpeedInfo_v1 other_
        if not isinstance(other, FanSpeedInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlFanSpeedInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlFanSpeedInfo_v1_t *>malloc(sizeof(nvmlFanSpeedInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating FanSpeedInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlFanSpeedInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This FanSpeedInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def fan(self):
        """int: the fan index"""
        return self._ptr[0].fan

    @fan.setter
    def fan(self, val):
        if self._readonly:
            raise ValueError("This FanSpeedInfo_v1 instance is read-only")
        self._ptr[0].fan = val

    @property
    def speed(self):
        """int: OUT: the fan speed in RPM."""
        return self._ptr[0].speed

    @speed.setter
    def speed(self, val):
        if self._readonly:
            raise ValueError("This FanSpeedInfo_v1 instance is read-only")
        self._ptr[0].speed = val

    @staticmethod
    def from_data(data):
        """Create an FanSpeedInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `fan_speed_info_v1_dtype` holding the data.
        """
        return __from_data(data, "fan_speed_info_v1_dtype", fan_speed_info_v1_dtype, FanSpeedInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an FanSpeedInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef FanSpeedInfo_v1 obj = FanSpeedInfo_v1.__new__(FanSpeedInfo_v1)
        if owner is None:
            obj._ptr = <nvmlFanSpeedInfo_v1_t *>malloc(sizeof(nvmlFanSpeedInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating FanSpeedInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlFanSpeedInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlFanSpeedInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_device_perf_modes_v1_dtype_offsets():
    cdef nvmlDevicePerfModes_v1_t pod = nvmlDevicePerfModes_v1_t()
    return _numpy.dtype({
        'names': ['version', 'str'],
        'formats': [_numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.str)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDevicePerfModes_v1_t),
    })

device_perf_modes_v1_dtype = _get_device_perf_modes_v1_dtype_offsets()

cdef class DevicePerfModes_v1:
    """Empty-initialize an instance of `nvmlDevicePerfModes_v1_t`.


    .. seealso:: `nvmlDevicePerfModes_v1_t`
    """
    cdef:
        nvmlDevicePerfModes_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDevicePerfModes_v1_t *>calloc(1, sizeof(nvmlDevicePerfModes_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DevicePerfModes_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDevicePerfModes_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DevicePerfModes_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DevicePerfModes_v1 other_
        if not isinstance(other, DevicePerfModes_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDevicePerfModes_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDevicePerfModes_v1_t *>malloc(sizeof(nvmlDevicePerfModes_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DevicePerfModes_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDevicePerfModes_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This DevicePerfModes_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def str(self):
        """~_numpy.int8: (array of length 2048).OUT: the performance modes string."""
        return cpython.PyUnicode_FromString(self._ptr[0].str)

    @str.setter
    def str(self, val):
        if self._readonly:
            raise ValueError("This DevicePerfModes_v1 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 2048:
            raise ValueError("String too long for field str, max length is 2047")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].str), <void *>ptr, 2048)

    @staticmethod
    def from_data(data):
        """Create an DevicePerfModes_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_perf_modes_v1_dtype` holding the data.
        """
        return __from_data(data, "device_perf_modes_v1_dtype", device_perf_modes_v1_dtype, DevicePerfModes_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DevicePerfModes_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DevicePerfModes_v1 obj = DevicePerfModes_v1.__new__(DevicePerfModes_v1)
        if owner is None:
            obj._ptr = <nvmlDevicePerfModes_v1_t *>malloc(sizeof(nvmlDevicePerfModes_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DevicePerfModes_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDevicePerfModes_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDevicePerfModes_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_device_current_clock_freqs_v1_dtype_offsets():
    cdef nvmlDeviceCurrentClockFreqs_v1_t pod = nvmlDeviceCurrentClockFreqs_v1_t()
    return _numpy.dtype({
        'names': ['version', 'str'],
        'formats': [_numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.str)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDeviceCurrentClockFreqs_v1_t),
    })

device_current_clock_freqs_v1_dtype = _get_device_current_clock_freqs_v1_dtype_offsets()

cdef class DeviceCurrentClockFreqs_v1:
    """Empty-initialize an instance of `nvmlDeviceCurrentClockFreqs_v1_t`.


    .. seealso:: `nvmlDeviceCurrentClockFreqs_v1_t`
    """
    cdef:
        nvmlDeviceCurrentClockFreqs_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDeviceCurrentClockFreqs_v1_t *>calloc(1, sizeof(nvmlDeviceCurrentClockFreqs_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DeviceCurrentClockFreqs_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDeviceCurrentClockFreqs_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DeviceCurrentClockFreqs_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DeviceCurrentClockFreqs_v1 other_
        if not isinstance(other, DeviceCurrentClockFreqs_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDeviceCurrentClockFreqs_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDeviceCurrentClockFreqs_v1_t *>malloc(sizeof(nvmlDeviceCurrentClockFreqs_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DeviceCurrentClockFreqs_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDeviceCurrentClockFreqs_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This DeviceCurrentClockFreqs_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def str(self):
        """~_numpy.int8: (array of length 2048).OUT: the current clock frequency string."""
        return cpython.PyUnicode_FromString(self._ptr[0].str)

    @str.setter
    def str(self, val):
        if self._readonly:
            raise ValueError("This DeviceCurrentClockFreqs_v1 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 2048:
            raise ValueError("String too long for field str, max length is 2047")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].str), <void *>ptr, 2048)

    @staticmethod
    def from_data(data):
        """Create an DeviceCurrentClockFreqs_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_current_clock_freqs_v1_dtype` holding the data.
        """
        return __from_data(data, "device_current_clock_freqs_v1_dtype", device_current_clock_freqs_v1_dtype, DeviceCurrentClockFreqs_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DeviceCurrentClockFreqs_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DeviceCurrentClockFreqs_v1 obj = DeviceCurrentClockFreqs_v1.__new__(DeviceCurrentClockFreqs_v1)
        if owner is None:
            obj._ptr = <nvmlDeviceCurrentClockFreqs_v1_t *>malloc(sizeof(nvmlDeviceCurrentClockFreqs_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DeviceCurrentClockFreqs_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDeviceCurrentClockFreqs_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDeviceCurrentClockFreqs_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_process_utilization_sample_dtype_offsets():
    cdef nvmlProcessUtilizationSample_t pod = nvmlProcessUtilizationSample_t()
    return _numpy.dtype({
        'names': ['pid', 'time_stamp', 'sm_util', 'mem_util', 'enc_util', 'dec_util'],
        'formats': [_numpy.uint32, _numpy.uint64, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.smUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decUtil)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessUtilizationSample_t),
    })

process_utilization_sample_dtype = _get_process_utilization_sample_dtype_offsets()

cdef class ProcessUtilizationSample:
    """Empty-initialize an array of `nvmlProcessUtilizationSample_t`.

    The resulting object is of length `size` and of dtype `process_utilization_sample_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlProcessUtilizationSample_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=process_utilization_sample_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlProcessUtilizationSample_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlProcessUtilizationSample_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ProcessUtilizationSample_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ProcessUtilizationSample object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ProcessUtilizationSample)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def time_stamp(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.time_stamp[0])
        return self._data.time_stamp

    @time_stamp.setter
    def time_stamp(self, val):
        self._data.time_stamp = val

    @property
    def sm_util(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.sm_util[0])
        return self._data.sm_util

    @sm_util.setter
    def sm_util(self, val):
        self._data.sm_util = val

    @property
    def mem_util(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.mem_util[0])
        return self._data.mem_util

    @mem_util.setter
    def mem_util(self, val):
        self._data.mem_util = val

    @property
    def enc_util(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.enc_util[0])
        return self._data.enc_util

    @enc_util.setter
    def enc_util(self, val):
        self._data.enc_util = val

    @property
    def dec_util(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.dec_util[0])
        return self._data.dec_util

    @dec_util.setter
    def dec_util(self, val):
        self._data.dec_util = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ProcessUtilizationSample.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == process_utilization_sample_dtype:
            return ProcessUtilizationSample.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ProcessUtilizationSample instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `process_utilization_sample_dtype` holding the data.
        """
        cdef ProcessUtilizationSample obj = ProcessUtilizationSample.__new__(ProcessUtilizationSample)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != process_utilization_sample_dtype:
            raise ValueError("data array must be of dtype process_utilization_sample_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ProcessUtilizationSample instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessUtilizationSample obj = ProcessUtilizationSample.__new__(ProcessUtilizationSample)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlProcessUtilizationSample_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=process_utilization_sample_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_process_utilization_info_v1_dtype_offsets():
    cdef nvmlProcessUtilizationInfo_v1_t pod = nvmlProcessUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['time_stamp', 'pid', 'sm_util', 'mem_util', 'enc_util', 'dec_util', 'jpg_util', 'ofa_util'],
        'formats': [_numpy.uint64, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.timeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.smUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.jpgUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ofaUtil)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessUtilizationInfo_v1_t),
    })

process_utilization_info_v1_dtype = _get_process_utilization_info_v1_dtype_offsets()

cdef class ProcessUtilizationInfo_v1:
    """Empty-initialize an array of `nvmlProcessUtilizationInfo_v1_t`.

    The resulting object is of length `size` and of dtype `process_utilization_info_v1_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlProcessUtilizationInfo_v1_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=process_utilization_info_v1_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlProcessUtilizationInfo_v1_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlProcessUtilizationInfo_v1_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ProcessUtilizationInfo_v1_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ProcessUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ProcessUtilizationInfo_v1)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def time_stamp(self):
        """Union[~_numpy.uint64, int]: CPU Timestamp in microseconds."""
        if self._data.size == 1:
            return int(self._data.time_stamp[0])
        return self._data.time_stamp

    @time_stamp.setter
    def time_stamp(self, val):
        self._data.time_stamp = val

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: PID of process."""
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def sm_util(self):
        """Union[~_numpy.uint32, int]: SM (3D/Compute) Util Value."""
        if self._data.size == 1:
            return int(self._data.sm_util[0])
        return self._data.sm_util

    @sm_util.setter
    def sm_util(self, val):
        self._data.sm_util = val

    @property
    def mem_util(self):
        """Union[~_numpy.uint32, int]: Frame Buffer Memory Util Value."""
        if self._data.size == 1:
            return int(self._data.mem_util[0])
        return self._data.mem_util

    @mem_util.setter
    def mem_util(self, val):
        self._data.mem_util = val

    @property
    def enc_util(self):
        """Union[~_numpy.uint32, int]: Encoder Util Value."""
        if self._data.size == 1:
            return int(self._data.enc_util[0])
        return self._data.enc_util

    @enc_util.setter
    def enc_util(self, val):
        self._data.enc_util = val

    @property
    def dec_util(self):
        """Union[~_numpy.uint32, int]: Decoder Util Value."""
        if self._data.size == 1:
            return int(self._data.dec_util[0])
        return self._data.dec_util

    @dec_util.setter
    def dec_util(self, val):
        self._data.dec_util = val

    @property
    def jpg_util(self):
        """Union[~_numpy.uint32, int]: Jpeg Util Value."""
        if self._data.size == 1:
            return int(self._data.jpg_util[0])
        return self._data.jpg_util

    @jpg_util.setter
    def jpg_util(self, val):
        self._data.jpg_util = val

    @property
    def ofa_util(self):
        """Union[~_numpy.uint32, int]: Ofa Util Value."""
        if self._data.size == 1:
            return int(self._data.ofa_util[0])
        return self._data.ofa_util

    @ofa_util.setter
    def ofa_util(self, val):
        self._data.ofa_util = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ProcessUtilizationInfo_v1.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == process_utilization_info_v1_dtype:
            return ProcessUtilizationInfo_v1.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ProcessUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `process_utilization_info_v1_dtype` holding the data.
        """
        cdef ProcessUtilizationInfo_v1 obj = ProcessUtilizationInfo_v1.__new__(ProcessUtilizationInfo_v1)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != process_utilization_info_v1_dtype:
            raise ValueError("data array must be of dtype process_utilization_info_v1_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ProcessUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessUtilizationInfo_v1 obj = ProcessUtilizationInfo_v1.__new__(ProcessUtilizationInfo_v1)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlProcessUtilizationInfo_v1_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=process_utilization_info_v1_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_ecc_sram_error_status_v1_dtype_offsets():
    cdef nvmlEccSramErrorStatus_v1_t pod = nvmlEccSramErrorStatus_v1_t()
    return _numpy.dtype({
        'names': ['version', 'aggregate_unc_parity', 'aggregate_unc_sec_ded', 'aggregate_cor', 'volatile_unc_parity', 'volatile_unc_sec_ded', 'volatile_cor', 'aggregate_unc_bucket_l2', 'aggregate_unc_bucket_sm', 'aggregate_unc_bucket_pcie', 'aggregate_unc_bucket_mcu', 'aggregate_unc_bucket_other', 'b_threshold_exceeded'],
        'formats': [_numpy.uint32, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncParity)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncSecDed)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateCor)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.volatileUncParity)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.volatileUncSecDed)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.volatileCor)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncBucketL2)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncBucketSm)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncBucketPcie)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncBucketMcu)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.aggregateUncBucketOther)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bThresholdExceeded)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlEccSramErrorStatus_v1_t),
    })

ecc_sram_error_status_v1_dtype = _get_ecc_sram_error_status_v1_dtype_offsets()

cdef class EccSramErrorStatus_v1:
    """Empty-initialize an instance of `nvmlEccSramErrorStatus_v1_t`.


    .. seealso:: `nvmlEccSramErrorStatus_v1_t`
    """
    cdef:
        nvmlEccSramErrorStatus_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlEccSramErrorStatus_v1_t *>calloc(1, sizeof(nvmlEccSramErrorStatus_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating EccSramErrorStatus_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlEccSramErrorStatus_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.EccSramErrorStatus_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef EccSramErrorStatus_v1 other_
        if not isinstance(other, EccSramErrorStatus_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlEccSramErrorStatus_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlEccSramErrorStatus_v1_t *>malloc(sizeof(nvmlEccSramErrorStatus_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating EccSramErrorStatus_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlEccSramErrorStatus_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def aggregate_unc_parity(self):
        """int: aggregate uncorrectable parity error count"""
        return self._ptr[0].aggregateUncParity

    @aggregate_unc_parity.setter
    def aggregate_unc_parity(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncParity = val

    @property
    def aggregate_unc_sec_ded(self):
        """int: aggregate uncorrectable SEC-DED error count"""
        return self._ptr[0].aggregateUncSecDed

    @aggregate_unc_sec_ded.setter
    def aggregate_unc_sec_ded(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncSecDed = val

    @property
    def aggregate_cor(self):
        """int: aggregate correctable error count"""
        return self._ptr[0].aggregateCor

    @aggregate_cor.setter
    def aggregate_cor(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateCor = val

    @property
    def volatile_unc_parity(self):
        """int: volatile uncorrectable parity error count"""
        return self._ptr[0].volatileUncParity

    @volatile_unc_parity.setter
    def volatile_unc_parity(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].volatileUncParity = val

    @property
    def volatile_unc_sec_ded(self):
        """int: volatile uncorrectable SEC-DED error count"""
        return self._ptr[0].volatileUncSecDed

    @volatile_unc_sec_ded.setter
    def volatile_unc_sec_ded(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].volatileUncSecDed = val

    @property
    def volatile_cor(self):
        """int: volatile correctable error count"""
        return self._ptr[0].volatileCor

    @volatile_cor.setter
    def volatile_cor(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].volatileCor = val

    @property
    def aggregate_unc_bucket_l2(self):
        """int: aggregate uncorrectable error count for L2 cache bucket"""
        return self._ptr[0].aggregateUncBucketL2

    @aggregate_unc_bucket_l2.setter
    def aggregate_unc_bucket_l2(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncBucketL2 = val

    @property
    def aggregate_unc_bucket_sm(self):
        """int: aggregate uncorrectable error count for SM bucket"""
        return self._ptr[0].aggregateUncBucketSm

    @aggregate_unc_bucket_sm.setter
    def aggregate_unc_bucket_sm(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncBucketSm = val

    @property
    def aggregate_unc_bucket_pcie(self):
        """int: aggregate uncorrectable error count for PCIE bucket"""
        return self._ptr[0].aggregateUncBucketPcie

    @aggregate_unc_bucket_pcie.setter
    def aggregate_unc_bucket_pcie(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncBucketPcie = val

    @property
    def aggregate_unc_bucket_mcu(self):
        """int: aggregate uncorrectable error count for Microcontroller bucket"""
        return self._ptr[0].aggregateUncBucketMcu

    @aggregate_unc_bucket_mcu.setter
    def aggregate_unc_bucket_mcu(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncBucketMcu = val

    @property
    def aggregate_unc_bucket_other(self):
        """int: aggregate uncorrectable error count for Other bucket"""
        return self._ptr[0].aggregateUncBucketOther

    @aggregate_unc_bucket_other.setter
    def aggregate_unc_bucket_other(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].aggregateUncBucketOther = val

    @property
    def b_threshold_exceeded(self):
        """int: if the error threshold of field diag is exceeded"""
        return self._ptr[0].bThresholdExceeded

    @b_threshold_exceeded.setter
    def b_threshold_exceeded(self, val):
        if self._readonly:
            raise ValueError("This EccSramErrorStatus_v1 instance is read-only")
        self._ptr[0].bThresholdExceeded = val

    @staticmethod
    def from_data(data):
        """Create an EccSramErrorStatus_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `ecc_sram_error_status_v1_dtype` holding the data.
        """
        return __from_data(data, "ecc_sram_error_status_v1_dtype", ecc_sram_error_status_v1_dtype, EccSramErrorStatus_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an EccSramErrorStatus_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef EccSramErrorStatus_v1 obj = EccSramErrorStatus_v1.__new__(EccSramErrorStatus_v1)
        if owner is None:
            obj._ptr = <nvmlEccSramErrorStatus_v1_t *>malloc(sizeof(nvmlEccSramErrorStatus_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating EccSramErrorStatus_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlEccSramErrorStatus_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlEccSramErrorStatus_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_platform_info_v1_dtype_offsets():
    cdef nvmlPlatformInfo_v1_t pod = nvmlPlatformInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'ib_guid', 'rack_guid', 'chassis_physical_slot_number', 'compute_slot_ind_ex', 'node_ind_ex', 'peer_type', 'module_id'],
        'formats': [_numpy.uint32, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ibGuid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.rackGuid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.chassisPhysicalSlotNumber)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.computeSlotIndex)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.nodeIndex)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.peerType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.moduleId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPlatformInfo_v1_t),
    })

platform_info_v1_dtype = _get_platform_info_v1_dtype_offsets()

cdef class PlatformInfo_v1:
    """Empty-initialize an instance of `nvmlPlatformInfo_v1_t`.


    .. seealso:: `nvmlPlatformInfo_v1_t`
    """
    cdef:
        nvmlPlatformInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPlatformInfo_v1_t *>calloc(1, sizeof(nvmlPlatformInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PlatformInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPlatformInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PlatformInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PlatformInfo_v1 other_
        if not isinstance(other, PlatformInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPlatformInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPlatformInfo_v1_t *>malloc(sizeof(nvmlPlatformInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PlatformInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPlatformInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def ib_guid(self):
        """~_numpy.uint8: (array of length 16).Infiniband GUID reported by platform (for Blackwell, ibGuid is 8 bytes so indices 8-15 are zero)"""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].ibGuid))
        return _numpy.asarray(arr)

    @ib_guid.setter
    def ib_guid(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].ibGuid)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def rack_guid(self):
        """~_numpy.uint8: (array of length 16).GUID of the rack containing this GPU (for Blackwell rackGuid is 13 bytes so indices 13-15 are zero)"""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].rackGuid))
        return _numpy.asarray(arr)

    @rack_guid.setter
    def rack_guid(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].rackGuid)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def chassis_physical_slot_number(self):
        """int: The slot number in the rack containing this GPU (includes switches)"""
        return self._ptr[0].chassisPhysicalSlotNumber

    @chassis_physical_slot_number.setter
    def chassis_physical_slot_number(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].chassisPhysicalSlotNumber = val

    @property
    def compute_slot_ind_ex(self):
        """int: The index within the compute slots in the rack containing this GPU (does not include switches)"""
        return self._ptr[0].computeSlotIndex

    @compute_slot_ind_ex.setter
    def compute_slot_ind_ex(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].computeSlotIndex = val

    @property
    def node_ind_ex(self):
        """int: Index of the node within the slot containing this GPU."""
        return self._ptr[0].nodeIndex

    @node_ind_ex.setter
    def node_ind_ex(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].nodeIndex = val

    @property
    def peer_type(self):
        """int: Platform indicated NVLink-peer type (e.g. switch present or not)"""
        return self._ptr[0].peerType

    @peer_type.setter
    def peer_type(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].peerType = val

    @property
    def module_id(self):
        """int: ID of this GPU within the node."""
        return self._ptr[0].moduleId

    @module_id.setter
    def module_id(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v1 instance is read-only")
        self._ptr[0].moduleId = val

    @staticmethod
    def from_data(data):
        """Create an PlatformInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `platform_info_v1_dtype` holding the data.
        """
        return __from_data(data, "platform_info_v1_dtype", platform_info_v1_dtype, PlatformInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PlatformInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PlatformInfo_v1 obj = PlatformInfo_v1.__new__(PlatformInfo_v1)
        if owner is None:
            obj._ptr = <nvmlPlatformInfo_v1_t *>malloc(sizeof(nvmlPlatformInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PlatformInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPlatformInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPlatformInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_platform_info_v2_dtype_offsets():
    cdef nvmlPlatformInfo_v2_t pod = nvmlPlatformInfo_v2_t()
    return _numpy.dtype({
        'names': ['version', 'ib_guid', 'chassis_serial_number', 'slot_number', 'tray_ind_ex', 'host_id', 'peer_type', 'module_id'],
        'formats': [_numpy.uint32, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ibGuid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.chassisSerialNumber)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.slotNumber)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.trayIndex)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hostId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.peerType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.moduleId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPlatformInfo_v2_t),
    })

platform_info_v2_dtype = _get_platform_info_v2_dtype_offsets()

cdef class PlatformInfo_v2:
    """Empty-initialize an instance of `nvmlPlatformInfo_v2_t`.


    .. seealso:: `nvmlPlatformInfo_v2_t`
    """
    cdef:
        nvmlPlatformInfo_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPlatformInfo_v2_t *>calloc(1, sizeof(nvmlPlatformInfo_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PlatformInfo_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPlatformInfo_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PlatformInfo_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PlatformInfo_v2 other_
        if not isinstance(other, PlatformInfo_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPlatformInfo_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPlatformInfo_v2_t *>malloc(sizeof(nvmlPlatformInfo_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PlatformInfo_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPlatformInfo_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def ib_guid(self):
        """~_numpy.uint8: (array of length 16).Infiniband GUID reported by platform (for Blackwell, ibGuid is 8 bytes so indices 8-15 are zero)"""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].ibGuid))
        return _numpy.asarray(arr)

    @ib_guid.setter
    def ib_guid(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].ibGuid)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def chassis_serial_number(self):
        """~_numpy.uint8: (array of length 16).Serial number of the chassis containing this GPU (for Blackwell it is 13 bytes so indices 13-15 are zero)"""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].chassisSerialNumber))
        return _numpy.asarray(arr)

    @chassis_serial_number.setter
    def chassis_serial_number(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].chassisSerialNumber)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def slot_number(self):
        """int: The slot number in the chassis containing this GPU (includes switches)"""
        return self._ptr[0].slotNumber

    @slot_number.setter
    def slot_number(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].slotNumber = val

    @property
    def tray_ind_ex(self):
        """int: The tray index within the compute slots in the chassis containing this GPU (does not include switches)"""
        return self._ptr[0].trayIndex

    @tray_ind_ex.setter
    def tray_ind_ex(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].trayIndex = val

    @property
    def host_id(self):
        """int: Index of the node within the slot containing this GPU."""
        return self._ptr[0].hostId

    @host_id.setter
    def host_id(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].hostId = val

    @property
    def peer_type(self):
        """int: Platform indicated NVLink-peer type (e.g. switch present or not)"""
        return self._ptr[0].peerType

    @peer_type.setter
    def peer_type(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].peerType = val

    @property
    def module_id(self):
        """int: ID of this GPU within the node."""
        return self._ptr[0].moduleId

    @module_id.setter
    def module_id(self, val):
        if self._readonly:
            raise ValueError("This PlatformInfo_v2 instance is read-only")
        self._ptr[0].moduleId = val

    @staticmethod
    def from_data(data):
        """Create an PlatformInfo_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `platform_info_v2_dtype` holding the data.
        """
        return __from_data(data, "platform_info_v2_dtype", platform_info_v2_dtype, PlatformInfo_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PlatformInfo_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PlatformInfo_v2 obj = PlatformInfo_v2.__new__(PlatformInfo_v2)
        if owner is None:
            obj._ptr = <nvmlPlatformInfo_v2_t *>malloc(sizeof(nvmlPlatformInfo_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PlatformInfo_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPlatformInfo_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPlatformInfo_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get__py_anon_pod1_dtype_offsets():
    cdef _anon_pod1 pod = _anon_pod1()
    return _numpy.dtype({
        'names': ['b_is_present', 'percentage', 'inc_threshold', 'dec_threshold'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.bIsPresent)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.percentage)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.incThreshold)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decThreshold)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod1),
    })

_py_anon_pod1_dtype = _get__py_anon_pod1_dtype_offsets()

cdef class _py_anon_pod1:
    """Empty-initialize an instance of `_anon_pod1`.


    .. seealso:: `_anon_pod1`
    """
    cdef:
        _anon_pod1 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod1 *>calloc(1, sizeof(_anon_pod1))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod1 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod1 other_
        if not isinstance(other, _py_anon_pod1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod1)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod1 *>malloc(sizeof(_anon_pod1))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod1))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def b_is_present(self):
        """int: """
        return self._ptr[0].bIsPresent

    @b_is_present.setter
    def b_is_present(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod1 instance is read-only")
        self._ptr[0].bIsPresent = val

    @property
    def percentage(self):
        """int: """
        return self._ptr[0].percentage

    @percentage.setter
    def percentage(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod1 instance is read-only")
        self._ptr[0].percentage = val

    @property
    def inc_threshold(self):
        """int: """
        return self._ptr[0].incThreshold

    @inc_threshold.setter
    def inc_threshold(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod1 instance is read-only")
        self._ptr[0].incThreshold = val

    @property
    def dec_threshold(self):
        """int: """
        return self._ptr[0].decThreshold

    @dec_threshold.setter
    def dec_threshold(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod1 instance is read-only")
        self._ptr[0].decThreshold = val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod1_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod1_dtype", _py_anon_pod1_dtype, _py_anon_pod1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod1 obj = _py_anon_pod1.__new__(_py_anon_pod1)
        if owner is None:
            obj._ptr = <_anon_pod1 *>malloc(sizeof(_anon_pod1))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod1))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod1 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_heterogeneous_mode_v1_dtype_offsets():
    cdef nvmlVgpuHeterogeneousMode_v1_t pod = nvmlVgpuHeterogeneousMode_v1_t()
    return _numpy.dtype({
        'names': ['version', 'mode'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.mode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuHeterogeneousMode_v1_t),
    })

vgpu_heterogeneous_mode_v1_dtype = _get_vgpu_heterogeneous_mode_v1_dtype_offsets()

cdef class VgpuHeterogeneousMode_v1:
    """Empty-initialize an instance of `nvmlVgpuHeterogeneousMode_v1_t`.


    .. seealso:: `nvmlVgpuHeterogeneousMode_v1_t`
    """
    cdef:
        nvmlVgpuHeterogeneousMode_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuHeterogeneousMode_v1_t *>calloc(1, sizeof(nvmlVgpuHeterogeneousMode_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuHeterogeneousMode_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuHeterogeneousMode_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuHeterogeneousMode_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuHeterogeneousMode_v1 other_
        if not isinstance(other, VgpuHeterogeneousMode_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuHeterogeneousMode_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuHeterogeneousMode_v1_t *>malloc(sizeof(nvmlVgpuHeterogeneousMode_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuHeterogeneousMode_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuHeterogeneousMode_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuHeterogeneousMode_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def mode(self):
        """int: The vGPU heterogeneous mode."""
        return self._ptr[0].mode

    @mode.setter
    def mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuHeterogeneousMode_v1 instance is read-only")
        self._ptr[0].mode = val

    @staticmethod
    def from_data(data):
        """Create an VgpuHeterogeneousMode_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_heterogeneous_mode_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_heterogeneous_mode_v1_dtype", vgpu_heterogeneous_mode_v1_dtype, VgpuHeterogeneousMode_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuHeterogeneousMode_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuHeterogeneousMode_v1 obj = VgpuHeterogeneousMode_v1.__new__(VgpuHeterogeneousMode_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuHeterogeneousMode_v1_t *>malloc(sizeof(nvmlVgpuHeterogeneousMode_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuHeterogeneousMode_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuHeterogeneousMode_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuHeterogeneousMode_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_placement_id_v1_dtype_offsets():
    cdef nvmlVgpuPlacementId_v1_t pod = nvmlVgpuPlacementId_v1_t()
    return _numpy.dtype({
        'names': ['version', 'placement_id'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placementId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuPlacementId_v1_t),
    })

vgpu_placement_id_v1_dtype = _get_vgpu_placement_id_v1_dtype_offsets()

cdef class VgpuPlacementId_v1:
    """Empty-initialize an instance of `nvmlVgpuPlacementId_v1_t`.


    .. seealso:: `nvmlVgpuPlacementId_v1_t`
    """
    cdef:
        nvmlVgpuPlacementId_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuPlacementId_v1_t *>calloc(1, sizeof(nvmlVgpuPlacementId_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuPlacementId_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuPlacementId_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuPlacementId_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuPlacementId_v1 other_
        if not isinstance(other, VgpuPlacementId_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuPlacementId_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuPlacementId_v1_t *>malloc(sizeof(nvmlVgpuPlacementId_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuPlacementId_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuPlacementId_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementId_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def placement_id(self):
        """int: Placement ID of the active vGPU instance."""
        return self._ptr[0].placementId

    @placement_id.setter
    def placement_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementId_v1 instance is read-only")
        self._ptr[0].placementId = val

    @staticmethod
    def from_data(data):
        """Create an VgpuPlacementId_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_placement_id_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_placement_id_v1_dtype", vgpu_placement_id_v1_dtype, VgpuPlacementId_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuPlacementId_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuPlacementId_v1 obj = VgpuPlacementId_v1.__new__(VgpuPlacementId_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuPlacementId_v1_t *>malloc(sizeof(nvmlVgpuPlacementId_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuPlacementId_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuPlacementId_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuPlacementId_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_placement_list_v2_dtype_offsets():
    cdef nvmlVgpuPlacementList_v2_t pod = nvmlVgpuPlacementList_v2_t()
    return _numpy.dtype({
        'names': ['version', 'placement_size', 'count', 'placement_ids', 'mode'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.intp, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placementSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.count)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placementIds)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.mode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuPlacementList_v2_t),
    })

vgpu_placement_list_v2_dtype = _get_vgpu_placement_list_v2_dtype_offsets()

cdef class VgpuPlacementList_v2:
    """Empty-initialize an instance of `nvmlVgpuPlacementList_v2_t`.


    .. seealso:: `nvmlVgpuPlacementList_v2_t`
    """
    cdef:
        nvmlVgpuPlacementList_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlVgpuPlacementList_v2_t *>calloc(1, sizeof(nvmlVgpuPlacementList_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuPlacementList_v2")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlVgpuPlacementList_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuPlacementList_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuPlacementList_v2 other_
        if not isinstance(other, VgpuPlacementList_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuPlacementList_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuPlacementList_v2_t *>malloc(sizeof(nvmlVgpuPlacementList_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuPlacementList_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuPlacementList_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementList_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def placement_size(self):
        """int: OUT: The number of slots occupied by the vGPU type."""
        return self._ptr[0].placementSize

    @placement_size.setter
    def placement_size(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementList_v2 instance is read-only")
        self._ptr[0].placementSize = val

    @property
    def placement_ids(self):
        """int: IN/OUT: Placement IDs for the vGPU type."""
        if self._ptr[0].placementIds == NULL:
            return []
        cdef view.array arr = view.array(shape=(self._ptr[0].count,), itemsize=sizeof(unsigned int), format="I", mode="c", allocate_buffer=False)
        arr.data = <char *>(self._ptr[0].placementIds)
        return _numpy.asarray(arr)

    @placement_ids.setter
    def placement_ids(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementList_v2 instance is read-only")
        cdef view.array arr = view.array(shape=(len(val),), itemsize=sizeof(unsigned int), format="I", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint32)
        self._ptr[0].placementIds = <unsigned int*><intptr_t>(arr.data)
        self._ptr[0].count = len(val)
        self._refs["placement_ids"] = arr

    @property
    def mode(self):
        """int: IN: The vGPU mode. Either NVML_VGPU_PGPU_HETEROGENEOUS_MODE or NVML_VGPU_PGPU_HOMOGENEOUS_MODE."""
        return self._ptr[0].mode

    @mode.setter
    def mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuPlacementList_v2 instance is read-only")
        self._ptr[0].mode = val

    @staticmethod
    def from_data(data):
        """Create an VgpuPlacementList_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_placement_list_v2_dtype` holding the data.
        """
        return __from_data(data, "vgpu_placement_list_v2_dtype", vgpu_placement_list_v2_dtype, VgpuPlacementList_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuPlacementList_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuPlacementList_v2 obj = VgpuPlacementList_v2.__new__(VgpuPlacementList_v2)
        if owner is None:
            obj._ptr = <nvmlVgpuPlacementList_v2_t *>malloc(sizeof(nvmlVgpuPlacementList_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuPlacementList_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuPlacementList_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuPlacementList_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_vgpu_type_bar1info_v1_dtype_offsets():
    cdef nvmlVgpuTypeBar1Info_v1_t pod = nvmlVgpuTypeBar1Info_v1_t()
    return _numpy.dtype({
        'names': ['version', 'bar1size'],
        'formats': [_numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bar1Size)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuTypeBar1Info_v1_t),
    })

vgpu_type_bar1info_v1_dtype = _get_vgpu_type_bar1info_v1_dtype_offsets()

cdef class VgpuTypeBar1Info_v1:
    """Empty-initialize an instance of `nvmlVgpuTypeBar1Info_v1_t`.


    .. seealso:: `nvmlVgpuTypeBar1Info_v1_t`
    """
    cdef:
        nvmlVgpuTypeBar1Info_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuTypeBar1Info_v1_t *>calloc(1, sizeof(nvmlVgpuTypeBar1Info_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuTypeBar1Info_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuTypeBar1Info_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuTypeBar1Info_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuTypeBar1Info_v1 other_
        if not isinstance(other, VgpuTypeBar1Info_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuTypeBar1Info_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuTypeBar1Info_v1_t *>malloc(sizeof(nvmlVgpuTypeBar1Info_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeBar1Info_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuTypeBar1Info_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeBar1Info_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def bar1size(self):
        """int: BAR1 size in megabytes."""
        return self._ptr[0].bar1Size

    @bar1size.setter
    def bar1size(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeBar1Info_v1 instance is read-only")
        self._ptr[0].bar1Size = val

    @staticmethod
    def from_data(data):
        """Create an VgpuTypeBar1Info_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_type_bar1info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_type_bar1info_v1_dtype", vgpu_type_bar1info_v1_dtype, VgpuTypeBar1Info_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuTypeBar1Info_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuTypeBar1Info_v1 obj = VgpuTypeBar1Info_v1.__new__(VgpuTypeBar1Info_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuTypeBar1Info_v1_t *>malloc(sizeof(nvmlVgpuTypeBar1Info_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeBar1Info_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuTypeBar1Info_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuTypeBar1Info_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_process_utilization_info_v1_dtype_offsets():
    cdef nvmlVgpuProcessUtilizationInfo_v1_t pod = nvmlVgpuProcessUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['process_name', 'time_stamp', 'vgpu_instance', 'pid', 'sm_util', 'mem_util', 'enc_util', 'dec_util', 'jpg_util', 'ofa_util'],
        'formats': [_numpy.int8, _numpy.uint64, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.processName)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstance)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.smUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.jpgUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ofaUtil)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuProcessUtilizationInfo_v1_t),
    })

vgpu_process_utilization_info_v1_dtype = _get_vgpu_process_utilization_info_v1_dtype_offsets()

cdef class VgpuProcessUtilizationInfo_v1:
    """Empty-initialize an array of `nvmlVgpuProcessUtilizationInfo_v1_t`.

    The resulting object is of length `size` and of dtype `vgpu_process_utilization_info_v1_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlVgpuProcessUtilizationInfo_v1_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=vgpu_process_utilization_info_v1_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlVgpuProcessUtilizationInfo_v1_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlVgpuProcessUtilizationInfo_v1_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.VgpuProcessUtilizationInfo_v1_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.VgpuProcessUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, VgpuProcessUtilizationInfo_v1)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def process_name(self):
        """~_numpy.int8: (array of length 64).Name of process running within the vGPU VM."""
        return self._data.process_name

    @process_name.setter
    def process_name(self, val):
        self._data.process_name = val

    @property
    def time_stamp(self):
        """Union[~_numpy.uint64, int]: CPU Timestamp in microseconds."""
        if self._data.size == 1:
            return int(self._data.time_stamp[0])
        return self._data.time_stamp

    @time_stamp.setter
    def time_stamp(self, val):
        self._data.time_stamp = val

    @property
    def vgpu_instance(self):
        """Union[~_numpy.uint32, int]: vGPU Instance"""
        if self._data.size == 1:
            return int(self._data.vgpu_instance[0])
        return self._data.vgpu_instance

    @vgpu_instance.setter
    def vgpu_instance(self, val):
        self._data.vgpu_instance = val

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: PID of process running within the vGPU VM."""
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def sm_util(self):
        """Union[~_numpy.uint32, int]: SM (3D/Compute) Util Value."""
        if self._data.size == 1:
            return int(self._data.sm_util[0])
        return self._data.sm_util

    @sm_util.setter
    def sm_util(self, val):
        self._data.sm_util = val

    @property
    def mem_util(self):
        """Union[~_numpy.uint32, int]: Frame Buffer Memory Util Value."""
        if self._data.size == 1:
            return int(self._data.mem_util[0])
        return self._data.mem_util

    @mem_util.setter
    def mem_util(self, val):
        self._data.mem_util = val

    @property
    def enc_util(self):
        """Union[~_numpy.uint32, int]: Encoder Util Value."""
        if self._data.size == 1:
            return int(self._data.enc_util[0])
        return self._data.enc_util

    @enc_util.setter
    def enc_util(self, val):
        self._data.enc_util = val

    @property
    def dec_util(self):
        """Union[~_numpy.uint32, int]: Decoder Util Value."""
        if self._data.size == 1:
            return int(self._data.dec_util[0])
        return self._data.dec_util

    @dec_util.setter
    def dec_util(self, val):
        self._data.dec_util = val

    @property
    def jpg_util(self):
        """Union[~_numpy.uint32, int]: Jpeg Util Value."""
        if self._data.size == 1:
            return int(self._data.jpg_util[0])
        return self._data.jpg_util

    @jpg_util.setter
    def jpg_util(self, val):
        self._data.jpg_util = val

    @property
    def ofa_util(self):
        """Union[~_numpy.uint32, int]: Ofa Util Value."""
        if self._data.size == 1:
            return int(self._data.ofa_util[0])
        return self._data.ofa_util

    @ofa_util.setter
    def ofa_util(self, val):
        self._data.ofa_util = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return VgpuProcessUtilizationInfo_v1.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == vgpu_process_utilization_info_v1_dtype:
            return VgpuProcessUtilizationInfo_v1.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an VgpuProcessUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `vgpu_process_utilization_info_v1_dtype` holding the data.
        """
        cdef VgpuProcessUtilizationInfo_v1 obj = VgpuProcessUtilizationInfo_v1.__new__(VgpuProcessUtilizationInfo_v1)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != vgpu_process_utilization_info_v1_dtype:
            raise ValueError("data array must be of dtype vgpu_process_utilization_info_v1_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an VgpuProcessUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuProcessUtilizationInfo_v1 obj = VgpuProcessUtilizationInfo_v1.__new__(VgpuProcessUtilizationInfo_v1)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlVgpuProcessUtilizationInfo_v1_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=vgpu_process_utilization_info_v1_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_vgpu_runtime_state_v1_dtype_offsets():
    cdef nvmlVgpuRuntimeState_v1_t pod = nvmlVgpuRuntimeState_v1_t()
    return _numpy.dtype({
        'names': ['version', 'size_'],
        'formats': [_numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.size)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuRuntimeState_v1_t),
    })

vgpu_runtime_state_v1_dtype = _get_vgpu_runtime_state_v1_dtype_offsets()

cdef class VgpuRuntimeState_v1:
    """Empty-initialize an instance of `nvmlVgpuRuntimeState_v1_t`.


    .. seealso:: `nvmlVgpuRuntimeState_v1_t`
    """
    cdef:
        nvmlVgpuRuntimeState_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuRuntimeState_v1_t *>calloc(1, sizeof(nvmlVgpuRuntimeState_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuRuntimeState_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuRuntimeState_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuRuntimeState_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuRuntimeState_v1 other_
        if not isinstance(other, VgpuRuntimeState_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuRuntimeState_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuRuntimeState_v1_t *>malloc(sizeof(nvmlVgpuRuntimeState_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuRuntimeState_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuRuntimeState_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuRuntimeState_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def size_(self):
        """int: OUT: The runtime state size of the vGPU instance."""
        return self._ptr[0].size

    @size_.setter
    def size_(self, val):
        if self._readonly:
            raise ValueError("This VgpuRuntimeState_v1 instance is read-only")
        self._ptr[0].size = val

    @staticmethod
    def from_data(data):
        """Create an VgpuRuntimeState_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_runtime_state_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_runtime_state_v1_dtype", vgpu_runtime_state_v1_dtype, VgpuRuntimeState_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuRuntimeState_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuRuntimeState_v1 obj = VgpuRuntimeState_v1.__new__(VgpuRuntimeState_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuRuntimeState_v1_t *>malloc(sizeof(nvmlVgpuRuntimeState_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuRuntimeState_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuRuntimeState_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuRuntimeState_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get__py_anon_pod2_dtype_offsets():
    cdef _anon_pod2 pod = _anon_pod2()
    return _numpy.dtype({
        'names': ['avg_factor', 'timeslice'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.avgFactor)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timeslice)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod2),
    })

_py_anon_pod2_dtype = _get__py_anon_pod2_dtype_offsets()

cdef class _py_anon_pod2:
    """Empty-initialize an instance of `_anon_pod2`.


    .. seealso:: `_anon_pod2`
    """
    cdef:
        _anon_pod2 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod2 *>calloc(1, sizeof(_anon_pod2))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod2 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod2 other_
        if not isinstance(other, _py_anon_pod2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod2)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod2 *>malloc(sizeof(_anon_pod2))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod2))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def avg_factor(self):
        """int: """
        return self._ptr[0].avgFactor

    @avg_factor.setter
    def avg_factor(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod2 instance is read-only")
        self._ptr[0].avgFactor = val

    @property
    def timeslice(self):
        """int: """
        return self._ptr[0].timeslice

    @timeslice.setter
    def timeslice(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod2 instance is read-only")
        self._ptr[0].timeslice = val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod2_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod2_dtype", _py_anon_pod2_dtype, _py_anon_pod2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod2 obj = _py_anon_pod2.__new__(_py_anon_pod2)
        if owner is None:
            obj._ptr = <_anon_pod2 *>malloc(sizeof(_anon_pod2))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod2))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod2 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get__py_anon_pod3_dtype_offsets():
    cdef _anon_pod3 pod = _anon_pod3()
    return _numpy.dtype({
        'names': ['timeslice'],
        'formats': [_numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.timeslice)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod3),
    })

_py_anon_pod3_dtype = _get__py_anon_pod3_dtype_offsets()

cdef class _py_anon_pod3:
    """Empty-initialize an instance of `_anon_pod3`.


    .. seealso:: `_anon_pod3`
    """
    cdef:
        _anon_pod3 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod3 *>calloc(1, sizeof(_anon_pod3))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod3")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod3 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod3 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod3 other_
        if not isinstance(other, _py_anon_pod3):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod3)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod3 *>malloc(sizeof(_anon_pod3))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod3")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod3))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def timeslice(self):
        """int: """
        return self._ptr[0].timeslice

    @timeslice.setter
    def timeslice(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod3 instance is read-only")
        self._ptr[0].timeslice = val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod3 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod3_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod3_dtype", _py_anon_pod3_dtype, _py_anon_pod3)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod3 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod3 obj = _py_anon_pod3.__new__(_py_anon_pod3)
        if owner is None:
            obj._ptr = <_anon_pod3 *>malloc(sizeof(_anon_pod3))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod3")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod3))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod3 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_log_entry_dtype_offsets():
    cdef nvmlVgpuSchedulerLogEntry_t pod = nvmlVgpuSchedulerLogEntry_t()
    return _numpy.dtype({
        'names': ['timestamp', 'time_run_total', 'time_run', 'sw_runlist_id', 'target_time_slice', 'cumulative_preemption_time'],
        'formats': [_numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint32, _numpy.uint64, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.timestamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timeRunTotal)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timeRun)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.swRunlistId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.targetTimeSlice)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.cumulativePreemptionTime)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerLogEntry_t),
    })

vgpu_scheduler_log_entry_dtype = _get_vgpu_scheduler_log_entry_dtype_offsets()

cdef class VgpuSchedulerLogEntry:
    """Empty-initialize an array of `nvmlVgpuSchedulerLogEntry_t`.

    The resulting object is of length `size` and of dtype `vgpu_scheduler_log_entry_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlVgpuSchedulerLogEntry_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=vgpu_scheduler_log_entry_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlVgpuSchedulerLogEntry_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlVgpuSchedulerLogEntry_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.VgpuSchedulerLogEntry_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.VgpuSchedulerLogEntry object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, VgpuSchedulerLogEntry)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def timestamp(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.timestamp[0])
        return self._data.timestamp

    @timestamp.setter
    def timestamp(self, val):
        self._data.timestamp = val

    @property
    def time_run_total(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.time_run_total[0])
        return self._data.time_run_total

    @time_run_total.setter
    def time_run_total(self, val):
        self._data.time_run_total = val

    @property
    def time_run(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.time_run[0])
        return self._data.time_run

    @time_run.setter
    def time_run(self, val):
        self._data.time_run = val

    @property
    def sw_runlist_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.sw_runlist_id[0])
        return self._data.sw_runlist_id

    @sw_runlist_id.setter
    def sw_runlist_id(self, val):
        self._data.sw_runlist_id = val

    @property
    def target_time_slice(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.target_time_slice[0])
        return self._data.target_time_slice

    @target_time_slice.setter
    def target_time_slice(self, val):
        self._data.target_time_slice = val

    @property
    def cumulative_preemption_time(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.cumulative_preemption_time[0])
        return self._data.cumulative_preemption_time

    @cumulative_preemption_time.setter
    def cumulative_preemption_time(self, val):
        self._data.cumulative_preemption_time = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return VgpuSchedulerLogEntry.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == vgpu_scheduler_log_entry_dtype:
            return VgpuSchedulerLogEntry.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerLogEntry instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `vgpu_scheduler_log_entry_dtype` holding the data.
        """
        cdef VgpuSchedulerLogEntry obj = VgpuSchedulerLogEntry.__new__(VgpuSchedulerLogEntry)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != vgpu_scheduler_log_entry_dtype:
            raise ValueError("data array must be of dtype vgpu_scheduler_log_entry_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an VgpuSchedulerLogEntry instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerLogEntry obj = VgpuSchedulerLogEntry.__new__(VgpuSchedulerLogEntry)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlVgpuSchedulerLogEntry_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=vgpu_scheduler_log_entry_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get__py_anon_pod4_dtype_offsets():
    cdef _anon_pod4 pod = _anon_pod4()
    return _numpy.dtype({
        'names': ['avg_factor', 'frequency'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.avgFactor)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.frequency)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod4),
    })

_py_anon_pod4_dtype = _get__py_anon_pod4_dtype_offsets()

cdef class _py_anon_pod4:
    """Empty-initialize an instance of `_anon_pod4`.


    .. seealso:: `_anon_pod4`
    """
    cdef:
        _anon_pod4 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod4 *>calloc(1, sizeof(_anon_pod4))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod4")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod4 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod4 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod4 other_
        if not isinstance(other, _py_anon_pod4):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod4)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod4 *>malloc(sizeof(_anon_pod4))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod4")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod4))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def avg_factor(self):
        """int: """
        return self._ptr[0].avgFactor

    @avg_factor.setter
    def avg_factor(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod4 instance is read-only")
        self._ptr[0].avgFactor = val

    @property
    def frequency(self):
        """int: """
        return self._ptr[0].frequency

    @frequency.setter
    def frequency(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod4 instance is read-only")
        self._ptr[0].frequency = val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod4 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod4_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod4_dtype", _py_anon_pod4_dtype, _py_anon_pod4)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod4 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod4 obj = _py_anon_pod4.__new__(_py_anon_pod4)
        if owner is None:
            obj._ptr = <_anon_pod4 *>malloc(sizeof(_anon_pod4))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod4")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod4))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod4 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get__py_anon_pod5_dtype_offsets():
    cdef _anon_pod5 pod = _anon_pod5()
    return _numpy.dtype({
        'names': ['timeslice'],
        'formats': [_numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.timeslice)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(_anon_pod5),
    })

_py_anon_pod5_dtype = _get__py_anon_pod5_dtype_offsets()

cdef class _py_anon_pod5:
    """Empty-initialize an instance of `_anon_pod5`.


    .. seealso:: `_anon_pod5`
    """
    cdef:
        _anon_pod5 *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <_anon_pod5 *>calloc(1, sizeof(_anon_pod5))
        if self._ptr == NULL:
            raise MemoryError("Error allocating _py_anon_pod5")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef _anon_pod5 *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}._py_anon_pod5 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef _py_anon_pod5 other_
        if not isinstance(other, _py_anon_pod5):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(_anon_pod5)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <_anon_pod5 *>malloc(sizeof(_anon_pod5))
            if self._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod5")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(_anon_pod5))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def timeslice(self):
        """int: """
        return self._ptr[0].timeslice

    @timeslice.setter
    def timeslice(self, val):
        if self._readonly:
            raise ValueError("This _py_anon_pod5 instance is read-only")
        self._ptr[0].timeslice = val

    @staticmethod
    def from_data(data):
        """Create an _py_anon_pod5 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `_py_anon_pod5_dtype` holding the data.
        """
        return __from_data(data, "_py_anon_pod5_dtype", _py_anon_pod5_dtype, _py_anon_pod5)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an _py_anon_pod5 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef _py_anon_pod5 obj = _py_anon_pod5.__new__(_py_anon_pod5)
        if owner is None:
            obj._ptr = <_anon_pod5 *>malloc(sizeof(_anon_pod5))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating _py_anon_pod5")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(_anon_pod5))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <_anon_pod5 *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_capabilities_dtype_offsets():
    cdef nvmlVgpuSchedulerCapabilities_t pod = nvmlVgpuSchedulerCapabilities_t()
    return _numpy.dtype({
        'names': ['supported_schedulers', 'max_timeslice', 'min_timeslice', 'is_arr_mode_supported', 'max_frequency_for_arr', 'min_frequency_for_arr', 'max_avg_factor_for_arr', 'min_avg_factor_for_arr'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.supportedSchedulers)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxTimeslice)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.minTimeslice)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isArrModeSupported)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxFrequencyForARR)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.minFrequencyForARR)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxAvgFactorForARR)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.minAvgFactorForARR)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerCapabilities_t),
    })

vgpu_scheduler_capabilities_dtype = _get_vgpu_scheduler_capabilities_dtype_offsets()

cdef class VgpuSchedulerCapabilities:
    """Empty-initialize an instance of `nvmlVgpuSchedulerCapabilities_t`.


    .. seealso:: `nvmlVgpuSchedulerCapabilities_t`
    """
    cdef:
        nvmlVgpuSchedulerCapabilities_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerCapabilities_t *>calloc(1, sizeof(nvmlVgpuSchedulerCapabilities_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerCapabilities")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerCapabilities_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerCapabilities object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerCapabilities other_
        if not isinstance(other, VgpuSchedulerCapabilities):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerCapabilities_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerCapabilities_t *>malloc(sizeof(nvmlVgpuSchedulerCapabilities_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerCapabilities")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerCapabilities_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def supported_schedulers(self):
        """~_numpy.uint32: (array of length 3)."""
        cdef view.array arr = view.array(shape=(3,), itemsize=sizeof(unsigned int), format="I", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].supportedSchedulers))
        return _numpy.asarray(arr)

    @supported_schedulers.setter
    def supported_schedulers(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        cdef view.array arr = view.array(shape=(3,), itemsize=sizeof(unsigned int), format="I", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint32)
        memcpy(<void *>(&(self._ptr[0].supportedSchedulers)), <void *>(arr.data), sizeof(unsigned int) * len(val))

    @property
    def max_timeslice(self):
        """int: """
        return self._ptr[0].maxTimeslice

    @max_timeslice.setter
    def max_timeslice(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].maxTimeslice = val

    @property
    def min_timeslice(self):
        """int: """
        return self._ptr[0].minTimeslice

    @min_timeslice.setter
    def min_timeslice(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].minTimeslice = val

    @property
    def is_arr_mode_supported(self):
        """int: """
        return self._ptr[0].isArrModeSupported

    @is_arr_mode_supported.setter
    def is_arr_mode_supported(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].isArrModeSupported = val

    @property
    def max_frequency_for_arr(self):
        """int: """
        return self._ptr[0].maxFrequencyForARR

    @max_frequency_for_arr.setter
    def max_frequency_for_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].maxFrequencyForARR = val

    @property
    def min_frequency_for_arr(self):
        """int: """
        return self._ptr[0].minFrequencyForARR

    @min_frequency_for_arr.setter
    def min_frequency_for_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].minFrequencyForARR = val

    @property
    def max_avg_factor_for_arr(self):
        """int: """
        return self._ptr[0].maxAvgFactorForARR

    @max_avg_factor_for_arr.setter
    def max_avg_factor_for_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].maxAvgFactorForARR = val

    @property
    def min_avg_factor_for_arr(self):
        """int: """
        return self._ptr[0].minAvgFactorForARR

    @min_avg_factor_for_arr.setter
    def min_avg_factor_for_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerCapabilities instance is read-only")
        self._ptr[0].minAvgFactorForARR = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerCapabilities instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_capabilities_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_capabilities_dtype", vgpu_scheduler_capabilities_dtype, VgpuSchedulerCapabilities)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerCapabilities instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerCapabilities obj = VgpuSchedulerCapabilities.__new__(VgpuSchedulerCapabilities)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerCapabilities_t *>malloc(sizeof(nvmlVgpuSchedulerCapabilities_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerCapabilities")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerCapabilities_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerCapabilities_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_license_expiry_dtype_offsets():
    cdef nvmlVgpuLicenseExpiry_t pod = nvmlVgpuLicenseExpiry_t()
    return _numpy.dtype({
        'names': ['year', 'month', 'day', 'hour', 'min_', 'sec', 'status'],
        'formats': [_numpy.uint32, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.year)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.month)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.day)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hour)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.min)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sec)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.status)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuLicenseExpiry_t),
    })

vgpu_license_expiry_dtype = _get_vgpu_license_expiry_dtype_offsets()

cdef class VgpuLicenseExpiry:
    """Empty-initialize an instance of `nvmlVgpuLicenseExpiry_t`.


    .. seealso:: `nvmlVgpuLicenseExpiry_t`
    """
    cdef:
        nvmlVgpuLicenseExpiry_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuLicenseExpiry_t *>calloc(1, sizeof(nvmlVgpuLicenseExpiry_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuLicenseExpiry")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuLicenseExpiry_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuLicenseExpiry object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuLicenseExpiry other_
        if not isinstance(other, VgpuLicenseExpiry):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuLicenseExpiry_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuLicenseExpiry_t *>malloc(sizeof(nvmlVgpuLicenseExpiry_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuLicenseExpiry")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuLicenseExpiry_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def year(self):
        """int: """
        return self._ptr[0].year

    @year.setter
    def year(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].year = val

    @property
    def month(self):
        """int: """
        return self._ptr[0].month

    @month.setter
    def month(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].month = val

    @property
    def day(self):
        """int: """
        return self._ptr[0].day

    @day.setter
    def day(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].day = val

    @property
    def hour(self):
        """int: """
        return self._ptr[0].hour

    @hour.setter
    def hour(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].hour = val

    @property
    def min_(self):
        """int: """
        return self._ptr[0].min

    @min_.setter
    def min_(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].min = val

    @property
    def sec(self):
        """int: """
        return self._ptr[0].sec

    @sec.setter
    def sec(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].sec = val

    @property
    def status(self):
        """int: """
        return self._ptr[0].status

    @status.setter
    def status(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseExpiry instance is read-only")
        self._ptr[0].status = val

    @staticmethod
    def from_data(data):
        """Create an VgpuLicenseExpiry instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_license_expiry_dtype` holding the data.
        """
        return __from_data(data, "vgpu_license_expiry_dtype", vgpu_license_expiry_dtype, VgpuLicenseExpiry)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuLicenseExpiry instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuLicenseExpiry obj = VgpuLicenseExpiry.__new__(VgpuLicenseExpiry)
        if owner is None:
            obj._ptr = <nvmlVgpuLicenseExpiry_t *>malloc(sizeof(nvmlVgpuLicenseExpiry_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuLicenseExpiry")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuLicenseExpiry_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuLicenseExpiry_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_grid_license_expiry_dtype_offsets():
    cdef nvmlGridLicenseExpiry_t pod = nvmlGridLicenseExpiry_t()
    return _numpy.dtype({
        'names': ['year', 'month', 'day', 'hour', 'min_', 'sec', 'status'],
        'formats': [_numpy.uint32, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint16, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.year)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.month)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.day)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hour)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.min)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sec)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.status)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGridLicenseExpiry_t),
    })

grid_license_expiry_dtype = _get_grid_license_expiry_dtype_offsets()

cdef class GridLicenseExpiry:
    """Empty-initialize an instance of `nvmlGridLicenseExpiry_t`.


    .. seealso:: `nvmlGridLicenseExpiry_t`
    """
    cdef:
        nvmlGridLicenseExpiry_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGridLicenseExpiry_t *>calloc(1, sizeof(nvmlGridLicenseExpiry_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GridLicenseExpiry")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGridLicenseExpiry_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GridLicenseExpiry object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GridLicenseExpiry other_
        if not isinstance(other, GridLicenseExpiry):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGridLicenseExpiry_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGridLicenseExpiry_t *>malloc(sizeof(nvmlGridLicenseExpiry_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GridLicenseExpiry")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGridLicenseExpiry_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def year(self):
        """int: """
        return self._ptr[0].year

    @year.setter
    def year(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].year = val

    @property
    def month(self):
        """int: """
        return self._ptr[0].month

    @month.setter
    def month(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].month = val

    @property
    def day(self):
        """int: """
        return self._ptr[0].day

    @day.setter
    def day(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].day = val

    @property
    def hour(self):
        """int: """
        return self._ptr[0].hour

    @hour.setter
    def hour(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].hour = val

    @property
    def min_(self):
        """int: """
        return self._ptr[0].min

    @min_.setter
    def min_(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].min = val

    @property
    def sec(self):
        """int: """
        return self._ptr[0].sec

    @sec.setter
    def sec(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].sec = val

    @property
    def status(self):
        """int: """
        return self._ptr[0].status

    @status.setter
    def status(self, val):
        if self._readonly:
            raise ValueError("This GridLicenseExpiry instance is read-only")
        self._ptr[0].status = val

    @staticmethod
    def from_data(data):
        """Create an GridLicenseExpiry instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `grid_license_expiry_dtype` holding the data.
        """
        return __from_data(data, "grid_license_expiry_dtype", grid_license_expiry_dtype, GridLicenseExpiry)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GridLicenseExpiry instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GridLicenseExpiry obj = GridLicenseExpiry.__new__(GridLicenseExpiry)
        if owner is None:
            obj._ptr = <nvmlGridLicenseExpiry_t *>malloc(sizeof(nvmlGridLicenseExpiry_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GridLicenseExpiry")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGridLicenseExpiry_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGridLicenseExpiry_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_type_id_info_v1_dtype_offsets():
    cdef nvmlVgpuTypeIdInfo_v1_t pod = nvmlVgpuTypeIdInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'vgpu_count', 'vgpu_type_ids'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuTypeIds)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuTypeIdInfo_v1_t),
    })

vgpu_type_id_info_v1_dtype = _get_vgpu_type_id_info_v1_dtype_offsets()

cdef class VgpuTypeIdInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuTypeIdInfo_v1_t`.


    .. seealso:: `nvmlVgpuTypeIdInfo_v1_t`
    """
    cdef:
        nvmlVgpuTypeIdInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuTypeIdInfo_v1_t *>calloc(1, sizeof(nvmlVgpuTypeIdInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuTypeIdInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuTypeIdInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuTypeIdInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuTypeIdInfo_v1 other_
        if not isinstance(other, VgpuTypeIdInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuTypeIdInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuTypeIdInfo_v1_t *>malloc(sizeof(nvmlVgpuTypeIdInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeIdInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuTypeIdInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeIdInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def vgpu_type_ids(self):
        """int: OUT: List of vGPU type IDs."""
        return <intptr_t>(self._ptr[0].vgpuTypeIds)

    @vgpu_type_ids.setter
    def vgpu_type_ids(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeIdInfo_v1 instance is read-only")
        self._ptr[0].vgpuTypeIds = <nvmlVgpuTypeId_t*><intptr_t>val

    @staticmethod
    def from_data(data):
        """Create an VgpuTypeIdInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_type_id_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_type_id_info_v1_dtype", vgpu_type_id_info_v1_dtype, VgpuTypeIdInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuTypeIdInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuTypeIdInfo_v1 obj = VgpuTypeIdInfo_v1.__new__(VgpuTypeIdInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuTypeIdInfo_v1_t *>malloc(sizeof(nvmlVgpuTypeIdInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeIdInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuTypeIdInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuTypeIdInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_type_max_instance_v1_dtype_offsets():
    cdef nvmlVgpuTypeMaxInstance_v1_t pod = nvmlVgpuTypeMaxInstance_v1_t()
    return _numpy.dtype({
        'names': ['version', 'vgpu_type_id', 'max_instance_per_gi'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuTypeId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxInstancePerGI)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuTypeMaxInstance_v1_t),
    })

vgpu_type_max_instance_v1_dtype = _get_vgpu_type_max_instance_v1_dtype_offsets()

cdef class VgpuTypeMaxInstance_v1:
    """Empty-initialize an instance of `nvmlVgpuTypeMaxInstance_v1_t`.


    .. seealso:: `nvmlVgpuTypeMaxInstance_v1_t`
    """
    cdef:
        nvmlVgpuTypeMaxInstance_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuTypeMaxInstance_v1_t *>calloc(1, sizeof(nvmlVgpuTypeMaxInstance_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuTypeMaxInstance_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuTypeMaxInstance_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuTypeMaxInstance_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuTypeMaxInstance_v1 other_
        if not isinstance(other, VgpuTypeMaxInstance_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuTypeMaxInstance_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuTypeMaxInstance_v1_t *>malloc(sizeof(nvmlVgpuTypeMaxInstance_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeMaxInstance_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuTypeMaxInstance_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeMaxInstance_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def vgpu_type_id(self):
        """int: IN: Handle to vGPU type."""
        return <unsigned int>(self._ptr[0].vgpuTypeId)

    @vgpu_type_id.setter
    def vgpu_type_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeMaxInstance_v1 instance is read-only")
        self._ptr[0].vgpuTypeId = <nvmlVgpuTypeId_t><unsigned int>val

    @property
    def max_instance_per_gi(self):
        """int: OUT: Maximum number of vGPU instances per GPU instance."""
        return self._ptr[0].maxInstancePerGI

    @max_instance_per_gi.setter
    def max_instance_per_gi(self, val):
        if self._readonly:
            raise ValueError("This VgpuTypeMaxInstance_v1 instance is read-only")
        self._ptr[0].maxInstancePerGI = val

    @staticmethod
    def from_data(data):
        """Create an VgpuTypeMaxInstance_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_type_max_instance_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_type_max_instance_v1_dtype", vgpu_type_max_instance_v1_dtype, VgpuTypeMaxInstance_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuTypeMaxInstance_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuTypeMaxInstance_v1 obj = VgpuTypeMaxInstance_v1.__new__(VgpuTypeMaxInstance_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuTypeMaxInstance_v1_t *>malloc(sizeof(nvmlVgpuTypeMaxInstance_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuTypeMaxInstance_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuTypeMaxInstance_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuTypeMaxInstance_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_active_vgpu_instance_info_v1_dtype_offsets():
    cdef nvmlActiveVgpuInstanceInfo_v1_t pod = nvmlActiveVgpuInstanceInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'vgpu_count', 'vgpu_instances'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstances)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlActiveVgpuInstanceInfo_v1_t),
    })

active_vgpu_instance_info_v1_dtype = _get_active_vgpu_instance_info_v1_dtype_offsets()

cdef class ActiveVgpuInstanceInfo_v1:
    """Empty-initialize an instance of `nvmlActiveVgpuInstanceInfo_v1_t`.


    .. seealso:: `nvmlActiveVgpuInstanceInfo_v1_t`
    """
    cdef:
        nvmlActiveVgpuInstanceInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlActiveVgpuInstanceInfo_v1_t *>calloc(1, sizeof(nvmlActiveVgpuInstanceInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ActiveVgpuInstanceInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlActiveVgpuInstanceInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ActiveVgpuInstanceInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ActiveVgpuInstanceInfo_v1 other_
        if not isinstance(other, ActiveVgpuInstanceInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlActiveVgpuInstanceInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlActiveVgpuInstanceInfo_v1_t *>malloc(sizeof(nvmlActiveVgpuInstanceInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ActiveVgpuInstanceInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlActiveVgpuInstanceInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ActiveVgpuInstanceInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def vgpu_instances(self):
        """int: IN/OUT: list of active vGPU instances."""
        return <intptr_t>(self._ptr[0].vgpuInstances)

    @vgpu_instances.setter
    def vgpu_instances(self, val):
        if self._readonly:
            raise ValueError("This ActiveVgpuInstanceInfo_v1 instance is read-only")
        self._ptr[0].vgpuInstances = <nvmlVgpuInstance_t*><intptr_t>val

    @staticmethod
    def from_data(data):
        """Create an ActiveVgpuInstanceInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `active_vgpu_instance_info_v1_dtype` holding the data.
        """
        return __from_data(data, "active_vgpu_instance_info_v1_dtype", active_vgpu_instance_info_v1_dtype, ActiveVgpuInstanceInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ActiveVgpuInstanceInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ActiveVgpuInstanceInfo_v1 obj = ActiveVgpuInstanceInfo_v1.__new__(ActiveVgpuInstanceInfo_v1)
        if owner is None:
            obj._ptr = <nvmlActiveVgpuInstanceInfo_v1_t *>malloc(sizeof(nvmlActiveVgpuInstanceInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ActiveVgpuInstanceInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlActiveVgpuInstanceInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlActiveVgpuInstanceInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_creatable_placement_info_v1_dtype_offsets():
    cdef nvmlVgpuCreatablePlacementInfo_v1_t pod = nvmlVgpuCreatablePlacementInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'vgpu_type_id', 'count', 'placement_ids', 'placement_size'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.intp, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuTypeId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.count)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placementIds)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placementSize)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuCreatablePlacementInfo_v1_t),
    })

vgpu_creatable_placement_info_v1_dtype = _get_vgpu_creatable_placement_info_v1_dtype_offsets()

cdef class VgpuCreatablePlacementInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuCreatablePlacementInfo_v1_t`.


    .. seealso:: `nvmlVgpuCreatablePlacementInfo_v1_t`
    """
    cdef:
        nvmlVgpuCreatablePlacementInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlVgpuCreatablePlacementInfo_v1_t *>calloc(1, sizeof(nvmlVgpuCreatablePlacementInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuCreatablePlacementInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlVgpuCreatablePlacementInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuCreatablePlacementInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuCreatablePlacementInfo_v1 other_
        if not isinstance(other, VgpuCreatablePlacementInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuCreatablePlacementInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuCreatablePlacementInfo_v1_t *>malloc(sizeof(nvmlVgpuCreatablePlacementInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuCreatablePlacementInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuCreatablePlacementInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuCreatablePlacementInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def vgpu_type_id(self):
        """int: IN: Handle to vGPU type."""
        return <unsigned int>(self._ptr[0].vgpuTypeId)

    @vgpu_type_id.setter
    def vgpu_type_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuCreatablePlacementInfo_v1 instance is read-only")
        self._ptr[0].vgpuTypeId = <nvmlVgpuTypeId_t><unsigned int>val

    @property
    def count(self):
        """int: IN/OUT: Count of the placement IDs."""
        return self._ptr[0].count

    @count.setter
    def count(self, val):
        if self._readonly:
            raise ValueError("This VgpuCreatablePlacementInfo_v1 instance is read-only")
        self._ptr[0].count = val

    @property
    def placement_ids(self):
        """int: IN/OUT: Placement IDs for the vGPU type."""
        if self._ptr[0].placementIds == NULL:
            return []
        cdef view.array arr = view.array(shape=(self._ptr[0].placementSize,), itemsize=sizeof(unsigned int), format="I", mode="c", allocate_buffer=False)
        arr.data = <char *>(self._ptr[0].placementIds)
        return _numpy.asarray(arr)

    @placement_ids.setter
    def placement_ids(self, val):
        if self._readonly:
            raise ValueError("This VgpuCreatablePlacementInfo_v1 instance is read-only")
        cdef view.array arr = view.array(shape=(len(val),), itemsize=sizeof(unsigned int), format="I", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint32)
        self._ptr[0].placementIds = <unsigned int*><intptr_t>(arr.data)
        self._ptr[0].placementSize = len(val)
        self._refs["placement_ids"] = arr

    @staticmethod
    def from_data(data):
        """Create an VgpuCreatablePlacementInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_creatable_placement_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_creatable_placement_info_v1_dtype", vgpu_creatable_placement_info_v1_dtype, VgpuCreatablePlacementInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuCreatablePlacementInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuCreatablePlacementInfo_v1 obj = VgpuCreatablePlacementInfo_v1.__new__(VgpuCreatablePlacementInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuCreatablePlacementInfo_v1_t *>malloc(sizeof(nvmlVgpuCreatablePlacementInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuCreatablePlacementInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuCreatablePlacementInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuCreatablePlacementInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_hwbc_entry_dtype_offsets():
    cdef nvmlHwbcEntry_t pod = nvmlHwbcEntry_t()
    return _numpy.dtype({
        'names': ['hwbc_id', 'firmware_version'],
        'formats': [_numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.hwbcId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.firmwareVersion)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlHwbcEntry_t),
    })

hwbc_entry_dtype = _get_hwbc_entry_dtype_offsets()

cdef class HwbcEntry:
    """Empty-initialize an array of `nvmlHwbcEntry_t`.

    The resulting object is of length `size` and of dtype `hwbc_entry_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlHwbcEntry_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=hwbc_entry_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlHwbcEntry_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlHwbcEntry_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.HwbcEntry_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.HwbcEntry object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, HwbcEntry)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def hwbc_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.hwbc_id[0])
        return self._data.hwbc_id

    @hwbc_id.setter
    def hwbc_id(self, val):
        self._data.hwbc_id = val

    @property
    def firmware_version(self):
        """~_numpy.int8: (array of length 32)."""
        return self._data.firmware_version

    @firmware_version.setter
    def firmware_version(self, val):
        self._data.firmware_version = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return HwbcEntry.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == hwbc_entry_dtype:
            return HwbcEntry.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an HwbcEntry instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `hwbc_entry_dtype` holding the data.
        """
        cdef HwbcEntry obj = HwbcEntry.__new__(HwbcEntry)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != hwbc_entry_dtype:
            raise ValueError("data array must be of dtype hwbc_entry_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an HwbcEntry instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef HwbcEntry obj = HwbcEntry.__new__(HwbcEntry)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlHwbcEntry_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=hwbc_entry_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_led_state_dtype_offsets():
    cdef nvmlLedState_t pod = nvmlLedState_t()
    return _numpy.dtype({
        'names': ['cause', 'color'],
        'formats': [_numpy.int8, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.cause)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.color)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlLedState_t),
    })

led_state_dtype = _get_led_state_dtype_offsets()

cdef class LedState:
    """Empty-initialize an instance of `nvmlLedState_t`.


    .. seealso:: `nvmlLedState_t`
    """
    cdef:
        nvmlLedState_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlLedState_t *>calloc(1, sizeof(nvmlLedState_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating LedState")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlLedState_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.LedState object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef LedState other_
        if not isinstance(other, LedState):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlLedState_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlLedState_t *>malloc(sizeof(nvmlLedState_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating LedState")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlLedState_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def cause(self):
        """~_numpy.int8: (array of length 256)."""
        return cpython.PyUnicode_FromString(self._ptr[0].cause)

    @cause.setter
    def cause(self, val):
        if self._readonly:
            raise ValueError("This LedState instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 256:
            raise ValueError("String too long for field cause, max length is 255")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].cause), <void *>ptr, 256)

    @property
    def color(self):
        """int: """
        return <int>(self._ptr[0].color)

    @color.setter
    def color(self, val):
        if self._readonly:
            raise ValueError("This LedState instance is read-only")
        self._ptr[0].color = <nvmlLedColor_t><int>val

    @staticmethod
    def from_data(data):
        """Create an LedState instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `led_state_dtype` holding the data.
        """
        return __from_data(data, "led_state_dtype", led_state_dtype, LedState)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an LedState instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef LedState obj = LedState.__new__(LedState)
        if owner is None:
            obj._ptr = <nvmlLedState_t *>malloc(sizeof(nvmlLedState_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating LedState")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlLedState_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlLedState_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_unit_info_dtype_offsets():
    cdef nvmlUnitInfo_t pod = nvmlUnitInfo_t()
    return _numpy.dtype({
        'names': ['name', 'id', 'serial', 'firmware_version'],
        'formats': [_numpy.int8, _numpy.int8, _numpy.int8, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.name)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.serial)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.firmwareVersion)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlUnitInfo_t),
    })

unit_info_dtype = _get_unit_info_dtype_offsets()

cdef class UnitInfo:
    """Empty-initialize an instance of `nvmlUnitInfo_t`.


    .. seealso:: `nvmlUnitInfo_t`
    """
    cdef:
        nvmlUnitInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlUnitInfo_t *>calloc(1, sizeof(nvmlUnitInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating UnitInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlUnitInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.UnitInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef UnitInfo other_
        if not isinstance(other, UnitInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlUnitInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlUnitInfo_t *>malloc(sizeof(nvmlUnitInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating UnitInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlUnitInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def name(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].name)

    @name.setter
    def name(self, val):
        if self._readonly:
            raise ValueError("This UnitInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field name, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].name), <void *>ptr, 96)

    @property
    def id(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].id)

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This UnitInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field id, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].id), <void *>ptr, 96)

    @property
    def serial(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].serial)

    @serial.setter
    def serial(self, val):
        if self._readonly:
            raise ValueError("This UnitInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field serial, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].serial), <void *>ptr, 96)

    @property
    def firmware_version(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].firmwareVersion)

    @firmware_version.setter
    def firmware_version(self, val):
        if self._readonly:
            raise ValueError("This UnitInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field firmware_version, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].firmwareVersion), <void *>ptr, 96)

    @staticmethod
    def from_data(data):
        """Create an UnitInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `unit_info_dtype` holding the data.
        """
        return __from_data(data, "unit_info_dtype", unit_info_dtype, UnitInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an UnitInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef UnitInfo obj = UnitInfo.__new__(UnitInfo)
        if owner is None:
            obj._ptr = <nvmlUnitInfo_t *>malloc(sizeof(nvmlUnitInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating UnitInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlUnitInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlUnitInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_psu_info_dtype_offsets():
    cdef nvmlPSUInfo_t pod = nvmlPSUInfo_t()
    return _numpy.dtype({
        'names': ['state', 'current', 'voltage', 'power'],
        'formats': [_numpy.int8, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.state)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.current)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.voltage)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.power)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPSUInfo_t),
    })

psu_info_dtype = _get_psu_info_dtype_offsets()

cdef class PSUInfo:
    """Empty-initialize an instance of `nvmlPSUInfo_t`.


    .. seealso:: `nvmlPSUInfo_t`
    """
    cdef:
        nvmlPSUInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPSUInfo_t *>calloc(1, sizeof(nvmlPSUInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PSUInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPSUInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PSUInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PSUInfo other_
        if not isinstance(other, PSUInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPSUInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPSUInfo_t *>malloc(sizeof(nvmlPSUInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PSUInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPSUInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def state(self):
        """~_numpy.int8: (array of length 256)."""
        return cpython.PyUnicode_FromString(self._ptr[0].state)

    @state.setter
    def state(self, val):
        if self._readonly:
            raise ValueError("This PSUInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 256:
            raise ValueError("String too long for field state, max length is 255")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].state), <void *>ptr, 256)

    @property
    def current(self):
        """int: """
        return self._ptr[0].current

    @current.setter
    def current(self, val):
        if self._readonly:
            raise ValueError("This PSUInfo instance is read-only")
        self._ptr[0].current = val

    @property
    def voltage(self):
        """int: """
        return self._ptr[0].voltage

    @voltage.setter
    def voltage(self, val):
        if self._readonly:
            raise ValueError("This PSUInfo instance is read-only")
        self._ptr[0].voltage = val

    @property
    def power(self):
        """int: """
        return self._ptr[0].power

    @power.setter
    def power(self, val):
        if self._readonly:
            raise ValueError("This PSUInfo instance is read-only")
        self._ptr[0].power = val

    @staticmethod
    def from_data(data):
        """Create an PSUInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `psu_info_dtype` holding the data.
        """
        return __from_data(data, "psu_info_dtype", psu_info_dtype, PSUInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PSUInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PSUInfo obj = PSUInfo.__new__(PSUInfo)
        if owner is None:
            obj._ptr = <nvmlPSUInfo_t *>malloc(sizeof(nvmlPSUInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PSUInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPSUInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPSUInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_unit_fan_info_dtype_offsets():
    cdef nvmlUnitFanInfo_t pod = nvmlUnitFanInfo_t()
    return _numpy.dtype({
        'names': ['speed', 'state'],
        'formats': [_numpy.uint32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.speed)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.state)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlUnitFanInfo_t),
    })

unit_fan_info_dtype = _get_unit_fan_info_dtype_offsets()

cdef class UnitFanInfo:
    """Empty-initialize an array of `nvmlUnitFanInfo_t`.

    The resulting object is of length `size` and of dtype `unit_fan_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlUnitFanInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=unit_fan_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlUnitFanInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlUnitFanInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.UnitFanInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.UnitFanInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, UnitFanInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def speed(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.speed[0])
        return self._data.speed

    @speed.setter
    def speed(self, val):
        self._data.speed = val

    @property
    def state(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.state[0])
        return self._data.state

    @state.setter
    def state(self, val):
        self._data.state = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return UnitFanInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == unit_fan_info_dtype:
            return UnitFanInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an UnitFanInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `unit_fan_info_dtype` holding the data.
        """
        cdef UnitFanInfo obj = UnitFanInfo.__new__(UnitFanInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != unit_fan_info_dtype:
            raise ValueError("data array must be of dtype unit_fan_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an UnitFanInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef UnitFanInfo obj = UnitFanInfo.__new__(UnitFanInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlUnitFanInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=unit_fan_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_event_data_dtype_offsets():
    cdef nvmlEventData_t pod = nvmlEventData_t()
    return _numpy.dtype({
        'names': ['device_', 'event_type', 'event_data', 'gpu_instance_id', 'compute_instance_id'],
        'formats': [_numpy.intp, _numpy.uint64, _numpy.uint64, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.device)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.eventType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.eventData)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpuInstanceId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.computeInstanceId)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlEventData_t),
    })

event_data_dtype = _get_event_data_dtype_offsets()

cdef class EventData:
    """Empty-initialize an instance of `nvmlEventData_t`.


    .. seealso:: `nvmlEventData_t`
    """
    cdef:
        nvmlEventData_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlEventData_t *>calloc(1, sizeof(nvmlEventData_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating EventData")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlEventData_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.EventData object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef EventData other_
        if not isinstance(other, EventData):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlEventData_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlEventData_t *>malloc(sizeof(nvmlEventData_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating EventData")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlEventData_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def device_(self):
        """int: """
        return <intptr_t>(self._ptr[0].device)

    @device_.setter
    def device_(self, val):
        if self._readonly:
            raise ValueError("This EventData instance is read-only")
        self._ptr[0].device = <nvmlDevice_t><intptr_t>val

    @property
    def event_type(self):
        """int: """
        return self._ptr[0].eventType

    @event_type.setter
    def event_type(self, val):
        if self._readonly:
            raise ValueError("This EventData instance is read-only")
        self._ptr[0].eventType = val

    @property
    def event_data(self):
        """int: """
        return self._ptr[0].eventData

    @event_data.setter
    def event_data(self, val):
        if self._readonly:
            raise ValueError("This EventData instance is read-only")
        self._ptr[0].eventData = val

    @property
    def gpu_instance_id(self):
        """int: """
        return self._ptr[0].gpuInstanceId

    @gpu_instance_id.setter
    def gpu_instance_id(self, val):
        if self._readonly:
            raise ValueError("This EventData instance is read-only")
        self._ptr[0].gpuInstanceId = val

    @property
    def compute_instance_id(self):
        """int: """
        return self._ptr[0].computeInstanceId

    @compute_instance_id.setter
    def compute_instance_id(self, val):
        if self._readonly:
            raise ValueError("This EventData instance is read-only")
        self._ptr[0].computeInstanceId = val

    @staticmethod
    def from_data(data):
        """Create an EventData instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `event_data_dtype` holding the data.
        """
        return __from_data(data, "event_data_dtype", event_data_dtype, EventData)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an EventData instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef EventData obj = EventData.__new__(EventData)
        if owner is None:
            obj._ptr = <nvmlEventData_t *>malloc(sizeof(nvmlEventData_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating EventData")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlEventData_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlEventData_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_accounting_stats_dtype_offsets():
    cdef nvmlAccountingStats_t pod = nvmlAccountingStats_t()
    return _numpy.dtype({
        'names': ['gpu_utilization', 'memory_utilization', 'max_memory_usage', 'time', 'start_time', 'is_running', 'reserved'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint64, _numpy.uint64, _numpy.uint64, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.gpuUtilization)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memoryUtilization)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxMemoryUsage)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.time)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.startTime)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isRunning)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.reserved)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlAccountingStats_t),
    })

accounting_stats_dtype = _get_accounting_stats_dtype_offsets()

cdef class AccountingStats:
    """Empty-initialize an instance of `nvmlAccountingStats_t`.


    .. seealso:: `nvmlAccountingStats_t`
    """
    cdef:
        nvmlAccountingStats_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlAccountingStats_t *>calloc(1, sizeof(nvmlAccountingStats_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating AccountingStats")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlAccountingStats_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.AccountingStats object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef AccountingStats other_
        if not isinstance(other, AccountingStats):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlAccountingStats_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlAccountingStats_t *>malloc(sizeof(nvmlAccountingStats_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating AccountingStats")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlAccountingStats_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def gpu_utilization(self):
        """int: """
        return self._ptr[0].gpuUtilization

    @gpu_utilization.setter
    def gpu_utilization(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].gpuUtilization = val

    @property
    def memory_utilization(self):
        """int: """
        return self._ptr[0].memoryUtilization

    @memory_utilization.setter
    def memory_utilization(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].memoryUtilization = val

    @property
    def max_memory_usage(self):
        """int: """
        return self._ptr[0].maxMemoryUsage

    @max_memory_usage.setter
    def max_memory_usage(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].maxMemoryUsage = val

    @property
    def time(self):
        """int: """
        return self._ptr[0].time

    @time.setter
    def time(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].time = val

    @property
    def start_time(self):
        """int: """
        return self._ptr[0].startTime

    @start_time.setter
    def start_time(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].startTime = val

    @property
    def is_running(self):
        """int: """
        return self._ptr[0].isRunning

    @is_running.setter
    def is_running(self, val):
        if self._readonly:
            raise ValueError("This AccountingStats instance is read-only")
        self._ptr[0].isRunning = val

    @staticmethod
    def from_data(data):
        """Create an AccountingStats instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `accounting_stats_dtype` holding the data.
        """
        return __from_data(data, "accounting_stats_dtype", accounting_stats_dtype, AccountingStats)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an AccountingStats instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef AccountingStats obj = AccountingStats.__new__(AccountingStats)
        if owner is None:
            obj._ptr = <nvmlAccountingStats_t *>malloc(sizeof(nvmlAccountingStats_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating AccountingStats")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlAccountingStats_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlAccountingStats_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_encoder_session_info_dtype_offsets():
    cdef nvmlEncoderSessionInfo_t pod = nvmlEncoderSessionInfo_t()
    return _numpy.dtype({
        'names': ['session_id', 'pid', 'vgpu_instance', 'codec_type', 'h_resolution', 'v_resolution', 'average_fps', 'average_latency'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.sessionId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstance)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.codecType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageFps)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageLatency)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlEncoderSessionInfo_t),
    })

encoder_session_info_dtype = _get_encoder_session_info_dtype_offsets()

cdef class EncoderSessionInfo:
    """Empty-initialize an array of `nvmlEncoderSessionInfo_t`.

    The resulting object is of length `size` and of dtype `encoder_session_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlEncoderSessionInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=encoder_session_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlEncoderSessionInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlEncoderSessionInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.EncoderSessionInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.EncoderSessionInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, EncoderSessionInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def session_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.session_id[0])
        return self._data.session_id

    @session_id.setter
    def session_id(self, val):
        self._data.session_id = val

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def vgpu_instance(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.vgpu_instance[0])
        return self._data.vgpu_instance

    @vgpu_instance.setter
    def vgpu_instance(self, val):
        self._data.vgpu_instance = val

    @property
    def codec_type(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.codec_type[0])
        return self._data.codec_type

    @codec_type.setter
    def codec_type(self, val):
        self._data.codec_type = val

    @property
    def h_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.h_resolution[0])
        return self._data.h_resolution

    @h_resolution.setter
    def h_resolution(self, val):
        self._data.h_resolution = val

    @property
    def v_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.v_resolution[0])
        return self._data.v_resolution

    @v_resolution.setter
    def v_resolution(self, val):
        self._data.v_resolution = val

    @property
    def average_fps(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.average_fps[0])
        return self._data.average_fps

    @average_fps.setter
    def average_fps(self, val):
        self._data.average_fps = val

    @property
    def average_latency(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.average_latency[0])
        return self._data.average_latency

    @average_latency.setter
    def average_latency(self, val):
        self._data.average_latency = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return EncoderSessionInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == encoder_session_info_dtype:
            return EncoderSessionInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an EncoderSessionInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `encoder_session_info_dtype` holding the data.
        """
        cdef EncoderSessionInfo obj = EncoderSessionInfo.__new__(EncoderSessionInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != encoder_session_info_dtype:
            raise ValueError("data array must be of dtype encoder_session_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an EncoderSessionInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef EncoderSessionInfo obj = EncoderSessionInfo.__new__(EncoderSessionInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlEncoderSessionInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=encoder_session_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_fbc_stats_dtype_offsets():
    cdef nvmlFBCStats_t pod = nvmlFBCStats_t()
    return _numpy.dtype({
        'names': ['sessions_count', 'average_fps', 'average_latency'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.sessionsCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageFPS)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageLatency)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlFBCStats_t),
    })

fbc_stats_dtype = _get_fbc_stats_dtype_offsets()

cdef class FBCStats:
    """Empty-initialize an instance of `nvmlFBCStats_t`.


    .. seealso:: `nvmlFBCStats_t`
    """
    cdef:
        nvmlFBCStats_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlFBCStats_t *>calloc(1, sizeof(nvmlFBCStats_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating FBCStats")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlFBCStats_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.FBCStats object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef FBCStats other_
        if not isinstance(other, FBCStats):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlFBCStats_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlFBCStats_t *>malloc(sizeof(nvmlFBCStats_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating FBCStats")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlFBCStats_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def sessions_count(self):
        """int: """
        return self._ptr[0].sessionsCount

    @sessions_count.setter
    def sessions_count(self, val):
        if self._readonly:
            raise ValueError("This FBCStats instance is read-only")
        self._ptr[0].sessionsCount = val

    @property
    def average_fps(self):
        """int: """
        return self._ptr[0].averageFPS

    @average_fps.setter
    def average_fps(self, val):
        if self._readonly:
            raise ValueError("This FBCStats instance is read-only")
        self._ptr[0].averageFPS = val

    @property
    def average_latency(self):
        """int: """
        return self._ptr[0].averageLatency

    @average_latency.setter
    def average_latency(self, val):
        if self._readonly:
            raise ValueError("This FBCStats instance is read-only")
        self._ptr[0].averageLatency = val

    @staticmethod
    def from_data(data):
        """Create an FBCStats instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `fbc_stats_dtype` holding the data.
        """
        return __from_data(data, "fbc_stats_dtype", fbc_stats_dtype, FBCStats)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an FBCStats instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef FBCStats obj = FBCStats.__new__(FBCStats)
        if owner is None:
            obj._ptr = <nvmlFBCStats_t *>malloc(sizeof(nvmlFBCStats_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating FBCStats")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlFBCStats_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlFBCStats_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_fbc_session_info_dtype_offsets():
    cdef nvmlFBCSessionInfo_t pod = nvmlFBCSessionInfo_t()
    return _numpy.dtype({
        'names': ['session_id', 'pid', 'vgpu_instance', 'display_ordinal', 'session_type', 'session_flags', 'h_max_resolution', 'v_max_resolution', 'h_resolution', 'v_resolution', 'average_fps', 'average_latency'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.sessionId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstance)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.displayOrdinal)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sessionType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sessionFlags)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hMaxResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vMaxResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vResolution)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageFPS)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.averageLatency)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlFBCSessionInfo_t),
    })

fbc_session_info_dtype = _get_fbc_session_info_dtype_offsets()

cdef class FBCSessionInfo:
    """Empty-initialize an array of `nvmlFBCSessionInfo_t`.

    The resulting object is of length `size` and of dtype `fbc_session_info_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlFBCSessionInfo_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=fbc_session_info_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlFBCSessionInfo_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlFBCSessionInfo_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.FBCSessionInfo_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.FBCSessionInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, FBCSessionInfo)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def session_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.session_id[0])
        return self._data.session_id

    @session_id.setter
    def session_id(self, val):
        self._data.session_id = val

    @property
    def pid(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.pid[0])
        return self._data.pid

    @pid.setter
    def pid(self, val):
        self._data.pid = val

    @property
    def vgpu_instance(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.vgpu_instance[0])
        return self._data.vgpu_instance

    @vgpu_instance.setter
    def vgpu_instance(self, val):
        self._data.vgpu_instance = val

    @property
    def display_ordinal(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.display_ordinal[0])
        return self._data.display_ordinal

    @display_ordinal.setter
    def display_ordinal(self, val):
        self._data.display_ordinal = val

    @property
    def session_type(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.session_type[0])
        return self._data.session_type

    @session_type.setter
    def session_type(self, val):
        self._data.session_type = val

    @property
    def session_flags(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.session_flags[0])
        return self._data.session_flags

    @session_flags.setter
    def session_flags(self, val):
        self._data.session_flags = val

    @property
    def h_max_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.h_max_resolution[0])
        return self._data.h_max_resolution

    @h_max_resolution.setter
    def h_max_resolution(self, val):
        self._data.h_max_resolution = val

    @property
    def v_max_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.v_max_resolution[0])
        return self._data.v_max_resolution

    @v_max_resolution.setter
    def v_max_resolution(self, val):
        self._data.v_max_resolution = val

    @property
    def h_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.h_resolution[0])
        return self._data.h_resolution

    @h_resolution.setter
    def h_resolution(self, val):
        self._data.h_resolution = val

    @property
    def v_resolution(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.v_resolution[0])
        return self._data.v_resolution

    @v_resolution.setter
    def v_resolution(self, val):
        self._data.v_resolution = val

    @property
    def average_fps(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.average_fps[0])
        return self._data.average_fps

    @average_fps.setter
    def average_fps(self, val):
        self._data.average_fps = val

    @property
    def average_latency(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.average_latency[0])
        return self._data.average_latency

    @average_latency.setter
    def average_latency(self, val):
        self._data.average_latency = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return FBCSessionInfo.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == fbc_session_info_dtype:
            return FBCSessionInfo.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an FBCSessionInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `fbc_session_info_dtype` holding the data.
        """
        cdef FBCSessionInfo obj = FBCSessionInfo.__new__(FBCSessionInfo)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != fbc_session_info_dtype:
            raise ValueError("data array must be of dtype fbc_session_info_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an FBCSessionInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef FBCSessionInfo obj = FBCSessionInfo.__new__(FBCSessionInfo)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlFBCSessionInfo_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=fbc_session_info_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_conf_compute_system_caps_dtype_offsets():
    cdef nvmlConfComputeSystemCaps_t pod = nvmlConfComputeSystemCaps_t()
    return _numpy.dtype({
        'names': ['cpu_caps', 'gpus_caps'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.cpuCaps)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpusCaps)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeSystemCaps_t),
    })

conf_compute_system_caps_dtype = _get_conf_compute_system_caps_dtype_offsets()

cdef class ConfComputeSystemCaps:
    """Empty-initialize an instance of `nvmlConfComputeSystemCaps_t`.


    .. seealso:: `nvmlConfComputeSystemCaps_t`
    """
    cdef:
        nvmlConfComputeSystemCaps_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeSystemCaps_t *>calloc(1, sizeof(nvmlConfComputeSystemCaps_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeSystemCaps")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeSystemCaps_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeSystemCaps object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeSystemCaps other_
        if not isinstance(other, ConfComputeSystemCaps):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeSystemCaps_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeSystemCaps_t *>malloc(sizeof(nvmlConfComputeSystemCaps_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeSystemCaps")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeSystemCaps_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def cpu_caps(self):
        """int: """
        return self._ptr[0].cpuCaps

    @cpu_caps.setter
    def cpu_caps(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeSystemCaps instance is read-only")
        self._ptr[0].cpuCaps = val

    @property
    def gpus_caps(self):
        """int: """
        return self._ptr[0].gpusCaps

    @gpus_caps.setter
    def gpus_caps(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeSystemCaps instance is read-only")
        self._ptr[0].gpusCaps = val

    @staticmethod
    def from_data(data):
        """Create an ConfComputeSystemCaps instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_system_caps_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_system_caps_dtype", conf_compute_system_caps_dtype, ConfComputeSystemCaps)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeSystemCaps instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeSystemCaps obj = ConfComputeSystemCaps.__new__(ConfComputeSystemCaps)
        if owner is None:
            obj._ptr = <nvmlConfComputeSystemCaps_t *>malloc(sizeof(nvmlConfComputeSystemCaps_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeSystemCaps")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeSystemCaps_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeSystemCaps_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_conf_compute_system_state_dtype_offsets():
    cdef nvmlConfComputeSystemState_t pod = nvmlConfComputeSystemState_t()
    return _numpy.dtype({
        'names': ['environment', 'cc_feature', 'dev_tools_mode'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.environment)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ccFeature)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.devToolsMode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeSystemState_t),
    })

conf_compute_system_state_dtype = _get_conf_compute_system_state_dtype_offsets()

cdef class ConfComputeSystemState:
    """Empty-initialize an instance of `nvmlConfComputeSystemState_t`.


    .. seealso:: `nvmlConfComputeSystemState_t`
    """
    cdef:
        nvmlConfComputeSystemState_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeSystemState_t *>calloc(1, sizeof(nvmlConfComputeSystemState_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeSystemState")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeSystemState_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeSystemState object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeSystemState other_
        if not isinstance(other, ConfComputeSystemState):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeSystemState_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeSystemState_t *>malloc(sizeof(nvmlConfComputeSystemState_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeSystemState")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeSystemState_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def environment(self):
        """int: """
        return self._ptr[0].environment

    @environment.setter
    def environment(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeSystemState instance is read-only")
        self._ptr[0].environment = val

    @property
    def cc_feature(self):
        """int: """
        return self._ptr[0].ccFeature

    @cc_feature.setter
    def cc_feature(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeSystemState instance is read-only")
        self._ptr[0].ccFeature = val

    @property
    def dev_tools_mode(self):
        """int: """
        return self._ptr[0].devToolsMode

    @dev_tools_mode.setter
    def dev_tools_mode(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeSystemState instance is read-only")
        self._ptr[0].devToolsMode = val

    @staticmethod
    def from_data(data):
        """Create an ConfComputeSystemState instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_system_state_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_system_state_dtype", conf_compute_system_state_dtype, ConfComputeSystemState)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeSystemState instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeSystemState obj = ConfComputeSystemState.__new__(ConfComputeSystemState)
        if owner is None:
            obj._ptr = <nvmlConfComputeSystemState_t *>malloc(sizeof(nvmlConfComputeSystemState_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeSystemState")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeSystemState_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeSystemState_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_system_conf_compute_settings_v1_dtype_offsets():
    cdef nvmlSystemConfComputeSettings_v1_t pod = nvmlSystemConfComputeSettings_v1_t()
    return _numpy.dtype({
        'names': ['version', 'environment', 'cc_feature', 'dev_tools_mode', 'multi_gpu_mode'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.environment)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ccFeature)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.devToolsMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.multiGpuMode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlSystemConfComputeSettings_v1_t),
    })

system_conf_compute_settings_v1_dtype = _get_system_conf_compute_settings_v1_dtype_offsets()

cdef class SystemConfComputeSettings_v1:
    """Empty-initialize an instance of `nvmlSystemConfComputeSettings_v1_t`.


    .. seealso:: `nvmlSystemConfComputeSettings_v1_t`
    """
    cdef:
        nvmlSystemConfComputeSettings_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlSystemConfComputeSettings_v1_t *>calloc(1, sizeof(nvmlSystemConfComputeSettings_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating SystemConfComputeSettings_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlSystemConfComputeSettings_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.SystemConfComputeSettings_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef SystemConfComputeSettings_v1 other_
        if not isinstance(other, SystemConfComputeSettings_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlSystemConfComputeSettings_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlSystemConfComputeSettings_v1_t *>malloc(sizeof(nvmlSystemConfComputeSettings_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating SystemConfComputeSettings_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlSystemConfComputeSettings_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This SystemConfComputeSettings_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def environment(self):
        """int: """
        return self._ptr[0].environment

    @environment.setter
    def environment(self, val):
        if self._readonly:
            raise ValueError("This SystemConfComputeSettings_v1 instance is read-only")
        self._ptr[0].environment = val

    @property
    def cc_feature(self):
        """int: """
        return self._ptr[0].ccFeature

    @cc_feature.setter
    def cc_feature(self, val):
        if self._readonly:
            raise ValueError("This SystemConfComputeSettings_v1 instance is read-only")
        self._ptr[0].ccFeature = val

    @property
    def dev_tools_mode(self):
        """int: """
        return self._ptr[0].devToolsMode

    @dev_tools_mode.setter
    def dev_tools_mode(self, val):
        if self._readonly:
            raise ValueError("This SystemConfComputeSettings_v1 instance is read-only")
        self._ptr[0].devToolsMode = val

    @property
    def multi_gpu_mode(self):
        """int: """
        return self._ptr[0].multiGpuMode

    @multi_gpu_mode.setter
    def multi_gpu_mode(self, val):
        if self._readonly:
            raise ValueError("This SystemConfComputeSettings_v1 instance is read-only")
        self._ptr[0].multiGpuMode = val

    @staticmethod
    def from_data(data):
        """Create an SystemConfComputeSettings_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `system_conf_compute_settings_v1_dtype` holding the data.
        """
        return __from_data(data, "system_conf_compute_settings_v1_dtype", system_conf_compute_settings_v1_dtype, SystemConfComputeSettings_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an SystemConfComputeSettings_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef SystemConfComputeSettings_v1 obj = SystemConfComputeSettings_v1.__new__(SystemConfComputeSettings_v1)
        if owner is None:
            obj._ptr = <nvmlSystemConfComputeSettings_v1_t *>malloc(sizeof(nvmlSystemConfComputeSettings_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating SystemConfComputeSettings_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlSystemConfComputeSettings_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlSystemConfComputeSettings_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_conf_compute_mem_size_info_dtype_offsets():
    cdef nvmlConfComputeMemSizeInfo_t pod = nvmlConfComputeMemSizeInfo_t()
    return _numpy.dtype({
        'names': ['protected_mem_size_kib', 'unprotected_mem_size_kib'],
        'formats': [_numpy.uint64, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.protectedMemSizeKib)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.unprotectedMemSizeKib)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeMemSizeInfo_t),
    })

conf_compute_mem_size_info_dtype = _get_conf_compute_mem_size_info_dtype_offsets()

cdef class ConfComputeMemSizeInfo:
    """Empty-initialize an instance of `nvmlConfComputeMemSizeInfo_t`.


    .. seealso:: `nvmlConfComputeMemSizeInfo_t`
    """
    cdef:
        nvmlConfComputeMemSizeInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeMemSizeInfo_t *>calloc(1, sizeof(nvmlConfComputeMemSizeInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeMemSizeInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeMemSizeInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeMemSizeInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeMemSizeInfo other_
        if not isinstance(other, ConfComputeMemSizeInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeMemSizeInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeMemSizeInfo_t *>malloc(sizeof(nvmlConfComputeMemSizeInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeMemSizeInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeMemSizeInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def protected_mem_size_kib(self):
        """int: """
        return self._ptr[0].protectedMemSizeKib

    @protected_mem_size_kib.setter
    def protected_mem_size_kib(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeMemSizeInfo instance is read-only")
        self._ptr[0].protectedMemSizeKib = val

    @property
    def unprotected_mem_size_kib(self):
        """int: """
        return self._ptr[0].unprotectedMemSizeKib

    @unprotected_mem_size_kib.setter
    def unprotected_mem_size_kib(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeMemSizeInfo instance is read-only")
        self._ptr[0].unprotectedMemSizeKib = val

    @staticmethod
    def from_data(data):
        """Create an ConfComputeMemSizeInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_mem_size_info_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_mem_size_info_dtype", conf_compute_mem_size_info_dtype, ConfComputeMemSizeInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeMemSizeInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeMemSizeInfo obj = ConfComputeMemSizeInfo.__new__(ConfComputeMemSizeInfo)
        if owner is None:
            obj._ptr = <nvmlConfComputeMemSizeInfo_t *>malloc(sizeof(nvmlConfComputeMemSizeInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeMemSizeInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeMemSizeInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeMemSizeInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_conf_compute_gpu_certificate_dtype_offsets():
    cdef nvmlConfComputeGpuCertificate_t pod = nvmlConfComputeGpuCertificate_t()
    return _numpy.dtype({
        'names': ['cert_chain_size', 'attestation_cert_chain_size', 'cert_chain', 'attestation_cert_chain'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint8, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.certChainSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.attestationCertChainSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.certChain)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.attestationCertChain)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeGpuCertificate_t),
    })

conf_compute_gpu_certificate_dtype = _get_conf_compute_gpu_certificate_dtype_offsets()

cdef class ConfComputeGpuCertificate:
    """Empty-initialize an instance of `nvmlConfComputeGpuCertificate_t`.


    .. seealso:: `nvmlConfComputeGpuCertificate_t`
    """
    cdef:
        nvmlConfComputeGpuCertificate_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeGpuCertificate_t *>calloc(1, sizeof(nvmlConfComputeGpuCertificate_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeGpuCertificate")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeGpuCertificate_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeGpuCertificate object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeGpuCertificate other_
        if not isinstance(other, ConfComputeGpuCertificate):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeGpuCertificate_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeGpuCertificate_t *>malloc(sizeof(nvmlConfComputeGpuCertificate_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGpuCertificate")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeGpuCertificate_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def cert_chain_size(self):
        """int: """
        return self._ptr[0].certChainSize

    @cert_chain_size.setter
    def cert_chain_size(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuCertificate instance is read-only")
        self._ptr[0].certChainSize = val

    @property
    def attestation_cert_chain_size(self):
        """int: """
        return self._ptr[0].attestationCertChainSize

    @attestation_cert_chain_size.setter
    def attestation_cert_chain_size(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuCertificate instance is read-only")
        self._ptr[0].attestationCertChainSize = val

    @property
    def cert_chain(self):
        """~_numpy.uint8: (array of length 4096)."""
        cdef view.array arr = view.array(shape=(4096,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].certChain))
        return _numpy.asarray(arr)

    @cert_chain.setter
    def cert_chain(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuCertificate instance is read-only")
        cdef view.array arr = view.array(shape=(4096,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].certChain)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def attestation_cert_chain(self):
        """~_numpy.uint8: (array of length 5120)."""
        cdef view.array arr = view.array(shape=(5120,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].attestationCertChain))
        return _numpy.asarray(arr)

    @attestation_cert_chain.setter
    def attestation_cert_chain(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuCertificate instance is read-only")
        cdef view.array arr = view.array(shape=(5120,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].attestationCertChain)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @staticmethod
    def from_data(data):
        """Create an ConfComputeGpuCertificate instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_gpu_certificate_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_gpu_certificate_dtype", conf_compute_gpu_certificate_dtype, ConfComputeGpuCertificate)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeGpuCertificate instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeGpuCertificate obj = ConfComputeGpuCertificate.__new__(ConfComputeGpuCertificate)
        if owner is None:
            obj._ptr = <nvmlConfComputeGpuCertificate_t *>malloc(sizeof(nvmlConfComputeGpuCertificate_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGpuCertificate")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeGpuCertificate_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeGpuCertificate_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_conf_compute_gpu_attestation_report_dtype_offsets():
    cdef nvmlConfComputeGpuAttestationReport_t pod = nvmlConfComputeGpuAttestationReport_t()
    return _numpy.dtype({
        'names': ['is_cec_attestation_report_present', 'attestation_report_size', 'cec_attestation_report_size', 'nonce', 'attestation_report', 'cec_attestation_report'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint8, _numpy.uint8, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.isCecAttestationReportPresent)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.attestationReportSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.cecAttestationReportSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.nonce)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.attestationReport)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.cecAttestationReport)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeGpuAttestationReport_t),
    })

conf_compute_gpu_attestation_report_dtype = _get_conf_compute_gpu_attestation_report_dtype_offsets()

cdef class ConfComputeGpuAttestationReport:
    """Empty-initialize an instance of `nvmlConfComputeGpuAttestationReport_t`.


    .. seealso:: `nvmlConfComputeGpuAttestationReport_t`
    """
    cdef:
        nvmlConfComputeGpuAttestationReport_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeGpuAttestationReport_t *>calloc(1, sizeof(nvmlConfComputeGpuAttestationReport_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeGpuAttestationReport")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeGpuAttestationReport_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeGpuAttestationReport object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeGpuAttestationReport other_
        if not isinstance(other, ConfComputeGpuAttestationReport):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeGpuAttestationReport_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeGpuAttestationReport_t *>malloc(sizeof(nvmlConfComputeGpuAttestationReport_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGpuAttestationReport")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeGpuAttestationReport_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def is_cec_attestation_report_present(self):
        """int: """
        return self._ptr[0].isCecAttestationReportPresent

    @is_cec_attestation_report_present.setter
    def is_cec_attestation_report_present(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        self._ptr[0].isCecAttestationReportPresent = val

    @property
    def attestation_report_size(self):
        """int: """
        return self._ptr[0].attestationReportSize

    @attestation_report_size.setter
    def attestation_report_size(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        self._ptr[0].attestationReportSize = val

    @property
    def cec_attestation_report_size(self):
        """int: """
        return self._ptr[0].cecAttestationReportSize

    @cec_attestation_report_size.setter
    def cec_attestation_report_size(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        self._ptr[0].cecAttestationReportSize = val

    @property
    def nonce(self):
        """~_numpy.uint8: (array of length 32)."""
        cdef view.array arr = view.array(shape=(32,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].nonce))
        return _numpy.asarray(arr)

    @nonce.setter
    def nonce(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        cdef view.array arr = view.array(shape=(32,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].nonce)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def attestation_report(self):
        """~_numpy.uint8: (array of length 8192)."""
        cdef view.array arr = view.array(shape=(8192,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].attestationReport))
        return _numpy.asarray(arr)

    @attestation_report.setter
    def attestation_report(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        cdef view.array arr = view.array(shape=(8192,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].attestationReport)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def cec_attestation_report(self):
        """~_numpy.uint8: (array of length 4096)."""
        cdef view.array arr = view.array(shape=(4096,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].cecAttestationReport))
        return _numpy.asarray(arr)

    @cec_attestation_report.setter
    def cec_attestation_report(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGpuAttestationReport instance is read-only")
        cdef view.array arr = view.array(shape=(4096,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].cecAttestationReport)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @staticmethod
    def from_data(data):
        """Create an ConfComputeGpuAttestationReport instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_gpu_attestation_report_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_gpu_attestation_report_dtype", conf_compute_gpu_attestation_report_dtype, ConfComputeGpuAttestationReport)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeGpuAttestationReport instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeGpuAttestationReport obj = ConfComputeGpuAttestationReport.__new__(ConfComputeGpuAttestationReport)
        if owner is None:
            obj._ptr = <nvmlConfComputeGpuAttestationReport_t *>malloc(sizeof(nvmlConfComputeGpuAttestationReport_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGpuAttestationReport")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeGpuAttestationReport_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeGpuAttestationReport_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_conf_compute_get_key_rotation_threshold_info_v1_dtype_offsets():
    cdef nvmlConfComputeGetKeyRotationThresholdInfo_v1_t pod = nvmlConfComputeGetKeyRotationThresholdInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'attacker_advantage'],
        'formats': [_numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.attackerAdvantage)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t),
    })

conf_compute_get_key_rotation_threshold_info_v1_dtype = _get_conf_compute_get_key_rotation_threshold_info_v1_dtype_offsets()

cdef class ConfComputeGetKeyRotationThresholdInfo_v1:
    """Empty-initialize an instance of `nvmlConfComputeGetKeyRotationThresholdInfo_v1_t`.


    .. seealso:: `nvmlConfComputeGetKeyRotationThresholdInfo_v1_t`
    """
    cdef:
        nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *>calloc(1, sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ConfComputeGetKeyRotationThresholdInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ConfComputeGetKeyRotationThresholdInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ConfComputeGetKeyRotationThresholdInfo_v1 other_
        if not isinstance(other, ConfComputeGetKeyRotationThresholdInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *>malloc(sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGetKeyRotationThresholdInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGetKeyRotationThresholdInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def attacker_advantage(self):
        """int: """
        return self._ptr[0].attackerAdvantage

    @attacker_advantage.setter
    def attacker_advantage(self, val):
        if self._readonly:
            raise ValueError("This ConfComputeGetKeyRotationThresholdInfo_v1 instance is read-only")
        self._ptr[0].attackerAdvantage = val

    @staticmethod
    def from_data(data):
        """Create an ConfComputeGetKeyRotationThresholdInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `conf_compute_get_key_rotation_threshold_info_v1_dtype` holding the data.
        """
        return __from_data(data, "conf_compute_get_key_rotation_threshold_info_v1_dtype", conf_compute_get_key_rotation_threshold_info_v1_dtype, ConfComputeGetKeyRotationThresholdInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ConfComputeGetKeyRotationThresholdInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ConfComputeGetKeyRotationThresholdInfo_v1 obj = ConfComputeGetKeyRotationThresholdInfo_v1.__new__(ConfComputeGetKeyRotationThresholdInfo_v1)
        if owner is None:
            obj._ptr = <nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *>malloc(sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ConfComputeGetKeyRotationThresholdInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlConfComputeGetKeyRotationThresholdInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpu_fabric_info_v2_dtype_offsets():
    cdef nvmlGpuFabricInfo_v2_t pod = nvmlGpuFabricInfo_v2_t()
    return _numpy.dtype({
        'names': ['version', 'cluster_uuid', 'status', 'clique_id', 'state', 'health_mask'],
        'formats': [_numpy.uint32, _numpy.uint8, _numpy.int32, _numpy.uint32, _numpy.uint8, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clusterUuid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.status)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.cliqueId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.state)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.healthMask)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuFabricInfo_v2_t),
    })

gpu_fabric_info_v2_dtype = _get_gpu_fabric_info_v2_dtype_offsets()

cdef class GpuFabricInfo_v2:
    """Empty-initialize an instance of `nvmlGpuFabricInfo_v2_t`.


    .. seealso:: `nvmlGpuFabricInfo_v2_t`
    """
    cdef:
        nvmlGpuFabricInfo_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuFabricInfo_v2_t *>calloc(1, sizeof(nvmlGpuFabricInfo_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuFabricInfo_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuFabricInfo_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuFabricInfo_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuFabricInfo_v2 other_
        if not isinstance(other, GpuFabricInfo_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuFabricInfo_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuFabricInfo_v2_t *>malloc(sizeof(nvmlGpuFabricInfo_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuFabricInfo_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuFabricInfo_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: Structure version identifier (set to nvmlGpuFabricInfo_v2)"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def cluster_uuid(self):
        """~_numpy.uint8: (array of length 16).Uuid of the cluster to which this GPU belongs."""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].clusterUuid))
        return _numpy.asarray(arr)

    @cluster_uuid.setter
    def cluster_uuid(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].clusterUuid)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def status(self):
        """int: Probe Error status, if any. Must be checked only if Probe state returns "complete"."""
        return <int>(self._ptr[0].status)

    @status.setter
    def status(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        self._ptr[0].status = <nvmlReturn_t><int>val

    @property
    def clique_id(self):
        """int: ID of the fabric clique to which this GPU belongs."""
        return self._ptr[0].cliqueId

    @clique_id.setter
    def clique_id(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        self._ptr[0].cliqueId = val

    @property
    def state(self):
        """int: Current Probe State of GPU registration process. See NVML_GPU_FABRIC_STATE_*."""
        return <unsigned char>(self._ptr[0].state)

    @state.setter
    def state(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        self._ptr[0].state = <nvmlGpuFabricState_t><unsigned char>val

    @property
    def health_mask(self):
        """int: GPU Fabric health Status Mask. See NVML_GPU_FABRIC_HEALTH_MASK_*."""
        return self._ptr[0].healthMask

    @health_mask.setter
    def health_mask(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v2 instance is read-only")
        self._ptr[0].healthMask = val

    @staticmethod
    def from_data(data):
        """Create an GpuFabricInfo_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_fabric_info_v2_dtype` holding the data.
        """
        return __from_data(data, "gpu_fabric_info_v2_dtype", gpu_fabric_info_v2_dtype, GpuFabricInfo_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuFabricInfo_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuFabricInfo_v2 obj = GpuFabricInfo_v2.__new__(GpuFabricInfo_v2)
        if owner is None:
            obj._ptr = <nvmlGpuFabricInfo_v2_t *>malloc(sizeof(nvmlGpuFabricInfo_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuFabricInfo_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuFabricInfo_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuFabricInfo_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nvlink_supported_bw_modes_v1_dtype_offsets():
    cdef nvmlNvlinkSupportedBwModes_v1_t pod = nvmlNvlinkSupportedBwModes_v1_t()
    return _numpy.dtype({
        'names': ['version', 'bw_modes', 'total_bw_modes'],
        'formats': [_numpy.uint32, _numpy.uint8, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bwModes)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.totalBwModes)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvlinkSupportedBwModes_v1_t),
    })

nvlink_supported_bw_modes_v1_dtype = _get_nvlink_supported_bw_modes_v1_dtype_offsets()

cdef class NvlinkSupportedBwModes_v1:
    """Empty-initialize an instance of `nvmlNvlinkSupportedBwModes_v1_t`.


    .. seealso:: `nvmlNvlinkSupportedBwModes_v1_t`
    """
    cdef:
        nvmlNvlinkSupportedBwModes_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvlinkSupportedBwModes_v1_t *>calloc(1, sizeof(nvmlNvlinkSupportedBwModes_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvlinkSupportedBwModes_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvlinkSupportedBwModes_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvlinkSupportedBwModes_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvlinkSupportedBwModes_v1 other_
        if not isinstance(other, NvlinkSupportedBwModes_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvlinkSupportedBwModes_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvlinkSupportedBwModes_v1_t *>malloc(sizeof(nvmlNvlinkSupportedBwModes_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvlinkSupportedBwModes_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvlinkSupportedBwModes_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSupportedBwModes_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def bw_modes(self):
        """~_numpy.uint8: (array of length 23)."""
        cdef view.array arr = view.array(shape=(23,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].bwModes))
        return _numpy.asarray(arr)

    @bw_modes.setter
    def bw_modes(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSupportedBwModes_v1 instance is read-only")
        cdef view.array arr = view.array(shape=(23,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].bwModes)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def total_bw_modes(self):
        """int: """
        return self._ptr[0].totalBwModes

    @total_bw_modes.setter
    def total_bw_modes(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSupportedBwModes_v1 instance is read-only")
        self._ptr[0].totalBwModes = val

    @staticmethod
    def from_data(data):
        """Create an NvlinkSupportedBwModes_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nvlink_supported_bw_modes_v1_dtype` holding the data.
        """
        return __from_data(data, "nvlink_supported_bw_modes_v1_dtype", nvlink_supported_bw_modes_v1_dtype, NvlinkSupportedBwModes_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvlinkSupportedBwModes_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvlinkSupportedBwModes_v1 obj = NvlinkSupportedBwModes_v1.__new__(NvlinkSupportedBwModes_v1)
        if owner is None:
            obj._ptr = <nvmlNvlinkSupportedBwModes_v1_t *>malloc(sizeof(nvmlNvlinkSupportedBwModes_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvlinkSupportedBwModes_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvlinkSupportedBwModes_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvlinkSupportedBwModes_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nvlink_get_bw_mode_v1_dtype_offsets():
    cdef nvmlNvlinkGetBwMode_v1_t pod = nvmlNvlinkGetBwMode_v1_t()
    return _numpy.dtype({
        'names': ['version', 'b_is_best', 'bw_mode'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bIsBest)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bwMode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvlinkGetBwMode_v1_t),
    })

nvlink_get_bw_mode_v1_dtype = _get_nvlink_get_bw_mode_v1_dtype_offsets()

cdef class NvlinkGetBwMode_v1:
    """Empty-initialize an instance of `nvmlNvlinkGetBwMode_v1_t`.


    .. seealso:: `nvmlNvlinkGetBwMode_v1_t`
    """
    cdef:
        nvmlNvlinkGetBwMode_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvlinkGetBwMode_v1_t *>calloc(1, sizeof(nvmlNvlinkGetBwMode_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvlinkGetBwMode_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvlinkGetBwMode_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvlinkGetBwMode_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvlinkGetBwMode_v1 other_
        if not isinstance(other, NvlinkGetBwMode_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvlinkGetBwMode_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvlinkGetBwMode_v1_t *>malloc(sizeof(nvmlNvlinkGetBwMode_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvlinkGetBwMode_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvlinkGetBwMode_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This NvlinkGetBwMode_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def b_is_best(self):
        """int: """
        return self._ptr[0].bIsBest

    @b_is_best.setter
    def b_is_best(self, val):
        if self._readonly:
            raise ValueError("This NvlinkGetBwMode_v1 instance is read-only")
        self._ptr[0].bIsBest = val

    @property
    def bw_mode(self):
        """int: """
        return self._ptr[0].bwMode

    @bw_mode.setter
    def bw_mode(self, val):
        if self._readonly:
            raise ValueError("This NvlinkGetBwMode_v1 instance is read-only")
        self._ptr[0].bwMode = val

    @staticmethod
    def from_data(data):
        """Create an NvlinkGetBwMode_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nvlink_get_bw_mode_v1_dtype` holding the data.
        """
        return __from_data(data, "nvlink_get_bw_mode_v1_dtype", nvlink_get_bw_mode_v1_dtype, NvlinkGetBwMode_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvlinkGetBwMode_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvlinkGetBwMode_v1 obj = NvlinkGetBwMode_v1.__new__(NvlinkGetBwMode_v1)
        if owner is None:
            obj._ptr = <nvmlNvlinkGetBwMode_v1_t *>malloc(sizeof(nvmlNvlinkGetBwMode_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvlinkGetBwMode_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvlinkGetBwMode_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvlinkGetBwMode_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nvlink_set_bw_mode_v1_dtype_offsets():
    cdef nvmlNvlinkSetBwMode_v1_t pod = nvmlNvlinkSetBwMode_v1_t()
    return _numpy.dtype({
        'names': ['version', 'b_set_best', 'bw_mode'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bSetBest)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bwMode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvlinkSetBwMode_v1_t),
    })

nvlink_set_bw_mode_v1_dtype = _get_nvlink_set_bw_mode_v1_dtype_offsets()

cdef class NvlinkSetBwMode_v1:
    """Empty-initialize an instance of `nvmlNvlinkSetBwMode_v1_t`.


    .. seealso:: `nvmlNvlinkSetBwMode_v1_t`
    """
    cdef:
        nvmlNvlinkSetBwMode_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvlinkSetBwMode_v1_t *>calloc(1, sizeof(nvmlNvlinkSetBwMode_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvlinkSetBwMode_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvlinkSetBwMode_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvlinkSetBwMode_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvlinkSetBwMode_v1 other_
        if not isinstance(other, NvlinkSetBwMode_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvlinkSetBwMode_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvlinkSetBwMode_v1_t *>malloc(sizeof(nvmlNvlinkSetBwMode_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvlinkSetBwMode_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvlinkSetBwMode_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSetBwMode_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def b_set_best(self):
        """int: """
        return self._ptr[0].bSetBest

    @b_set_best.setter
    def b_set_best(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSetBwMode_v1 instance is read-only")
        self._ptr[0].bSetBest = val

    @property
    def bw_mode(self):
        """int: """
        return self._ptr[0].bwMode

    @bw_mode.setter
    def bw_mode(self, val):
        if self._readonly:
            raise ValueError("This NvlinkSetBwMode_v1 instance is read-only")
        self._ptr[0].bwMode = val

    @staticmethod
    def from_data(data):
        """Create an NvlinkSetBwMode_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nvlink_set_bw_mode_v1_dtype` holding the data.
        """
        return __from_data(data, "nvlink_set_bw_mode_v1_dtype", nvlink_set_bw_mode_v1_dtype, NvlinkSetBwMode_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvlinkSetBwMode_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvlinkSetBwMode_v1 obj = NvlinkSetBwMode_v1.__new__(NvlinkSetBwMode_v1)
        if owner is None:
            obj._ptr = <nvmlNvlinkSetBwMode_v1_t *>malloc(sizeof(nvmlNvlinkSetBwMode_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvlinkSetBwMode_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvlinkSetBwMode_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvlinkSetBwMode_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_version_dtype_offsets():
    cdef nvmlVgpuVersion_t pod = nvmlVgpuVersion_t()
    return _numpy.dtype({
        'names': ['min_version', 'max_version'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.minVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.maxVersion)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuVersion_t),
    })

vgpu_version_dtype = _get_vgpu_version_dtype_offsets()

cdef class VgpuVersion:
    """Empty-initialize an instance of `nvmlVgpuVersion_t`.


    .. seealso:: `nvmlVgpuVersion_t`
    """
    cdef:
        nvmlVgpuVersion_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuVersion_t *>calloc(1, sizeof(nvmlVgpuVersion_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuVersion")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuVersion_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuVersion object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuVersion other_
        if not isinstance(other, VgpuVersion):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuVersion_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuVersion_t *>malloc(sizeof(nvmlVgpuVersion_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuVersion")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuVersion_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def min_version(self):
        """int: """
        return self._ptr[0].minVersion

    @min_version.setter
    def min_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuVersion instance is read-only")
        self._ptr[0].minVersion = val

    @property
    def max_version(self):
        """int: """
        return self._ptr[0].maxVersion

    @max_version.setter
    def max_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuVersion instance is read-only")
        self._ptr[0].maxVersion = val

    @staticmethod
    def from_data(data):
        """Create an VgpuVersion instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_version_dtype` holding the data.
        """
        return __from_data(data, "vgpu_version_dtype", vgpu_version_dtype, VgpuVersion)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuVersion instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuVersion obj = VgpuVersion.__new__(VgpuVersion)
        if owner is None:
            obj._ptr = <nvmlVgpuVersion_t *>malloc(sizeof(nvmlVgpuVersion_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuVersion")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuVersion_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuVersion_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_metadata_dtype_offsets():
    cdef nvmlVgpuMetadata_t pod = nvmlVgpuMetadata_t()
    return _numpy.dtype({
        'names': ['version', 'revision', 'guest_info_state', 'guest_driver_version', 'host_driver_version', 'reserved', 'vgpu_virtualization_caps', 'guest_vgpu_version', 'opaque_data_size', 'opaque_data'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.int32, _numpy.int8, _numpy.int8, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.revision)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.guestInfoState)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.guestDriverVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hostDriverVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.reserved)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuVirtualizationCaps)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.guestVgpuVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.opaqueDataSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.opaqueData)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuMetadata_t),
    })

vgpu_metadata_dtype = _get_vgpu_metadata_dtype_offsets()

cdef class VgpuMetadata:
    """Empty-initialize an instance of `nvmlVgpuMetadata_t`.


    .. seealso:: `nvmlVgpuMetadata_t`
    """
    cdef:
        nvmlVgpuMetadata_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuMetadata_t *>calloc(1, sizeof(nvmlVgpuMetadata_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuMetadata")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuMetadata_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuMetadata object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuMetadata other_
        if not isinstance(other, VgpuMetadata):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuMetadata_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuMetadata_t *>malloc(sizeof(nvmlVgpuMetadata_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuMetadata")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuMetadata_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].version = val

    @property
    def revision(self):
        """int: """
        return self._ptr[0].revision

    @revision.setter
    def revision(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].revision = val

    @property
    def guest_info_state(self):
        """int: """
        return <int>(self._ptr[0].guestInfoState)

    @guest_info_state.setter
    def guest_info_state(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].guestInfoState = <nvmlVgpuGuestInfoState_t><int>val

    @property
    def guest_driver_version(self):
        """~_numpy.int8: (array of length 80)."""
        return cpython.PyUnicode_FromString(self._ptr[0].guestDriverVersion)

    @guest_driver_version.setter
    def guest_driver_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 80:
            raise ValueError("String too long for field guest_driver_version, max length is 79")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].guestDriverVersion), <void *>ptr, 80)

    @property
    def host_driver_version(self):
        """~_numpy.int8: (array of length 80)."""
        return cpython.PyUnicode_FromString(self._ptr[0].hostDriverVersion)

    @host_driver_version.setter
    def host_driver_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 80:
            raise ValueError("String too long for field host_driver_version, max length is 79")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].hostDriverVersion), <void *>ptr, 80)

    @property
    def vgpu_virtualization_caps(self):
        """int: """
        return self._ptr[0].vgpuVirtualizationCaps

    @vgpu_virtualization_caps.setter
    def vgpu_virtualization_caps(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].vgpuVirtualizationCaps = val

    @property
    def guest_vgpu_version(self):
        """int: """
        return self._ptr[0].guestVgpuVersion

    @guest_vgpu_version.setter
    def guest_vgpu_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].guestVgpuVersion = val

    @property
    def opaque_data_size(self):
        """int: """
        return self._ptr[0].opaqueDataSize

    @opaque_data_size.setter
    def opaque_data_size(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        self._ptr[0].opaqueDataSize = val

    @property
    def opaque_data(self):
        """~_numpy.int8: (array of length 4)."""
        return cpython.PyUnicode_FromString(self._ptr[0].opaqueData)

    @opaque_data.setter
    def opaque_data(self, val):
        if self._readonly:
            raise ValueError("This VgpuMetadata instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 4:
            raise ValueError("String too long for field opaque_data, max length is 3")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].opaqueData), <void *>ptr, 4)

    @staticmethod
    def from_data(data):
        """Create an VgpuMetadata instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_metadata_dtype` holding the data.
        """
        return __from_data(data, "vgpu_metadata_dtype", vgpu_metadata_dtype, VgpuMetadata)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuMetadata instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuMetadata obj = VgpuMetadata.__new__(VgpuMetadata)
        if owner is None:
            obj._ptr = <nvmlVgpuMetadata_t *>malloc(sizeof(nvmlVgpuMetadata_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuMetadata")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuMetadata_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuMetadata_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_pgpu_compatibility_dtype_offsets():
    cdef nvmlVgpuPgpuCompatibility_t pod = nvmlVgpuPgpuCompatibility_t()
    return _numpy.dtype({
        'names': ['vgpu_vm_compatibility', 'compatibility_limit_code'],
        'formats': [_numpy.int32, _numpy.int32],
        'offsets': [
            (<intptr_t>&(pod.vgpuVmCompatibility)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.compatibilityLimitCode)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuPgpuCompatibility_t),
    })

vgpu_pgpu_compatibility_dtype = _get_vgpu_pgpu_compatibility_dtype_offsets()

cdef class VgpuPgpuCompatibility:
    """Empty-initialize an instance of `nvmlVgpuPgpuCompatibility_t`.


    .. seealso:: `nvmlVgpuPgpuCompatibility_t`
    """
    cdef:
        nvmlVgpuPgpuCompatibility_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuPgpuCompatibility_t *>calloc(1, sizeof(nvmlVgpuPgpuCompatibility_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuPgpuCompatibility")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuPgpuCompatibility_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuPgpuCompatibility object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuPgpuCompatibility other_
        if not isinstance(other, VgpuPgpuCompatibility):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuPgpuCompatibility_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuPgpuCompatibility_t *>malloc(sizeof(nvmlVgpuPgpuCompatibility_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuPgpuCompatibility")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuPgpuCompatibility_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def vgpu_vm_compatibility(self):
        """int: """
        return <int>(self._ptr[0].vgpuVmCompatibility)

    @vgpu_vm_compatibility.setter
    def vgpu_vm_compatibility(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuCompatibility instance is read-only")
        self._ptr[0].vgpuVmCompatibility = <nvmlVgpuVmCompatibility_t><int>val

    @property
    def compatibility_limit_code(self):
        """int: """
        return <int>(self._ptr[0].compatibilityLimitCode)

    @compatibility_limit_code.setter
    def compatibility_limit_code(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuCompatibility instance is read-only")
        self._ptr[0].compatibilityLimitCode = <nvmlVgpuPgpuCompatibilityLimitCode_t><int>val

    @staticmethod
    def from_data(data):
        """Create an VgpuPgpuCompatibility instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_pgpu_compatibility_dtype` holding the data.
        """
        return __from_data(data, "vgpu_pgpu_compatibility_dtype", vgpu_pgpu_compatibility_dtype, VgpuPgpuCompatibility)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuPgpuCompatibility instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuPgpuCompatibility obj = VgpuPgpuCompatibility.__new__(VgpuPgpuCompatibility)
        if owner is None:
            obj._ptr = <nvmlVgpuPgpuCompatibility_t *>malloc(sizeof(nvmlVgpuPgpuCompatibility_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuPgpuCompatibility")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuPgpuCompatibility_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuPgpuCompatibility_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpu_instance_placement_dtype_offsets():
    cdef nvmlGpuInstancePlacement_t pod = nvmlGpuInstancePlacement_t()
    return _numpy.dtype({
        'names': ['start', 'size_'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.start)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.size)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuInstancePlacement_t),
    })

gpu_instance_placement_dtype = _get_gpu_instance_placement_dtype_offsets()

cdef class GpuInstancePlacement:
    """Empty-initialize an array of `nvmlGpuInstancePlacement_t`.

    The resulting object is of length `size` and of dtype `gpu_instance_placement_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlGpuInstancePlacement_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=gpu_instance_placement_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlGpuInstancePlacement_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlGpuInstancePlacement_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.GpuInstancePlacement_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.GpuInstancePlacement object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, GpuInstancePlacement)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def start(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.start[0])
        return self._data.start

    @start.setter
    def start(self, val):
        self._data.start = val

    @property
    def size_(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.size_[0])
        return self._data.size_

    @size_.setter
    def size_(self, val):
        self._data.size_ = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return GpuInstancePlacement.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == gpu_instance_placement_dtype:
            return GpuInstancePlacement.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an GpuInstancePlacement instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `gpu_instance_placement_dtype` holding the data.
        """
        cdef GpuInstancePlacement obj = GpuInstancePlacement.__new__(GpuInstancePlacement)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != gpu_instance_placement_dtype:
            raise ValueError("data array must be of dtype gpu_instance_placement_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an GpuInstancePlacement instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuInstancePlacement obj = GpuInstancePlacement.__new__(GpuInstancePlacement)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlGpuInstancePlacement_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=gpu_instance_placement_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_gpu_instance_profile_info_v2_dtype_offsets():
    cdef nvmlGpuInstanceProfileInfo_v2_t pod = nvmlGpuInstanceProfileInfo_v2_t()
    return _numpy.dtype({
        'names': ['version', 'id', 'is_p2p_supported', 'slice_count', 'instance_count', 'multiprocessor_count', 'copy_engine_count', 'decoder_count', 'encoder_count', 'jpeg_count', 'ofa_count', 'memory_size_mb', 'name'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint64, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isP2pSupported)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.instanceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.multiprocessorCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.copyEngineCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.jpegCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ofaCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memorySizeMB)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.name)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuInstanceProfileInfo_v2_t),
    })

gpu_instance_profile_info_v2_dtype = _get_gpu_instance_profile_info_v2_dtype_offsets()

cdef class GpuInstanceProfileInfo_v2:
    """Empty-initialize an instance of `nvmlGpuInstanceProfileInfo_v2_t`.


    .. seealso:: `nvmlGpuInstanceProfileInfo_v2_t`
    """
    cdef:
        nvmlGpuInstanceProfileInfo_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuInstanceProfileInfo_v2_t *>calloc(1, sizeof(nvmlGpuInstanceProfileInfo_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuInstanceProfileInfo_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuInstanceProfileInfo_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuInstanceProfileInfo_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuInstanceProfileInfo_v2 other_
        if not isinstance(other, GpuInstanceProfileInfo_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuInstanceProfileInfo_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuInstanceProfileInfo_v2_t *>malloc(sizeof(nvmlGpuInstanceProfileInfo_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceProfileInfo_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuInstanceProfileInfo_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].id = val

    @property
    def is_p2p_supported(self):
        """int: """
        return self._ptr[0].isP2pSupported

    @is_p2p_supported.setter
    def is_p2p_supported(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].isP2pSupported = val

    @property
    def slice_count(self):
        """int: """
        return self._ptr[0].sliceCount

    @slice_count.setter
    def slice_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sliceCount = val

    @property
    def instance_count(self):
        """int: """
        return self._ptr[0].instanceCount

    @instance_count.setter
    def instance_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].instanceCount = val

    @property
    def multiprocessor_count(self):
        """int: """
        return self._ptr[0].multiprocessorCount

    @multiprocessor_count.setter
    def multiprocessor_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].multiprocessorCount = val

    @property
    def copy_engine_count(self):
        """int: """
        return self._ptr[0].copyEngineCount

    @copy_engine_count.setter
    def copy_engine_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].copyEngineCount = val

    @property
    def decoder_count(self):
        """int: """
        return self._ptr[0].decoderCount

    @decoder_count.setter
    def decoder_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].decoderCount = val

    @property
    def encoder_count(self):
        """int: """
        return self._ptr[0].encoderCount

    @encoder_count.setter
    def encoder_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].encoderCount = val

    @property
    def jpeg_count(self):
        """int: """
        return self._ptr[0].jpegCount

    @jpeg_count.setter
    def jpeg_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].jpegCount = val

    @property
    def ofa_count(self):
        """int: """
        return self._ptr[0].ofaCount

    @ofa_count.setter
    def ofa_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].ofaCount = val

    @property
    def memory_size_mb(self):
        """int: """
        return self._ptr[0].memorySizeMB

    @memory_size_mb.setter
    def memory_size_mb(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].memorySizeMB = val

    @property
    def name(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].name)

    @name.setter
    def name(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v2 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field name, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].name), <void *>ptr, 96)

    @staticmethod
    def from_data(data):
        """Create an GpuInstanceProfileInfo_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_instance_profile_info_v2_dtype` holding the data.
        """
        return __from_data(data, "gpu_instance_profile_info_v2_dtype", gpu_instance_profile_info_v2_dtype, GpuInstanceProfileInfo_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuInstanceProfileInfo_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuInstanceProfileInfo_v2 obj = GpuInstanceProfileInfo_v2.__new__(GpuInstanceProfileInfo_v2)
        if owner is None:
            obj._ptr = <nvmlGpuInstanceProfileInfo_v2_t *>malloc(sizeof(nvmlGpuInstanceProfileInfo_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceProfileInfo_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuInstanceProfileInfo_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuInstanceProfileInfo_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpu_instance_profile_info_v3_dtype_offsets():
    cdef nvmlGpuInstanceProfileInfo_v3_t pod = nvmlGpuInstanceProfileInfo_v3_t()
    return _numpy.dtype({
        'names': ['version', 'id', 'slice_count', 'instance_count', 'multiprocessor_count', 'copy_engine_count', 'decoder_count', 'encoder_count', 'jpeg_count', 'ofa_count', 'memory_size_mb', 'name', 'capabilities'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint64, _numpy.int8, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.instanceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.multiprocessorCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.copyEngineCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.jpegCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ofaCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memorySizeMB)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.name)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.capabilities)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuInstanceProfileInfo_v3_t),
    })

gpu_instance_profile_info_v3_dtype = _get_gpu_instance_profile_info_v3_dtype_offsets()

cdef class GpuInstanceProfileInfo_v3:
    """Empty-initialize an instance of `nvmlGpuInstanceProfileInfo_v3_t`.


    .. seealso:: `nvmlGpuInstanceProfileInfo_v3_t`
    """
    cdef:
        nvmlGpuInstanceProfileInfo_v3_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuInstanceProfileInfo_v3_t *>calloc(1, sizeof(nvmlGpuInstanceProfileInfo_v3_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuInstanceProfileInfo_v3")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuInstanceProfileInfo_v3_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuInstanceProfileInfo_v3 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuInstanceProfileInfo_v3 other_
        if not isinstance(other, GpuInstanceProfileInfo_v3):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuInstanceProfileInfo_v3_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuInstanceProfileInfo_v3_t *>malloc(sizeof(nvmlGpuInstanceProfileInfo_v3_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceProfileInfo_v3")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuInstanceProfileInfo_v3_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].version = val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].id = val

    @property
    def slice_count(self):
        """int: """
        return self._ptr[0].sliceCount

    @slice_count.setter
    def slice_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sliceCount = val

    @property
    def instance_count(self):
        """int: """
        return self._ptr[0].instanceCount

    @instance_count.setter
    def instance_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].instanceCount = val

    @property
    def multiprocessor_count(self):
        """int: """
        return self._ptr[0].multiprocessorCount

    @multiprocessor_count.setter
    def multiprocessor_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].multiprocessorCount = val

    @property
    def copy_engine_count(self):
        """int: """
        return self._ptr[0].copyEngineCount

    @copy_engine_count.setter
    def copy_engine_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].copyEngineCount = val

    @property
    def decoder_count(self):
        """int: """
        return self._ptr[0].decoderCount

    @decoder_count.setter
    def decoder_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].decoderCount = val

    @property
    def encoder_count(self):
        """int: """
        return self._ptr[0].encoderCount

    @encoder_count.setter
    def encoder_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].encoderCount = val

    @property
    def jpeg_count(self):
        """int: """
        return self._ptr[0].jpegCount

    @jpeg_count.setter
    def jpeg_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].jpegCount = val

    @property
    def ofa_count(self):
        """int: """
        return self._ptr[0].ofaCount

    @ofa_count.setter
    def ofa_count(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].ofaCount = val

    @property
    def memory_size_mb(self):
        """int: """
        return self._ptr[0].memorySizeMB

    @memory_size_mb.setter
    def memory_size_mb(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].memorySizeMB = val

    @property
    def name(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].name)

    @name.setter
    def name(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field name, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].name), <void *>ptr, 96)

    @property
    def capabilities(self):
        """int: """
        return self._ptr[0].capabilities

    @capabilities.setter
    def capabilities(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].capabilities = val

    @staticmethod
    def from_data(data):
        """Create an GpuInstanceProfileInfo_v3 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_instance_profile_info_v3_dtype` holding the data.
        """
        return __from_data(data, "gpu_instance_profile_info_v3_dtype", gpu_instance_profile_info_v3_dtype, GpuInstanceProfileInfo_v3)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuInstanceProfileInfo_v3 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuInstanceProfileInfo_v3 obj = GpuInstanceProfileInfo_v3.__new__(GpuInstanceProfileInfo_v3)
        if owner is None:
            obj._ptr = <nvmlGpuInstanceProfileInfo_v3_t *>malloc(sizeof(nvmlGpuInstanceProfileInfo_v3_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceProfileInfo_v3")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuInstanceProfileInfo_v3_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuInstanceProfileInfo_v3_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_compute_instance_placement_dtype_offsets():
    cdef nvmlComputeInstancePlacement_t pod = nvmlComputeInstancePlacement_t()
    return _numpy.dtype({
        'names': ['start', 'size_'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.start)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.size)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlComputeInstancePlacement_t),
    })

compute_instance_placement_dtype = _get_compute_instance_placement_dtype_offsets()

cdef class ComputeInstancePlacement:
    """Empty-initialize an array of `nvmlComputeInstancePlacement_t`.

    The resulting object is of length `size` and of dtype `compute_instance_placement_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlComputeInstancePlacement_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=compute_instance_placement_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlComputeInstancePlacement_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlComputeInstancePlacement_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.ComputeInstancePlacement_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.ComputeInstancePlacement object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, ComputeInstancePlacement)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def start(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.start[0])
        return self._data.start

    @start.setter
    def start(self, val):
        self._data.start = val

    @property
    def size_(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.size_[0])
        return self._data.size_

    @size_.setter
    def size_(self, val):
        self._data.size_ = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return ComputeInstancePlacement.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == compute_instance_placement_dtype:
            return ComputeInstancePlacement.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an ComputeInstancePlacement instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `compute_instance_placement_dtype` holding the data.
        """
        cdef ComputeInstancePlacement obj = ComputeInstancePlacement.__new__(ComputeInstancePlacement)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != compute_instance_placement_dtype:
            raise ValueError("data array must be of dtype compute_instance_placement_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an ComputeInstancePlacement instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ComputeInstancePlacement obj = ComputeInstancePlacement.__new__(ComputeInstancePlacement)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlComputeInstancePlacement_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=compute_instance_placement_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_compute_instance_profile_info_v2_dtype_offsets():
    cdef nvmlComputeInstanceProfileInfo_v2_t pod = nvmlComputeInstanceProfileInfo_v2_t()
    return _numpy.dtype({
        'names': ['version', 'id', 'slice_count', 'instance_count', 'multiprocessor_count', 'shared_copy_engine_count', 'shared_decoder_count', 'shared_encoder_count', 'shared_jpeg_count', 'shared_ofa_count', 'name'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.instanceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.multiprocessorCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedCopyEngineCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedDecoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedEncoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedJpegCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedOfaCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.name)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlComputeInstanceProfileInfo_v2_t),
    })

compute_instance_profile_info_v2_dtype = _get_compute_instance_profile_info_v2_dtype_offsets()

cdef class ComputeInstanceProfileInfo_v2:
    """Empty-initialize an instance of `nvmlComputeInstanceProfileInfo_v2_t`.


    .. seealso:: `nvmlComputeInstanceProfileInfo_v2_t`
    """
    cdef:
        nvmlComputeInstanceProfileInfo_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlComputeInstanceProfileInfo_v2_t *>calloc(1, sizeof(nvmlComputeInstanceProfileInfo_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ComputeInstanceProfileInfo_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlComputeInstanceProfileInfo_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ComputeInstanceProfileInfo_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ComputeInstanceProfileInfo_v2 other_
        if not isinstance(other, ComputeInstanceProfileInfo_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlComputeInstanceProfileInfo_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlComputeInstanceProfileInfo_v2_t *>malloc(sizeof(nvmlComputeInstanceProfileInfo_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceProfileInfo_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlComputeInstanceProfileInfo_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].id = val

    @property
    def slice_count(self):
        """int: """
        return self._ptr[0].sliceCount

    @slice_count.setter
    def slice_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sliceCount = val

    @property
    def instance_count(self):
        """int: """
        return self._ptr[0].instanceCount

    @instance_count.setter
    def instance_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].instanceCount = val

    @property
    def multiprocessor_count(self):
        """int: """
        return self._ptr[0].multiprocessorCount

    @multiprocessor_count.setter
    def multiprocessor_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].multiprocessorCount = val

    @property
    def shared_copy_engine_count(self):
        """int: """
        return self._ptr[0].sharedCopyEngineCount

    @shared_copy_engine_count.setter
    def shared_copy_engine_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sharedCopyEngineCount = val

    @property
    def shared_decoder_count(self):
        """int: """
        return self._ptr[0].sharedDecoderCount

    @shared_decoder_count.setter
    def shared_decoder_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sharedDecoderCount = val

    @property
    def shared_encoder_count(self):
        """int: """
        return self._ptr[0].sharedEncoderCount

    @shared_encoder_count.setter
    def shared_encoder_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sharedEncoderCount = val

    @property
    def shared_jpeg_count(self):
        """int: """
        return self._ptr[0].sharedJpegCount

    @shared_jpeg_count.setter
    def shared_jpeg_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sharedJpegCount = val

    @property
    def shared_ofa_count(self):
        """int: """
        return self._ptr[0].sharedOfaCount

    @shared_ofa_count.setter
    def shared_ofa_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        self._ptr[0].sharedOfaCount = val

    @property
    def name(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].name)

    @name.setter
    def name(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v2 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field name, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].name), <void *>ptr, 96)

    @staticmethod
    def from_data(data):
        """Create an ComputeInstanceProfileInfo_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `compute_instance_profile_info_v2_dtype` holding the data.
        """
        return __from_data(data, "compute_instance_profile_info_v2_dtype", compute_instance_profile_info_v2_dtype, ComputeInstanceProfileInfo_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ComputeInstanceProfileInfo_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ComputeInstanceProfileInfo_v2 obj = ComputeInstanceProfileInfo_v2.__new__(ComputeInstanceProfileInfo_v2)
        if owner is None:
            obj._ptr = <nvmlComputeInstanceProfileInfo_v2_t *>malloc(sizeof(nvmlComputeInstanceProfileInfo_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceProfileInfo_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlComputeInstanceProfileInfo_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlComputeInstanceProfileInfo_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_compute_instance_profile_info_v3_dtype_offsets():
    cdef nvmlComputeInstanceProfileInfo_v3_t pod = nvmlComputeInstanceProfileInfo_v3_t()
    return _numpy.dtype({
        'names': ['version', 'id', 'slice_count', 'instance_count', 'multiprocessor_count', 'shared_copy_engine_count', 'shared_decoder_count', 'shared_encoder_count', 'shared_jpeg_count', 'shared_ofa_count', 'name', 'capabilities'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.int8, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sliceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.instanceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.multiprocessorCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedCopyEngineCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedDecoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedEncoderCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedJpegCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sharedOfaCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.name)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.capabilities)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlComputeInstanceProfileInfo_v3_t),
    })

compute_instance_profile_info_v3_dtype = _get_compute_instance_profile_info_v3_dtype_offsets()

cdef class ComputeInstanceProfileInfo_v3:
    """Empty-initialize an instance of `nvmlComputeInstanceProfileInfo_v3_t`.


    .. seealso:: `nvmlComputeInstanceProfileInfo_v3_t`
    """
    cdef:
        nvmlComputeInstanceProfileInfo_v3_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlComputeInstanceProfileInfo_v3_t *>calloc(1, sizeof(nvmlComputeInstanceProfileInfo_v3_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ComputeInstanceProfileInfo_v3")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlComputeInstanceProfileInfo_v3_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ComputeInstanceProfileInfo_v3 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ComputeInstanceProfileInfo_v3 other_
        if not isinstance(other, ComputeInstanceProfileInfo_v3):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlComputeInstanceProfileInfo_v3_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlComputeInstanceProfileInfo_v3_t *>malloc(sizeof(nvmlComputeInstanceProfileInfo_v3_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceProfileInfo_v3")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlComputeInstanceProfileInfo_v3_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].version = val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].id = val

    @property
    def slice_count(self):
        """int: """
        return self._ptr[0].sliceCount

    @slice_count.setter
    def slice_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sliceCount = val

    @property
    def instance_count(self):
        """int: """
        return self._ptr[0].instanceCount

    @instance_count.setter
    def instance_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].instanceCount = val

    @property
    def multiprocessor_count(self):
        """int: """
        return self._ptr[0].multiprocessorCount

    @multiprocessor_count.setter
    def multiprocessor_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].multiprocessorCount = val

    @property
    def shared_copy_engine_count(self):
        """int: """
        return self._ptr[0].sharedCopyEngineCount

    @shared_copy_engine_count.setter
    def shared_copy_engine_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sharedCopyEngineCount = val

    @property
    def shared_decoder_count(self):
        """int: """
        return self._ptr[0].sharedDecoderCount

    @shared_decoder_count.setter
    def shared_decoder_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sharedDecoderCount = val

    @property
    def shared_encoder_count(self):
        """int: """
        return self._ptr[0].sharedEncoderCount

    @shared_encoder_count.setter
    def shared_encoder_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sharedEncoderCount = val

    @property
    def shared_jpeg_count(self):
        """int: """
        return self._ptr[0].sharedJpegCount

    @shared_jpeg_count.setter
    def shared_jpeg_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sharedJpegCount = val

    @property
    def shared_ofa_count(self):
        """int: """
        return self._ptr[0].sharedOfaCount

    @shared_ofa_count.setter
    def shared_ofa_count(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].sharedOfaCount = val

    @property
    def name(self):
        """~_numpy.int8: (array of length 96)."""
        return cpython.PyUnicode_FromString(self._ptr[0].name)

    @name.setter
    def name(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 96:
            raise ValueError("String too long for field name, max length is 95")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].name), <void *>ptr, 96)

    @property
    def capabilities(self):
        """int: """
        return self._ptr[0].capabilities

    @capabilities.setter
    def capabilities(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceProfileInfo_v3 instance is read-only")
        self._ptr[0].capabilities = val

    @staticmethod
    def from_data(data):
        """Create an ComputeInstanceProfileInfo_v3 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `compute_instance_profile_info_v3_dtype` holding the data.
        """
        return __from_data(data, "compute_instance_profile_info_v3_dtype", compute_instance_profile_info_v3_dtype, ComputeInstanceProfileInfo_v3)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ComputeInstanceProfileInfo_v3 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ComputeInstanceProfileInfo_v3 obj = ComputeInstanceProfileInfo_v3.__new__(ComputeInstanceProfileInfo_v3)
        if owner is None:
            obj._ptr = <nvmlComputeInstanceProfileInfo_v3_t *>malloc(sizeof(nvmlComputeInstanceProfileInfo_v3_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceProfileInfo_v3")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlComputeInstanceProfileInfo_v3_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlComputeInstanceProfileInfo_v3_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpm_support_dtype_offsets():
    cdef nvmlGpmSupport_t pod = nvmlGpmSupport_t()
    return _numpy.dtype({
        'names': ['version', 'is_supported_device'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isSupportedDevice)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpmSupport_t),
    })

gpm_support_dtype = _get_gpm_support_dtype_offsets()

cdef class GpmSupport:
    """Empty-initialize an instance of `nvmlGpmSupport_t`.


    .. seealso:: `nvmlGpmSupport_t`
    """
    cdef:
        nvmlGpmSupport_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpmSupport_t *>calloc(1, sizeof(nvmlGpmSupport_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpmSupport")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpmSupport_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpmSupport object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpmSupport other_
        if not isinstance(other, GpmSupport):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpmSupport_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpmSupport_t *>malloc(sizeof(nvmlGpmSupport_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpmSupport")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpmSupport_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN: Set to NVML_GPM_SUPPORT_VERSION."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This GpmSupport instance is read-only")
        self._ptr[0].version = val

    @property
    def is_supported_device(self):
        """int: OUT: Indicates device support."""
        return self._ptr[0].isSupportedDevice

    @is_supported_device.setter
    def is_supported_device(self, val):
        if self._readonly:
            raise ValueError("This GpmSupport instance is read-only")
        self._ptr[0].isSupportedDevice = val

    @staticmethod
    def from_data(data):
        """Create an GpmSupport instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpm_support_dtype` holding the data.
        """
        return __from_data(data, "gpm_support_dtype", gpm_support_dtype, GpmSupport)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpmSupport instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpmSupport obj = GpmSupport.__new__(GpmSupport)
        if owner is None:
            obj._ptr = <nvmlGpmSupport_t *>malloc(sizeof(nvmlGpmSupport_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpmSupport")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpmSupport_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpmSupport_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_device_capabilities_v1_dtype_offsets():
    cdef nvmlDeviceCapabilities_v1_t pod = nvmlDeviceCapabilities_v1_t()
    return _numpy.dtype({
        'names': ['version', 'cap_mask'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.capMask)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDeviceCapabilities_v1_t),
    })

device_capabilities_v1_dtype = _get_device_capabilities_v1_dtype_offsets()

cdef class DeviceCapabilities_v1:
    """Empty-initialize an instance of `nvmlDeviceCapabilities_v1_t`.


    .. seealso:: `nvmlDeviceCapabilities_v1_t`
    """
    cdef:
        nvmlDeviceCapabilities_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDeviceCapabilities_v1_t *>calloc(1, sizeof(nvmlDeviceCapabilities_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DeviceCapabilities_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDeviceCapabilities_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DeviceCapabilities_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DeviceCapabilities_v1 other_
        if not isinstance(other, DeviceCapabilities_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDeviceCapabilities_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDeviceCapabilities_v1_t *>malloc(sizeof(nvmlDeviceCapabilities_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DeviceCapabilities_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDeviceCapabilities_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This DeviceCapabilities_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def cap_mask(self):
        """int: OUT: Bit mask of capabilities."""
        return self._ptr[0].capMask

    @cap_mask.setter
    def cap_mask(self, val):
        if self._readonly:
            raise ValueError("This DeviceCapabilities_v1 instance is read-only")
        self._ptr[0].capMask = val

    @staticmethod
    def from_data(data):
        """Create an DeviceCapabilities_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_capabilities_v1_dtype` holding the data.
        """
        return __from_data(data, "device_capabilities_v1_dtype", device_capabilities_v1_dtype, DeviceCapabilities_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DeviceCapabilities_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DeviceCapabilities_v1 obj = DeviceCapabilities_v1.__new__(DeviceCapabilities_v1)
        if owner is None:
            obj._ptr = <nvmlDeviceCapabilities_v1_t *>malloc(sizeof(nvmlDeviceCapabilities_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DeviceCapabilities_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDeviceCapabilities_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDeviceCapabilities_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_device_addressing_mode_v1_dtype_offsets():
    cdef nvmlDeviceAddressingMode_v1_t pod = nvmlDeviceAddressingMode_v1_t()
    return _numpy.dtype({
        'names': ['version', 'value'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.value)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDeviceAddressingMode_v1_t),
    })

device_addressing_mode_v1_dtype = _get_device_addressing_mode_v1_dtype_offsets()

cdef class DeviceAddressingMode_v1:
    """Empty-initialize an instance of `nvmlDeviceAddressingMode_v1_t`.


    .. seealso:: `nvmlDeviceAddressingMode_v1_t`
    """
    cdef:
        nvmlDeviceAddressingMode_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDeviceAddressingMode_v1_t *>calloc(1, sizeof(nvmlDeviceAddressingMode_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DeviceAddressingMode_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDeviceAddressingMode_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DeviceAddressingMode_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DeviceAddressingMode_v1 other_
        if not isinstance(other, DeviceAddressingMode_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDeviceAddressingMode_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDeviceAddressingMode_v1_t *>malloc(sizeof(nvmlDeviceAddressingMode_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DeviceAddressingMode_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDeviceAddressingMode_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: API version."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This DeviceAddressingMode_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def value(self):
        """int: One of `nvmlDeviceAddressingModeType_t`."""
        return self._ptr[0].value

    @value.setter
    def value(self, val):
        if self._readonly:
            raise ValueError("This DeviceAddressingMode_v1 instance is read-only")
        self._ptr[0].value = val

    @staticmethod
    def from_data(data):
        """Create an DeviceAddressingMode_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_addressing_mode_v1_dtype` holding the data.
        """
        return __from_data(data, "device_addressing_mode_v1_dtype", device_addressing_mode_v1_dtype, DeviceAddressingMode_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DeviceAddressingMode_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DeviceAddressingMode_v1 obj = DeviceAddressingMode_v1.__new__(DeviceAddressingMode_v1)
        if owner is None:
            obj._ptr = <nvmlDeviceAddressingMode_v1_t *>malloc(sizeof(nvmlDeviceAddressingMode_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DeviceAddressingMode_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDeviceAddressingMode_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDeviceAddressingMode_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_repair_status_v1_dtype_offsets():
    cdef nvmlRepairStatus_v1_t pod = nvmlRepairStatus_v1_t()
    return _numpy.dtype({
        'names': ['version', 'b_channel_repair_pending', 'b_tpc_repair_pending'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bChannelRepairPending)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bTpcRepairPending)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlRepairStatus_v1_t),
    })

repair_status_v1_dtype = _get_repair_status_v1_dtype_offsets()

cdef class RepairStatus_v1:
    """Empty-initialize an instance of `nvmlRepairStatus_v1_t`.


    .. seealso:: `nvmlRepairStatus_v1_t`
    """
    cdef:
        nvmlRepairStatus_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlRepairStatus_v1_t *>calloc(1, sizeof(nvmlRepairStatus_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating RepairStatus_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlRepairStatus_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.RepairStatus_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef RepairStatus_v1 other_
        if not isinstance(other, RepairStatus_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlRepairStatus_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlRepairStatus_v1_t *>malloc(sizeof(nvmlRepairStatus_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating RepairStatus_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlRepairStatus_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: API version number."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This RepairStatus_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def b_channel_repair_pending(self):
        """int: Reference to `unsigned` int."""
        return self._ptr[0].bChannelRepairPending

    @b_channel_repair_pending.setter
    def b_channel_repair_pending(self, val):
        if self._readonly:
            raise ValueError("This RepairStatus_v1 instance is read-only")
        self._ptr[0].bChannelRepairPending = val

    @property
    def b_tpc_repair_pending(self):
        """int: Reference to `unsigned` int."""
        return self._ptr[0].bTpcRepairPending

    @b_tpc_repair_pending.setter
    def b_tpc_repair_pending(self, val):
        if self._readonly:
            raise ValueError("This RepairStatus_v1 instance is read-only")
        self._ptr[0].bTpcRepairPending = val

    @staticmethod
    def from_data(data):
        """Create an RepairStatus_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `repair_status_v1_dtype` holding the data.
        """
        return __from_data(data, "repair_status_v1_dtype", repair_status_v1_dtype, RepairStatus_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an RepairStatus_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef RepairStatus_v1 obj = RepairStatus_v1.__new__(RepairStatus_v1)
        if owner is None:
            obj._ptr = <nvmlRepairStatus_v1_t *>malloc(sizeof(nvmlRepairStatus_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating RepairStatus_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlRepairStatus_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlRepairStatus_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_pdi_v1_dtype_offsets():
    cdef nvmlPdi_v1_t pod = nvmlPdi_v1_t()
    return _numpy.dtype({
        'names': ['version', 'value'],
        'formats': [_numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.value)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPdi_v1_t),
    })

pdi_v1_dtype = _get_pdi_v1_dtype_offsets()

cdef class Pdi_v1:
    """Empty-initialize an instance of `nvmlPdi_v1_t`.


    .. seealso:: `nvmlPdi_v1_t`
    """
    cdef:
        nvmlPdi_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPdi_v1_t *>calloc(1, sizeof(nvmlPdi_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating Pdi_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPdi_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.Pdi_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef Pdi_v1 other_
        if not isinstance(other, Pdi_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPdi_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPdi_v1_t *>malloc(sizeof(nvmlPdi_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating Pdi_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPdi_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: API version number."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This Pdi_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def value(self):
        """int: 64-bit PDI value"""
        return self._ptr[0].value

    @value.setter
    def value(self, val):
        if self._readonly:
            raise ValueError("This Pdi_v1 instance is read-only")
        self._ptr[0].value = val

    @staticmethod
    def from_data(data):
        """Create an Pdi_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `pdi_v1_dtype` holding the data.
        """
        return __from_data(data, "pdi_v1_dtype", pdi_v1_dtype, Pdi_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an Pdi_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Pdi_v1 obj = Pdi_v1.__new__(Pdi_v1)
        if owner is None:
            obj._ptr = <nvmlPdi_v1_t *>malloc(sizeof(nvmlPdi_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating Pdi_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPdi_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPdi_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_device_power_mizer_modes_v1_dtype_offsets():
    cdef nvmlDevicePowerMizerModes_v1_t pod = nvmlDevicePowerMizerModes_v1_t()
    return _numpy.dtype({
        'names': ['current_mode', 'mode', 'supported_power_mizer_modes'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.currentMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.mode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.supportedPowerMizerModes)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlDevicePowerMizerModes_v1_t),
    })

device_power_mizer_modes_v1_dtype = _get_device_power_mizer_modes_v1_dtype_offsets()

cdef class DevicePowerMizerModes_v1:
    """Empty-initialize an instance of `nvmlDevicePowerMizerModes_v1_t`.


    .. seealso:: `nvmlDevicePowerMizerModes_v1_t`
    """
    cdef:
        nvmlDevicePowerMizerModes_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlDevicePowerMizerModes_v1_t *>calloc(1, sizeof(nvmlDevicePowerMizerModes_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating DevicePowerMizerModes_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlDevicePowerMizerModes_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.DevicePowerMizerModes_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef DevicePowerMizerModes_v1 other_
        if not isinstance(other, DevicePowerMizerModes_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlDevicePowerMizerModes_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlDevicePowerMizerModes_v1_t *>malloc(sizeof(nvmlDevicePowerMizerModes_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating DevicePowerMizerModes_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlDevicePowerMizerModes_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def current_mode(self):
        """int: OUT: the current powermizer mode."""
        return self._ptr[0].currentMode

    @current_mode.setter
    def current_mode(self, val):
        if self._readonly:
            raise ValueError("This DevicePowerMizerModes_v1 instance is read-only")
        self._ptr[0].currentMode = val

    @property
    def mode(self):
        """int: IN: the powermizer mode to set."""
        return self._ptr[0].mode

    @mode.setter
    def mode(self, val):
        if self._readonly:
            raise ValueError("This DevicePowerMizerModes_v1 instance is read-only")
        self._ptr[0].mode = val

    @property
    def supported_power_mizer_modes(self):
        """int: OUT: Bitmask of supported powermizer modes."""
        return self._ptr[0].supportedPowerMizerModes

    @supported_power_mizer_modes.setter
    def supported_power_mizer_modes(self, val):
        if self._readonly:
            raise ValueError("This DevicePowerMizerModes_v1 instance is read-only")
        self._ptr[0].supportedPowerMizerModes = val

    @staticmethod
    def from_data(data):
        """Create an DevicePowerMizerModes_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `device_power_mizer_modes_v1_dtype` holding the data.
        """
        return __from_data(data, "device_power_mizer_modes_v1_dtype", device_power_mizer_modes_v1_dtype, DevicePowerMizerModes_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an DevicePowerMizerModes_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef DevicePowerMizerModes_v1 obj = DevicePowerMizerModes_v1.__new__(DevicePowerMizerModes_v1)
        if owner is None:
            obj._ptr = <nvmlDevicePowerMizerModes_v1_t *>malloc(sizeof(nvmlDevicePowerMizerModes_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating DevicePowerMizerModes_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlDevicePowerMizerModes_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlDevicePowerMizerModes_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_ecc_sram_unique_uncorrected_error_entry_v1_dtype_offsets():
    cdef nvmlEccSramUniqueUncorrectedErrorEntry_v1_t pod = nvmlEccSramUniqueUncorrectedErrorEntry_v1_t()
    return _numpy.dtype({
        'names': ['unit', 'location', 'sublocation', 'extlocation', 'address', 'is_parity', 'count'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.unit)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.location)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sublocation)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.extlocation)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.address)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isParity)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.count)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlEccSramUniqueUncorrectedErrorEntry_v1_t),
    })

ecc_sram_unique_uncorrected_error_entry_v1_dtype = _get_ecc_sram_unique_uncorrected_error_entry_v1_dtype_offsets()

cdef class EccSramUniqueUncorrectedErrorEntry_v1:
    """Empty-initialize an array of `nvmlEccSramUniqueUncorrectedErrorEntry_v1_t`.

    The resulting object is of length `size` and of dtype `ecc_sram_unique_uncorrected_error_entry_v1_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlEccSramUniqueUncorrectedErrorEntry_v1_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=ecc_sram_unique_uncorrected_error_entry_v1_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlEccSramUniqueUncorrectedErrorEntry_v1_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlEccSramUniqueUncorrectedErrorEntry_v1_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.EccSramUniqueUncorrectedErrorEntry_v1_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.EccSramUniqueUncorrectedErrorEntry_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, EccSramUniqueUncorrectedErrorEntry_v1)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def unit(self):
        """Union[~_numpy.uint32, int]: the SRAM unit index"""
        if self._data.size == 1:
            return int(self._data.unit[0])
        return self._data.unit

    @unit.setter
    def unit(self, val):
        self._data.unit = val

    @property
    def location(self):
        """Union[~_numpy.uint32, int]: the error location within the SRAM unit"""
        if self._data.size == 1:
            return int(self._data.location[0])
        return self._data.location

    @location.setter
    def location(self, val):
        self._data.location = val

    @property
    def sublocation(self):
        """Union[~_numpy.uint32, int]: the error sublocation within the SRAM unit"""
        if self._data.size == 1:
            return int(self._data.sublocation[0])
        return self._data.sublocation

    @sublocation.setter
    def sublocation(self, val):
        self._data.sublocation = val

    @property
    def extlocation(self):
        """Union[~_numpy.uint32, int]: the error extlocation within the SRAM unit"""
        if self._data.size == 1:
            return int(self._data.extlocation[0])
        return self._data.extlocation

    @extlocation.setter
    def extlocation(self, val):
        self._data.extlocation = val

    @property
    def address(self):
        """Union[~_numpy.uint32, int]: the error address within the SRAM unit"""
        if self._data.size == 1:
            return int(self._data.address[0])
        return self._data.address

    @address.setter
    def address(self, val):
        self._data.address = val

    @property
    def is_parity(self):
        """Union[~_numpy.uint32, int]: if the SRAM error is parity or not"""
        if self._data.size == 1:
            return int(self._data.is_parity[0])
        return self._data.is_parity

    @is_parity.setter
    def is_parity(self, val):
        self._data.is_parity = val

    @property
    def count(self):
        """Union[~_numpy.uint32, int]: the error count at the same SRAM address"""
        if self._data.size == 1:
            return int(self._data.count[0])
        return self._data.count

    @count.setter
    def count(self, val):
        self._data.count = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return EccSramUniqueUncorrectedErrorEntry_v1.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == ecc_sram_unique_uncorrected_error_entry_v1_dtype:
            return EccSramUniqueUncorrectedErrorEntry_v1.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an EccSramUniqueUncorrectedErrorEntry_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `ecc_sram_unique_uncorrected_error_entry_v1_dtype` holding the data.
        """
        cdef EccSramUniqueUncorrectedErrorEntry_v1 obj = EccSramUniqueUncorrectedErrorEntry_v1.__new__(EccSramUniqueUncorrectedErrorEntry_v1)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != ecc_sram_unique_uncorrected_error_entry_v1_dtype:
            raise ValueError("data array must be of dtype ecc_sram_unique_uncorrected_error_entry_v1_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an EccSramUniqueUncorrectedErrorEntry_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef EccSramUniqueUncorrectedErrorEntry_v1 obj = EccSramUniqueUncorrectedErrorEntry_v1.__new__(EccSramUniqueUncorrectedErrorEntry_v1)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlEccSramUniqueUncorrectedErrorEntry_v1_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=ecc_sram_unique_uncorrected_error_entry_v1_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_gpu_fabric_info_v3_dtype_offsets():
    cdef nvmlGpuFabricInfo_v3_t pod = nvmlGpuFabricInfo_v3_t()
    return _numpy.dtype({
        'names': ['version', 'cluster_uuid', 'status', 'clique_id', 'state', 'health_mask', 'health_summary'],
        'formats': [_numpy.uint32, _numpy.uint8, _numpy.int32, _numpy.uint32, _numpy.uint8, _numpy.uint32, _numpy.uint8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clusterUuid)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.status)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.cliqueId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.state)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.healthMask)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.healthSummary)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuFabricInfo_v3_t),
    })

gpu_fabric_info_v3_dtype = _get_gpu_fabric_info_v3_dtype_offsets()

cdef class GpuFabricInfo_v3:
    """Empty-initialize an instance of `nvmlGpuFabricInfo_v3_t`.


    .. seealso:: `nvmlGpuFabricInfo_v3_t`
    """
    cdef:
        nvmlGpuFabricInfo_v3_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuFabricInfo_v3_t *>calloc(1, sizeof(nvmlGpuFabricInfo_v3_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuFabricInfo_v3")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuFabricInfo_v3_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuFabricInfo_v3 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuFabricInfo_v3 other_
        if not isinstance(other, GpuFabricInfo_v3):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuFabricInfo_v3_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuFabricInfo_v3_t *>malloc(sizeof(nvmlGpuFabricInfo_v3_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuFabricInfo_v3")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuFabricInfo_v3_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: Structure version identifier (set to nvmlGpuFabricInfo_v2)"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].version = val

    @property
    def cluster_uuid(self):
        """~_numpy.uint8: (array of length 16).Uuid of the cluster to which this GPU belongs."""
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c", allocate_buffer=False)
        arr.data = <char *>(&(self._ptr[0].clusterUuid))
        return _numpy.asarray(arr)

    @cluster_uuid.setter
    def cluster_uuid(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        cdef view.array arr = view.array(shape=(16,), itemsize=sizeof(unsigned char), format="B", mode="c")
        arr[:] = _numpy.asarray(val, dtype=_numpy.uint8)
        memcpy(<void *>(&(self._ptr[0].clusterUuid)), <void *>(arr.data), sizeof(unsigned char) * len(val))

    @property
    def status(self):
        """int: Probe Error status, if any. Must be checked only if Probe state returns "complete"."""
        return <int>(self._ptr[0].status)

    @status.setter
    def status(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].status = <nvmlReturn_t><int>val

    @property
    def clique_id(self):
        """int: ID of the fabric clique to which this GPU belongs."""
        return self._ptr[0].cliqueId

    @clique_id.setter
    def clique_id(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].cliqueId = val

    @property
    def state(self):
        """int: Current Probe State of GPU registration process. See NVML_GPU_FABRIC_STATE_*."""
        return <unsigned char>(self._ptr[0].state)

    @state.setter
    def state(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].state = <nvmlGpuFabricState_t><unsigned char>val

    @property
    def health_mask(self):
        """int: GPU Fabric health Status Mask. See NVML_GPU_FABRIC_HEALTH_MASK_*."""
        return self._ptr[0].healthMask

    @health_mask.setter
    def health_mask(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].healthMask = val

    @property
    def health_summary(self):
        """int: GPU Fabric health summary. See NVML_GPU_FABRIC_HEALTH_SUMMARY_*."""
        return self._ptr[0].healthSummary

    @health_summary.setter
    def health_summary(self, val):
        if self._readonly:
            raise ValueError("This GpuFabricInfo_v3 instance is read-only")
        self._ptr[0].healthSummary = val

    @staticmethod
    def from_data(data):
        """Create an GpuFabricInfo_v3 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_fabric_info_v3_dtype` holding the data.
        """
        return __from_data(data, "gpu_fabric_info_v3_dtype", gpu_fabric_info_v3_dtype, GpuFabricInfo_v3)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuFabricInfo_v3 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuFabricInfo_v3 obj = GpuFabricInfo_v3.__new__(GpuFabricInfo_v3)
        if owner is None:
            obj._ptr = <nvmlGpuFabricInfo_v3_t *>malloc(sizeof(nvmlGpuFabricInfo_v3_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuFabricInfo_v3")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuFabricInfo_v3_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuFabricInfo_v3_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nv_link_info_v1_dtype_offsets():
    cdef nvmlNvLinkInfo_v1_t pod = nvmlNvLinkInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'is_nvle_enabled'],
        'formats': [_numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isNvleEnabled)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvLinkInfo_v1_t),
    })

nv_link_info_v1_dtype = _get_nv_link_info_v1_dtype_offsets()

cdef class NvLinkInfo_v1:
    """Empty-initialize an instance of `nvmlNvLinkInfo_v1_t`.


    .. seealso:: `nvmlNvLinkInfo_v1_t`
    """
    cdef:
        nvmlNvLinkInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvLinkInfo_v1_t *>calloc(1, sizeof(nvmlNvLinkInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvLinkInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvLinkInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvLinkInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvLinkInfo_v1 other_
        if not isinstance(other, NvLinkInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvLinkInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvLinkInfo_v1_t *>malloc(sizeof(nvmlNvLinkInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvLinkInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvLinkInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: IN - the API version number."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This NvLinkInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def is_nvle_enabled(self):
        """int: OUT - NVLINK encryption enablement."""
        return self._ptr[0].isNvleEnabled

    @is_nvle_enabled.setter
    def is_nvle_enabled(self, val):
        if self._readonly:
            raise ValueError("This NvLinkInfo_v1 instance is read-only")
        self._ptr[0].isNvleEnabled = val

    @staticmethod
    def from_data(data):
        """Create an NvLinkInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nv_link_info_v1_dtype` holding the data.
        """
        return __from_data(data, "nv_link_info_v1_dtype", nv_link_info_v1_dtype, NvLinkInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvLinkInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvLinkInfo_v1 obj = NvLinkInfo_v1.__new__(NvLinkInfo_v1)
        if owner is None:
            obj._ptr = <nvmlNvLinkInfo_v1_t *>malloc(sizeof(nvmlNvLinkInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvLinkInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvLinkInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvLinkInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nvlink_firmware_version_dtype_offsets():
    cdef nvmlNvlinkFirmwareVersion_t pod = nvmlNvlinkFirmwareVersion_t()
    return _numpy.dtype({
        'names': ['ucode_type', 'major', 'minor', 'sub_minor'],
        'formats': [_numpy.uint8, _numpy.uint32, _numpy.uint32, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.ucodeType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.major)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.minor)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.subMinor)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvlinkFirmwareVersion_t),
    })

nvlink_firmware_version_dtype = _get_nvlink_firmware_version_dtype_offsets()

cdef class NvlinkFirmwareVersion:
    """Empty-initialize an instance of `nvmlNvlinkFirmwareVersion_t`.


    .. seealso:: `nvmlNvlinkFirmwareVersion_t`
    """
    cdef:
        nvmlNvlinkFirmwareVersion_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvlinkFirmwareVersion_t *>calloc(1, sizeof(nvmlNvlinkFirmwareVersion_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvlinkFirmwareVersion")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvlinkFirmwareVersion_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvlinkFirmwareVersion object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvlinkFirmwareVersion other_
        if not isinstance(other, NvlinkFirmwareVersion):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvlinkFirmwareVersion_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvlinkFirmwareVersion_t *>malloc(sizeof(nvmlNvlinkFirmwareVersion_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvlinkFirmwareVersion")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvlinkFirmwareVersion_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def ucode_type(self):
        """int: """
        return self._ptr[0].ucodeType

    @ucode_type.setter
    def ucode_type(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareVersion instance is read-only")
        self._ptr[0].ucodeType = val

    @property
    def major(self):
        """int: """
        return self._ptr[0].major

    @major.setter
    def major(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareVersion instance is read-only")
        self._ptr[0].major = val

    @property
    def minor(self):
        """int: """
        return self._ptr[0].minor

    @minor.setter
    def minor(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareVersion instance is read-only")
        self._ptr[0].minor = val

    @property
    def sub_minor(self):
        """int: """
        return self._ptr[0].subMinor

    @sub_minor.setter
    def sub_minor(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareVersion instance is read-only")
        self._ptr[0].subMinor = val

    @staticmethod
    def from_data(data):
        """Create an NvlinkFirmwareVersion instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nvlink_firmware_version_dtype` holding the data.
        """
        return __from_data(data, "nvlink_firmware_version_dtype", nvlink_firmware_version_dtype, NvlinkFirmwareVersion)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvlinkFirmwareVersion instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvlinkFirmwareVersion obj = NvlinkFirmwareVersion.__new__(NvlinkFirmwareVersion)
        if owner is None:
            obj._ptr = <nvmlNvlinkFirmwareVersion_t *>malloc(sizeof(nvmlNvlinkFirmwareVersion_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvlinkFirmwareVersion")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvlinkFirmwareVersion_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvlinkFirmwareVersion_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_unrepairable_memory_status_v1_dtype_offsets():
    cdef nvmlUnrepairableMemoryStatus_v1_t pod = nvmlUnrepairableMemoryStatus_v1_t()
    return _numpy.dtype({
        'names': ['b_unrepairable_memory'],
        'formats': [_numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.bUnrepairableMemory)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlUnrepairableMemoryStatus_v1_t),
    })

unrepairable_memory_status_v1_dtype = _get_unrepairable_memory_status_v1_dtype_offsets()

cdef class UnrepairableMemoryStatus_v1:
    """Empty-initialize an instance of `nvmlUnrepairableMemoryStatus_v1_t`.


    .. seealso:: `nvmlUnrepairableMemoryStatus_v1_t`
    """
    cdef:
        nvmlUnrepairableMemoryStatus_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlUnrepairableMemoryStatus_v1_t *>calloc(1, sizeof(nvmlUnrepairableMemoryStatus_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating UnrepairableMemoryStatus_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlUnrepairableMemoryStatus_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.UnrepairableMemoryStatus_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef UnrepairableMemoryStatus_v1 other_
        if not isinstance(other, UnrepairableMemoryStatus_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlUnrepairableMemoryStatus_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlUnrepairableMemoryStatus_v1_t *>malloc(sizeof(nvmlUnrepairableMemoryStatus_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating UnrepairableMemoryStatus_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlUnrepairableMemoryStatus_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def b_unrepairable_memory(self):
        """int: Reference to `unsigned` int."""
        return self._ptr[0].bUnrepairableMemory

    @b_unrepairable_memory.setter
    def b_unrepairable_memory(self, val):
        if self._readonly:
            raise ValueError("This UnrepairableMemoryStatus_v1 instance is read-only")
        self._ptr[0].bUnrepairableMemory = val

    @staticmethod
    def from_data(data):
        """Create an UnrepairableMemoryStatus_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `unrepairable_memory_status_v1_dtype` holding the data.
        """
        return __from_data(data, "unrepairable_memory_status_v1_dtype", unrepairable_memory_status_v1_dtype, UnrepairableMemoryStatus_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an UnrepairableMemoryStatus_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef UnrepairableMemoryStatus_v1 obj = UnrepairableMemoryStatus_v1.__new__(UnrepairableMemoryStatus_v1)
        if owner is None:
            obj._ptr = <nvmlUnrepairableMemoryStatus_v1_t *>malloc(sizeof(nvmlUnrepairableMemoryStatus_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating UnrepairableMemoryStatus_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlUnrepairableMemoryStatus_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlUnrepairableMemoryStatus_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_rusd_settings_v1_dtype_offsets():
    cdef nvmlRusdSettings_v1_t pod = nvmlRusdSettings_v1_t()
    return _numpy.dtype({
        'names': ['version', 'poll_mask'],
        'formats': [_numpy.uint32, _numpy.uint64],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pollMask)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlRusdSettings_v1_t),
    })

rusd_settings_v1_dtype = _get_rusd_settings_v1_dtype_offsets()

cdef class RusdSettings_v1:
    """Empty-initialize an instance of `nvmlRusdSettings_v1_t`.


    .. seealso:: `nvmlRusdSettings_v1_t`
    """
    cdef:
        nvmlRusdSettings_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlRusdSettings_v1_t *>calloc(1, sizeof(nvmlRusdSettings_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating RusdSettings_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlRusdSettings_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.RusdSettings_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef RusdSettings_v1 other_
        if not isinstance(other, RusdSettings_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlRusdSettings_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlRusdSettings_v1_t *>malloc(sizeof(nvmlRusdSettings_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating RusdSettings_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlRusdSettings_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This RusdSettings_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def poll_mask(self):
        """int: Bitmask of polling data. 0 value means the GPU's RUSD polling mask is cleared."""
        return self._ptr[0].pollMask

    @poll_mask.setter
    def poll_mask(self, val):
        if self._readonly:
            raise ValueError("This RusdSettings_v1 instance is read-only")
        self._ptr[0].pollMask = val

    @staticmethod
    def from_data(data):
        """Create an RusdSettings_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `rusd_settings_v1_dtype` holding the data.
        """
        return __from_data(data, "rusd_settings_v1_dtype", rusd_settings_v1_dtype, RusdSettings_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an RusdSettings_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef RusdSettings_v1 obj = RusdSettings_v1.__new__(RusdSettings_v1)
        if owner is None:
            obj._ptr = <nvmlRusdSettings_v1_t *>malloc(sizeof(nvmlRusdSettings_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating RusdSettings_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlRusdSettings_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlRusdSettings_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_prm_counter_input_v1_dtype_offsets():
    cdef nvmlPRMCounterInput_v1_t pod = nvmlPRMCounterInput_v1_t()
    return _numpy.dtype({
        'names': ['local_port'],
        'formats': [_numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.localPort)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPRMCounterInput_v1_t),
    })

prm_counter_input_v1_dtype = _get_prm_counter_input_v1_dtype_offsets()

cdef class PRMCounterInput_v1:
    """Empty-initialize an instance of `nvmlPRMCounterInput_v1_t`.


    .. seealso:: `nvmlPRMCounterInput_v1_t`
    """
    cdef:
        nvmlPRMCounterInput_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPRMCounterInput_v1_t *>calloc(1, sizeof(nvmlPRMCounterInput_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PRMCounterInput_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPRMCounterInput_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PRMCounterInput_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PRMCounterInput_v1 other_
        if not isinstance(other, PRMCounterInput_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPRMCounterInput_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPRMCounterInput_v1_t *>malloc(sizeof(nvmlPRMCounterInput_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterInput_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPRMCounterInput_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def local_port(self):
        """int: Local port number."""
        return self._ptr[0].localPort

    @local_port.setter
    def local_port(self, val):
        if self._readonly:
            raise ValueError("This PRMCounterInput_v1 instance is read-only")
        self._ptr[0].localPort = val

    @staticmethod
    def from_data(data):
        """Create an PRMCounterInput_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `prm_counter_input_v1_dtype` holding the data.
        """
        return __from_data(data, "prm_counter_input_v1_dtype", prm_counter_input_v1_dtype, PRMCounterInput_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PRMCounterInput_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PRMCounterInput_v1 obj = PRMCounterInput_v1.__new__(PRMCounterInput_v1)
        if owner is None:
            obj._ptr = <nvmlPRMCounterInput_v1_t *>malloc(sizeof(nvmlPRMCounterInput_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterInput_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPRMCounterInput_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPRMCounterInput_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_excluded_device_info_dtype_offsets():
    cdef nvmlExcludedDeviceInfo_t pod = nvmlExcludedDeviceInfo_t()
    return _numpy.dtype({
        'names': ['pci_info', 'uuid'],
        'formats': [pci_info_dtype, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.pciInfo)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.uuid)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlExcludedDeviceInfo_t),
    })

excluded_device_info_dtype = _get_excluded_device_info_dtype_offsets()

cdef class ExcludedDeviceInfo:
    """Empty-initialize an instance of `nvmlExcludedDeviceInfo_t`.


    .. seealso:: `nvmlExcludedDeviceInfo_t`
    """
    cdef:
        nvmlExcludedDeviceInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlExcludedDeviceInfo_t *>calloc(1, sizeof(nvmlExcludedDeviceInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ExcludedDeviceInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlExcludedDeviceInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ExcludedDeviceInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ExcludedDeviceInfo other_
        if not isinstance(other, ExcludedDeviceInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlExcludedDeviceInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlExcludedDeviceInfo_t *>malloc(sizeof(nvmlExcludedDeviceInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ExcludedDeviceInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlExcludedDeviceInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def pci_info(self):
        """PciInfo: """
        return PciInfo.from_ptr(<intptr_t>&(self._ptr[0].pciInfo), self._readonly, self)

    @pci_info.setter
    def pci_info(self, val):
        if self._readonly:
            raise ValueError("This ExcludedDeviceInfo instance is read-only")
        cdef PciInfo val_ = val
        memcpy(<void *>&(self._ptr[0].pciInfo), <void *>(val_._get_ptr()), sizeof(nvmlPciInfo_t) * 1)

    @property
    def uuid(self):
        """~_numpy.int8: (array of length 80)."""
        return cpython.PyUnicode_FromString(self._ptr[0].uuid)

    @uuid.setter
    def uuid(self, val):
        if self._readonly:
            raise ValueError("This ExcludedDeviceInfo instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 80:
            raise ValueError("String too long for field uuid, max length is 79")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].uuid), <void *>ptr, 80)

    @staticmethod
    def from_data(data):
        """Create an ExcludedDeviceInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `excluded_device_info_dtype` holding the data.
        """
        return __from_data(data, "excluded_device_info_dtype", excluded_device_info_dtype, ExcludedDeviceInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ExcludedDeviceInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ExcludedDeviceInfo obj = ExcludedDeviceInfo.__new__(ExcludedDeviceInfo)
        if owner is None:
            obj._ptr = <nvmlExcludedDeviceInfo_t *>malloc(sizeof(nvmlExcludedDeviceInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ExcludedDeviceInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlExcludedDeviceInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlExcludedDeviceInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_process_detail_list_v1_dtype_offsets():
    cdef nvmlProcessDetailList_v1_t pod = nvmlProcessDetailList_v1_t()
    return _numpy.dtype({
        'names': ['version', 'mode', 'num_proc_array_entries', 'proc_array'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.mode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.numProcArrayEntries)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.procArray)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessDetailList_v1_t),
    })

process_detail_list_v1_dtype = _get_process_detail_list_v1_dtype_offsets()

cdef class ProcessDetailList_v1:
    """Empty-initialize an instance of `nvmlProcessDetailList_v1_t`.


    .. seealso:: `nvmlProcessDetailList_v1_t`
    """
    cdef:
        nvmlProcessDetailList_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlProcessDetailList_v1_t *>calloc(1, sizeof(nvmlProcessDetailList_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ProcessDetailList_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlProcessDetailList_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ProcessDetailList_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ProcessDetailList_v1 other_
        if not isinstance(other, ProcessDetailList_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlProcessDetailList_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlProcessDetailList_v1_t *>malloc(sizeof(nvmlProcessDetailList_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ProcessDetailList_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlProcessDetailList_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: Struct version, MUST be nvmlProcessDetailList_v1."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ProcessDetailList_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def mode(self):
        """int: Process mode(Compute/Graphics/MPSCompute)"""
        return self._ptr[0].mode

    @mode.setter
    def mode(self, val):
        if self._readonly:
            raise ValueError("This ProcessDetailList_v1 instance is read-only")
        self._ptr[0].mode = val

    @property
    def proc_array(self):
        """int: Process array."""
        if self._ptr[0].procArray == NULL or self._ptr[0].numProcArrayEntries == 0:
            return []
        return ProcessDetail_v1.from_ptr(<intptr_t>(self._ptr[0].procArray), self._ptr[0].numProcArrayEntries)

    @proc_array.setter
    def proc_array(self, val):
        if self._readonly:
            raise ValueError("This ProcessDetailList_v1 instance is read-only")
        cdef ProcessDetail_v1 arr = val
        self._ptr[0].procArray = <nvmlProcessDetail_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].numProcArrayEntries = len(arr)
        self._refs["proc_array"] = arr

    @staticmethod
    def from_data(data):
        """Create an ProcessDetailList_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `process_detail_list_v1_dtype` holding the data.
        """
        return __from_data(data, "process_detail_list_v1_dtype", process_detail_list_v1_dtype, ProcessDetailList_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ProcessDetailList_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessDetailList_v1 obj = ProcessDetailList_v1.__new__(ProcessDetailList_v1)
        if owner is None:
            obj._ptr = <nvmlProcessDetailList_v1_t *>malloc(sizeof(nvmlProcessDetailList_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ProcessDetailList_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlProcessDetailList_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlProcessDetailList_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_bridge_chip_hierarchy_dtype_offsets():
    cdef nvmlBridgeChipHierarchy_t pod = nvmlBridgeChipHierarchy_t()
    return _numpy.dtype({
        'names': ['bridge_count', 'bridge_chip_info'],
        'formats': [_numpy.uint8, bridge_chip_info_dtype],
        'offsets': [
            (<intptr_t>&(pod.bridgeCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.bridgeChipInfo)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlBridgeChipHierarchy_t),
    })

bridge_chip_hierarchy_dtype = _get_bridge_chip_hierarchy_dtype_offsets()

cdef class BridgeChipHierarchy:
    """Empty-initialize an instance of `nvmlBridgeChipHierarchy_t`.


    .. seealso:: `nvmlBridgeChipHierarchy_t`
    """
    cdef:
        nvmlBridgeChipHierarchy_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlBridgeChipHierarchy_t *>calloc(1, sizeof(nvmlBridgeChipHierarchy_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating BridgeChipHierarchy")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlBridgeChipHierarchy_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.BridgeChipHierarchy object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef BridgeChipHierarchy other_
        if not isinstance(other, BridgeChipHierarchy):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlBridgeChipHierarchy_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlBridgeChipHierarchy_t *>malloc(sizeof(nvmlBridgeChipHierarchy_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating BridgeChipHierarchy")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlBridgeChipHierarchy_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def bridge_chip_info(self):
        """BridgeChipInfo: """
        return BridgeChipInfo.from_ptr(<intptr_t>&(self._ptr[0].bridgeChipInfo), 128, self._readonly)

    @bridge_chip_info.setter
    def bridge_chip_info(self, val):
        if self._readonly:
            raise ValueError("This BridgeChipHierarchy instance is read-only")
        cdef BridgeChipInfo val_ = val
        if len(val) != 128:
            raise ValueError(f"Expected length 128 for field bridge_chip_info, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].bridgeChipInfo), <void *>(val_._get_ptr()), sizeof(nvmlBridgeChipInfo_t) * 128)

    @property
    def bridge_count(self):
        """int: """
        return self._ptr[0].bridgeCount

    @bridge_count.setter
    def bridge_count(self, val):
        if self._readonly:
            raise ValueError("This BridgeChipHierarchy instance is read-only")
        self._ptr[0].bridgeCount = val

    @staticmethod
    def from_data(data):
        """Create an BridgeChipHierarchy instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `bridge_chip_hierarchy_dtype` holding the data.
        """
        return __from_data(data, "bridge_chip_hierarchy_dtype", bridge_chip_hierarchy_dtype, BridgeChipHierarchy)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an BridgeChipHierarchy instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef BridgeChipHierarchy obj = BridgeChipHierarchy.__new__(BridgeChipHierarchy)
        if owner is None:
            obj._ptr = <nvmlBridgeChipHierarchy_t *>malloc(sizeof(nvmlBridgeChipHierarchy_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating BridgeChipHierarchy")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlBridgeChipHierarchy_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlBridgeChipHierarchy_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_sample_dtype_offsets():
    cdef nvmlSample_t pod = nvmlSample_t()
    return _numpy.dtype({
        'names': ['time_stamp', 'sample_value'],
        'formats': [_numpy.uint64, value_dtype],
        'offsets': [
            (<intptr_t>&(pod.timeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sampleValue)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlSample_t),
    })

sample_dtype = _get_sample_dtype_offsets()

cdef class Sample:
    """Empty-initialize an array of `nvmlSample_t`.

    The resulting object is of length `size` and of dtype `sample_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlSample_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=sample_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlSample_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlSample_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.Sample_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.Sample object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, Sample)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def time_stamp(self):
        """Union[~_numpy.uint64, int]: """
        if self._data.size == 1:
            return int(self._data.time_stamp[0])
        return self._data.time_stamp

    @time_stamp.setter
    def time_stamp(self, val):
        self._data.time_stamp = val

    @property
    def sample_value(self):
        """value_dtype: """
        return self._data.sample_value

    @sample_value.setter
    def sample_value(self, val):
        self._data.sample_value = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return Sample.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == sample_dtype:
            return Sample.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an Sample instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `sample_dtype` holding the data.
        """
        cdef Sample obj = Sample.__new__(Sample)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != sample_dtype:
            raise ValueError("data array must be of dtype sample_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an Sample instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef Sample obj = Sample.__new__(Sample)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlSample_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=sample_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_vgpu_instance_utilization_info_v1_dtype_offsets():
    cdef nvmlVgpuInstanceUtilizationInfo_v1_t pod = nvmlVgpuInstanceUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['time_stamp', 'vgpu_instance', 'sm_util', 'mem_util', 'enc_util', 'dec_util', 'jpg_util', 'ofa_util'],
        'formats': [_numpy.uint64, _numpy.uint32, value_dtype, value_dtype, value_dtype, value_dtype, value_dtype, value_dtype],
        'offsets': [
            (<intptr_t>&(pod.timeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstance)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.smUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.memUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.encUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.decUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.jpgUtil)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.ofaUtil)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuInstanceUtilizationInfo_v1_t),
    })

vgpu_instance_utilization_info_v1_dtype = _get_vgpu_instance_utilization_info_v1_dtype_offsets()

cdef class VgpuInstanceUtilizationInfo_v1:
    """Empty-initialize an array of `nvmlVgpuInstanceUtilizationInfo_v1_t`.

    The resulting object is of length `size` and of dtype `vgpu_instance_utilization_info_v1_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlVgpuInstanceUtilizationInfo_v1_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=vgpu_instance_utilization_info_v1_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlVgpuInstanceUtilizationInfo_v1_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlVgpuInstanceUtilizationInfo_v1_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.VgpuInstanceUtilizationInfo_v1_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.VgpuInstanceUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, VgpuInstanceUtilizationInfo_v1)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def time_stamp(self):
        """Union[~_numpy.uint64, int]: CPU Timestamp in microseconds."""
        if self._data.size == 1:
            return int(self._data.time_stamp[0])
        return self._data.time_stamp

    @time_stamp.setter
    def time_stamp(self, val):
        self._data.time_stamp = val

    @property
    def vgpu_instance(self):
        """Union[~_numpy.uint32, int]: vGPU Instance"""
        if self._data.size == 1:
            return int(self._data.vgpu_instance[0])
        return self._data.vgpu_instance

    @vgpu_instance.setter
    def vgpu_instance(self, val):
        self._data.vgpu_instance = val

    @property
    def sm_util(self):
        """value_dtype: SM (3D/Compute) Util Value."""
        return self._data.sm_util

    @sm_util.setter
    def sm_util(self, val):
        self._data.sm_util = val

    @property
    def mem_util(self):
        """value_dtype: Frame Buffer Memory Util Value."""
        return self._data.mem_util

    @mem_util.setter
    def mem_util(self, val):
        self._data.mem_util = val

    @property
    def enc_util(self):
        """value_dtype: Encoder Util Value."""
        return self._data.enc_util

    @enc_util.setter
    def enc_util(self, val):
        self._data.enc_util = val

    @property
    def dec_util(self):
        """value_dtype: Decoder Util Value."""
        return self._data.dec_util

    @dec_util.setter
    def dec_util(self, val):
        self._data.dec_util = val

    @property
    def jpg_util(self):
        """value_dtype: Jpeg Util Value."""
        return self._data.jpg_util

    @jpg_util.setter
    def jpg_util(self, val):
        self._data.jpg_util = val

    @property
    def ofa_util(self):
        """value_dtype: Ofa Util Value."""
        return self._data.ofa_util

    @ofa_util.setter
    def ofa_util(self, val):
        self._data.ofa_util = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return VgpuInstanceUtilizationInfo_v1.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == vgpu_instance_utilization_info_v1_dtype:
            return VgpuInstanceUtilizationInfo_v1.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an VgpuInstanceUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `vgpu_instance_utilization_info_v1_dtype` holding the data.
        """
        cdef VgpuInstanceUtilizationInfo_v1 obj = VgpuInstanceUtilizationInfo_v1.__new__(VgpuInstanceUtilizationInfo_v1)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != vgpu_instance_utilization_info_v1_dtype:
            raise ValueError("data array must be of dtype vgpu_instance_utilization_info_v1_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an VgpuInstanceUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuInstanceUtilizationInfo_v1 obj = VgpuInstanceUtilizationInfo_v1.__new__(VgpuInstanceUtilizationInfo_v1)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlVgpuInstanceUtilizationInfo_v1_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=vgpu_instance_utilization_info_v1_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_field_value_dtype_offsets():
    cdef nvmlFieldValue_t pod = nvmlFieldValue_t()
    return _numpy.dtype({
        'names': ['field_id', 'scope_id', 'timestamp', 'latency_usec', 'value_type', 'nvml_return', 'value'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.int64, _numpy.int64, _numpy.int32, _numpy.int32, value_dtype],
        'offsets': [
            (<intptr_t>&(pod.fieldId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.scopeId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.timestamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.latencyUsec)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.valueType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.nvmlReturn)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.value)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlFieldValue_t),
    })

field_value_dtype = _get_field_value_dtype_offsets()

cdef class FieldValue:
    """Empty-initialize an array of `nvmlFieldValue_t`.

    The resulting object is of length `size` and of dtype `field_value_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlFieldValue_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=field_value_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlFieldValue_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlFieldValue_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.FieldValue_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.FieldValue object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, FieldValue)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def field_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.field_id[0])
        return self._data.field_id

    @field_id.setter
    def field_id(self, val):
        self._data.field_id = val

    @property
    def scope_id(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.scope_id[0])
        return self._data.scope_id

    @scope_id.setter
    def scope_id(self, val):
        self._data.scope_id = val

    @property
    def timestamp(self):
        """Union[~_numpy.int64, int]: """
        if self._data.size == 1:
            return int(self._data.timestamp[0])
        return self._data.timestamp

    @timestamp.setter
    def timestamp(self, val):
        self._data.timestamp = val

    @property
    def latency_usec(self):
        """Union[~_numpy.int64, int]: """
        if self._data.size == 1:
            return int(self._data.latency_usec[0])
        return self._data.latency_usec

    @latency_usec.setter
    def latency_usec(self, val):
        self._data.latency_usec = val

    @property
    def value_type(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.value_type[0])
        return self._data.value_type

    @value_type.setter
    def value_type(self, val):
        self._data.value_type = val

    @property
    def nvml_return(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.nvml_return[0])
        return self._data.nvml_return

    @nvml_return.setter
    def nvml_return(self, val):
        self._data.nvml_return = val

    @property
    def value(self):
        """value_dtype: """
        return self._data.value

    @value.setter
    def value(self, val):
        self._data.value = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return FieldValue.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == field_value_dtype:
            return FieldValue.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an FieldValue instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `field_value_dtype` holding the data.
        """
        cdef FieldValue obj = FieldValue.__new__(FieldValue)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != field_value_dtype:
            raise ValueError("data array must be of dtype field_value_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an FieldValue instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef FieldValue obj = FieldValue.__new__(FieldValue)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlFieldValue_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=field_value_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_prm_counter_value_v1_dtype_offsets():
    cdef nvmlPRMCounterValue_v1_t pod = nvmlPRMCounterValue_v1_t()
    return _numpy.dtype({
        'names': ['status', 'output_type', 'output_value'],
        'formats': [_numpy.int32, _numpy.int32, value_dtype],
        'offsets': [
            (<intptr_t>&(pod.status)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.outputType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.outputValue)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPRMCounterValue_v1_t),
    })

prm_counter_value_v1_dtype = _get_prm_counter_value_v1_dtype_offsets()

cdef class PRMCounterValue_v1:
    """Empty-initialize an instance of `nvmlPRMCounterValue_v1_t`.


    .. seealso:: `nvmlPRMCounterValue_v1_t`
    """
    cdef:
        nvmlPRMCounterValue_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPRMCounterValue_v1_t *>calloc(1, sizeof(nvmlPRMCounterValue_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PRMCounterValue_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPRMCounterValue_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PRMCounterValue_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PRMCounterValue_v1 other_
        if not isinstance(other, PRMCounterValue_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPRMCounterValue_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPRMCounterValue_v1_t *>malloc(sizeof(nvmlPRMCounterValue_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterValue_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPRMCounterValue_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def output_value(self):
        """Value: Output value."""
        return Value.from_ptr(<intptr_t>&(self._ptr[0].outputValue), self._readonly, self)

    @output_value.setter
    def output_value(self, val):
        if self._readonly:
            raise ValueError("This PRMCounterValue_v1 instance is read-only")
        cdef Value val_ = val
        memcpy(<void *>&(self._ptr[0].outputValue), <void *>(val_._get_ptr()), sizeof(nvmlValue_t) * 1)

    @property
    def status(self):
        """int: Status of the PRM counter read."""
        return <int>(self._ptr[0].status)

    @status.setter
    def status(self, val):
        if self._readonly:
            raise ValueError("This PRMCounterValue_v1 instance is read-only")
        self._ptr[0].status = <nvmlReturn_t><int>val

    @property
    def output_type(self):
        """int: Output value type."""
        return <int>(self._ptr[0].outputType)

    @output_type.setter
    def output_type(self, val):
        if self._readonly:
            raise ValueError("This PRMCounterValue_v1 instance is read-only")
        self._ptr[0].outputType = <nvmlValueType_t><int>val

    @staticmethod
    def from_data(data):
        """Create an PRMCounterValue_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `prm_counter_value_v1_dtype` holding the data.
        """
        return __from_data(data, "prm_counter_value_v1_dtype", prm_counter_value_v1_dtype, PRMCounterValue_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PRMCounterValue_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PRMCounterValue_v1 obj = PRMCounterValue_v1.__new__(PRMCounterValue_v1)
        if owner is None:
            obj._ptr = <nvmlPRMCounterValue_v1_t *>malloc(sizeof(nvmlPRMCounterValue_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterValue_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPRMCounterValue_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPRMCounterValue_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpu_thermal_settings_dtype_offsets():
    cdef nvmlGpuThermalSettings_t pod = nvmlGpuThermalSettings_t()
    return _numpy.dtype({
        'names': ['count', 'sensor'],
        'formats': [_numpy.uint32, _py_anon_pod0_dtype],
        'offsets': [
            (<intptr_t>&(pod.count)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sensor)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuThermalSettings_t),
    })

gpu_thermal_settings_dtype = _get_gpu_thermal_settings_dtype_offsets()

cdef class GpuThermalSettings:
    """Empty-initialize an instance of `nvmlGpuThermalSettings_t`.


    .. seealso:: `nvmlGpuThermalSettings_t`
    """
    cdef:
        nvmlGpuThermalSettings_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuThermalSettings_t *>calloc(1, sizeof(nvmlGpuThermalSettings_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuThermalSettings")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuThermalSettings_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuThermalSettings object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuThermalSettings other_
        if not isinstance(other, GpuThermalSettings):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuThermalSettings_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuThermalSettings_t *>malloc(sizeof(nvmlGpuThermalSettings_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuThermalSettings")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuThermalSettings_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def sensor(self):
        """_py_anon_pod0: """
        return _py_anon_pod0.from_ptr(<intptr_t>&(self._ptr[0].sensor), 3, self._readonly)

    @sensor.setter
    def sensor(self, val):
        if self._readonly:
            raise ValueError("This GpuThermalSettings instance is read-only")
        cdef _py_anon_pod0 val_ = val
        if len(val) != 3:
            raise ValueError(f"Expected length 3 for field sensor, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].sensor), <void *>(val_._get_ptr()), sizeof(_anon_pod0) * 3)

    @property
    def count(self):
        """int: """
        return self._ptr[0].count

    @count.setter
    def count(self, val):
        if self._readonly:
            raise ValueError("This GpuThermalSettings instance is read-only")
        self._ptr[0].count = val

    @staticmethod
    def from_data(data):
        """Create an GpuThermalSettings instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_thermal_settings_dtype` holding the data.
        """
        return __from_data(data, "gpu_thermal_settings_dtype", gpu_thermal_settings_dtype, GpuThermalSettings)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuThermalSettings instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuThermalSettings obj = GpuThermalSettings.__new__(GpuThermalSettings)
        if owner is None:
            obj._ptr = <nvmlGpuThermalSettings_t *>malloc(sizeof(nvmlGpuThermalSettings_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuThermalSettings")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuThermalSettings_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuThermalSettings_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_clk_mon_status_dtype_offsets():
    cdef nvmlClkMonStatus_t pod = nvmlClkMonStatus_t()
    return _numpy.dtype({
        'names': ['b_global_status', 'clk_mon_list_size', 'clk_mon_list'],
        'formats': [_numpy.uint32, _numpy.uint32, clk_mon_fault_info_dtype],
        'offsets': [
            (<intptr_t>&(pod.bGlobalStatus)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clkMonListSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.clkMonList)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlClkMonStatus_t),
    })

clk_mon_status_dtype = _get_clk_mon_status_dtype_offsets()

cdef class ClkMonStatus:
    """Empty-initialize an instance of `nvmlClkMonStatus_t`.


    .. seealso:: `nvmlClkMonStatus_t`
    """
    cdef:
        nvmlClkMonStatus_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlClkMonStatus_t *>calloc(1, sizeof(nvmlClkMonStatus_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ClkMonStatus")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlClkMonStatus_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ClkMonStatus object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ClkMonStatus other_
        if not isinstance(other, ClkMonStatus):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlClkMonStatus_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlClkMonStatus_t *>malloc(sizeof(nvmlClkMonStatus_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ClkMonStatus")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlClkMonStatus_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def clk_mon_list(self):
        """ClkMonFaultInfo: """
        return ClkMonFaultInfo.from_ptr(<intptr_t>&(self._ptr[0].clkMonList), 32, self._readonly)

    @clk_mon_list.setter
    def clk_mon_list(self, val):
        if self._readonly:
            raise ValueError("This ClkMonStatus instance is read-only")
        cdef ClkMonFaultInfo val_ = val
        if len(val) != 32:
            raise ValueError(f"Expected length 32 for field clk_mon_list, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].clkMonList), <void *>(val_._get_ptr()), sizeof(nvmlClkMonFaultInfo_t) * 32)

    @property
    def b_global_status(self):
        """int: """
        return self._ptr[0].bGlobalStatus

    @b_global_status.setter
    def b_global_status(self, val):
        if self._readonly:
            raise ValueError("This ClkMonStatus instance is read-only")
        self._ptr[0].bGlobalStatus = val

    @property
    def clk_mon_list_size(self):
        """int: """
        return self._ptr[0].clkMonListSize

    @clk_mon_list_size.setter
    def clk_mon_list_size(self, val):
        if self._readonly:
            raise ValueError("This ClkMonStatus instance is read-only")
        self._ptr[0].clkMonListSize = val

    @staticmethod
    def from_data(data):
        """Create an ClkMonStatus instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `clk_mon_status_dtype` holding the data.
        """
        return __from_data(data, "clk_mon_status_dtype", clk_mon_status_dtype, ClkMonStatus)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ClkMonStatus instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ClkMonStatus obj = ClkMonStatus.__new__(ClkMonStatus)
        if owner is None:
            obj._ptr = <nvmlClkMonStatus_t *>malloc(sizeof(nvmlClkMonStatus_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ClkMonStatus")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlClkMonStatus_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlClkMonStatus_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_processes_utilization_info_v1_dtype_offsets():
    cdef nvmlProcessesUtilizationInfo_v1_t pod = nvmlProcessesUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'process_samples_count', 'last_seen_time_stamp', 'proc_util_array'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint64, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.processSamplesCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.lastSeenTimeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.procUtilArray)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlProcessesUtilizationInfo_v1_t),
    })

processes_utilization_info_v1_dtype = _get_processes_utilization_info_v1_dtype_offsets()

cdef class ProcessesUtilizationInfo_v1:
    """Empty-initialize an instance of `nvmlProcessesUtilizationInfo_v1_t`.


    .. seealso:: `nvmlProcessesUtilizationInfo_v1_t`
    """
    cdef:
        nvmlProcessesUtilizationInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlProcessesUtilizationInfo_v1_t *>calloc(1, sizeof(nvmlProcessesUtilizationInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ProcessesUtilizationInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlProcessesUtilizationInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ProcessesUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ProcessesUtilizationInfo_v1 other_
        if not isinstance(other, ProcessesUtilizationInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlProcessesUtilizationInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlProcessesUtilizationInfo_v1_t *>malloc(sizeof(nvmlProcessesUtilizationInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ProcessesUtilizationInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlProcessesUtilizationInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This ProcessesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def last_seen_time_stamp(self):
        """int: Return only samples with timestamp greater than lastSeenTimeStamp."""
        return self._ptr[0].lastSeenTimeStamp

    @last_seen_time_stamp.setter
    def last_seen_time_stamp(self, val):
        if self._readonly:
            raise ValueError("This ProcessesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].lastSeenTimeStamp = val

    @property
    def proc_util_array(self):
        """int: The array (allocated by caller) of the utilization of GPU SM, framebuffer, video encoder, video decoder, JPEG, and OFA."""
        if self._ptr[0].procUtilArray == NULL or self._ptr[0].processSamplesCount == 0:
            return []
        return ProcessUtilizationInfo_v1.from_ptr(<intptr_t>(self._ptr[0].procUtilArray), self._ptr[0].processSamplesCount)

    @proc_util_array.setter
    def proc_util_array(self, val):
        if self._readonly:
            raise ValueError("This ProcessesUtilizationInfo_v1 instance is read-only")
        cdef ProcessUtilizationInfo_v1 arr = val
        self._ptr[0].procUtilArray = <nvmlProcessUtilizationInfo_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].processSamplesCount = len(arr)
        self._refs["proc_util_array"] = arr

    @staticmethod
    def from_data(data):
        """Create an ProcessesUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `processes_utilization_info_v1_dtype` holding the data.
        """
        return __from_data(data, "processes_utilization_info_v1_dtype", processes_utilization_info_v1_dtype, ProcessesUtilizationInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ProcessesUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ProcessesUtilizationInfo_v1 obj = ProcessesUtilizationInfo_v1.__new__(ProcessesUtilizationInfo_v1)
        if owner is None:
            obj._ptr = <nvmlProcessesUtilizationInfo_v1_t *>malloc(sizeof(nvmlProcessesUtilizationInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ProcessesUtilizationInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlProcessesUtilizationInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlProcessesUtilizationInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_gpu_dynamic_pstates_info_dtype_offsets():
    cdef nvmlGpuDynamicPstatesInfo_t pod = nvmlGpuDynamicPstatesInfo_t()
    return _numpy.dtype({
        'names': ['flags_', 'utilization'],
        'formats': [_numpy.uint32, _py_anon_pod1_dtype],
        'offsets': [
            (<intptr_t>&(pod.flags)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.utilization)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuDynamicPstatesInfo_t),
    })

gpu_dynamic_pstates_info_dtype = _get_gpu_dynamic_pstates_info_dtype_offsets()

cdef class GpuDynamicPstatesInfo:
    """Empty-initialize an instance of `nvmlGpuDynamicPstatesInfo_t`.


    .. seealso:: `nvmlGpuDynamicPstatesInfo_t`
    """
    cdef:
        nvmlGpuDynamicPstatesInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuDynamicPstatesInfo_t *>calloc(1, sizeof(nvmlGpuDynamicPstatesInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuDynamicPstatesInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuDynamicPstatesInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuDynamicPstatesInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuDynamicPstatesInfo other_
        if not isinstance(other, GpuDynamicPstatesInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuDynamicPstatesInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuDynamicPstatesInfo_t *>malloc(sizeof(nvmlGpuDynamicPstatesInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuDynamicPstatesInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuDynamicPstatesInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def utilization(self):
        """_py_anon_pod1: """
        return _py_anon_pod1.from_ptr(<intptr_t>&(self._ptr[0].utilization), 8, self._readonly)

    @utilization.setter
    def utilization(self, val):
        if self._readonly:
            raise ValueError("This GpuDynamicPstatesInfo instance is read-only")
        cdef _py_anon_pod1 val_ = val
        if len(val) != 8:
            raise ValueError(f"Expected length 8 for field utilization, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].utilization), <void *>(val_._get_ptr()), sizeof(_anon_pod1) * 8)

    @property
    def flags_(self):
        """int: """
        return self._ptr[0].flags

    @flags_.setter
    def flags_(self, val):
        if self._readonly:
            raise ValueError("This GpuDynamicPstatesInfo instance is read-only")
        self._ptr[0].flags = val

    @staticmethod
    def from_data(data):
        """Create an GpuDynamicPstatesInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_dynamic_pstates_info_dtype` holding the data.
        """
        return __from_data(data, "gpu_dynamic_pstates_info_dtype", gpu_dynamic_pstates_info_dtype, GpuDynamicPstatesInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuDynamicPstatesInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuDynamicPstatesInfo obj = GpuDynamicPstatesInfo.__new__(GpuDynamicPstatesInfo)
        if owner is None:
            obj._ptr = <nvmlGpuDynamicPstatesInfo_t *>malloc(sizeof(nvmlGpuDynamicPstatesInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuDynamicPstatesInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuDynamicPstatesInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuDynamicPstatesInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_processes_utilization_info_v1_dtype_offsets():
    cdef nvmlVgpuProcessesUtilizationInfo_v1_t pod = nvmlVgpuProcessesUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'vgpu_process_count', 'last_seen_time_stamp', 'vgpu_proc_util_array'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint64, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuProcessCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.lastSeenTimeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuProcUtilArray)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t),
    })

vgpu_processes_utilization_info_v1_dtype = _get_vgpu_processes_utilization_info_v1_dtype_offsets()

cdef class VgpuProcessesUtilizationInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuProcessesUtilizationInfo_v1_t`.


    .. seealso:: `nvmlVgpuProcessesUtilizationInfo_v1_t`
    """
    cdef:
        nvmlVgpuProcessesUtilizationInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlVgpuProcessesUtilizationInfo_v1_t *>calloc(1, sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuProcessesUtilizationInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlVgpuProcessesUtilizationInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuProcessesUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuProcessesUtilizationInfo_v1 other_
        if not isinstance(other, VgpuProcessesUtilizationInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuProcessesUtilizationInfo_v1_t *>malloc(sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuProcessesUtilizationInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuProcessesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def last_seen_time_stamp(self):
        """int: Return only samples with timestamp greater than lastSeenTimeStamp."""
        return self._ptr[0].lastSeenTimeStamp

    @last_seen_time_stamp.setter
    def last_seen_time_stamp(self, val):
        if self._readonly:
            raise ValueError("This VgpuProcessesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].lastSeenTimeStamp = val

    @property
    def vgpu_proc_util_array(self):
        """int: The array (allocated by caller) in which utilization of processes running on vGPU instances are returned."""
        if self._ptr[0].vgpuProcUtilArray == NULL or self._ptr[0].vgpuProcessCount == 0:
            return []
        return VgpuProcessUtilizationInfo_v1.from_ptr(<intptr_t>(self._ptr[0].vgpuProcUtilArray), self._ptr[0].vgpuProcessCount)

    @vgpu_proc_util_array.setter
    def vgpu_proc_util_array(self, val):
        if self._readonly:
            raise ValueError("This VgpuProcessesUtilizationInfo_v1 instance is read-only")
        cdef VgpuProcessUtilizationInfo_v1 arr = val
        self._ptr[0].vgpuProcUtilArray = <nvmlVgpuProcessUtilizationInfo_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].vgpuProcessCount = len(arr)
        self._refs["vgpu_proc_util_array"] = arr

    @staticmethod
    def from_data(data):
        """Create an VgpuProcessesUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_processes_utilization_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_processes_utilization_info_v1_dtype", vgpu_processes_utilization_info_v1_dtype, VgpuProcessesUtilizationInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuProcessesUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuProcessesUtilizationInfo_v1 obj = VgpuProcessesUtilizationInfo_v1.__new__(VgpuProcessesUtilizationInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuProcessesUtilizationInfo_v1_t *>malloc(sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuProcessesUtilizationInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuProcessesUtilizationInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuProcessesUtilizationInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


vgpu_scheduler_params_dtype = _numpy.dtype((
    _numpy.dtype((_numpy.void, sizeof(nvmlVgpuSchedulerParams_t))),
    {
        "vgpu_sched_data_with_arr": (_py_anon_pod2_dtype, 0),
        "vgpu_sched_data": (_py_anon_pod3_dtype, 0),
    }
    ))


cdef class VgpuSchedulerParams:
    """Empty-initialize an instance of `nvmlVgpuSchedulerParams_t`.


    .. seealso:: `nvmlVgpuSchedulerParams_t`
    """
    cdef:
        nvmlVgpuSchedulerParams_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerParams_t *>calloc(1, sizeof(nvmlVgpuSchedulerParams_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerParams")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerParams_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerParams object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerParams other_
        if not isinstance(other, VgpuSchedulerParams):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerParams_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerParams_t *>malloc(sizeof(nvmlVgpuSchedulerParams_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerParams")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerParams_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def vgpu_sched_data_with_arr(self):
        """_py_anon_pod2: """
        return _py_anon_pod2.from_ptr(<intptr_t>&(self._ptr[0].vgpuSchedDataWithARR), self._readonly, self)

    @vgpu_sched_data_with_arr.setter
    def vgpu_sched_data_with_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerParams instance is read-only")
        cdef _py_anon_pod2 val_ = val
        memcpy(<void *>&(self._ptr[0].vgpuSchedDataWithARR), <void *>(val_._get_ptr()), sizeof(_anon_pod2) * 1)

    @property
    def vgpu_sched_data(self):
        """_py_anon_pod3: """
        return _py_anon_pod3.from_ptr(<intptr_t>&(self._ptr[0].vgpuSchedData), self._readonly, self)

    @vgpu_sched_data.setter
    def vgpu_sched_data(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerParams instance is read-only")
        cdef _py_anon_pod3 val_ = val
        memcpy(<void *>&(self._ptr[0].vgpuSchedData), <void *>(val_._get_ptr()), sizeof(_anon_pod3) * 1)

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerParams instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_params_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_params_dtype", vgpu_scheduler_params_dtype, VgpuSchedulerParams)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerParams instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerParams obj = VgpuSchedulerParams.__new__(VgpuSchedulerParams)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerParams_t *>malloc(sizeof(nvmlVgpuSchedulerParams_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerParams")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerParams_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerParams_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


vgpu_scheduler_set_params_dtype = _numpy.dtype((
    _numpy.dtype((_numpy.void, sizeof(nvmlVgpuSchedulerSetParams_t))),
    {
        "vgpu_sched_data_with_arr": (_py_anon_pod4_dtype, 0),
        "vgpu_sched_data": (_py_anon_pod5_dtype, 0),
    }
    ))


cdef class VgpuSchedulerSetParams:
    """Empty-initialize an instance of `nvmlVgpuSchedulerSetParams_t`.


    .. seealso:: `nvmlVgpuSchedulerSetParams_t`
    """
    cdef:
        nvmlVgpuSchedulerSetParams_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerSetParams_t *>calloc(1, sizeof(nvmlVgpuSchedulerSetParams_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerSetParams")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerSetParams_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerSetParams object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerSetParams other_
        if not isinstance(other, VgpuSchedulerSetParams):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerSetParams_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerSetParams_t *>malloc(sizeof(nvmlVgpuSchedulerSetParams_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerSetParams")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerSetParams_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def vgpu_sched_data_with_arr(self):
        """_py_anon_pod4: """
        return _py_anon_pod4.from_ptr(<intptr_t>&(self._ptr[0].vgpuSchedDataWithARR), self._readonly, self)

    @vgpu_sched_data_with_arr.setter
    def vgpu_sched_data_with_arr(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerSetParams instance is read-only")
        cdef _py_anon_pod4 val_ = val
        memcpy(<void *>&(self._ptr[0].vgpuSchedDataWithARR), <void *>(val_._get_ptr()), sizeof(_anon_pod4) * 1)

    @property
    def vgpu_sched_data(self):
        """_py_anon_pod5: """
        return _py_anon_pod5.from_ptr(<intptr_t>&(self._ptr[0].vgpuSchedData), self._readonly, self)

    @vgpu_sched_data.setter
    def vgpu_sched_data(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerSetParams instance is read-only")
        cdef _py_anon_pod5 val_ = val
        memcpy(<void *>&(self._ptr[0].vgpuSchedData), <void *>(val_._get_ptr()), sizeof(_anon_pod5) * 1)

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerSetParams instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_set_params_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_set_params_dtype", vgpu_scheduler_set_params_dtype, VgpuSchedulerSetParams)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerSetParams instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerSetParams obj = VgpuSchedulerSetParams.__new__(VgpuSchedulerSetParams)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerSetParams_t *>malloc(sizeof(nvmlVgpuSchedulerSetParams_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerSetParams")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerSetParams_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerSetParams_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_license_info_dtype_offsets():
    cdef nvmlVgpuLicenseInfo_t pod = nvmlVgpuLicenseInfo_t()
    return _numpy.dtype({
        'names': ['is_licensed', 'license_expiry', 'current_state'],
        'formats': [_numpy.uint8, vgpu_license_expiry_dtype, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.isLicensed)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.licenseExpiry)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.currentState)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuLicenseInfo_t),
    })

vgpu_license_info_dtype = _get_vgpu_license_info_dtype_offsets()

cdef class VgpuLicenseInfo:
    """Empty-initialize an instance of `nvmlVgpuLicenseInfo_t`.


    .. seealso:: `nvmlVgpuLicenseInfo_t`
    """
    cdef:
        nvmlVgpuLicenseInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuLicenseInfo_t *>calloc(1, sizeof(nvmlVgpuLicenseInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuLicenseInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuLicenseInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuLicenseInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuLicenseInfo other_
        if not isinstance(other, VgpuLicenseInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuLicenseInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuLicenseInfo_t *>malloc(sizeof(nvmlVgpuLicenseInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuLicenseInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuLicenseInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def license_expiry(self):
        """VgpuLicenseExpiry: """
        return VgpuLicenseExpiry.from_ptr(<intptr_t>&(self._ptr[0].licenseExpiry), self._readonly, self)

    @license_expiry.setter
    def license_expiry(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseInfo instance is read-only")
        cdef VgpuLicenseExpiry val_ = val
        memcpy(<void *>&(self._ptr[0].licenseExpiry), <void *>(val_._get_ptr()), sizeof(nvmlVgpuLicenseExpiry_t) * 1)

    @property
    def is_licensed(self):
        """int: """
        return self._ptr[0].isLicensed

    @is_licensed.setter
    def is_licensed(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseInfo instance is read-only")
        self._ptr[0].isLicensed = val

    @property
    def current_state(self):
        """int: """
        return self._ptr[0].currentState

    @current_state.setter
    def current_state(self, val):
        if self._readonly:
            raise ValueError("This VgpuLicenseInfo instance is read-only")
        self._ptr[0].currentState = val

    @staticmethod
    def from_data(data):
        """Create an VgpuLicenseInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_license_info_dtype` holding the data.
        """
        return __from_data(data, "vgpu_license_info_dtype", vgpu_license_info_dtype, VgpuLicenseInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuLicenseInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuLicenseInfo obj = VgpuLicenseInfo.__new__(VgpuLicenseInfo)
        if owner is None:
            obj._ptr = <nvmlVgpuLicenseInfo_t *>malloc(sizeof(nvmlVgpuLicenseInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuLicenseInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuLicenseInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuLicenseInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_grid_licensable_feature_dtype_offsets():
    cdef nvmlGridLicensableFeature_t pod = nvmlGridLicensableFeature_t()
    return _numpy.dtype({
        'names': ['feature_code', 'feature_state', 'license_info', 'product_name', 'feature_enabled', 'license_expiry'],
        'formats': [_numpy.int32, _numpy.uint32, _numpy.int8, _numpy.int8, _numpy.uint32, grid_license_expiry_dtype],
        'offsets': [
            (<intptr_t>&(pod.featureCode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.featureState)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.licenseInfo)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.productName)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.featureEnabled)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.licenseExpiry)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGridLicensableFeature_t),
    })

grid_licensable_feature_dtype = _get_grid_licensable_feature_dtype_offsets()

cdef class GridLicensableFeature:
    """Empty-initialize an array of `nvmlGridLicensableFeature_t`.

    The resulting object is of length `size` and of dtype `grid_licensable_feature_dtype`.
    If default-constructed, the instance represents a single struct.

    Args:
        size (int): number of structs, default=1.


    .. seealso:: `nvmlGridLicensableFeature_t`
    """
    cdef:
        readonly object _data



    def __init__(self, size=1):
        arr = _numpy.empty(size, dtype=grid_licensable_feature_dtype)
        self._data = arr.view(_numpy.recarray)
        assert self._data.itemsize == sizeof(nvmlGridLicensableFeature_t), \
            f"itemsize {self._data.itemsize} mismatches struct size { sizeof(nvmlGridLicensableFeature_t) }"

    def __repr__(self):
        if self._data.size > 1:
            return f"<{__name__}.GridLicensableFeature_Array_{self._data.size} object at {hex(id(self))}>"
        else:
            return f"<{__name__}.GridLicensableFeature object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return self._data.ctypes.data

    cdef intptr_t _get_ptr(self):
        return self._data.ctypes.data

    def __int__(self):
        if self._data.size > 1:
            raise TypeError("int() argument must be a bytes-like object of size 1. "
                            "To get the pointer address of an array, use .ptr")
        return self._data.ctypes.data

    def __len__(self):
        return self._data.size

    def __eq__(self, other):
        cdef object self_data = self._data
        if (not isinstance(other, GridLicensableFeature)) or self_data.size != other._data.size or self_data.dtype != other._data.dtype:
            return False
        return bool((self_data == other._data).all())

    @property
    def feature_code(self):
        """Union[~_numpy.int32, int]: """
        if self._data.size == 1:
            return int(self._data.feature_code[0])
        return self._data.feature_code

    @feature_code.setter
    def feature_code(self, val):
        self._data.feature_code = val

    @property
    def feature_state(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.feature_state[0])
        return self._data.feature_state

    @feature_state.setter
    def feature_state(self, val):
        self._data.feature_state = val

    @property
    def license_info(self):
        """~_numpy.int8: (array of length 128)."""
        return self._data.license_info

    @license_info.setter
    def license_info(self, val):
        self._data.license_info = val

    @property
    def product_name(self):
        """~_numpy.int8: (array of length 128)."""
        return self._data.product_name

    @product_name.setter
    def product_name(self, val):
        self._data.product_name = val

    @property
    def feature_enabled(self):
        """Union[~_numpy.uint32, int]: """
        if self._data.size == 1:
            return int(self._data.feature_enabled[0])
        return self._data.feature_enabled

    @feature_enabled.setter
    def feature_enabled(self, val):
        self._data.feature_enabled = val

    @property
    def license_expiry(self):
        """grid_license_expiry_dtype: """
        return self._data.license_expiry

    @license_expiry.setter
    def license_expiry(self, val):
        self._data.license_expiry = val

    def __getitem__(self, key):
        cdef ssize_t key_
        cdef ssize_t size
        if isinstance(key, int):
            key_ = key
            size = self._data.size
            if key_ >= size or key_ <= -(size+1):
                raise IndexError("index is out of bounds")
            if key_ < 0:
                key_ += size
            return GridLicensableFeature.from_data(self._data[key_:key_+1])
        out = self._data[key]
        if isinstance(out, _numpy.recarray) and out.dtype == grid_licensable_feature_dtype:
            return GridLicensableFeature.from_data(out)
        return out

    def __setitem__(self, key, val):
        self._data[key] = val

    @staticmethod
    def from_data(data):
        """Create an GridLicensableFeature instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a 1D array of dtype `grid_licensable_feature_dtype` holding the data.
        """
        cdef GridLicensableFeature obj = GridLicensableFeature.__new__(GridLicensableFeature)
        if not isinstance(data, _numpy.ndarray):
            raise TypeError("data argument must be a NumPy ndarray")
        if data.ndim != 1:
            raise ValueError("data array must be 1D")
        if data.dtype != grid_licensable_feature_dtype:
            raise ValueError("data array must be of dtype grid_licensable_feature_dtype")
        obj._data = data.view(_numpy.recarray)

        return obj

    @staticmethod
    def from_ptr(intptr_t ptr, size_t size=1, bint readonly=False):
        """Create an GridLicensableFeature instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            size (int): number of structs, default=1.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GridLicensableFeature obj = GridLicensableFeature.__new__(GridLicensableFeature)
        cdef flag = cpython.buffer.PyBUF_READ if readonly else cpython.buffer.PyBUF_WRITE
        cdef object buf = cpython.memoryview.PyMemoryView_FromMemory(
            <char*>ptr, sizeof(nvmlGridLicensableFeature_t) * size, flag)
        data = _numpy.ndarray(size, buffer=buf, dtype=grid_licensable_feature_dtype)
        obj._data = data.view(_numpy.recarray)

        return obj


cdef _get_unit_fan_speeds_dtype_offsets():
    cdef nvmlUnitFanSpeeds_t pod = nvmlUnitFanSpeeds_t()
    return _numpy.dtype({
        'names': ['fans', 'count'],
        'formats': [unit_fan_info_dtype, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.fans)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.count)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlUnitFanSpeeds_t),
    })

unit_fan_speeds_dtype = _get_unit_fan_speeds_dtype_offsets()

cdef class UnitFanSpeeds:
    """Empty-initialize an instance of `nvmlUnitFanSpeeds_t`.


    .. seealso:: `nvmlUnitFanSpeeds_t`
    """
    cdef:
        nvmlUnitFanSpeeds_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlUnitFanSpeeds_t *>calloc(1, sizeof(nvmlUnitFanSpeeds_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating UnitFanSpeeds")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlUnitFanSpeeds_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.UnitFanSpeeds object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef UnitFanSpeeds other_
        if not isinstance(other, UnitFanSpeeds):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlUnitFanSpeeds_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlUnitFanSpeeds_t *>malloc(sizeof(nvmlUnitFanSpeeds_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating UnitFanSpeeds")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlUnitFanSpeeds_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def fans(self):
        """UnitFanInfo: """
        return UnitFanInfo.from_ptr(<intptr_t>&(self._ptr[0].fans), 24, self._readonly)

    @fans.setter
    def fans(self, val):
        if self._readonly:
            raise ValueError("This UnitFanSpeeds instance is read-only")
        cdef UnitFanInfo val_ = val
        if len(val) != 24:
            raise ValueError(f"Expected length 24 for field fans, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].fans), <void *>(val_._get_ptr()), sizeof(nvmlUnitFanInfo_t) * 24)

    @property
    def count(self):
        """int: """
        return self._ptr[0].count

    @count.setter
    def count(self, val):
        if self._readonly:
            raise ValueError("This UnitFanSpeeds instance is read-only")
        self._ptr[0].count = val

    @staticmethod
    def from_data(data):
        """Create an UnitFanSpeeds instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `unit_fan_speeds_dtype` holding the data.
        """
        return __from_data(data, "unit_fan_speeds_dtype", unit_fan_speeds_dtype, UnitFanSpeeds)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an UnitFanSpeeds instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef UnitFanSpeeds obj = UnitFanSpeeds.__new__(UnitFanSpeeds)
        if owner is None:
            obj._ptr = <nvmlUnitFanSpeeds_t *>malloc(sizeof(nvmlUnitFanSpeeds_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating UnitFanSpeeds")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlUnitFanSpeeds_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlUnitFanSpeeds_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_pgpu_metadata_dtype_offsets():
    cdef nvmlVgpuPgpuMetadata_t pod = nvmlVgpuPgpuMetadata_t()
    return _numpy.dtype({
        'names': ['version', 'revision', 'host_driver_version', 'pgpu_virtualization_caps', 'reserved', 'host_supported_vgpu_range', 'opaque_data_size', 'opaque_data'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.int8, _numpy.uint32, _numpy.uint32, vgpu_version_dtype, _numpy.uint32, _numpy.int8],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.revision)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hostDriverVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.pgpuVirtualizationCaps)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.reserved)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.hostSupportedVgpuRange)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.opaqueDataSize)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.opaqueData)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuPgpuMetadata_t),
    })

vgpu_pgpu_metadata_dtype = _get_vgpu_pgpu_metadata_dtype_offsets()

cdef class VgpuPgpuMetadata:
    """Empty-initialize an instance of `nvmlVgpuPgpuMetadata_t`.


    .. seealso:: `nvmlVgpuPgpuMetadata_t`
    """
    cdef:
        nvmlVgpuPgpuMetadata_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuPgpuMetadata_t *>calloc(1, sizeof(nvmlVgpuPgpuMetadata_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuPgpuMetadata")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuPgpuMetadata_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuPgpuMetadata object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuPgpuMetadata other_
        if not isinstance(other, VgpuPgpuMetadata):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuPgpuMetadata_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuPgpuMetadata_t *>malloc(sizeof(nvmlVgpuPgpuMetadata_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuPgpuMetadata")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuPgpuMetadata_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def host_supported_vgpu_range(self):
        """VgpuVersion: """
        return VgpuVersion.from_ptr(<intptr_t>&(self._ptr[0].hostSupportedVgpuRange), self._readonly, self)

    @host_supported_vgpu_range.setter
    def host_supported_vgpu_range(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        cdef VgpuVersion val_ = val
        memcpy(<void *>&(self._ptr[0].hostSupportedVgpuRange), <void *>(val_._get_ptr()), sizeof(nvmlVgpuVersion_t) * 1)

    @property
    def version(self):
        """int: """
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        self._ptr[0].version = val

    @property
    def revision(self):
        """int: """
        return self._ptr[0].revision

    @revision.setter
    def revision(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        self._ptr[0].revision = val

    @property
    def host_driver_version(self):
        """~_numpy.int8: (array of length 80)."""
        return cpython.PyUnicode_FromString(self._ptr[0].hostDriverVersion)

    @host_driver_version.setter
    def host_driver_version(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 80:
            raise ValueError("String too long for field host_driver_version, max length is 79")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].hostDriverVersion), <void *>ptr, 80)

    @property
    def pgpu_virtualization_caps(self):
        """int: """
        return self._ptr[0].pgpuVirtualizationCaps

    @pgpu_virtualization_caps.setter
    def pgpu_virtualization_caps(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        self._ptr[0].pgpuVirtualizationCaps = val

    @property
    def opaque_data_size(self):
        """int: """
        return self._ptr[0].opaqueDataSize

    @opaque_data_size.setter
    def opaque_data_size(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        self._ptr[0].opaqueDataSize = val

    @property
    def opaque_data(self):
        """~_numpy.int8: (array of length 4)."""
        return cpython.PyUnicode_FromString(self._ptr[0].opaqueData)

    @opaque_data.setter
    def opaque_data(self, val):
        if self._readonly:
            raise ValueError("This VgpuPgpuMetadata instance is read-only")
        cdef bytes buf = val.encode()
        if len(buf) >= 4:
            raise ValueError("String too long for field opaque_data, max length is 3")
        cdef char *ptr = buf
        memcpy(<void *>(self._ptr[0].opaqueData), <void *>ptr, 4)

    @staticmethod
    def from_data(data):
        """Create an VgpuPgpuMetadata instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_pgpu_metadata_dtype` holding the data.
        """
        return __from_data(data, "vgpu_pgpu_metadata_dtype", vgpu_pgpu_metadata_dtype, VgpuPgpuMetadata)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuPgpuMetadata instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuPgpuMetadata obj = VgpuPgpuMetadata.__new__(VgpuPgpuMetadata)
        if owner is None:
            obj._ptr = <nvmlVgpuPgpuMetadata_t *>malloc(sizeof(nvmlVgpuPgpuMetadata_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuPgpuMetadata")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuPgpuMetadata_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuPgpuMetadata_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_gpu_instance_info_dtype_offsets():
    cdef nvmlGpuInstanceInfo_t pod = nvmlGpuInstanceInfo_t()
    return _numpy.dtype({
        'names': ['device_', 'id', 'profile_id', 'placement'],
        'formats': [_numpy.intp, _numpy.uint32, _numpy.uint32, gpu_instance_placement_dtype],
        'offsets': [
            (<intptr_t>&(pod.device)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.profileId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placement)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGpuInstanceInfo_t),
    })

gpu_instance_info_dtype = _get_gpu_instance_info_dtype_offsets()

cdef class GpuInstanceInfo:
    """Empty-initialize an instance of `nvmlGpuInstanceInfo_t`.


    .. seealso:: `nvmlGpuInstanceInfo_t`
    """
    cdef:
        nvmlGpuInstanceInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGpuInstanceInfo_t *>calloc(1, sizeof(nvmlGpuInstanceInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GpuInstanceInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGpuInstanceInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GpuInstanceInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GpuInstanceInfo other_
        if not isinstance(other, GpuInstanceInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGpuInstanceInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGpuInstanceInfo_t *>malloc(sizeof(nvmlGpuInstanceInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGpuInstanceInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def placement(self):
        """GpuInstancePlacement: """
        return GpuInstancePlacement.from_ptr(<intptr_t>&(self._ptr[0].placement), self._readonly, self)

    @placement.setter
    def placement(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceInfo instance is read-only")
        cdef GpuInstancePlacement val_ = val
        memcpy(<void *>&(self._ptr[0].placement), <void *>(val_._get_ptr()), sizeof(nvmlGpuInstancePlacement_t) * 1)

    @property
    def device_(self):
        """int: """
        return <intptr_t>(self._ptr[0].device)

    @device_.setter
    def device_(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceInfo instance is read-only")
        self._ptr[0].device = <nvmlDevice_t><intptr_t>val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceInfo instance is read-only")
        self._ptr[0].id = val

    @property
    def profile_id(self):
        """int: """
        return self._ptr[0].profileId

    @profile_id.setter
    def profile_id(self, val):
        if self._readonly:
            raise ValueError("This GpuInstanceInfo instance is read-only")
        self._ptr[0].profileId = val

    @staticmethod
    def from_data(data):
        """Create an GpuInstanceInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `gpu_instance_info_dtype` holding the data.
        """
        return __from_data(data, "gpu_instance_info_dtype", gpu_instance_info_dtype, GpuInstanceInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GpuInstanceInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GpuInstanceInfo obj = GpuInstanceInfo.__new__(GpuInstanceInfo)
        if owner is None:
            obj._ptr = <nvmlGpuInstanceInfo_t *>malloc(sizeof(nvmlGpuInstanceInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GpuInstanceInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGpuInstanceInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGpuInstanceInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_compute_instance_info_dtype_offsets():
    cdef nvmlComputeInstanceInfo_t pod = nvmlComputeInstanceInfo_t()
    return _numpy.dtype({
        'names': ['device_', 'gpu_instance', 'id', 'profile_id', 'placement'],
        'formats': [_numpy.intp, _numpy.intp, _numpy.uint32, _numpy.uint32, compute_instance_placement_dtype],
        'offsets': [
            (<intptr_t>&(pod.device)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gpuInstance)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.id)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.profileId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.placement)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlComputeInstanceInfo_t),
    })

compute_instance_info_dtype = _get_compute_instance_info_dtype_offsets()

cdef class ComputeInstanceInfo:
    """Empty-initialize an instance of `nvmlComputeInstanceInfo_t`.


    .. seealso:: `nvmlComputeInstanceInfo_t`
    """
    cdef:
        nvmlComputeInstanceInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlComputeInstanceInfo_t *>calloc(1, sizeof(nvmlComputeInstanceInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating ComputeInstanceInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlComputeInstanceInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.ComputeInstanceInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef ComputeInstanceInfo other_
        if not isinstance(other, ComputeInstanceInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlComputeInstanceInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlComputeInstanceInfo_t *>malloc(sizeof(nvmlComputeInstanceInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlComputeInstanceInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def placement(self):
        """ComputeInstancePlacement: """
        return ComputeInstancePlacement.from_ptr(<intptr_t>&(self._ptr[0].placement), self._readonly, self)

    @placement.setter
    def placement(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceInfo instance is read-only")
        cdef ComputeInstancePlacement val_ = val
        memcpy(<void *>&(self._ptr[0].placement), <void *>(val_._get_ptr()), sizeof(nvmlComputeInstancePlacement_t) * 1)

    @property
    def device_(self):
        """int: """
        return <intptr_t>(self._ptr[0].device)

    @device_.setter
    def device_(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceInfo instance is read-only")
        self._ptr[0].device = <nvmlDevice_t><intptr_t>val

    @property
    def gpu_instance(self):
        """int: """
        return <intptr_t>(self._ptr[0].gpuInstance)

    @gpu_instance.setter
    def gpu_instance(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceInfo instance is read-only")
        self._ptr[0].gpuInstance = <nvmlGpuInstance_t><intptr_t>val

    @property
    def id(self):
        """int: """
        return self._ptr[0].id

    @id.setter
    def id(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceInfo instance is read-only")
        self._ptr[0].id = val

    @property
    def profile_id(self):
        """int: """
        return self._ptr[0].profileId

    @profile_id.setter
    def profile_id(self, val):
        if self._readonly:
            raise ValueError("This ComputeInstanceInfo instance is read-only")
        self._ptr[0].profileId = val

    @staticmethod
    def from_data(data):
        """Create an ComputeInstanceInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `compute_instance_info_dtype` holding the data.
        """
        return __from_data(data, "compute_instance_info_dtype", compute_instance_info_dtype, ComputeInstanceInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an ComputeInstanceInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef ComputeInstanceInfo obj = ComputeInstanceInfo.__new__(ComputeInstanceInfo)
        if owner is None:
            obj._ptr = <nvmlComputeInstanceInfo_t *>malloc(sizeof(nvmlComputeInstanceInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating ComputeInstanceInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlComputeInstanceInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlComputeInstanceInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_ecc_sram_unique_uncorrected_error_counts_v1_dtype_offsets():
    cdef nvmlEccSramUniqueUncorrectedErrorCounts_v1_t pod = nvmlEccSramUniqueUncorrectedErrorCounts_v1_t()
    return _numpy.dtype({
        'names': ['version', 'entry_count', 'entries'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.entryCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.entries)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t),
    })

ecc_sram_unique_uncorrected_error_counts_v1_dtype = _get_ecc_sram_unique_uncorrected_error_counts_v1_dtype_offsets()

cdef class EccSramUniqueUncorrectedErrorCounts_v1:
    """Empty-initialize an instance of `nvmlEccSramUniqueUncorrectedErrorCounts_v1_t`.


    .. seealso:: `nvmlEccSramUniqueUncorrectedErrorCounts_v1_t`
    """
    cdef:
        nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *>calloc(1, sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating EccSramUniqueUncorrectedErrorCounts_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.EccSramUniqueUncorrectedErrorCounts_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef EccSramUniqueUncorrectedErrorCounts_v1 other_
        if not isinstance(other, EccSramUniqueUncorrectedErrorCounts_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *>malloc(sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating EccSramUniqueUncorrectedErrorCounts_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: the API version number"""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This EccSramUniqueUncorrectedErrorCounts_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def entries(self):
        """int: pointer to caller-supplied buffer to return the SRAM unique uncorrected ECC error count entries"""
        if self._ptr[0].entries == NULL or self._ptr[0].entryCount == 0:
            return []
        return EccSramUniqueUncorrectedErrorEntry_v1.from_ptr(<intptr_t>(self._ptr[0].entries), self._ptr[0].entryCount)

    @entries.setter
    def entries(self, val):
        if self._readonly:
            raise ValueError("This EccSramUniqueUncorrectedErrorCounts_v1 instance is read-only")
        cdef EccSramUniqueUncorrectedErrorEntry_v1 arr = val
        self._ptr[0].entries = <nvmlEccSramUniqueUncorrectedErrorEntry_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].entryCount = len(arr)
        self._refs["entries"] = arr

    @staticmethod
    def from_data(data):
        """Create an EccSramUniqueUncorrectedErrorCounts_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `ecc_sram_unique_uncorrected_error_counts_v1_dtype` holding the data.
        """
        return __from_data(data, "ecc_sram_unique_uncorrected_error_counts_v1_dtype", ecc_sram_unique_uncorrected_error_counts_v1_dtype, EccSramUniqueUncorrectedErrorCounts_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an EccSramUniqueUncorrectedErrorCounts_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef EccSramUniqueUncorrectedErrorCounts_v1 obj = EccSramUniqueUncorrectedErrorCounts_v1.__new__(EccSramUniqueUncorrectedErrorCounts_v1)
        if owner is None:
            obj._ptr = <nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *>malloc(sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating EccSramUniqueUncorrectedErrorCounts_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlEccSramUniqueUncorrectedErrorCounts_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlEccSramUniqueUncorrectedErrorCounts_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_nvlink_firmware_info_dtype_offsets():
    cdef nvmlNvlinkFirmwareInfo_t pod = nvmlNvlinkFirmwareInfo_t()
    return _numpy.dtype({
        'names': ['firmware_version', 'num_valid_entries'],
        'formats': [nvlink_firmware_version_dtype, _numpy.uint32],
        'offsets': [
            (<intptr_t>&(pod.firmwareVersion)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.numValidEntries)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvlinkFirmwareInfo_t),
    })

nvlink_firmware_info_dtype = _get_nvlink_firmware_info_dtype_offsets()

cdef class NvlinkFirmwareInfo:
    """Empty-initialize an instance of `nvmlNvlinkFirmwareInfo_t`.


    .. seealso:: `nvmlNvlinkFirmwareInfo_t`
    """
    cdef:
        nvmlNvlinkFirmwareInfo_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvlinkFirmwareInfo_t *>calloc(1, sizeof(nvmlNvlinkFirmwareInfo_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvlinkFirmwareInfo")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvlinkFirmwareInfo_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvlinkFirmwareInfo object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvlinkFirmwareInfo other_
        if not isinstance(other, NvlinkFirmwareInfo):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvlinkFirmwareInfo_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvlinkFirmwareInfo_t *>malloc(sizeof(nvmlNvlinkFirmwareInfo_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvlinkFirmwareInfo")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvlinkFirmwareInfo_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def firmware_version(self):
        """NvlinkFirmwareVersion: OUT - NVLINK firmware version."""
        return NvlinkFirmwareVersion.from_ptr(<intptr_t>&(self._ptr[0].firmwareVersion), 100, self._readonly)

    @firmware_version.setter
    def firmware_version(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareInfo instance is read-only")
        cdef NvlinkFirmwareVersion val_ = val
        if len(val) != 100:
            raise ValueError(f"Expected length 100 for field firmware_version, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].firmwareVersion), <void *>(val_._get_ptr()), sizeof(nvmlNvlinkFirmwareVersion_t) * 100)

    @property
    def num_valid_entries(self):
        """int: OUT - Number of valid firmware entries."""
        return self._ptr[0].numValidEntries

    @num_valid_entries.setter
    def num_valid_entries(self, val):
        if self._readonly:
            raise ValueError("This NvlinkFirmwareInfo instance is read-only")
        self._ptr[0].numValidEntries = val

    @staticmethod
    def from_data(data):
        """Create an NvlinkFirmwareInfo instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nvlink_firmware_info_dtype` holding the data.
        """
        return __from_data(data, "nvlink_firmware_info_dtype", nvlink_firmware_info_dtype, NvlinkFirmwareInfo)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvlinkFirmwareInfo instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvlinkFirmwareInfo obj = NvlinkFirmwareInfo.__new__(NvlinkFirmwareInfo)
        if owner is None:
            obj._ptr = <nvmlNvlinkFirmwareInfo_t *>malloc(sizeof(nvmlNvlinkFirmwareInfo_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvlinkFirmwareInfo")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvlinkFirmwareInfo_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvlinkFirmwareInfo_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_instances_utilization_info_v1_dtype_offsets():
    cdef nvmlVgpuInstancesUtilizationInfo_v1_t pod = nvmlVgpuInstancesUtilizationInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'sample_val_type', 'vgpu_instance_count', 'last_seen_time_stamp', 'vgpu_util_array'],
        'formats': [_numpy.uint32, _numpy.int32, _numpy.uint32, _numpy.uint64, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.sampleValType)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuInstanceCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.lastSeenTimeStamp)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.vgpuUtilArray)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t),
    })

vgpu_instances_utilization_info_v1_dtype = _get_vgpu_instances_utilization_info_v1_dtype_offsets()

cdef class VgpuInstancesUtilizationInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuInstancesUtilizationInfo_v1_t`.


    .. seealso:: `nvmlVgpuInstancesUtilizationInfo_v1_t`
    """
    cdef:
        nvmlVgpuInstancesUtilizationInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlVgpuInstancesUtilizationInfo_v1_t *>calloc(1, sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuInstancesUtilizationInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlVgpuInstancesUtilizationInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuInstancesUtilizationInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuInstancesUtilizationInfo_v1 other_
        if not isinstance(other, VgpuInstancesUtilizationInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuInstancesUtilizationInfo_v1_t *>malloc(sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuInstancesUtilizationInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def version(self):
        """int: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuInstancesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def sample_val_type(self):
        """int: Hold the type of returned sample values."""
        return <int>(self._ptr[0].sampleValType)

    @sample_val_type.setter
    def sample_val_type(self, val):
        if self._readonly:
            raise ValueError("This VgpuInstancesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].sampleValType = <nvmlValueType_t><int>val

    @property
    def last_seen_time_stamp(self):
        """int: Return only samples with timestamp greater than lastSeenTimeStamp."""
        return self._ptr[0].lastSeenTimeStamp

    @last_seen_time_stamp.setter
    def last_seen_time_stamp(self, val):
        if self._readonly:
            raise ValueError("This VgpuInstancesUtilizationInfo_v1 instance is read-only")
        self._ptr[0].lastSeenTimeStamp = val

    @property
    def vgpu_util_array(self):
        """int: The array (allocated by caller) in which vGPU utilization are returned."""
        if self._ptr[0].vgpuUtilArray == NULL or self._ptr[0].vgpuInstanceCount == 0:
            return []
        return VgpuInstanceUtilizationInfo_v1.from_ptr(<intptr_t>(self._ptr[0].vgpuUtilArray), self._ptr[0].vgpuInstanceCount)

    @vgpu_util_array.setter
    def vgpu_util_array(self, val):
        if self._readonly:
            raise ValueError("This VgpuInstancesUtilizationInfo_v1 instance is read-only")
        cdef VgpuInstanceUtilizationInfo_v1 arr = val
        self._ptr[0].vgpuUtilArray = <nvmlVgpuInstanceUtilizationInfo_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].vgpuInstanceCount = len(arr)
        self._refs["vgpu_util_array"] = arr

    @staticmethod
    def from_data(data):
        """Create an VgpuInstancesUtilizationInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_instances_utilization_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_instances_utilization_info_v1_dtype", vgpu_instances_utilization_info_v1_dtype, VgpuInstancesUtilizationInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuInstancesUtilizationInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuInstancesUtilizationInfo_v1 obj = VgpuInstancesUtilizationInfo_v1.__new__(VgpuInstancesUtilizationInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuInstancesUtilizationInfo_v1_t *>malloc(sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuInstancesUtilizationInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuInstancesUtilizationInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuInstancesUtilizationInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj


cdef _get_prm_counter_v1_dtype_offsets():
    cdef nvmlPRMCounter_v1_t pod = nvmlPRMCounter_v1_t()
    return _numpy.dtype({
        'names': ['counter_id', 'in_data', 'counter_value'],
        'formats': [_numpy.uint32, prm_counter_input_v1_dtype, prm_counter_value_v1_dtype],
        'offsets': [
            (<intptr_t>&(pod.counterId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.inData)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.counterValue)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPRMCounter_v1_t),
    })

prm_counter_v1_dtype = _get_prm_counter_v1_dtype_offsets()

cdef class PRMCounter_v1:
    """Empty-initialize an instance of `nvmlPRMCounter_v1_t`.


    .. seealso:: `nvmlPRMCounter_v1_t`
    """
    cdef:
        nvmlPRMCounter_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlPRMCounter_v1_t *>calloc(1, sizeof(nvmlPRMCounter_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PRMCounter_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlPRMCounter_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PRMCounter_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PRMCounter_v1 other_
        if not isinstance(other, PRMCounter_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPRMCounter_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPRMCounter_v1_t *>malloc(sizeof(nvmlPRMCounter_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PRMCounter_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPRMCounter_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def in_data(self):
        """PRMCounterInput_v1: PRM input values."""
        return PRMCounterInput_v1.from_ptr(<intptr_t>&(self._ptr[0].inData), self._readonly, self)

    @in_data.setter
    def in_data(self, val):
        if self._readonly:
            raise ValueError("This PRMCounter_v1 instance is read-only")
        cdef PRMCounterInput_v1 val_ = val
        memcpy(<void *>&(self._ptr[0].inData), <void *>(val_._get_ptr()), sizeof(nvmlPRMCounterInput_v1_t) * 1)

    @property
    def counter_value(self):
        """PRMCounterValue_v1: Counter value."""
        return PRMCounterValue_v1.from_ptr(<intptr_t>&(self._ptr[0].counterValue), self._readonly, self)

    @counter_value.setter
    def counter_value(self, val):
        if self._readonly:
            raise ValueError("This PRMCounter_v1 instance is read-only")
        cdef PRMCounterValue_v1 val_ = val
        memcpy(<void *>&(self._ptr[0].counterValue), <void *>(val_._get_ptr()), sizeof(nvmlPRMCounterValue_v1_t) * 1)

    @property
    def counter_id(self):
        """int: Counter ID, one of nvmlPRMCounterId_t."""
        return self._ptr[0].counterId

    @counter_id.setter
    def counter_id(self, val):
        if self._readonly:
            raise ValueError("This PRMCounter_v1 instance is read-only")
        self._ptr[0].counterId = val

    @staticmethod
    def from_data(data):
        """Create an PRMCounter_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `prm_counter_v1_dtype` holding the data.
        """
        return __from_data(data, "prm_counter_v1_dtype", prm_counter_v1_dtype, PRMCounter_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PRMCounter_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PRMCounter_v1 obj = PRMCounter_v1.__new__(PRMCounter_v1)
        if owner is None:
            obj._ptr = <nvmlPRMCounter_v1_t *>malloc(sizeof(nvmlPRMCounter_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PRMCounter_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPRMCounter_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPRMCounter_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_log_dtype_offsets():
    cdef nvmlVgpuSchedulerLog_t pod = nvmlVgpuSchedulerLog_t()
    return _numpy.dtype({
        'names': ['engine_id', 'scheduler_policy', 'arr_mode', 'scheduler_params', 'entries_count', 'log_entries'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, vgpu_scheduler_params_dtype, _numpy.uint32, vgpu_scheduler_log_entry_dtype],
        'offsets': [
            (<intptr_t>&(pod.engineId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerPolicy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.arrMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerParams)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.entriesCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.logEntries)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerLog_t),
    })

vgpu_scheduler_log_dtype = _get_vgpu_scheduler_log_dtype_offsets()

cdef class VgpuSchedulerLog:
    """Empty-initialize an instance of `nvmlVgpuSchedulerLog_t`.


    .. seealso:: `nvmlVgpuSchedulerLog_t`
    """
    cdef:
        nvmlVgpuSchedulerLog_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerLog_t *>calloc(1, sizeof(nvmlVgpuSchedulerLog_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerLog")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerLog_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerLog object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerLog other_
        if not isinstance(other, VgpuSchedulerLog):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerLog_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerLog_t *>malloc(sizeof(nvmlVgpuSchedulerLog_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerLog")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerLog_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def scheduler_params(self):
        """VgpuSchedulerParams: """
        return VgpuSchedulerParams.from_ptr(<intptr_t>&(self._ptr[0].schedulerParams), self._readonly, self)

    @scheduler_params.setter
    def scheduler_params(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        cdef VgpuSchedulerParams val_ = val
        memcpy(<void *>&(self._ptr[0].schedulerParams), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerParams_t) * 1)

    @property
    def log_entries(self):
        """VgpuSchedulerLogEntry: """
        return VgpuSchedulerLogEntry.from_ptr(<intptr_t>&(self._ptr[0].logEntries), 200, self._readonly)

    @log_entries.setter
    def log_entries(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        cdef VgpuSchedulerLogEntry val_ = val
        if len(val) != 200:
            raise ValueError(f"Expected length 200 for field log_entries, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].logEntries), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerLogEntry_t) * 200)

    @property
    def engine_id(self):
        """int: """
        return self._ptr[0].engineId

    @engine_id.setter
    def engine_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        self._ptr[0].engineId = val

    @property
    def scheduler_policy(self):
        """int: """
        return self._ptr[0].schedulerPolicy

    @scheduler_policy.setter
    def scheduler_policy(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        self._ptr[0].schedulerPolicy = val

    @property
    def arr_mode(self):
        """int: """
        return self._ptr[0].arrMode

    @arr_mode.setter
    def arr_mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        self._ptr[0].arrMode = val

    @property
    def entries_count(self):
        """int: """
        return self._ptr[0].entriesCount

    @entries_count.setter
    def entries_count(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLog instance is read-only")
        self._ptr[0].entriesCount = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerLog instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_log_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_log_dtype", vgpu_scheduler_log_dtype, VgpuSchedulerLog)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerLog instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerLog obj = VgpuSchedulerLog.__new__(VgpuSchedulerLog)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerLog_t *>malloc(sizeof(nvmlVgpuSchedulerLog_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerLog")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerLog_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerLog_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_get_state_dtype_offsets():
    cdef nvmlVgpuSchedulerGetState_t pod = nvmlVgpuSchedulerGetState_t()
    return _numpy.dtype({
        'names': ['scheduler_policy', 'arr_mode', 'scheduler_params'],
        'formats': [_numpy.uint32, _numpy.uint32, vgpu_scheduler_params_dtype],
        'offsets': [
            (<intptr_t>&(pod.schedulerPolicy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.arrMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerParams)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerGetState_t),
    })

vgpu_scheduler_get_state_dtype = _get_vgpu_scheduler_get_state_dtype_offsets()

cdef class VgpuSchedulerGetState:
    """Empty-initialize an instance of `nvmlVgpuSchedulerGetState_t`.


    .. seealso:: `nvmlVgpuSchedulerGetState_t`
    """
    cdef:
        nvmlVgpuSchedulerGetState_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerGetState_t *>calloc(1, sizeof(nvmlVgpuSchedulerGetState_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerGetState")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerGetState_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerGetState object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerGetState other_
        if not isinstance(other, VgpuSchedulerGetState):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerGetState_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerGetState_t *>malloc(sizeof(nvmlVgpuSchedulerGetState_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerGetState")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerGetState_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def scheduler_params(self):
        """VgpuSchedulerParams: """
        return VgpuSchedulerParams.from_ptr(<intptr_t>&(self._ptr[0].schedulerParams), self._readonly, self)

    @scheduler_params.setter
    def scheduler_params(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerGetState instance is read-only")
        cdef VgpuSchedulerParams val_ = val
        memcpy(<void *>&(self._ptr[0].schedulerParams), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerParams_t) * 1)

    @property
    def scheduler_policy(self):
        """int: """
        return self._ptr[0].schedulerPolicy

    @scheduler_policy.setter
    def scheduler_policy(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerGetState instance is read-only")
        self._ptr[0].schedulerPolicy = val

    @property
    def arr_mode(self):
        """int: """
        return self._ptr[0].arrMode

    @arr_mode.setter
    def arr_mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerGetState instance is read-only")
        self._ptr[0].arrMode = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerGetState instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_get_state_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_get_state_dtype", vgpu_scheduler_get_state_dtype, VgpuSchedulerGetState)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerGetState instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerGetState obj = VgpuSchedulerGetState.__new__(VgpuSchedulerGetState)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerGetState_t *>malloc(sizeof(nvmlVgpuSchedulerGetState_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerGetState")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerGetState_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerGetState_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_state_info_v1_dtype_offsets():
    cdef nvmlVgpuSchedulerStateInfo_v1_t pod = nvmlVgpuSchedulerStateInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'engine_id', 'scheduler_policy', 'arr_mode', 'scheduler_params'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, vgpu_scheduler_params_dtype],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.engineId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerPolicy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.arrMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerParams)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerStateInfo_v1_t),
    })

vgpu_scheduler_state_info_v1_dtype = _get_vgpu_scheduler_state_info_v1_dtype_offsets()

cdef class VgpuSchedulerStateInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuSchedulerStateInfo_v1_t`.


    .. seealso:: `nvmlVgpuSchedulerStateInfo_v1_t`
    """
    cdef:
        nvmlVgpuSchedulerStateInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerStateInfo_v1_t *>calloc(1, sizeof(nvmlVgpuSchedulerStateInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerStateInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerStateInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerStateInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerStateInfo_v1 other_
        if not isinstance(other, VgpuSchedulerStateInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerStateInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerStateInfo_v1_t *>malloc(sizeof(nvmlVgpuSchedulerStateInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerStateInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerStateInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def scheduler_params(self):
        """VgpuSchedulerParams: OUT: vGPU Scheduler Parameters."""
        return VgpuSchedulerParams.from_ptr(<intptr_t>&(self._ptr[0].schedulerParams), self._readonly, self)

    @scheduler_params.setter
    def scheduler_params(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerStateInfo_v1 instance is read-only")
        cdef VgpuSchedulerParams val_ = val
        memcpy(<void *>&(self._ptr[0].schedulerParams), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerParams_t) * 1)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerStateInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def engine_id(self):
        """int: IN: Engine whose software scheduler state info is fetched. One of NVML_VGPU_SCHEDULER_ENGINE_TYPE_*."""
        return self._ptr[0].engineId

    @engine_id.setter
    def engine_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerStateInfo_v1 instance is read-only")
        self._ptr[0].engineId = val

    @property
    def scheduler_policy(self):
        """int: OUT: Scheduler policy."""
        return self._ptr[0].schedulerPolicy

    @scheduler_policy.setter
    def scheduler_policy(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerStateInfo_v1 instance is read-only")
        self._ptr[0].schedulerPolicy = val

    @property
    def arr_mode(self):
        """int: OUT: Adaptive Round Robin scheduler mode. One of the NVML_VGPU_SCHEDULER_ARR_*."""
        return self._ptr[0].arrMode

    @arr_mode.setter
    def arr_mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerStateInfo_v1 instance is read-only")
        self._ptr[0].arrMode = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerStateInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_state_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_state_info_v1_dtype", vgpu_scheduler_state_info_v1_dtype, VgpuSchedulerStateInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerStateInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerStateInfo_v1 obj = VgpuSchedulerStateInfo_v1.__new__(VgpuSchedulerStateInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerStateInfo_v1_t *>malloc(sizeof(nvmlVgpuSchedulerStateInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerStateInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerStateInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerStateInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_log_info_v1_dtype_offsets():
    cdef nvmlVgpuSchedulerLogInfo_v1_t pod = nvmlVgpuSchedulerLogInfo_v1_t()
    return _numpy.dtype({
        'names': ['version', 'engine_id', 'scheduler_policy', 'arr_mode', 'scheduler_params', 'entries_count', 'log_entries'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, vgpu_scheduler_params_dtype, _numpy.uint32, vgpu_scheduler_log_entry_dtype],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.engineId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerPolicy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.arrMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerParams)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.entriesCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.logEntries)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerLogInfo_v1_t),
    })

vgpu_scheduler_log_info_v1_dtype = _get_vgpu_scheduler_log_info_v1_dtype_offsets()

cdef class VgpuSchedulerLogInfo_v1:
    """Empty-initialize an instance of `nvmlVgpuSchedulerLogInfo_v1_t`.


    .. seealso:: `nvmlVgpuSchedulerLogInfo_v1_t`
    """
    cdef:
        nvmlVgpuSchedulerLogInfo_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerLogInfo_v1_t *>calloc(1, sizeof(nvmlVgpuSchedulerLogInfo_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerLogInfo_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerLogInfo_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerLogInfo_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerLogInfo_v1 other_
        if not isinstance(other, VgpuSchedulerLogInfo_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerLogInfo_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerLogInfo_v1_t *>malloc(sizeof(nvmlVgpuSchedulerLogInfo_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerLogInfo_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerLogInfo_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def scheduler_params(self):
        """VgpuSchedulerParams: OUT: vGPU Scheduler Parameters."""
        return VgpuSchedulerParams.from_ptr(<intptr_t>&(self._ptr[0].schedulerParams), self._readonly, self)

    @scheduler_params.setter
    def scheduler_params(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        cdef VgpuSchedulerParams val_ = val
        memcpy(<void *>&(self._ptr[0].schedulerParams), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerParams_t) * 1)

    @property
    def log_entries(self):
        """VgpuSchedulerLogEntry: OUT: Structure to store the state and logs of a software runlist."""
        return VgpuSchedulerLogEntry.from_ptr(<intptr_t>&(self._ptr[0].logEntries), 200, self._readonly)

    @log_entries.setter
    def log_entries(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        cdef VgpuSchedulerLogEntry val_ = val
        if len(val) != 200:
            raise ValueError(f"Expected length 200 for field log_entries, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].logEntries), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerLogEntry_t) * 200)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def engine_id(self):
        """int: IN: Engine whose software runlist log entries are fetched. One of One of NVML_VGPU_SCHEDULER_ENGINE_TYPE_*."""
        return self._ptr[0].engineId

    @engine_id.setter
    def engine_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        self._ptr[0].engineId = val

    @property
    def scheduler_policy(self):
        """int: OUT: Scheduler policy."""
        return self._ptr[0].schedulerPolicy

    @scheduler_policy.setter
    def scheduler_policy(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        self._ptr[0].schedulerPolicy = val

    @property
    def arr_mode(self):
        """int: OUT: Adaptive Round Robin scheduler mode. One of the NVML_VGPU_SCHEDULER_ARR_*."""
        return self._ptr[0].arrMode

    @arr_mode.setter
    def arr_mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        self._ptr[0].arrMode = val

    @property
    def entries_count(self):
        """int: OUT: Count of log entries fetched."""
        return self._ptr[0].entriesCount

    @entries_count.setter
    def entries_count(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerLogInfo_v1 instance is read-only")
        self._ptr[0].entriesCount = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerLogInfo_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_log_info_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_log_info_v1_dtype", vgpu_scheduler_log_info_v1_dtype, VgpuSchedulerLogInfo_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerLogInfo_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerLogInfo_v1 obj = VgpuSchedulerLogInfo_v1.__new__(VgpuSchedulerLogInfo_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerLogInfo_v1_t *>malloc(sizeof(nvmlVgpuSchedulerLogInfo_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerLogInfo_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerLogInfo_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerLogInfo_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_vgpu_scheduler_state_v1_dtype_offsets():
    cdef nvmlVgpuSchedulerState_v1_t pod = nvmlVgpuSchedulerState_v1_t()
    return _numpy.dtype({
        'names': ['version', 'engine_id', 'scheduler_policy', 'enable_arr_mode', 'scheduler_params'],
        'formats': [_numpy.uint32, _numpy.uint32, _numpy.uint32, _numpy.uint32, vgpu_scheduler_set_params_dtype],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.engineId)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerPolicy)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.enableARRMode)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.schedulerParams)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlVgpuSchedulerState_v1_t),
    })

vgpu_scheduler_state_v1_dtype = _get_vgpu_scheduler_state_v1_dtype_offsets()

cdef class VgpuSchedulerState_v1:
    """Empty-initialize an instance of `nvmlVgpuSchedulerState_v1_t`.


    .. seealso:: `nvmlVgpuSchedulerState_v1_t`
    """
    cdef:
        nvmlVgpuSchedulerState_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlVgpuSchedulerState_v1_t *>calloc(1, sizeof(nvmlVgpuSchedulerState_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating VgpuSchedulerState_v1")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlVgpuSchedulerState_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.VgpuSchedulerState_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef VgpuSchedulerState_v1 other_
        if not isinstance(other, VgpuSchedulerState_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlVgpuSchedulerState_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlVgpuSchedulerState_v1_t *>malloc(sizeof(nvmlVgpuSchedulerState_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerState_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlVgpuSchedulerState_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def scheduler_params(self):
        """VgpuSchedulerSetParams: IN: vGPU Scheduler Parameters."""
        return VgpuSchedulerSetParams.from_ptr(<intptr_t>&(self._ptr[0].schedulerParams), self._readonly, self)

    @scheduler_params.setter
    def scheduler_params(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerState_v1 instance is read-only")
        cdef VgpuSchedulerSetParams val_ = val
        memcpy(<void *>&(self._ptr[0].schedulerParams), <void *>(val_._get_ptr()), sizeof(nvmlVgpuSchedulerSetParams_t) * 1)

    @property
    def version(self):
        """int: IN: The version number of this struct."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerState_v1 instance is read-only")
        self._ptr[0].version = val

    @property
    def engine_id(self):
        """int: IN: One of NVML_VGPU_SCHEDULER_ENGINE_TYPE_*."""
        return self._ptr[0].engineId

    @engine_id.setter
    def engine_id(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerState_v1 instance is read-only")
        self._ptr[0].engineId = val

    @property
    def scheduler_policy(self):
        """int: IN: Scheduler policy."""
        return self._ptr[0].schedulerPolicy

    @scheduler_policy.setter
    def scheduler_policy(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerState_v1 instance is read-only")
        self._ptr[0].schedulerPolicy = val

    @property
    def enable_arr_mode(self):
        """int: IN: Adaptive Round Robin scheduler."""
        return self._ptr[0].enableARRMode

    @enable_arr_mode.setter
    def enable_arr_mode(self, val):
        if self._readonly:
            raise ValueError("This VgpuSchedulerState_v1 instance is read-only")
        self._ptr[0].enableARRMode = val

    @staticmethod
    def from_data(data):
        """Create an VgpuSchedulerState_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `vgpu_scheduler_state_v1_dtype` holding the data.
        """
        return __from_data(data, "vgpu_scheduler_state_v1_dtype", vgpu_scheduler_state_v1_dtype, VgpuSchedulerState_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an VgpuSchedulerState_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef VgpuSchedulerState_v1 obj = VgpuSchedulerState_v1.__new__(VgpuSchedulerState_v1)
        if owner is None:
            obj._ptr = <nvmlVgpuSchedulerState_v1_t *>malloc(sizeof(nvmlVgpuSchedulerState_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating VgpuSchedulerState_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlVgpuSchedulerState_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlVgpuSchedulerState_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_grid_licensable_features_dtype_offsets():
    cdef nvmlGridLicensableFeatures_t pod = nvmlGridLicensableFeatures_t()
    return _numpy.dtype({
        'names': ['is_grid_license_supported', 'licensable_features_count', 'grid_licensable_features'],
        'formats': [_numpy.int32, _numpy.uint32, grid_licensable_feature_dtype],
        'offsets': [
            (<intptr_t>&(pod.isGridLicenseSupported)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.licensableFeaturesCount)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.gridLicensableFeatures)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlGridLicensableFeatures_t),
    })

grid_licensable_features_dtype = _get_grid_licensable_features_dtype_offsets()

cdef class GridLicensableFeatures:
    """Empty-initialize an instance of `nvmlGridLicensableFeatures_t`.


    .. seealso:: `nvmlGridLicensableFeatures_t`
    """
    cdef:
        nvmlGridLicensableFeatures_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlGridLicensableFeatures_t *>calloc(1, sizeof(nvmlGridLicensableFeatures_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating GridLicensableFeatures")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlGridLicensableFeatures_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.GridLicensableFeatures object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef GridLicensableFeatures other_
        if not isinstance(other, GridLicensableFeatures):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlGridLicensableFeatures_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlGridLicensableFeatures_t *>malloc(sizeof(nvmlGridLicensableFeatures_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating GridLicensableFeatures")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlGridLicensableFeatures_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def grid_licensable_features(self):
        """GridLicensableFeature: """
        return GridLicensableFeature.from_ptr(<intptr_t>&(self._ptr[0].gridLicensableFeatures), 3, self._readonly)

    @grid_licensable_features.setter
    def grid_licensable_features(self, val):
        if self._readonly:
            raise ValueError("This GridLicensableFeatures instance is read-only")
        cdef GridLicensableFeature val_ = val
        if len(val) != 3:
            raise ValueError(f"Expected length 3 for field grid_licensable_features, got {len(val)}")
        memcpy(<void *>&(self._ptr[0].gridLicensableFeatures), <void *>(val_._get_ptr()), sizeof(nvmlGridLicensableFeature_t) * 3)

    @property
    def is_grid_license_supported(self):
        """int: """
        return self._ptr[0].isGridLicenseSupported

    @is_grid_license_supported.setter
    def is_grid_license_supported(self, val):
        if self._readonly:
            raise ValueError("This GridLicensableFeatures instance is read-only")
        self._ptr[0].isGridLicenseSupported = val

    @property
    def licensable_features_count(self):
        """int: """
        return self._ptr[0].licensableFeaturesCount

    @licensable_features_count.setter
    def licensable_features_count(self, val):
        if self._readonly:
            raise ValueError("This GridLicensableFeatures instance is read-only")
        self._ptr[0].licensableFeaturesCount = val

    @staticmethod
    def from_data(data):
        """Create an GridLicensableFeatures instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `grid_licensable_features_dtype` holding the data.
        """
        return __from_data(data, "grid_licensable_features_dtype", grid_licensable_features_dtype, GridLicensableFeatures)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an GridLicensableFeatures instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef GridLicensableFeatures obj = GridLicensableFeatures.__new__(GridLicensableFeatures)
        if owner is None:
            obj._ptr = <nvmlGridLicensableFeatures_t *>malloc(sizeof(nvmlGridLicensableFeatures_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating GridLicensableFeatures")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlGridLicensableFeatures_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlGridLicensableFeatures_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_nv_link_info_v2_dtype_offsets():
    cdef nvmlNvLinkInfo_v2_t pod = nvmlNvLinkInfo_v2_t()
    return _numpy.dtype({
        'names': ['version', 'is_nvle_enabled', 'firmware_info'],
        'formats': [_numpy.uint32, _numpy.uint32, nvlink_firmware_info_dtype],
        'offsets': [
            (<intptr_t>&(pod.version)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.isNvleEnabled)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.firmwareInfo)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlNvLinkInfo_v2_t),
    })

nv_link_info_v2_dtype = _get_nv_link_info_v2_dtype_offsets()

cdef class NvLinkInfo_v2:
    """Empty-initialize an instance of `nvmlNvLinkInfo_v2_t`.


    .. seealso:: `nvmlNvLinkInfo_v2_t`
    """
    cdef:
        nvmlNvLinkInfo_v2_t *_ptr
        object _owner
        bint _owned
        bint _readonly

    def __init__(self):
        self._ptr = <nvmlNvLinkInfo_v2_t *>calloc(1, sizeof(nvmlNvLinkInfo_v2_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating NvLinkInfo_v2")
        self._owner = None
        self._owned = True
        self._readonly = False

    def __dealloc__(self):
        cdef nvmlNvLinkInfo_v2_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.NvLinkInfo_v2 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef NvLinkInfo_v2 other_
        if not isinstance(other, NvLinkInfo_v2):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlNvLinkInfo_v2_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlNvLinkInfo_v2_t *>malloc(sizeof(nvmlNvLinkInfo_v2_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating NvLinkInfo_v2")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlNvLinkInfo_v2_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def firmware_info(self):
        """NvlinkFirmwareInfo: OUT - NVLINK Firmware info."""
        return NvlinkFirmwareInfo.from_ptr(<intptr_t>&(self._ptr[0].firmwareInfo), self._readonly, self)

    @firmware_info.setter
    def firmware_info(self, val):
        if self._readonly:
            raise ValueError("This NvLinkInfo_v2 instance is read-only")
        cdef NvlinkFirmwareInfo val_ = val
        memcpy(<void *>&(self._ptr[0].firmwareInfo), <void *>(val_._get_ptr()), sizeof(nvmlNvlinkFirmwareInfo_t) * 1)

    @property
    def version(self):
        """int: IN - the API version number."""
        return self._ptr[0].version

    @version.setter
    def version(self, val):
        if self._readonly:
            raise ValueError("This NvLinkInfo_v2 instance is read-only")
        self._ptr[0].version = val

    @property
    def is_nvle_enabled(self):
        """int: OUT - NVLINK encryption enablement."""
        return self._ptr[0].isNvleEnabled

    @is_nvle_enabled.setter
    def is_nvle_enabled(self, val):
        if self._readonly:
            raise ValueError("This NvLinkInfo_v2 instance is read-only")
        self._ptr[0].isNvleEnabled = val

    @staticmethod
    def from_data(data):
        """Create an NvLinkInfo_v2 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `nv_link_info_v2_dtype` holding the data.
        """
        return __from_data(data, "nv_link_info_v2_dtype", nv_link_info_v2_dtype, NvLinkInfo_v2)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an NvLinkInfo_v2 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef NvLinkInfo_v2 obj = NvLinkInfo_v2.__new__(NvLinkInfo_v2)
        if owner is None:
            obj._ptr = <nvmlNvLinkInfo_v2_t *>malloc(sizeof(nvmlNvLinkInfo_v2_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating NvLinkInfo_v2")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlNvLinkInfo_v2_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlNvLinkInfo_v2_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        return obj


cdef _get_prm_counter_list_v1_dtype_offsets():
    cdef nvmlPRMCounterList_v1_t pod = nvmlPRMCounterList_v1_t()
    return _numpy.dtype({
        'names': ['num_counters', 'counters'],
        'formats': [_numpy.uint32, _numpy.intp],
        'offsets': [
            (<intptr_t>&(pod.numCounters)) - (<intptr_t>&pod),
            (<intptr_t>&(pod.counters)) - (<intptr_t>&pod),
        ],
        'itemsize': sizeof(nvmlPRMCounterList_v1_t),
    })

prm_counter_list_v1_dtype = _get_prm_counter_list_v1_dtype_offsets()

cdef class PRMCounterList_v1:
    """Empty-initialize an instance of `nvmlPRMCounterList_v1_t`.


    .. seealso:: `nvmlPRMCounterList_v1_t`
    """
    cdef:
        nvmlPRMCounterList_v1_t *_ptr
        object _owner
        bint _owned
        bint _readonly
        dict _refs

    def __init__(self):
        self._ptr = <nvmlPRMCounterList_v1_t *>calloc(1, sizeof(nvmlPRMCounterList_v1_t))
        if self._ptr == NULL:
            raise MemoryError("Error allocating PRMCounterList_v1")
        self._owner = None
        self._owned = True
        self._readonly = False
        self._refs = {}

    def __dealloc__(self):
        cdef nvmlPRMCounterList_v1_t *ptr
        if self._owned and self._ptr != NULL:
            ptr = self._ptr
            self._ptr = NULL
            free(ptr)

    def __repr__(self):
        return f"<{__name__}.PRMCounterList_v1 object at {hex(id(self))}>"

    @property
    def ptr(self):
        """Get the pointer address to the data as Python :class:`int`."""
        return <intptr_t>(self._ptr)

    cdef intptr_t _get_ptr(self):
        return <intptr_t>(self._ptr)

    def __int__(self):
        return <intptr_t>(self._ptr)

    def __eq__(self, other):
        cdef PRMCounterList_v1 other_
        if not isinstance(other, PRMCounterList_v1):
            return False
        other_ = other
        return (memcmp(<void *><intptr_t>(self._ptr), <void *><intptr_t>(other_._ptr), sizeof(nvmlPRMCounterList_v1_t)) == 0)

    def __setitem__(self, key, val):
        if key == 0 and isinstance(val, _numpy.ndarray):
            self._ptr = <nvmlPRMCounterList_v1_t *>malloc(sizeof(nvmlPRMCounterList_v1_t))
            if self._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterList_v1")
            memcpy(<void*>self._ptr, <void*><intptr_t>val.ctypes.data, sizeof(nvmlPRMCounterList_v1_t))
            self._owner = None
            self._owned = True
            self._readonly = not val.flags.writeable
        else:
            setattr(self, key, val)

    @property
    def counters(self):
        """int: Pointer to array of PRM counters."""
        if self._ptr[0].counters == NULL or self._ptr[0].numCounters == 0:
            return []
        return PRMCounter_v1.from_ptr(<intptr_t>(self._ptr[0].counters), self._ptr[0].numCounters)

    @counters.setter
    def counters(self, val):
        if self._readonly:
            raise ValueError("This PRMCounterList_v1 instance is read-only")
        cdef PRMCounter_v1 arr = val
        self._ptr[0].counters = <nvmlPRMCounter_v1_t*><intptr_t>(arr._get_ptr())
        self._ptr[0].numCounters = len(arr)
        self._refs["counters"] = arr

    @staticmethod
    def from_data(data):
        """Create an PRMCounterList_v1 instance wrapping the given NumPy array.

        Args:
            data (_numpy.ndarray): a single-element array of dtype `prm_counter_list_v1_dtype` holding the data.
        """
        return __from_data(data, "prm_counter_list_v1_dtype", prm_counter_list_v1_dtype, PRMCounterList_v1)

    @staticmethod
    def from_ptr(intptr_t ptr, bint readonly=False, object owner=None):
        """Create an PRMCounterList_v1 instance wrapping the given pointer.

        Args:
            ptr (intptr_t): pointer address as Python :class:`int` to the data.
            owner (object): The Python object that owns the pointer. If not provided, data will be copied.
            readonly (bool): whether the data is read-only (to the user). default is `False`.
        """
        if ptr == 0:
            raise ValueError("ptr must not be null (0)")
        cdef PRMCounterList_v1 obj = PRMCounterList_v1.__new__(PRMCounterList_v1)
        if owner is None:
            obj._ptr = <nvmlPRMCounterList_v1_t *>malloc(sizeof(nvmlPRMCounterList_v1_t))
            if obj._ptr == NULL:
                raise MemoryError("Error allocating PRMCounterList_v1")
            memcpy(<void*>(obj._ptr), <void*>ptr, sizeof(nvmlPRMCounterList_v1_t))
            obj._owner = None
            obj._owned = True
        else:
            obj._ptr = <nvmlPRMCounterList_v1_t *>ptr
            obj._owner = owner
            obj._owned = False
        obj._readonly = readonly
        obj._refs = {}
        return obj



cpdef init_v2():
    """Initialize NVML, but don't initialize any GPUs yet.

    .. seealso:: `nvmlInit_v2`
    """
    with nogil:
        __status__ = nvmlInit_v2()
    check_status(__status__)


cpdef init_with_flags(unsigned int flags):
    """nvmlInitWithFlags is a variant of nvmlInit(), that allows passing a set of boolean values modifying the behaviour of nvmlInit(). Other than the "flags" parameter it is completely similar to ``nvmlInit_v2``.

    Args:
        flags (unsigned int): behaviour modifier flags.

    .. seealso:: `nvmlInitWithFlags`
    """
    with nogil:
        __status__ = nvmlInitWithFlags(flags)
    check_status(__status__)


cpdef shutdown():
    """Shut down NVML by releasing all GPU resources previously allocated with :func:`init_v2`.

    .. seealso:: `nvmlShutdown`
    """
    with nogil:
        __status__ = nvmlShutdown()
    check_status(__status__)


cpdef str error_string(int result):
    """Helper method for converting NVML error codes into readable strings.

    Args:
        result (Return): NVML error code to convert.

    .. seealso:: `nvmlErrorString`
    """
    cdef bytes _output_
    _output_ = nvmlErrorString(<_Return>result)
    return _output_.decode()


cpdef str system_get_driver_version():
    """Retrieves the version of the system's graphics driver.

    .. seealso:: `nvmlSystemGetDriverVersion`
    """
    cdef unsigned int length = 80
    cdef char[80] version
    with nogil:
        __status__ = nvmlSystemGetDriverVersion(version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef str system_get_nvml_version():
    """Retrieves the version of the NVML library.

    .. seealso:: `nvmlSystemGetNVMLVersion`
    """
    cdef unsigned int length = 80
    cdef char[80] version
    with nogil:
        __status__ = nvmlSystemGetNVMLVersion(version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef int system_get_cuda_driver_version() except *:
    """Retrieves the version of the CUDA driver.

    Returns:
        int: Reference in which to return the version identifier.

    .. seealso:: `nvmlSystemGetCudaDriverVersion`
    """
    cdef int cuda_driver_version
    with nogil:
        __status__ = nvmlSystemGetCudaDriverVersion(&cuda_driver_version)
    check_status(__status__)
    return cuda_driver_version


cpdef int system_get_cuda_driver_version_v2() except 0:
    """Retrieves the version of the CUDA driver from the shared library.

    Returns:
        int: Reference in which to return the version identifier.

    .. seealso:: `nvmlSystemGetCudaDriverVersion_v2`
    """
    cdef int cuda_driver_version
    with nogil:
        __status__ = nvmlSystemGetCudaDriverVersion_v2(&cuda_driver_version)
    check_status(__status__)
    return cuda_driver_version


cpdef str system_get_process_name(unsigned int pid):
    """Gets name of the process with provided process id.

    Args:
        pid (unsigned int): The identifier of the process.

    .. seealso:: `nvmlSystemGetProcessName`
    """
    cdef unsigned int length = 1024
    cdef char[1024] name
    with nogil:
        __status__ = nvmlSystemGetProcessName(pid, name, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(name)


cpdef object system_get_hic_version():
    """Retrieves the IDs and firmware versions for any Host Interface Cards (HICs) in the system.

    .. seealso:: `nvmlSystemGetHicVersion`
    """
    cdef unsigned int[1] hwbc_count = [0]
    with nogil:
        __status__ = nvmlSystemGetHicVersion(<unsigned int*>hwbc_count, NULL)
    check_status_size(__status__)
    cdef HwbcEntry hwbc_entries = HwbcEntry(hwbc_count[0])
    cdef nvmlHwbcEntry_t *hwbc_entries_ptr = <nvmlHwbcEntry_t *><intptr_t>(hwbc_entries._get_ptr())
    if hwbc_count[0] == 0:
        return hwbc_entries
    with nogil:
        __status__ = nvmlSystemGetHicVersion(<unsigned int*>hwbc_count, hwbc_entries_ptr)
    check_status(__status__)
    return hwbc_entries


cpdef unsigned int unit_get_count() except? 0:
    """Retrieves the number of units in the system.

    Returns:
        unsigned int: Reference in which to return the number of units.

    .. seealso:: `nvmlUnitGetCount`
    """
    cdef unsigned int unit_count
    with nogil:
        __status__ = nvmlUnitGetCount(&unit_count)
    check_status(__status__)
    return unit_count


cpdef intptr_t unit_get_handle_by_index(unsigned int ind_ex) except? 0:
    """Acquire the handle for a particular unit, based on its ind_ex.

    Args:
        ind_ex (unsigned int): The ind_ex of the target unit, >= 0 and < ``unitCount``.

    Returns:
        intptr_t: Reference in which to return the unit handle.

    .. seealso:: `nvmlUnitGetHandleByIndex`
    """
    cdef Unit unit
    with nogil:
        __status__ = nvmlUnitGetHandleByIndex(ind_ex, &unit)
    check_status(__status__)
    return <intptr_t>unit


cpdef object unit_get_unit_info(intptr_t unit):
    """Retrieves the static information associated with a unit.

    Args:
        unit (intptr_t): The identifier of the target unit.

    Returns:
        nvmlUnitInfo_t: Reference in which to return the unit information.

    .. seealso:: `nvmlUnitGetUnitInfo`
    """
    cdef UnitInfo info_py = UnitInfo()
    cdef nvmlUnitInfo_t *info = <nvmlUnitInfo_t *><intptr_t>(info_py._get_ptr())
    with nogil:
        __status__ = nvmlUnitGetUnitInfo(<Unit>unit, info)
    check_status(__status__)
    return info_py


cpdef object unit_get_led_state(intptr_t unit):
    """Retrieves the LED state associated with this unit.

    Args:
        unit (intptr_t): The identifier of the target unit.

    Returns:
        nvmlLedState_t: Reference in which to return the current LED state.

    .. seealso:: `nvmlUnitGetLedState`
    """
    cdef LedState state_py = LedState()
    cdef nvmlLedState_t *state = <nvmlLedState_t *><intptr_t>(state_py._get_ptr())
    with nogil:
        __status__ = nvmlUnitGetLedState(<Unit>unit, state)
    check_status(__status__)
    return state_py


cpdef object unit_get_psu_info(intptr_t unit):
    """Retrieves the PSU stats for the unit.

    Args:
        unit (intptr_t): The identifier of the target unit.

    Returns:
        nvmlPSUInfo_t: Reference in which to return the PSU information.

    .. seealso:: `nvmlUnitGetPsuInfo`
    """
    cdef PSUInfo psu_py = PSUInfo()
    cdef nvmlPSUInfo_t *psu = <nvmlPSUInfo_t *><intptr_t>(psu_py._get_ptr())
    with nogil:
        __status__ = nvmlUnitGetPsuInfo(<Unit>unit, psu)
    check_status(__status__)
    return psu_py


cpdef unsigned int unit_get_temperature(intptr_t unit, unsigned int type) except? 0:
    """Retrieves the temperature readings for the unit, in degrees C.

    Args:
        unit (intptr_t): The identifier of the target unit.
        type (unsigned int): The type of reading to take.

    Returns:
        unsigned int: Reference in which to return the intake temperature.

    .. seealso:: `nvmlUnitGetTemperature`
    """
    cdef unsigned int temp
    with nogil:
        __status__ = nvmlUnitGetTemperature(<Unit>unit, type, &temp)
    check_status(__status__)
    return temp


cpdef object unit_get_fan_speed_info(intptr_t unit):
    """Retrieves the fan speed readings for the unit.

    Args:
        unit (intptr_t): The identifier of the target unit.

    Returns:
        nvmlUnitFanSpeeds_t: Reference in which to return the fan speed information.

    .. seealso:: `nvmlUnitGetFanSpeedInfo`
    """
    cdef UnitFanSpeeds fan_speeds_py = UnitFanSpeeds()
    cdef nvmlUnitFanSpeeds_t *fan_speeds = <nvmlUnitFanSpeeds_t *><intptr_t>(fan_speeds_py._get_ptr())
    with nogil:
        __status__ = nvmlUnitGetFanSpeedInfo(<Unit>unit, fan_speeds)
    check_status(__status__)
    return fan_speeds_py


cpdef unsigned int device_get_count_v2() except? 0:
    """Retrieves the number of compute devices in the system. A compute device is a single GPU.

    Returns:
        unsigned int: Reference in which to return the number of accessible devices.

    .. seealso:: `nvmlDeviceGetCount_v2`
    """
    cdef unsigned int device_count
    with nogil:
        __status__ = nvmlDeviceGetCount_v2(&device_count)
    check_status(__status__)
    return device_count


cpdef object device_get_attributes_v2(intptr_t device):
    """Get attributes (engine counts etc.) for the given NVML device handle.

    Args:
        device (intptr_t): NVML device handle.

    Returns:
        nvmlDeviceAttributes_t: Device attributes.

    .. seealso:: `nvmlDeviceGetAttributes_v2`
    """
    cdef DeviceAttributes attributes_py = DeviceAttributes()
    cdef nvmlDeviceAttributes_t *attributes = <nvmlDeviceAttributes_t *><intptr_t>(attributes_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetAttributes_v2(<Device>device, attributes)
    check_status(__status__)
    return attributes_py


cpdef intptr_t device_get_handle_by_index_v2(unsigned int ind_ex) except? 0:
    """Acquire the handle for a particular device, based on its ind_ex.

    Args:
        ind_ex (unsigned int): The ind_ex of the target GPU, >= 0 and < ``accessibleDevices``.

    Returns:
        intptr_t: Reference in which to return the device handle.

    .. seealso:: `nvmlDeviceGetHandleByIndex_v2`
    """
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetHandleByIndex_v2(ind_ex, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef intptr_t device_get_handle_by_serial(serial) except? 0:
    """Acquire the handle for a particular device, based on its board serial number.

    Args:
        serial (str): The board serial number of the target GPU.

    Returns:
        intptr_t: Reference in which to return the device handle.

    .. seealso:: `nvmlDeviceGetHandleBySerial`
    """
    if not isinstance(serial, str):
        raise TypeError("serial must be a Python str")
    cdef bytes _temp_serial_ = (<str>serial).encode()
    cdef char* _serial_ = _temp_serial_
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetHandleBySerial(<const char*>_serial_, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef intptr_t device_get_handle_by_uuid(uuid) except? 0:
    """Acquire the handle for a particular device, based on its globally unique immutable UUID (in ASCII format) associated with each device.

    Args:
        uuid (str): The UUID of the target GPU or MIG instance.

    Returns:
        intptr_t: Reference in which to return the device handle or MIG device handle.

    .. seealso:: `nvmlDeviceGetHandleByUUID`
    """
    if not isinstance(uuid, str):
        raise TypeError("uuid must be a Python str")
    cdef bytes _temp_uuid_ = (<str>uuid).encode()
    cdef char* _uuid_ = _temp_uuid_
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetHandleByUUID(<const char*>_uuid_, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef intptr_t device_get_handle_by_uuidv(intptr_t uuid) except? 0:
    """Acquire the handle for a particular device, based on its globally unique immutable UUID (in either ASCII or binary format) associated with each device. See ``nvmlUUID_v1_t`` for more information on the UUID struct. The caller must set the appropriate version prior to calling this API.

    Args:
        uuid (intptr_t): The UUID of the target GPU or MIG instance.

    Returns:
        intptr_t: Reference in which to return the device handle or MIG device handle.

    .. seealso:: `nvmlDeviceGetHandleByUUIDV`
    """
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetHandleByUUIDV(<const nvmlUUID_t*>uuid, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef intptr_t device_get_handle_by_pci_bus_id_v2(pci_bus_id) except? 0:
    """Acquire the handle for a particular device, based on its PCI bus id.

    Args:
        pci_bus_id (str): The PCI bus id of the target GPU Accept the following formats (all numbers in hexadecimal): domain:bus:device.function in format x:x:x.x domain:bus:device in format x:x:x bus:device.function in format x:x.x.

    Returns:
        intptr_t: Reference in which to return the device handle.

    .. seealso:: `nvmlDeviceGetHandleByPciBusId_v2`
    """
    if not isinstance(pci_bus_id, str):
        raise TypeError("pci_bus_id must be a Python str")
    cdef bytes _temp_pci_bus_id_ = (<str>pci_bus_id).encode()
    cdef char* _pci_bus_id_ = _temp_pci_bus_id_
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetHandleByPciBusId_v2(<const char*>_pci_bus_id_, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef str device_get_name(intptr_t device):
    """Retrieves the name of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetName`
    """
    cdef unsigned int length = 96
    cdef char[96] name
    with nogil:
        __status__ = nvmlDeviceGetName(<Device>device, name, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(name)


cpdef int device_get_brand(intptr_t device) except? -1:
    """Retrieves the brand of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the product brand type.

    .. seealso:: `nvmlDeviceGetBrand`
    """
    cdef _BrandType type
    with nogil:
        __status__ = nvmlDeviceGetBrand(<Device>device, &type)
    check_status(__status__)
    return <int>type


cpdef unsigned int device_get_index(intptr_t device) except? 0:
    """Retrieves the NVML index of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the NVML index of the device.

    .. seealso:: `nvmlDeviceGetIndex`
    """
    cdef unsigned int ind_ex
    with nogil:
        __status__ = nvmlDeviceGetIndex(<Device>device, &ind_ex)
    check_status(__status__)
    return ind_ex


cpdef str device_get_serial(intptr_t device):
    """Retrieves the globally unique board serial number associated with this device's board.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetSerial`
    """
    cdef unsigned int length = 30
    cdef char[30] serial
    with nogil:
        __status__ = nvmlDeviceGetSerial(<Device>device, serial, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(serial)


cpdef unsigned int device_get_module_id(intptr_t device) except? 0:
    """Get a unique identifier for the device module on the baseboard.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Unique identifier for the GPU module.

    .. seealso:: `nvmlDeviceGetModuleId`
    """
    cdef unsigned int module_id
    with nogil:
        __status__ = nvmlDeviceGetModuleId(<Device>device, &module_id)
    check_status(__status__)
    return module_id


cpdef object device_get_c2c_mode_info_v(intptr_t device):
    """Retrieves the Device's C2C Mode information.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlC2cModeInfo_v1_t: Output struct containing the device's C2C Mode info.

    .. seealso:: `nvmlDeviceGetC2cModeInfoV`
    """
    cdef C2cModeInfo_v1 c2c_mode_info_py = C2cModeInfo_v1()
    cdef nvmlC2cModeInfo_v1_t *c2c_mode_info = <nvmlC2cModeInfo_v1_t *><intptr_t>(c2c_mode_info_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetC2cModeInfoV(<Device>device, c2c_mode_info)
    check_status(__status__)
    return c2c_mode_info_py


cpdef object device_get_memory_affinity(intptr_t device, unsigned int node_set_size, unsigned int scope):
    """Retrieves an array of unsigned ints (sized to node_set_size) of bitmasks with the ideal memory affinity within node or socket for the device. For example, if NUMA node 0, 1 are ideal within the socket for the device and node_set_size == 1, result[0] = 0x3.

    Args:
        device (intptr_t): The identifier of the target device.
        node_set_size (unsigned int): The size of the nodeSet array that is safe to access.
        scope (unsigned int): Array reference in which to return a bitmask of NODEs, 64 NODEs per unsigned long on 64-bit machines, 32 on 32-bit machines.

    .. seealso:: `nvmlDeviceGetMemoryAffinity`
    """
    if node_set_size == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned long), format="L", mode="c")[:0]
    cdef view.array node_set = view.array(shape=(node_set_size,), itemsize=sizeof(unsigned long), format="L", mode="c")
    cdef unsigned long *node_set_ptr = <unsigned long *>(node_set.data)
    with nogil:
        __status__ = nvmlDeviceGetMemoryAffinity(<Device>device, node_set_size, node_set_ptr, <nvmlAffinityScope_t>scope)
    check_status(__status__)
    return node_set


cpdef object device_get_cpu_affinity_within_scope(intptr_t device, unsigned int cpu_set_size, unsigned int scope):
    """Retrieves an array of unsigned ints (sized to cpu_set_size) of bitmasks with the ideal CPU affinity within node or socket for the device. For example, if processors 0, 1, 32, and 33 are ideal for the device and cpu_set_size == 2, result[0] = 0x3, result[1] = 0x3.

    Args:
        device (intptr_t): The identifier of the target device.
        cpu_set_size (unsigned int): The size of the cpuSet array that is safe to access.
        scope (unsigned int): Array reference in which to return a bitmask of CPUs, 64 CPUs per unsigned long on 64-bit machines, 32 on 32-bit machines.

    .. seealso:: `nvmlDeviceGetCpuAffinityWithinScope`
    """
    if cpu_set_size == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned long), format="L", mode="c")[:0]
    cdef view.array cpu_set = view.array(shape=(cpu_set_size,), itemsize=sizeof(unsigned long), format="L", mode="c")
    cdef unsigned long *cpu_set_ptr = <unsigned long *>(cpu_set.data)
    with nogil:
        __status__ = nvmlDeviceGetCpuAffinityWithinScope(<Device>device, cpu_set_size, cpu_set_ptr, <nvmlAffinityScope_t>scope)
    check_status(__status__)
    return cpu_set


cpdef object device_get_cpu_affinity(intptr_t device, unsigned int cpu_set_size):
    """Retrieves an array of unsigned ints (sized to cpu_set_size) of bitmasks with the ideal CPU affinity for the device For example, if processors 0, 1, 32, and 33 are ideal for the device and cpu_set_size == 2, result[0] = 0x3, result[1] = 0x3 This is equivalent to calling ``nvmlDeviceGetCpuAffinityWithinScope`` with ``NVML_AFFINITY_SCOPE_NODE``.

    Args:
        device (intptr_t): The identifier of the target device.
        cpu_set_size (unsigned int): The size of the cpuSet array that is safe to access.

    .. seealso:: `nvmlDeviceGetCpuAffinity`
    """
    if cpu_set_size == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned long), format="L", mode="c")[:0]
    cdef view.array cpu_set = view.array(shape=(cpu_set_size,), itemsize=sizeof(unsigned long), format="L", mode="c")
    cdef unsigned long *cpu_set_ptr = <unsigned long *>(cpu_set.data)
    with nogil:
        __status__ = nvmlDeviceGetCpuAffinity(<Device>device, cpu_set_size, cpu_set_ptr)
    check_status(__status__)
    return cpu_set


cpdef device_set_cpu_affinity(intptr_t device):
    """Sets the ideal affinity for the calling thread and device using the guidelines given in :func:`device_get_cpu_affinity`. Note, this is a change as of version 8.0. Older versions set the affinity for a calling process and all children. Currently supports up to 1024 processors.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceSetCpuAffinity`
    """
    with nogil:
        __status__ = nvmlDeviceSetCpuAffinity(<Device>device)
    check_status(__status__)


cpdef device_clear_cpu_affinity(intptr_t device):
    """Clear all affinity bindings for the calling thread. Note, this is a change as of version 8.0 as older versions cleared the affinity for a calling process and all children.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceClearCpuAffinity`
    """
    with nogil:
        __status__ = nvmlDeviceClearCpuAffinity(<Device>device)
    check_status(__status__)


cpdef unsigned int device_get_numa_node_id(intptr_t device) except? 0:
    """Get the NUMA node of the given GPU device. This only applies to platforms where the GPUs are NUMA nodes.

    Args:
        device (intptr_t): The device handle.

    Returns:
        unsigned int: NUMA node ID of the device.

    .. seealso:: `nvmlDeviceGetNumaNodeId`
    """
    cdef unsigned int node
    with nogil:
        __status__ = nvmlDeviceGetNumaNodeId(<Device>device, &node)
    check_status(__status__)
    return node


cpdef int device_get_topology_common_ancestor(intptr_t device1, intptr_t device2) except? -1:
    """Retrieve the common ancestor for two devices For all products. Supported on Linux only.

    Args:
        device1 (intptr_t): The identifier of the first device.
        device2 (intptr_t): The identifier of the second device.

    Returns:
        int: A ``nvmlGpuTopologyLevel_t`` that gives the path type.

    .. seealso:: `nvmlDeviceGetTopologyCommonAncestor`
    """
    cdef _GpuTopologyLevel path_info
    with nogil:
        __status__ = nvmlDeviceGetTopologyCommonAncestor(<Device>device1, <Device>device2, &path_info)
    check_status(__status__)
    return <int>path_info


cpdef int device_get_p2p_status(intptr_t device1, intptr_t device2, int p2p_ind_ex) except? -1:
    """Retrieve the status for a given p2p capability index between a given pair of GPU.

    Args:
        device1 (intptr_t): The first device.
        device2 (intptr_t): The second device.
        p2p_ind_ex (GpuP2PCapsIndex): p2p Capability Index being looked for between ``device1`` and ``device2``.

    Returns:
        int: Reference in which to return the status of the ``p2p_ind_ex`` between ``device1`` and ``device2``.

    .. seealso:: `nvmlDeviceGetP2PStatus`
    """
    cdef _GpuP2PStatus p2p_status
    with nogil:
        __status__ = nvmlDeviceGetP2PStatus(<Device>device1, <Device>device2, <_GpuP2PCapsIndex>p2p_ind_ex, &p2p_status)
    check_status(__status__)
    return <int>p2p_status


cpdef str device_get_uuid(intptr_t device):
    """Retrieves the globally unique immutable UUID associated with this device, as a 5 part hexadecimal string, that augments the immutable, board serial identifier.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetUUID`
    """
    cdef unsigned int length = 96
    cdef char[96] uuid
    with nogil:
        __status__ = nvmlDeviceGetUUID(<Device>device, uuid, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(uuid)


cpdef unsigned int device_get_minor_number(intptr_t device) except? 0:
    """Retrieves minor number for the device. The minor number for the device is such that the Nvidia device node file for each GPU will have the form /dev/nvidia[minor number].

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the minor number for the device.

    .. seealso:: `nvmlDeviceGetMinorNumber`
    """
    cdef unsigned int minor_number
    with nogil:
        __status__ = nvmlDeviceGetMinorNumber(<Device>device, &minor_number)
    check_status(__status__)
    return minor_number


cpdef str device_get_board_part_number(intptr_t device):
    """Retrieves the the device board part number which is programmed into the board's InfoROM.

    Args:
        device (intptr_t): Identifier of the target device.

    .. seealso:: `nvmlDeviceGetBoardPartNumber`
    """
    cdef unsigned int length = 80
    cdef char[80] part_number
    with nogil:
        __status__ = nvmlDeviceGetBoardPartNumber(<Device>device, part_number, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(part_number)


cpdef str device_get_inforom_version(intptr_t device, int object):
    """Retrieves the version information for the device's infoROM object.

    Args:
        device (intptr_t): The identifier of the target device.
        object (InforomObject): The target infoROM object.

    .. seealso:: `nvmlDeviceGetInforomVersion`
    """
    cdef unsigned int length = 16
    cdef char[16] version
    with nogil:
        __status__ = nvmlDeviceGetInforomVersion(<Device>device, <_InforomObject>object, version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef str device_get_inforom_image_version(intptr_t device):
    """Retrieves the global infoROM image version.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetInforomImageVersion`
    """
    cdef unsigned int length = 16
    cdef char[16] version
    with nogil:
        __status__ = nvmlDeviceGetInforomImageVersion(<Device>device, version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef unsigned int device_get_inforom_configuration_checksum(intptr_t device) except? 0:
    """Retrieves the checksum of the configuration stored in the device's infoROM.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the infoROM configuration checksum.

    .. seealso:: `nvmlDeviceGetInforomConfigurationChecksum`
    """
    cdef unsigned int checksum
    with nogil:
        __status__ = nvmlDeviceGetInforomConfigurationChecksum(<Device>device, &checksum)
    check_status(__status__)
    return checksum


cpdef device_validate_inforom(intptr_t device):
    """Reads the infoROM from the flash and verifies the checksums.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceValidateInforom`
    """
    with nogil:
        __status__ = nvmlDeviceValidateInforom(<Device>device)
    check_status(__status__)


cpdef unsigned long device_get_last_bbx_flush_time(intptr_t device, intptr_t timestamp) except? 0:
    """Retrieves the timestamp and the duration of the last flush of the BBX (blackbox) infoROM object during the current run.

    Args:
        device (intptr_t): The identifier of the target device.
        timestamp (intptr_t): The start timestamp of the last BBX Flush.

    Returns:
        unsigned long: The duration (us) of the last BBX Flush.

    .. seealso:: `nvmlDeviceGetLastBBXFlushTime`
    """
    cdef unsigned long duration_us
    with nogil:
        __status__ = nvmlDeviceGetLastBBXFlushTime(<Device>device, <unsigned long long*>timestamp, &duration_us)
    check_status(__status__)
    return duration_us


cpdef int device_get_display_mode(intptr_t device) except? -1:
    """Retrieves the display mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the display mode.

    .. seealso:: `nvmlDeviceGetDisplayMode`
    """
    cdef _EnableState display
    with nogil:
        __status__ = nvmlDeviceGetDisplayMode(<Device>device, &display)
    check_status(__status__)
    return <int>display


cpdef int device_get_display_active(intptr_t device) except? -1:
    """Retrieves the display active state for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the display active state.

    .. seealso:: `nvmlDeviceGetDisplayActive`
    """
    cdef _EnableState is_active
    with nogil:
        __status__ = nvmlDeviceGetDisplayActive(<Device>device, &is_active)
    check_status(__status__)
    return <int>is_active


cpdef int device_get_persistence_mode(intptr_t device) except? -1:
    """Retrieves the persistence mode associated with this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the current driver persistence mode.

    .. seealso:: `nvmlDeviceGetPersistenceMode`
    """
    cdef _EnableState mode
    with nogil:
        __status__ = nvmlDeviceGetPersistenceMode(<Device>device, &mode)
    check_status(__status__)
    return <int>mode


cpdef object device_get_pci_info_ext(intptr_t device):
    """Retrieves PCI attributes of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlPciInfoExt_v1_t: Reference in which to return the PCI info.

    .. seealso:: `nvmlDeviceGetPciInfoExt`
    """
    cdef PciInfoExt_v1 pci_py = PciInfoExt_v1()
    cdef nvmlPciInfoExt_t *pci = <nvmlPciInfoExt_t *><intptr_t>(pci_py._get_ptr())
    pci.version = sizeof(nvmlPciInfoExt_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetPciInfoExt(<Device>device, pci)
    check_status(__status__)
    return pci_py


cpdef object device_get_pci_info_v3(intptr_t device):
    """Retrieves the PCI attributes of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlPciInfo_t: Reference in which to return the PCI info.

    .. seealso:: `nvmlDeviceGetPciInfo_v3`
    """
    cdef PciInfo pci_py = PciInfo()
    cdef nvmlPciInfo_t *pci = <nvmlPciInfo_t *><intptr_t>(pci_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetPciInfo_v3(<Device>device, pci)
    check_status(__status__)
    return pci_py


cpdef unsigned int device_get_max_pcie_link_generation(intptr_t device) except? 0:
    """Retrieves the maximum PCIe link generation possible with this device and system.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the max PCIe link generation.

    .. seealso:: `nvmlDeviceGetMaxPcieLinkGeneration`
    """
    cdef unsigned int max_link_gen
    with nogil:
        __status__ = nvmlDeviceGetMaxPcieLinkGeneration(<Device>device, &max_link_gen)
    check_status(__status__)
    return max_link_gen


cpdef unsigned int device_get_gpu_max_pcie_link_generation(intptr_t device) except? 0:
    """Retrieves the maximum PCIe link generation supported by this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the max PCIe link generation.

    .. seealso:: `nvmlDeviceGetGpuMaxPcieLinkGeneration`
    """
    cdef unsigned int max_link_gen_device
    with nogil:
        __status__ = nvmlDeviceGetGpuMaxPcieLinkGeneration(<Device>device, &max_link_gen_device)
    check_status(__status__)
    return max_link_gen_device


cpdef unsigned int device_get_max_pcie_link_width(intptr_t device) except? 0:
    """Retrieves the maximum PCIe link width possible with this device and system.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the max PCIe link generation.

    .. seealso:: `nvmlDeviceGetMaxPcieLinkWidth`
    """
    cdef unsigned int max_link_width
    with nogil:
        __status__ = nvmlDeviceGetMaxPcieLinkWidth(<Device>device, &max_link_width)
    check_status(__status__)
    return max_link_width


cpdef unsigned int device_get_curr_pcie_link_generation(intptr_t device) except? 0:
    """Retrieves the current PCIe link generation.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the current PCIe link generation.

    .. seealso:: `nvmlDeviceGetCurrPcieLinkGeneration`
    """
    cdef unsigned int curr_link_gen
    with nogil:
        __status__ = nvmlDeviceGetCurrPcieLinkGeneration(<Device>device, &curr_link_gen)
    check_status(__status__)
    return curr_link_gen


cpdef unsigned int device_get_curr_pcie_link_width(intptr_t device) except? 0:
    """Retrieves the current PCIe link width.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the current PCIe link generation.

    .. seealso:: `nvmlDeviceGetCurrPcieLinkWidth`
    """
    cdef unsigned int curr_link_width
    with nogil:
        __status__ = nvmlDeviceGetCurrPcieLinkWidth(<Device>device, &curr_link_width)
    check_status(__status__)
    return curr_link_width


cpdef unsigned int device_get_pcie_throughput(intptr_t device, int counter) except? 0:
    """Retrieve PCIe utilization information. This function is querying a byte counter over a 20ms interval and thus is the PCIe throughput over that interval.

    Args:
        device (intptr_t): The identifier of the target device.
        counter (PcieUtilCounter): The specific counter that should be queried ``nvmlPcieUtilCounter_t``.

    Returns:
        unsigned int: Reference in which to return throughput in KB/s.

    .. seealso:: `nvmlDeviceGetPcieThroughput`
    """
    cdef unsigned int value
    with nogil:
        __status__ = nvmlDeviceGetPcieThroughput(<Device>device, <_PcieUtilCounter>counter, &value)
    check_status(__status__)
    return value


cpdef unsigned int device_get_pcie_replay_counter(intptr_t device) except? 0:
    """Retrieve the PCIe replay counter.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the counter's value.

    .. seealso:: `nvmlDeviceGetPcieReplayCounter`
    """
    cdef unsigned int value
    with nogil:
        __status__ = nvmlDeviceGetPcieReplayCounter(<Device>device, &value)
    check_status(__status__)
    return value


cpdef unsigned int device_get_clock_info(intptr_t device, int type) except? 0:
    """Retrieves the current clock speeds for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        type (ClockType): Identify which clock domain to query.

    Returns:
        unsigned int: Reference in which to return the clock speed in MHz.

    .. seealso:: `nvmlDeviceGetClockInfo`
    """
    cdef unsigned int clock
    with nogil:
        __status__ = nvmlDeviceGetClockInfo(<Device>device, <_ClockType>type, &clock)
    check_status(__status__)
    return clock


cpdef unsigned int device_get_max_clock_info(intptr_t device, int type) except? 0:
    """Retrieves the maximum clock speeds for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        type (ClockType): Identify which clock domain to query.

    Returns:
        unsigned int: Reference in which to return the clock speed in MHz.

    .. seealso:: `nvmlDeviceGetMaxClockInfo`
    """
    cdef unsigned int clock
    with nogil:
        __status__ = nvmlDeviceGetMaxClockInfo(<Device>device, <_ClockType>type, &clock)
    check_status(__status__)
    return clock


cpdef int device_get_gpc_clk_vf_offset(intptr_t device) except? 0:
    """Retrieve the GPCCLK VF offset value.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: The retrieved GPCCLK VF offset value.

    .. seealso:: `nvmlDeviceGetGpcClkVfOffset`
    """
    cdef int offset
    with nogil:
        __status__ = nvmlDeviceGetGpcClkVfOffset(<Device>device, &offset)
    check_status(__status__)
    return offset


cpdef unsigned int device_get_clock(intptr_t device, int clock_type, int clock_id) except? 0:
    """Retrieves the clock speed for the clock specified by the clock type and clock ID.

    Args:
        device (intptr_t): The identifier of the target device.
        clock_type (ClockType): Identify which clock domain to query.
        clock_id (ClockId): Identify which clock in the domain to query.

    Returns:
        unsigned int: Reference in which to return the clock in MHz.

    .. seealso:: `nvmlDeviceGetClock`
    """
    cdef unsigned int clock_m_hz
    with nogil:
        __status__ = nvmlDeviceGetClock(<Device>device, <_ClockType>clock_type, <_ClockId>clock_id, &clock_m_hz)
    check_status(__status__)
    return clock_m_hz


cpdef unsigned int device_get_max_customer_boost_clock(intptr_t device, int clock_type) except? 0:
    """Retrieves the customer defined maximum boost clock speed specified by the given clock type.

    Args:
        device (intptr_t): The identifier of the target device.
        clock_type (ClockType): Identify which clock domain to query.

    Returns:
        unsigned int: Reference in which to return the clock in MHz.

    .. seealso:: `nvmlDeviceGetMaxCustomerBoostClock`
    """
    cdef unsigned int clock_m_hz
    with nogil:
        __status__ = nvmlDeviceGetMaxCustomerBoostClock(<Device>device, <_ClockType>clock_type, &clock_m_hz)
    check_status(__status__)
    return clock_m_hz


cpdef object device_get_supported_memory_clocks(intptr_t device):
    """Retrieves the list of possible memory clocks that can be used as an argument for ``nvmlDeviceSetMemoryLockedClocks``.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetSupportedMemoryClocks`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlDeviceGetSupportedMemoryClocks(<Device>device, <unsigned int*>count, NULL)
    check_status_size(__status__)
    if count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned int), format="I", mode="c")[:0]
    cdef view.array clocks_m_hz = view.array(shape=(count[0],), itemsize=sizeof(unsigned int), format="I", mode="c")
    cdef unsigned int *clocks_m_hz_ptr = <unsigned int *>(clocks_m_hz.data)
    with nogil:
        __status__ = nvmlDeviceGetSupportedMemoryClocks(<Device>device, <unsigned int*>count, clocks_m_hz_ptr)
    check_status(__status__)
    return clocks_m_hz


cpdef object device_get_supported_graphics_clocks(intptr_t device, unsigned int memory_clock_m_hz):
    """Retrieves the list of possible graphics clocks that can be used as an argument for ``nvmlDeviceSetGpuLockedClocks``.

    Args:
        device (intptr_t): The identifier of the target device.
        memory_clock_m_hz (unsigned int): Memory clock for which to return possible graphics clocks.

    .. seealso:: `nvmlDeviceGetSupportedGraphicsClocks`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlDeviceGetSupportedGraphicsClocks(<Device>device, memory_clock_m_hz, <unsigned int*>count, NULL)
    check_status_size(__status__)
    if count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned int), format="I", mode="c")[:0]
    cdef view.array clocks_m_hz = view.array(shape=(count[0],), itemsize=sizeof(unsigned int), format="I", mode="c")
    cdef unsigned int *clocks_m_hz_ptr = <unsigned int *>(clocks_m_hz.data)
    with nogil:
        __status__ = nvmlDeviceGetSupportedGraphicsClocks(<Device>device, memory_clock_m_hz, <unsigned int*>count, clocks_m_hz_ptr)
    check_status(__status__)
    return clocks_m_hz


cpdef tuple device_get_auto_boosted_clocks_enabled(intptr_t device):
    """Retrieve the current state of Auto Boosted clocks on a device and store it in ``isEnabled``.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: Where to store the current state of Auto Boosted clocks of the target device.
        - int: Where to store the default Auto Boosted clocks behavior of the target device that the device will revert to when no applications are using the GPU.

    .. seealso:: `nvmlDeviceGetAutoBoostedClocksEnabled`
    """
    cdef _EnableState is_enabled
    cdef _EnableState default_is_enabled
    with nogil:
        __status__ = nvmlDeviceGetAutoBoostedClocksEnabled(<Device>device, &is_enabled, &default_is_enabled)
    check_status(__status__)
    return (<int>is_enabled, <int>default_is_enabled)


cpdef unsigned int device_get_fan_speed(intptr_t device) except? 0:
    """Retrieves the intended operating speed of the device's fan.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the fan speed percentage.

    .. seealso:: `nvmlDeviceGetFanSpeed`
    """
    cdef unsigned int speed
    with nogil:
        __status__ = nvmlDeviceGetFanSpeed(<Device>device, &speed)
    check_status(__status__)
    return speed


cpdef unsigned int device_get_fan_speed_v2(intptr_t device, unsigned int fan) except? 0:
    """Retrieves the intended operating speed of the device's specified fan.

    Args:
        device (intptr_t): The identifier of the target device.
        fan (unsigned int): The index of the target fan, zero indexed.

    Returns:
        unsigned int: Reference in which to return the fan speed percentage.

    .. seealso:: `nvmlDeviceGetFanSpeed_v2`
    """
    cdef unsigned int speed
    with nogil:
        __status__ = nvmlDeviceGetFanSpeed_v2(<Device>device, fan, &speed)
    check_status(__status__)
    return speed


cpdef object device_get_fan_speed_rpm(intptr_t device):
    """Retrieves the intended operating speed in rotations per minute (RPM) of the device's specified fan.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlFanSpeedInfo_v1_t: Structure specifying the index of the target fan (input) and retrieved fan speed value (output).

    .. seealso:: `nvmlDeviceGetFanSpeedRPM`
    """
    cdef FanSpeedInfo_v1 fan_speed_py = FanSpeedInfo_v1()
    cdef nvmlFanSpeedInfo_t *fan_speed = <nvmlFanSpeedInfo_t *><intptr_t>(fan_speed_py._get_ptr())
    fan_speed.version = sizeof(nvmlFanSpeedInfo_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetFanSpeedRPM(<Device>device, fan_speed)
    check_status(__status__)
    return fan_speed_py


cpdef unsigned int device_get_target_fan_speed(intptr_t device, unsigned int fan) except? 0:
    """Retrieves the intended target speed of the device's specified fan.

    Args:
        device (intptr_t): The identifier of the target device.
        fan (unsigned int): The index of the target fan, zero indexed.

    Returns:
        unsigned int: Reference in which to return the fan speed percentage.

    .. seealso:: `nvmlDeviceGetTargetFanSpeed`
    """
    cdef unsigned int target_speed
    with nogil:
        __status__ = nvmlDeviceGetTargetFanSpeed(<Device>device, fan, &target_speed)
    check_status(__status__)
    return target_speed


cpdef tuple device_get_min_max_fan_speed(intptr_t device):
    """Retrieves the min and max fan speed that user can set for the GPU fan.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: The minimum speed allowed to set.
        - unsigned int: The maximum speed allowed to set.

    .. seealso:: `nvmlDeviceGetMinMaxFanSpeed`
    """
    cdef unsigned int min_speed
    cdef unsigned int max_speed
    with nogil:
        __status__ = nvmlDeviceGetMinMaxFanSpeed(<Device>device, &min_speed, &max_speed)
    check_status(__status__)
    return (min_speed, max_speed)


cpdef unsigned int device_get_fan_control_policy_v2(intptr_t device, unsigned int fan) except *:
    """Gets current fan control policy.

    Args:
        device (intptr_t): The identifier of the target ``device``.
        fan (unsigned int): The index of the target fan, zero indexed.

    Returns:
        unsigned int: Reference in which to return the fan control ``policy``.

    .. seealso:: `nvmlDeviceGetFanControlPolicy_v2`
    """
    cdef nvmlFanControlPolicy_t policy
    with nogil:
        __status__ = nvmlDeviceGetFanControlPolicy_v2(<Device>device, fan, &policy)
    check_status(__status__)
    return <unsigned int>policy


cpdef unsigned int device_get_num_fans(intptr_t device) except? 0:
    """Retrieves the number of fans on the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The number of fans.

    .. seealso:: `nvmlDeviceGetNumFans`
    """
    cdef unsigned int num_fans
    with nogil:
        __status__ = nvmlDeviceGetNumFans(<Device>device, &num_fans)
    check_status(__status__)
    return num_fans


cpdef object device_get_cooler_info(intptr_t device):
    """Retrieves the cooler's information. Returns a cooler's control signal characteristics. The possible types are restricted, Variable and Toggle. See ``nvmlCoolerControl_t`` for details on available signal types. Returns objects that cooler cools. Targets may be GPU, Memory, Power Supply or All of these. See ``nvmlCoolerTarget_t`` for details on available targets.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlCoolerInfo_v1_t: Structure specifying the cooler's control signal characteristics (out) and the target that cooler cools (out).

    .. seealso:: `nvmlDeviceGetCoolerInfo`
    """
    cdef CoolerInfo_v1 cooler_info_py = CoolerInfo_v1()
    cdef nvmlCoolerInfo_t *cooler_info = <nvmlCoolerInfo_t *><intptr_t>(cooler_info_py._get_ptr())
    cooler_info.version = sizeof(nvmlCoolerInfo_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetCoolerInfo(<Device>device, cooler_info)
    check_status(__status__)
    return cooler_info_py


cpdef unsigned int device_get_temperature_threshold(intptr_t device, int threshold_type) except? 0:
    """Retrieves the temperature threshold for the GPU with the specified threshold type in degrees C.

    Args:
        device (intptr_t): The identifier of the target device.
        threshold_type (TemperatureThresholds): The type of threshold value queried.

    Returns:
        unsigned int: Reference in which to return the temperature reading.

    .. seealso:: `nvmlDeviceGetTemperatureThreshold`
    """
    cdef unsigned int temp
    with nogil:
        __status__ = nvmlDeviceGetTemperatureThreshold(<Device>device, <_TemperatureThresholds>threshold_type, &temp)
    check_status(__status__)
    return temp


cpdef object device_get_margin_temperature(intptr_t device):
    """Retrieves the thermal margin temperature (distance to nearest slowdown threshold).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlMarginTemperature_v1_t: Versioned structure in which to return the temperature reading.

    .. seealso:: `nvmlDeviceGetMarginTemperature`
    """
    cdef MarginTemperature_v1 margin_temp_info_py = MarginTemperature_v1()
    cdef nvmlMarginTemperature_t *margin_temp_info = <nvmlMarginTemperature_t *><intptr_t>(margin_temp_info_py._get_ptr())
    margin_temp_info.version = sizeof(nvmlMarginTemperature_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetMarginTemperature(<Device>device, margin_temp_info)
    check_status(__status__)
    return margin_temp_info_py


cpdef object device_get_thermal_settings(intptr_t device, unsigned int sensor_ind_ex):
    """Used to execute a list of thermal system instructions.

    Args:
        device (intptr_t): The identifier of the target device.
        sensor_ind_ex (unsigned int): The index of the thermal sensor.

    Returns:
        nvmlGpuThermalSettings_t: Reference in which to return the thermal sensor information.

    .. seealso:: `nvmlDeviceGetThermalSettings`
    """
    cdef GpuThermalSettings p_thermal_settings_py = GpuThermalSettings()
    cdef nvmlGpuThermalSettings_t *p_thermal_settings = <nvmlGpuThermalSettings_t *><intptr_t>(p_thermal_settings_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetThermalSettings(<Device>device, sensor_ind_ex, p_thermal_settings)
    check_status(__status__)
    return p_thermal_settings_py


cpdef int device_get_performance_state(intptr_t device) except? -1:
    """Retrieves the current performance state for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the performance state reading.

    .. seealso:: `nvmlDeviceGetPerformanceState`
    """
    cdef _Pstates p_state
    with nogil:
        __status__ = nvmlDeviceGetPerformanceState(<Device>device, &p_state)
    check_status(__status__)
    return <int>p_state


cpdef unsigned long long device_get_current_clocks_event_reasons(intptr_t device) except? 0:
    """Retrieves current clocks event reasons.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned long long: Reference in which to return bitmask of active clocks event reasons.

    .. seealso:: `nvmlDeviceGetCurrentClocksEventReasons`
    """
    cdef unsigned long long clocks_event_reasons
    with nogil:
        __status__ = nvmlDeviceGetCurrentClocksEventReasons(<Device>device, &clocks_event_reasons)
    check_status(__status__)
    return clocks_event_reasons


cpdef unsigned long long device_get_supported_clocks_event_reasons(intptr_t device) except? 0:
    """Retrieves bitmask of supported clocks event reasons that can be returned by ``nvmlDeviceGetCurrentClocksEventReasons``.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned long long: Reference in which to return bitmask of supported clocks event reasons.

    .. seealso:: `nvmlDeviceGetSupportedClocksEventReasons`
    """
    cdef unsigned long long supported_clocks_event_reasons
    with nogil:
        __status__ = nvmlDeviceGetSupportedClocksEventReasons(<Device>device, &supported_clocks_event_reasons)
    check_status(__status__)
    return supported_clocks_event_reasons


cpdef int device_get_power_state(intptr_t device) except? -1:
    """Deprecated: Use ``nvmlDeviceGetPerformanceState``. This function exposes an incorrect generalization.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the performance state reading.

    .. seealso:: `nvmlDeviceGetPowerState`
    """
    cdef _Pstates p_state
    with nogil:
        __status__ = nvmlDeviceGetPowerState(<Device>device, &p_state)
    check_status(__status__)
    return <int>p_state


cpdef object device_get_dynamic_pstates_info(intptr_t device):
    """Retrieve performance monitor samples from the associated subdevice.

    Args:
        device (intptr_t): .

    Returns:
        nvmlGpuDynamicPstatesInfo_t: .

    .. seealso:: `nvmlDeviceGetDynamicPstatesInfo`
    """
    cdef GpuDynamicPstatesInfo p_dynamic_pstates_info_py = GpuDynamicPstatesInfo()
    cdef nvmlGpuDynamicPstatesInfo_t *p_dynamic_pstates_info = <nvmlGpuDynamicPstatesInfo_t *><intptr_t>(p_dynamic_pstates_info_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetDynamicPstatesInfo(<Device>device, p_dynamic_pstates_info)
    check_status(__status__)
    return p_dynamic_pstates_info_py


cpdef int device_get_mem_clk_vf_offset(intptr_t device) except? 0:
    """Retrieve the MemClk (Memory Clock) VF offset value.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: The retrieved MemClk VF offset value.

    .. seealso:: `nvmlDeviceGetMemClkVfOffset`
    """
    cdef int offset
    with nogil:
        __status__ = nvmlDeviceGetMemClkVfOffset(<Device>device, &offset)
    check_status(__status__)
    return offset


cpdef tuple device_get_min_max_clock_of_p_state(intptr_t device, int type, int pstate):
    """Retrieve min and max clocks of some clock domain for a given PState.

    Args:
        device (intptr_t): The identifier of the target device.
        type (ClockType): Clock domain.
        pstate (Pstates): PState to query.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference in which to return min clock frequency.
        - unsigned int: Reference in which to return max clock frequency.

    .. seealso:: `nvmlDeviceGetMinMaxClockOfPState`
    """
    cdef unsigned int min_clock_m_hz
    cdef unsigned int max_clock_m_hz
    with nogil:
        __status__ = nvmlDeviceGetMinMaxClockOfPState(<Device>device, <_ClockType>type, <_Pstates>pstate, &min_clock_m_hz, &max_clock_m_hz)
    check_status(__status__)
    return (min_clock_m_hz, max_clock_m_hz)


cpdef tuple device_get_gpc_clk_min_max_vf_offset(intptr_t device):
    """Retrieve the GPCCLK min max VF offset value.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: The retrieved GPCCLK VF min offset value.
        - int: The retrieved GPCCLK VF max offset value.

    .. seealso:: `nvmlDeviceGetGpcClkMinMaxVfOffset`
    """
    cdef int min_offset
    cdef int max_offset
    with nogil:
        __status__ = nvmlDeviceGetGpcClkMinMaxVfOffset(<Device>device, &min_offset, &max_offset)
    check_status(__status__)
    return (min_offset, max_offset)


cpdef tuple device_get_mem_clk_min_max_vf_offset(intptr_t device):
    """Retrieve the MemClk (Memory Clock) min max VF offset value.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: The retrieved MemClk VF min offset value.
        - int: The retrieved MemClk VF max offset value.

    .. seealso:: `nvmlDeviceGetMemClkMinMaxVfOffset`
    """
    cdef int min_offset
    cdef int max_offset
    with nogil:
        __status__ = nvmlDeviceGetMemClkMinMaxVfOffset(<Device>device, &min_offset, &max_offset)
    check_status(__status__)
    return (min_offset, max_offset)


cpdef object device_get_clock_offsets(intptr_t device):
    """Retrieve min, max and current clock offset of some clock domain for a given PState.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlClockOffset_v1_t: Structure specifying the clock type (input) and the pstate (input) retrieved clock offset value (output), min clock offset (output) and max clock offset (output).

    .. seealso:: `nvmlDeviceGetClockOffsets`
    """
    cdef ClockOffset_v1 info_py = ClockOffset_v1()
    cdef nvmlClockOffset_t *info = <nvmlClockOffset_t *><intptr_t>(info_py._get_ptr())
    info.version = sizeof(nvmlClockOffset_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetClockOffsets(<Device>device, info)
    check_status(__status__)
    return info_py


cpdef device_set_clock_offsets(intptr_t device, intptr_t info):
    """Control current clock offset of some clock domain for a given PState.

    Args:
        device (intptr_t): The identifier of the target device.
        info (intptr_t): Structure specifying the clock type (input), the pstate (input) and clock offset value (input).

    .. seealso:: `nvmlDeviceSetClockOffsets`
    """
    with nogil:
        __status__ = nvmlDeviceSetClockOffsets(<Device>device, <nvmlClockOffset_t*>info)
    check_status(__status__)


cpdef object device_get_performance_modes(intptr_t device):
    """Retrieves a performance mode string with all the performance modes defined for this device along with their associated GPU Clock and Memory Clock values. Not all tokens will be reported on all GPUs, and additional tokens may be added in the future. For backwards compatibility we still provide nvclock and memclock; those are the same as nvclockmin and memclockmin.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlDevicePerfModes_v1_t: Reference in which to return the performance level string.

    .. seealso:: `nvmlDeviceGetPerformanceModes`
    """
    cdef DevicePerfModes_v1 perf_modes_py = DevicePerfModes_v1()
    cdef nvmlDevicePerfModes_t *perf_modes = <nvmlDevicePerfModes_t *><intptr_t>(perf_modes_py._get_ptr())
    perf_modes.version = sizeof(nvmlDevicePerfModes_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetPerformanceModes(<Device>device, perf_modes)
    check_status(__status__)
    return perf_modes_py


cpdef object device_get_current_clock_freqs(intptr_t device):
    """Retrieves a string with the associated current GPU Clock and Memory Clock values.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlDeviceCurrentClockFreqs_v1_t: Reference in which to return the performance level string.

    .. seealso:: `nvmlDeviceGetCurrentClockFreqs`
    """
    cdef DeviceCurrentClockFreqs_v1 current_clock_freqs_py = DeviceCurrentClockFreqs_v1()
    cdef nvmlDeviceCurrentClockFreqs_t *current_clock_freqs = <nvmlDeviceCurrentClockFreqs_t *><intptr_t>(current_clock_freqs_py._get_ptr())
    current_clock_freqs.version = sizeof(nvmlDeviceCurrentClockFreqs_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetCurrentClockFreqs(<Device>device, current_clock_freqs)
    check_status(__status__)
    return current_clock_freqs_py


cpdef unsigned int device_get_power_management_limit(intptr_t device) except? 0:
    """Retrieves the power management limit associated with this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the power management limit in milliwatts.

    .. seealso:: `nvmlDeviceGetPowerManagementLimit`
    """
    cdef unsigned int limit
    with nogil:
        __status__ = nvmlDeviceGetPowerManagementLimit(<Device>device, &limit)
    check_status(__status__)
    return limit


cpdef tuple device_get_power_management_limit_constraints(intptr_t device):
    """Retrieves information about possible values of power management limits on this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference in which to return the minimum power management limit in milliwatts.
        - unsigned int: Reference in which to return the maximum power management limit in milliwatts.

    .. seealso:: `nvmlDeviceGetPowerManagementLimitConstraints`
    """
    cdef unsigned int min_limit
    cdef unsigned int max_limit
    with nogil:
        __status__ = nvmlDeviceGetPowerManagementLimitConstraints(<Device>device, &min_limit, &max_limit)
    check_status(__status__)
    return (min_limit, max_limit)


cpdef unsigned int device_get_power_management_default_limit(intptr_t device) except? 0:
    """Retrieves default power management limit on this device, in milliwatts. Default power management limit is a power management limit that the device boots with.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the default power management limit in milliwatts.

    .. seealso:: `nvmlDeviceGetPowerManagementDefaultLimit`
    """
    cdef unsigned int default_limit
    with nogil:
        __status__ = nvmlDeviceGetPowerManagementDefaultLimit(<Device>device, &default_limit)
    check_status(__status__)
    return default_limit


cpdef unsigned int device_get_power_usage(intptr_t device) except? 0:
    """Retrieves power usage for this GPU in milliwatts and its associated circuitry (e.g. memory).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the power usage information.

    .. seealso:: `nvmlDeviceGetPowerUsage`
    """
    cdef unsigned int power
    with nogil:
        __status__ = nvmlDeviceGetPowerUsage(<Device>device, &power)
    check_status(__status__)
    return power


cpdef unsigned long long device_get_total_energy_consumption(intptr_t device) except? 0:
    """Retrieves total energy consumption for this GPU in millijoules (mJ) since the driver was last reloaded.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned long long: Reference in which to return the energy consumption information.

    .. seealso:: `nvmlDeviceGetTotalEnergyConsumption`
    """
    cdef unsigned long long energy
    with nogil:
        __status__ = nvmlDeviceGetTotalEnergyConsumption(<Device>device, &energy)
    check_status(__status__)
    return energy


cpdef unsigned int device_get_enforced_power_limit(intptr_t device) except? 0:
    """Get the effective power limit that the driver enforces after taking into account all limiters.

    Args:
        device (intptr_t): The device to communicate with.

    Returns:
        unsigned int: Reference in which to return the power management limit in milliwatts.

    .. seealso:: `nvmlDeviceGetEnforcedPowerLimit`
    """
    cdef unsigned int limit
    with nogil:
        __status__ = nvmlDeviceGetEnforcedPowerLimit(<Device>device, &limit)
    check_status(__status__)
    return limit


cpdef tuple device_get_gpu_operation_mode(intptr_t device):
    """Retrieves the current GOM and pending GOM (the one that GPU will switch to after reboot).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: Reference in which to return the current GOM.
        - int: Reference in which to return the pending GOM.

    .. seealso:: `nvmlDeviceGetGpuOperationMode`
    """
    cdef _GpuOperationMode current
    cdef _GpuOperationMode pending
    with nogil:
        __status__ = nvmlDeviceGetGpuOperationMode(<Device>device, &current, &pending)
    check_status(__status__)
    return (<int>current, <int>pending)


cpdef object device_get_memory_info_v2(intptr_t device):
    """Retrieves the amount of used, free, reserved and total memory available on the device, in bytes. The reserved amount is supported on version 2 only.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlMemory_v2_t: Reference in which to return the memory information.

    .. seealso:: `nvmlDeviceGetMemoryInfo_v2`
    """
    cdef Memory_v2 memory_py = Memory_v2()
    cdef nvmlMemory_v2_t *memory = <nvmlMemory_v2_t *><intptr_t>(memory_py._get_ptr())
    memory.version = sizeof(nvmlMemory_v2_t) | (2 << 24)
    with nogil:
        __status__ = nvmlDeviceGetMemoryInfo_v2(<Device>device, memory)
    check_status(__status__)
    return memory_py


cpdef int device_get_compute_mode(intptr_t device) except? -1:
    """Retrieves the current compute mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the current compute mode.

    .. seealso:: `nvmlDeviceGetComputeMode`
    """
    cdef _ComputeMode mode
    with nogil:
        __status__ = nvmlDeviceGetComputeMode(<Device>device, &mode)
    check_status(__status__)
    return <int>mode


cpdef tuple device_get_cuda_compute_capability(intptr_t device):
    """Retrieves the CUDA compute capability of the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: Reference in which to return the major CUDA compute capability.
        - int: Reference in which to return the minor CUDA compute capability.

    .. seealso:: `nvmlDeviceGetCudaComputeCapability`
    """
    cdef int major
    cdef int minor
    with nogil:
        __status__ = nvmlDeviceGetCudaComputeCapability(<Device>device, &major, &minor)
    check_status(__status__)
    return (major, minor)


cpdef tuple device_get_dram_encryption_mode(intptr_t device):
    """Retrieves the current and pending DRAM Encryption modes for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - nvmlDramEncryptionInfo_v1_t: Reference in which to return the current DRAM Encryption mode.
        - nvmlDramEncryptionInfo_v1_t: Reference in which to return the pending DRAM Encryption mode.

    .. seealso:: `nvmlDeviceGetDramEncryptionMode`
    """
    cdef nvmlDramEncryptionInfo_t current
    cdef nvmlDramEncryptionInfo_t pending
    with nogil:
        __status__ = nvmlDeviceGetDramEncryptionMode(<Device>device, &current, &pending)
    check_status(__status__)
    return (<nvmlDramEncryptionInfo_v1_t>current, <nvmlDramEncryptionInfo_v1_t>pending)


cpdef device_set_dram_encryption_mode(intptr_t device, intptr_t dram_encryption):
    """Set the DRAM Encryption mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        dram_encryption (intptr_t): The target DRAM Encryption mode.

    .. seealso:: `nvmlDeviceSetDramEncryptionMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetDramEncryptionMode(<Device>device, <const nvmlDramEncryptionInfo_t*>dram_encryption)
    check_status(__status__)


cpdef tuple device_get_ecc_mode(intptr_t device):
    """Retrieves the current and pending ECC modes for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: Reference in which to return the current ECC mode.
        - int: Reference in which to return the pending ECC mode.

    .. seealso:: `nvmlDeviceGetEccMode`
    """
    cdef _EnableState current
    cdef _EnableState pending
    with nogil:
        __status__ = nvmlDeviceGetEccMode(<Device>device, &current, &pending)
    check_status(__status__)
    return (<int>current, <int>pending)


cpdef int device_get_default_ecc_mode(intptr_t device) except? -1:
    """Retrieves the default ECC modes for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the default ECC mode.

    .. seealso:: `nvmlDeviceGetDefaultEccMode`
    """
    cdef _EnableState default_mode
    with nogil:
        __status__ = nvmlDeviceGetDefaultEccMode(<Device>device, &default_mode)
    check_status(__status__)
    return <int>default_mode


cpdef unsigned int device_get_board_id(intptr_t device) except? 0:
    """Retrieves the device boardId from 0-N. Devices with the same boardId indicate GPUs connected to the same PLX. Use in conjunction with :func:`device_get_multi_gpu_board` to decide if they are on the same board as well. The boardId returned is a unique ID for the current configuration. Uniqueness and ordering across reboots and system configurations is not guaranteed (i.e. if a Tesla K40c returns 0x100 and the two GPUs on a Tesla K10 in the same system returns 0x200 it is not guaranteed they will always return those values but they will always be different from each other).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return the device's board ID.

    .. seealso:: `nvmlDeviceGetBoardId`
    """
    cdef unsigned int board_id
    with nogil:
        __status__ = nvmlDeviceGetBoardId(<Device>device, &board_id)
    check_status(__status__)
    return board_id


cpdef unsigned int device_get_multi_gpu_board(intptr_t device) except? 0:
    """Retrieves whether the device is on a Multi-GPU Board Devices that are on multi-GPU boards will set ``multiGpuBool`` to a non-zero value.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to return a zero or non-zero value to indicate whether the device is on a multi GPU board.

    .. seealso:: `nvmlDeviceGetMultiGpuBoard`
    """
    cdef unsigned int multi_gpu_bool
    with nogil:
        __status__ = nvmlDeviceGetMultiGpuBoard(<Device>device, &multi_gpu_bool)
    check_status(__status__)
    return multi_gpu_bool


cpdef unsigned long long device_get_total_ecc_errors(intptr_t device, int error_type, int counter_type) except? 0:
    """Retrieves the total ECC error counts for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        error_type (MemoryErrorType): Flag that specifies the type of the errors.
        counter_type (EccCounterType): Flag that specifies the counter-type of the errors.

    Returns:
        unsigned long long: Reference in which to return the specified ECC errors.

    .. seealso:: `nvmlDeviceGetTotalEccErrors`
    """
    cdef unsigned long long ecc_counts
    with nogil:
        __status__ = nvmlDeviceGetTotalEccErrors(<Device>device, <_MemoryErrorType>error_type, <_EccCounterType>counter_type, &ecc_counts)
    check_status(__status__)
    return ecc_counts


cpdef unsigned long long device_get_memory_error_counter(intptr_t device, int error_type, int counter_type, int location_type) except? 0:
    """Retrieves the requested memory error counter for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        error_type (MemoryErrorType): Flag that specifies the type of error.
        counter_type (EccCounterType): Flag that specifies the counter-type of the errors.
        location_type (MemoryLocation): Specifies the location of the counter.

    Returns:
        unsigned long long: Reference in which to return the ECC counter.

    .. seealso:: `nvmlDeviceGetMemoryErrorCounter`
    """
    cdef unsigned long long count
    with nogil:
        __status__ = nvmlDeviceGetMemoryErrorCounter(<Device>device, <_MemoryErrorType>error_type, <_EccCounterType>counter_type, <_MemoryLocation>location_type, &count)
    check_status(__status__)
    return count


cpdef object device_get_utilization_rates(intptr_t device):
    """Retrieves the current utilization rates for the device's major subsystems.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlUtilization_t: Reference in which to return the utilization information.

    .. seealso:: `nvmlDeviceGetUtilizationRates`
    """
    cdef Utilization utilization_py = Utilization()
    cdef nvmlUtilization_t *utilization = <nvmlUtilization_t *><intptr_t>(utilization_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetUtilizationRates(<Device>device, utilization)
    check_status(__status__)
    return utilization_py


cpdef tuple device_get_encoder_utilization(intptr_t device):
    """Retrieves the current utilization and sampling size in microseconds for the Encoder.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference to an unsigned int for encoder utilization info.
        - unsigned int: Reference to an unsigned int for the sampling period in US.

    .. seealso:: `nvmlDeviceGetEncoderUtilization`
    """
    cdef unsigned int utilization
    cdef unsigned int sampling_period_us
    with nogil:
        __status__ = nvmlDeviceGetEncoderUtilization(<Device>device, &utilization, &sampling_period_us)
    check_status(__status__)
    return (utilization, sampling_period_us)


cpdef unsigned int device_get_encoder_capacity(intptr_t device, int encoder_query_type) except? 0:
    """Retrieves the current capacity of the device's encoder, as a percentage of maximum encoder capacity with valid values in the range 0-100.

    Args:
        device (intptr_t): The identifier of the target device.
        encoder_query_type (EncoderType): Type of encoder to query.

    Returns:
        unsigned int: Reference to an unsigned int for the encoder capacity.

    .. seealso:: `nvmlDeviceGetEncoderCapacity`
    """
    cdef unsigned int encoder_capacity
    with nogil:
        __status__ = nvmlDeviceGetEncoderCapacity(<Device>device, <_EncoderType>encoder_query_type, &encoder_capacity)
    check_status(__status__)
    return encoder_capacity


cpdef tuple device_get_encoder_stats(intptr_t device):
    """Retrieves the current encoder statistics for a given device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 3-tuple containing:

        - unsigned int: Reference to an unsigned int for count of active encoder sessions.
        - unsigned int: Reference to an unsigned int for trailing average FPS of all active sessions.
        - unsigned int: Reference to an unsigned int for encode latency in microseconds.

    .. seealso:: `nvmlDeviceGetEncoderStats`
    """
    cdef unsigned int session_count
    cdef unsigned int average_fps
    cdef unsigned int average_latency
    with nogil:
        __status__ = nvmlDeviceGetEncoderStats(<Device>device, &session_count, &average_fps, &average_latency)
    check_status(__status__)
    return (session_count, average_fps, average_latency)


cpdef object device_get_encoder_sessions(intptr_t device):
    """Retrieves information about active encoder sessions on a target device.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetEncoderSessions`
    """
    cdef unsigned int[1] session_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetEncoderSessions(<Device>device, <unsigned int*>session_count, NULL)
    check_status_size(__status__)
    cdef EncoderSessionInfo session_infos = EncoderSessionInfo(session_count[0])
    cdef nvmlEncoderSessionInfo_t *session_infos_ptr = <nvmlEncoderSessionInfo_t *><intptr_t>(session_infos._get_ptr())
    if session_count[0] == 0:
        return session_infos
    with nogil:
        __status__ = nvmlDeviceGetEncoderSessions(<Device>device, <unsigned int*>session_count, session_infos_ptr)
    check_status(__status__)
    return session_infos


cpdef tuple device_get_decoder_utilization(intptr_t device):
    """Retrieves the current utilization and sampling size in microseconds for the Decoder.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference to an unsigned int for decoder utilization info.
        - unsigned int: Reference to an unsigned int for the sampling period in US.

    .. seealso:: `nvmlDeviceGetDecoderUtilization`
    """
    cdef unsigned int utilization
    cdef unsigned int sampling_period_us
    with nogil:
        __status__ = nvmlDeviceGetDecoderUtilization(<Device>device, &utilization, &sampling_period_us)
    check_status(__status__)
    return (utilization, sampling_period_us)


cpdef tuple device_get_jpg_utilization(intptr_t device):
    """Retrieves the current utilization and sampling size in microseconds for the JPG.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference to an unsigned int for jpg utilization info.
        - unsigned int: Reference to an unsigned int for the sampling period in US.

    .. seealso:: `nvmlDeviceGetJpgUtilization`
    """
    cdef unsigned int utilization
    cdef unsigned int sampling_period_us
    with nogil:
        __status__ = nvmlDeviceGetJpgUtilization(<Device>device, &utilization, &sampling_period_us)
    check_status(__status__)
    return (utilization, sampling_period_us)


cpdef tuple device_get_ofa_utilization(intptr_t device):
    """Retrieves the current utilization and sampling size in microseconds for the OFA (Optical Flow Accelerator).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Reference to an unsigned int for ofa utilization info.
        - unsigned int: Reference to an unsigned int for the sampling period in US.

    .. seealso:: `nvmlDeviceGetOfaUtilization`
    """
    cdef unsigned int utilization
    cdef unsigned int sampling_period_us
    with nogil:
        __status__ = nvmlDeviceGetOfaUtilization(<Device>device, &utilization, &sampling_period_us)
    check_status(__status__)
    return (utilization, sampling_period_us)


cpdef object device_get_fbc_stats(intptr_t device):
    """Retrieves the active frame buffer capture sessions statistics for a given device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlFBCStats_t: Reference to nvmlFBCStats_t structure containing NvFBC stats.

    .. seealso:: `nvmlDeviceGetFBCStats`
    """
    cdef FBCStats fbc_stats_py = FBCStats()
    cdef nvmlFBCStats_t *fbc_stats = <nvmlFBCStats_t *><intptr_t>(fbc_stats_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetFBCStats(<Device>device, fbc_stats)
    check_status(__status__)
    return fbc_stats_py


cpdef object device_get_fbc_sessions(intptr_t device):
    """Retrieves information about active frame buffer capture sessions on a target device.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetFBCSessions`
    """
    cdef unsigned int[1] session_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetFBCSessions(<Device>device, <unsigned int*>session_count, NULL)
    check_status_size(__status__)
    cdef FBCSessionInfo session_info = FBCSessionInfo(session_count[0])
    cdef nvmlFBCSessionInfo_t *session_info_ptr = <nvmlFBCSessionInfo_t *><intptr_t>(session_info._get_ptr())
    if session_count[0] == 0:
        return session_info
    with nogil:
        __status__ = nvmlDeviceGetFBCSessions(<Device>device, <unsigned int*>session_count, session_info_ptr)
    check_status(__status__)
    return session_info


cpdef tuple device_get_driver_model_v2(intptr_t device):
    """Retrieves the current and pending driver model for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - int: Reference in which to return the current driver model.
        - int: Reference in which to return the pending driver model.

    .. seealso:: `nvmlDeviceGetDriverModel_v2`
    """
    cdef _DriverModel current
    cdef _DriverModel pending
    with nogil:
        __status__ = nvmlDeviceGetDriverModel_v2(<Device>device, &current, &pending)
    check_status(__status__)
    return (<int>current, <int>pending)


cpdef str device_get_vbios_version(intptr_t device):
    """Get VBIOS version of the device.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetVbiosVersion`
    """
    cdef unsigned int length = 32
    cdef char[32] version
    with nogil:
        __status__ = nvmlDeviceGetVbiosVersion(<Device>device, version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef object device_get_bridge_chip_info(intptr_t device):
    """Get Bridge Chip Information for all the bridge chips on the board.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlBridgeChipHierarchy_t: Reference to the returned bridge chip Hierarchy.

    .. seealso:: `nvmlDeviceGetBridgeChipInfo`
    """
    cdef BridgeChipHierarchy bridge_hierarchy_py = BridgeChipHierarchy()
    cdef nvmlBridgeChipHierarchy_t *bridge_hierarchy = <nvmlBridgeChipHierarchy_t *><intptr_t>(bridge_hierarchy_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetBridgeChipInfo(<Device>device, bridge_hierarchy)
    check_status(__status__)
    return bridge_hierarchy_py


cpdef object device_get_compute_running_processes_v3(intptr_t device):
    """Get information about processes with a compute context on a device.

    Args:
        device (intptr_t): The device handle or MIG device handle.

    .. seealso:: `nvmlDeviceGetComputeRunningProcesses_v3`
    """
    cdef unsigned int[1] info_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetComputeRunningProcesses_v3(<Device>device, <unsigned int*>info_count, NULL)
    check_status_size(__status__)
    cdef ProcessInfo infos = ProcessInfo(info_count[0])
    cdef nvmlProcessInfo_t *infos_ptr = <nvmlProcessInfo_t *><intptr_t>(infos._get_ptr())
    if info_count[0] == 0:
        return infos
    with nogil:
        __status__ = nvmlDeviceGetComputeRunningProcesses_v3(<Device>device, <unsigned int*>info_count, infos_ptr)
    check_status(__status__)
    return infos


cpdef object device_get_mps_compute_running_processes_v3(intptr_t device):
    """Get information about processes with a Multi-Process Service (MPS) compute context on a device.

    Args:
        device (intptr_t): The device handle or MIG device handle.

    .. seealso:: `nvmlDeviceGetMPSComputeRunningProcesses_v3`
    """
    cdef unsigned int[1] info_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetMPSComputeRunningProcesses_v3(<Device>device, <unsigned int*>info_count, NULL)
    check_status_size(__status__)
    cdef ProcessInfo infos = ProcessInfo(info_count[0])
    cdef nvmlProcessInfo_t *infos_ptr = <nvmlProcessInfo_t *><intptr_t>(infos._get_ptr())
    if info_count[0] == 0:
        return infos
    with nogil:
        __status__ = nvmlDeviceGetMPSComputeRunningProcesses_v3(<Device>device, <unsigned int*>info_count, infos_ptr)
    check_status(__status__)
    return infos


cpdef int device_on_same_board(intptr_t device1, intptr_t device2) except? 0:
    """Check if the GPU devices are on the same physical board.

    Args:
        device1 (intptr_t): The first GPU device.
        device2 (intptr_t): The second GPU device.

    Returns:
        int: Reference in which to return the status. Non-zero indicates that the GPUs are on the same board.

    .. seealso:: `nvmlDeviceOnSameBoard`
    """
    cdef int on_same_board
    with nogil:
        __status__ = nvmlDeviceOnSameBoard(<Device>device1, <Device>device2, &on_same_board)
    check_status(__status__)
    return on_same_board


cpdef int device_get_api_restriction(intptr_t device, int api_type) except? -1:
    """Retrieves the root/admin permissions on the target API. See ``nvmlRestrictedAPI_t`` for the list of supported APIs. If an API is restricted only root users can call that API. See ``nvmlDeviceSetAPIRestriction`` to change current permissions.

    Args:
        device (intptr_t): The identifier of the target device.
        api_type (RestrictedAPI): Target API type for this operation.

    Returns:
        int: Reference in which to return the current restriction NVML_FEATURE_ENABLED indicates that the API is root-only NVML_FEATURE_DISABLED indicates that the API is accessible to all users.

    .. seealso:: `nvmlDeviceGetAPIRestriction`
    """
    cdef _EnableState is_restricted
    with nogil:
        __status__ = nvmlDeviceGetAPIRestriction(<Device>device, <_RestrictedAPI>api_type, &is_restricted)
    check_status(__status__)
    return <int>is_restricted


cpdef object device_get_bar1_memory_info(intptr_t device):
    """Gets Total, Available and Used size of BAR1 memory.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlBAR1Memory_t: Reference in which BAR1 memory information is returned.

    .. seealso:: `nvmlDeviceGetBAR1MemoryInfo`
    """
    cdef BAR1Memory bar1memory_py = BAR1Memory()
    cdef nvmlBAR1Memory_t *bar1memory = <nvmlBAR1Memory_t *><intptr_t>(bar1memory_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetBAR1MemoryInfo(<Device>device, bar1memory)
    check_status(__status__)
    return bar1memory_py


cpdef unsigned int device_get_irq_num(intptr_t device) except? 0:
    """Gets the device's interrupt number.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The interrupt number associated with the specified device.

    .. seealso:: `nvmlDeviceGetIrqNum`
    """
    cdef unsigned int irq_num
    with nogil:
        __status__ = nvmlDeviceGetIrqNum(<Device>device, &irq_num)
    check_status(__status__)
    return irq_num


cpdef unsigned int device_get_num_gpu_cores(intptr_t device) except? 0:
    """Gets the device's core count.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The number of cores for the specified device.

    .. seealso:: `nvmlDeviceGetNumGpuCores`
    """
    cdef unsigned int num_cores
    with nogil:
        __status__ = nvmlDeviceGetNumGpuCores(<Device>device, &num_cores)
    check_status(__status__)
    return num_cores


cpdef unsigned int device_get_power_source(intptr_t device) except *:
    """Gets the devices power source.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The power source of the device.

    .. seealso:: `nvmlDeviceGetPowerSource`
    """
    cdef nvmlPowerSource_t power_source
    with nogil:
        __status__ = nvmlDeviceGetPowerSource(<Device>device, &power_source)
    check_status(__status__)
    return <unsigned int>power_source


cpdef unsigned int device_get_memory_bus_width(intptr_t device) except? 0:
    """Gets the device's memory bus width.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The devices's memory bus width.

    .. seealso:: `nvmlDeviceGetMemoryBusWidth`
    """
    cdef unsigned int bus_width
    with nogil:
        __status__ = nvmlDeviceGetMemoryBusWidth(<Device>device, &bus_width)
    check_status(__status__)
    return bus_width


cpdef unsigned int device_get_pcie_link_max_speed(intptr_t device) except? 0:
    """Gets the device's PCIE Max Link speed in MBPS.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The devices's PCIE Max Link speed in MBPS.

    .. seealso:: `nvmlDeviceGetPcieLinkMaxSpeed`
    """
    cdef unsigned int max_speed
    with nogil:
        __status__ = nvmlDeviceGetPcieLinkMaxSpeed(<Device>device, &max_speed)
    check_status(__status__)
    return max_speed


cpdef unsigned int device_get_pcie_speed(intptr_t device) except? 0:
    """Gets the device's PCIe Link speed in Mbps.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The devices's PCIe Max Link speed in Mbps.

    .. seealso:: `nvmlDeviceGetPcieSpeed`
    """
    cdef unsigned int pcie_speed
    with nogil:
        __status__ = nvmlDeviceGetPcieSpeed(<Device>device, &pcie_speed)
    check_status(__status__)
    return pcie_speed


cpdef unsigned int device_get_adaptive_clock_info_status(intptr_t device) except? 0:
    """Gets the device's Adaptive Clock status.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The current adaptive clocking status, either NVML_ADAPTIVE_CLOCKING_INFO_STATUS_DISABLED or NVML_ADAPTIVE_CLOCKING_INFO_STATUS_ENABLED.

    .. seealso:: `nvmlDeviceGetAdaptiveClockInfoStatus`
    """
    cdef unsigned int adaptive_clock_status
    with nogil:
        __status__ = nvmlDeviceGetAdaptiveClockInfoStatus(<Device>device, &adaptive_clock_status)
    check_status(__status__)
    return adaptive_clock_status


cpdef unsigned int device_get_bus_type(intptr_t device) except? 0:
    """Get the type of the GPU Bus (PCIe, PCI, ...).

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: The PCI Bus type.

    .. seealso:: `nvmlDeviceGetBusType`
    """
    cdef nvmlBusType_t type
    with nogil:
        __status__ = nvmlDeviceGetBusType(<Device>device, &type)
    check_status(__status__)
    return <unsigned int>type


cpdef object system_get_conf_compute_capabilities():
    """Get Conf Computing System capabilities.

    Returns:
        nvmlConfComputeSystemCaps_t: System CC capabilities.

    .. seealso:: `nvmlSystemGetConfComputeCapabilities`
    """
    cdef ConfComputeSystemCaps capabilities_py = ConfComputeSystemCaps()
    cdef nvmlConfComputeSystemCaps_t *capabilities = <nvmlConfComputeSystemCaps_t *><intptr_t>(capabilities_py._get_ptr())
    with nogil:
        __status__ = nvmlSystemGetConfComputeCapabilities(capabilities)
    check_status(__status__)
    return capabilities_py


cpdef object system_get_conf_compute_state():
    """Get Conf Computing System State.

    Returns:
        nvmlConfComputeSystemState_t: System CC State.

    .. seealso:: `nvmlSystemGetConfComputeState`
    """
    cdef ConfComputeSystemState state_py = ConfComputeSystemState()
    cdef nvmlConfComputeSystemState_t *state = <nvmlConfComputeSystemState_t *><intptr_t>(state_py._get_ptr())
    with nogil:
        __status__ = nvmlSystemGetConfComputeState(state)
    check_status(__status__)
    return state_py


cpdef object device_get_conf_compute_mem_size_info(intptr_t device):
    """Get Conf Computing Protected and Unprotected Memory Sizes.

    Args:
        device (intptr_t): Device handle.

    Returns:
        nvmlConfComputeMemSizeInfo_t: Protected/Unprotected Memory sizes.

    .. seealso:: `nvmlDeviceGetConfComputeMemSizeInfo`
    """
    cdef ConfComputeMemSizeInfo mem_info_py = ConfComputeMemSizeInfo()
    cdef nvmlConfComputeMemSizeInfo_t *mem_info = <nvmlConfComputeMemSizeInfo_t *><intptr_t>(mem_info_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetConfComputeMemSizeInfo(<Device>device, mem_info)
    check_status(__status__)
    return mem_info_py


cpdef unsigned int system_get_conf_compute_gpus_ready_state() except? 0:
    """Get Conf Computing GPUs ready state.

    Returns:
        unsigned int: Returns GPU current work accepting state, NVML_CC_ACCEPTING_CLIENT_REQUESTS_TRUE or NVML_CC_ACCEPTING_CLIENT_REQUESTS_FALSE.

    .. seealso:: `nvmlSystemGetConfComputeGpusReadyState`
    """
    cdef unsigned int is_accepting_work
    with nogil:
        __status__ = nvmlSystemGetConfComputeGpusReadyState(&is_accepting_work)
    check_status(__status__)
    return is_accepting_work


cpdef object device_get_conf_compute_protected_memory_usage(intptr_t device):
    """Get Conf Computing protected memory usage.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlMemory_t: Reference in which to return the memory information.

    .. seealso:: `nvmlDeviceGetConfComputeProtectedMemoryUsage`
    """
    cdef Memory memory_py = Memory()
    cdef nvmlMemory_t *memory = <nvmlMemory_t *><intptr_t>(memory_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetConfComputeProtectedMemoryUsage(<Device>device, memory)
    check_status(__status__)
    return memory_py


cpdef object device_get_conf_compute_gpu_certificate(intptr_t device):
    """Get Conf Computing GPU certificate details.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlConfComputeGpuCertificate_t: Reference in which to return the gpu certificate information.

    .. seealso:: `nvmlDeviceGetConfComputeGpuCertificate`
    """
    cdef ConfComputeGpuCertificate gpu_cert_py = ConfComputeGpuCertificate()
    cdef nvmlConfComputeGpuCertificate_t *gpu_cert = <nvmlConfComputeGpuCertificate_t *><intptr_t>(gpu_cert_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetConfComputeGpuCertificate(<Device>device, gpu_cert)
    check_status(__status__)
    return gpu_cert_py


cpdef object device_get_conf_compute_gpu_attestation_report(intptr_t device):
    """Get Conf Computing GPU attestation report.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlConfComputeGpuAttestationReport_t: Reference in which to return the gpu attestation report.

    .. seealso:: `nvmlDeviceGetConfComputeGpuAttestationReport`
    """
    cdef ConfComputeGpuAttestationReport gpu_atst_report_py = ConfComputeGpuAttestationReport()
    cdef nvmlConfComputeGpuAttestationReport_t *gpu_atst_report = <nvmlConfComputeGpuAttestationReport_t *><intptr_t>(gpu_atst_report_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetConfComputeGpuAttestationReport(<Device>device, gpu_atst_report)
    check_status(__status__)
    return gpu_atst_report_py


cpdef object system_get_conf_compute_key_rotation_threshold_info():
    """Get Conf Computing key rotation threshold detail.

    Returns:
        nvmlConfComputeGetKeyRotationThresholdInfo_v1_t: Reference in which to return the key rotation threshold data.

    .. seealso:: `nvmlSystemGetConfComputeKeyRotationThresholdInfo`
    """
    cdef ConfComputeGetKeyRotationThresholdInfo_v1 p_key_rotation_thr_info_py = ConfComputeGetKeyRotationThresholdInfo_v1()
    cdef nvmlConfComputeGetKeyRotationThresholdInfo_t *p_key_rotation_thr_info = <nvmlConfComputeGetKeyRotationThresholdInfo_t *><intptr_t>(p_key_rotation_thr_info_py._get_ptr())
    p_key_rotation_thr_info.version = sizeof(nvmlConfComputeGetKeyRotationThresholdInfo_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlSystemGetConfComputeKeyRotationThresholdInfo(p_key_rotation_thr_info)
    check_status(__status__)
    return p_key_rotation_thr_info_py


cpdef device_set_conf_compute_unprotected_mem_size(intptr_t device, unsigned long long size_ki_b):
    """Set Conf Computing Unprotected Memory Size.

    Args:
        device (intptr_t): Device Handle.
        size_ki_b (unsigned long long): Unprotected Memory size to be set in KiB.

    .. seealso:: `nvmlDeviceSetConfComputeUnprotectedMemSize`
    """
    with nogil:
        __status__ = nvmlDeviceSetConfComputeUnprotectedMemSize(<Device>device, size_ki_b)
    check_status(__status__)


cpdef system_set_conf_compute_gpus_ready_state(unsigned int is_accepting_work):
    """Set Conf Computing GPUs ready state.

    Args:
        is_accepting_work (unsigned int): GPU accepting new work, NVML_CC_ACCEPTING_CLIENT_REQUESTS_TRUE or NVML_CC_ACCEPTING_CLIENT_REQUESTS_FALSE.

    .. seealso:: `nvmlSystemSetConfComputeGpusReadyState`
    """
    with nogil:
        __status__ = nvmlSystemSetConfComputeGpusReadyState(is_accepting_work)
    check_status(__status__)


cpdef system_set_conf_compute_key_rotation_threshold_info(intptr_t p_key_rotation_thr_info):
    """Set Conf Computing key rotation threshold.

    Args:
        p_key_rotation_thr_info (intptr_t): Reference to the key rotation threshold data.

    .. seealso:: `nvmlSystemSetConfComputeKeyRotationThresholdInfo`
    """
    with nogil:
        __status__ = nvmlSystemSetConfComputeKeyRotationThresholdInfo(<nvmlConfComputeSetKeyRotationThresholdInfo_t*>p_key_rotation_thr_info)
    check_status(__status__)


cpdef object system_get_conf_compute_settings():
    """Get Conf Computing System Settings.

    Returns:
        nvmlSystemConfComputeSettings_v1_t: System CC settings.

    .. seealso:: `nvmlSystemGetConfComputeSettings`
    """
    cdef SystemConfComputeSettings_v1 settings_py = SystemConfComputeSettings_v1()
    cdef nvmlSystemConfComputeSettings_t *settings = <nvmlSystemConfComputeSettings_t *><intptr_t>(settings_py._get_ptr())
    settings.version = sizeof(nvmlSystemConfComputeSettings_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlSystemGetConfComputeSettings(settings)
    check_status(__status__)
    return settings_py


cpdef char device_get_gsp_firmware_version(intptr_t device) except? 0:
    """Retrieve GSP firmware version.

    Args:
        device (intptr_t): Device handle.

    Returns:
        char: The retrieved GSP firmware version.

    .. seealso:: `nvmlDeviceGetGspFirmwareVersion`
    """
    cdef char version
    with nogil:
        __status__ = nvmlDeviceGetGspFirmwareVersion(<Device>device, &version)
    check_status(__status__)
    return version


cpdef tuple device_get_gsp_firmware_mode(intptr_t device):
    """Retrieve GSP firmware mode.

    Args:
        device (intptr_t): Device handle.

    Returns:
        A 2-tuple containing:

        - unsigned int: Pointer to specify if GSP firmware is enabled.
        - unsigned int: Pointer to specify if GSP firmware is supported by default on ``device``.

    .. seealso:: `nvmlDeviceGetGspFirmwareMode`
    """
    cdef unsigned int is_enabled
    cdef unsigned int default_mode
    with nogil:
        __status__ = nvmlDeviceGetGspFirmwareMode(<Device>device, &is_enabled, &default_mode)
    check_status(__status__)
    return (is_enabled, default_mode)


cpdef object device_get_sram_ecc_error_status(intptr_t device):
    """Get SRAM ECC error status of this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlEccSramErrorStatus_v1_t: Returns SRAM ECC error status.

    .. seealso:: `nvmlDeviceGetSramEccErrorStatus`
    """
    cdef EccSramErrorStatus_v1 status_py = EccSramErrorStatus_v1()
    cdef nvmlEccSramErrorStatus_t *status = <nvmlEccSramErrorStatus_t *><intptr_t>(status_py._get_ptr())
    status.version = sizeof(nvmlEccSramErrorStatus_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetSramEccErrorStatus(<Device>device, status)
    check_status(__status__)
    return status_py


cpdef int device_get_accounting_mode(intptr_t device) except? -1:
    """Queries the state of per process accounting mode.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the current accounting mode.

    .. seealso:: `nvmlDeviceGetAccountingMode`
    """
    cdef _EnableState mode
    with nogil:
        __status__ = nvmlDeviceGetAccountingMode(<Device>device, &mode)
    check_status(__status__)
    return <int>mode


cpdef object device_get_accounting_stats(intptr_t device, unsigned int pid):
    """Queries process's accounting stats.

    Args:
        device (intptr_t): The identifier of the target device.
        pid (unsigned int): Process Id of the target process to query stats for.

    Returns:
        nvmlAccountingStats_t: Reference in which to return the process's accounting stats.

    .. seealso:: `nvmlDeviceGetAccountingStats`
    """
    cdef AccountingStats stats_py = AccountingStats()
    cdef nvmlAccountingStats_t *stats = <nvmlAccountingStats_t *><intptr_t>(stats_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetAccountingStats(<Device>device, pid, stats)
    check_status(__status__)
    return stats_py


cpdef object device_get_accounting_pids(intptr_t device):
    """Queries list of processes that can be queried for accounting stats. The list of processes returned can be in running or terminated state.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetAccountingPids`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlDeviceGetAccountingPids(<Device>device, <unsigned int*>count, NULL)
    check_status_size(__status__)
    if count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned int), format="I", mode="c")[:0]
    cdef view.array pids = view.array(shape=(count[0],), itemsize=sizeof(unsigned int), format="I", mode="c")
    cdef unsigned int *pids_ptr = <unsigned int *>(pids.data)
    with nogil:
        __status__ = nvmlDeviceGetAccountingPids(<Device>device, <unsigned int*>count, pids_ptr)
    check_status(__status__)
    return pids


cpdef unsigned int device_get_accounting_buffer_size(intptr_t device) except? 0:
    """Returns the number of processes that the circular buffer with accounting pids can hold.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference in which to provide the size (in number of elements) of the circular buffer for accounting stats.

    .. seealso:: `nvmlDeviceGetAccountingBufferSize`
    """
    cdef unsigned int buffer_size
    with nogil:
        __status__ = nvmlDeviceGetAccountingBufferSize(<Device>device, &buffer_size)
    check_status(__status__)
    return buffer_size


cpdef object device_get_retired_pages(intptr_t device, int cause):
    """Returns the list of retired pages by source, including pages that are pending retirement The address information provided from this API is the hardware address of the page that was retired. Note that this does not match the virtual address used in CUDA, but will match the address information in Xid 63.

    Args:
        device (intptr_t): The identifier of the target device.
        cause (PageRetirementCause): Filter page addresses by cause of retirement.

    .. seealso:: `nvmlDeviceGetRetiredPages`
    """
    cdef unsigned int[1] page_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetRetiredPages(<Device>device, <_PageRetirementCause>cause, <unsigned int*>page_count, NULL)
    check_status_size(__status__)
    if page_count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned long long), format="Q", mode="c")[:0]
    cdef view.array addresses = view.array(shape=(page_count[0],), itemsize=sizeof(unsigned long long), format="Q", mode="c")
    cdef unsigned long long *addresses_ptr = <unsigned long long *>(addresses.data)
    with nogil:
        __status__ = nvmlDeviceGetRetiredPages(<Device>device, <_PageRetirementCause>cause, <unsigned int*>page_count, addresses_ptr)
    check_status(__status__)
    return addresses


cpdef int device_get_retired_pages_pending_status(intptr_t device) except? -1:
    """Check if any pages are pending retirement and need a reboot to fully retire.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the pending status.

    .. seealso:: `nvmlDeviceGetRetiredPagesPendingStatus`
    """
    cdef _EnableState is_pending
    with nogil:
        __status__ = nvmlDeviceGetRetiredPagesPendingStatus(<Device>device, &is_pending)
    check_status(__status__)
    return <int>is_pending


cpdef tuple device_get_remapped_rows(intptr_t device):
    """Get number of remapped rows. The number of rows reported will be based on the cause of the remapping. isPending indicates whether or not there are pending remappings. A reset will be required to actually remap the row. failureOccurred will be set if a row remapping ever failed in the past. A pending remapping won't affect future work on the GPU since error-containment and dynamic page blacklisting will take care of that.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 4-tuple containing:

        - unsigned int: Reference for number of rows remapped due to correctable errors.
        - unsigned int: Reference for number of rows remapped due to uncorrectable errors.
        - unsigned int: Reference for whether or not remappings are pending.
        - unsigned int: Reference that is set when a remapping has failed in the past.

    .. seealso:: `nvmlDeviceGetRemappedRows`
    """
    cdef unsigned int corr_rows
    cdef unsigned int unc_rows
    cdef unsigned int is_pending
    cdef unsigned int failure_occurred
    with nogil:
        __status__ = nvmlDeviceGetRemappedRows(<Device>device, &corr_rows, &unc_rows, &is_pending, &failure_occurred)
    check_status(__status__)
    return (corr_rows, unc_rows, is_pending, failure_occurred)


cpdef object device_get_row_remapper_histogram(intptr_t device):
    """Get the row remapper histogram. Returns the remap availability for each bank on the GPU.

    Args:
        device (intptr_t): Device handle.

    Returns:
        nvmlRowRemapperHistogramValues_t: Histogram values.

    .. seealso:: `nvmlDeviceGetRowRemapperHistogram`
    """
    cdef RowRemapperHistogramValues values_py = RowRemapperHistogramValues()
    cdef nvmlRowRemapperHistogramValues_t *values = <nvmlRowRemapperHistogramValues_t *><intptr_t>(values_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetRowRemapperHistogram(<Device>device, values)
    check_status(__status__)
    return values_py


cpdef unsigned int device_get_architecture(intptr_t device) except? 0:
    """Get architecture for device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Reference where architecture is returned, if call successful. Set to NVML_DEVICE_ARCH_* upon success.

    .. seealso:: `nvmlDeviceGetArchitecture`
    """
    cdef nvmlDeviceArchitecture_t arch
    with nogil:
        __status__ = nvmlDeviceGetArchitecture(<Device>device, &arch)
    check_status(__status__)
    return <unsigned int>arch


cpdef object device_get_clk_mon_status(intptr_t device):
    """Retrieves the frequency monitor fault status for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlClkMonStatus_t: Reference in which to return the clkmon fault status.

    .. seealso:: `nvmlDeviceGetClkMonStatus`
    """
    cdef ClkMonStatus status_py = ClkMonStatus()
    cdef nvmlClkMonStatus_t *status = <nvmlClkMonStatus_t *><intptr_t>(status_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetClkMonStatus(<Device>device, status)
    check_status(__status__)
    return status_py


cpdef object device_get_process_utilization(intptr_t device, unsigned long long last_seen_time_stamp):
    """Retrieves the current utilization and process ID.

    Args:
        device (intptr_t): The identifier of the target device.
        last_seen_time_stamp (unsigned long long): Pointer to caller-supplied buffer in which guest process utilization samples are returned.

    .. seealso:: `nvmlDeviceGetProcessUtilization`
    """
    cdef unsigned int[1] process_samples_count = [0]
    with nogil:
        __status__ = nvmlDeviceGetProcessUtilization(<Device>device, NULL, <unsigned int*>process_samples_count, last_seen_time_stamp)
    check_status_size(__status__)
    cdef ProcessUtilizationSample utilization = ProcessUtilizationSample(process_samples_count[0])
    cdef nvmlProcessUtilizationSample_t *utilization_ptr = <nvmlProcessUtilizationSample_t *><intptr_t>(utilization._get_ptr())
    if process_samples_count[0] == 0:
        return utilization
    with nogil:
        __status__ = nvmlDeviceGetProcessUtilization(<Device>device, utilization_ptr, <unsigned int*>process_samples_count, last_seen_time_stamp)
    check_status(__status__)
    return utilization


cpdef unit_set_led_state(intptr_t unit, int color):
    """Set the LED state for the unit. The LED can be either green (0) or amber (1).

    Args:
        unit (intptr_t): The identifier of the target unit.
        color (LedColor): The target LED color.

    .. seealso:: `nvmlUnitSetLedState`
    """
    with nogil:
        __status__ = nvmlUnitSetLedState(<Unit>unit, <_LedColor>color)
    check_status(__status__)


cpdef device_set_persistence_mode(intptr_t device, int mode):
    """Set the persistence mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        mode (EnableState): The target persistence mode.

    .. seealso:: `nvmlDeviceSetPersistenceMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetPersistenceMode(<Device>device, <_EnableState>mode)
    check_status(__status__)


cpdef device_set_compute_mode(intptr_t device, int mode):
    """Set the compute mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        mode (ComputeMode): The target compute mode.

    .. seealso:: `nvmlDeviceSetComputeMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetComputeMode(<Device>device, <_ComputeMode>mode)
    check_status(__status__)


cpdef device_set_ecc_mode(intptr_t device, int ecc):
    """Set the ECC mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        ecc (EnableState): The target ECC mode.

    .. seealso:: `nvmlDeviceSetEccMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetEccMode(<Device>device, <_EnableState>ecc)
    check_status(__status__)


cpdef device_clear_ecc_error_counts(intptr_t device, int counter_type):
    """Clear the ECC error and other memory error counts for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        counter_type (EccCounterType): Flag that indicates which type of errors should be cleared.

    .. seealso:: `nvmlDeviceClearEccErrorCounts`
    """
    with nogil:
        __status__ = nvmlDeviceClearEccErrorCounts(<Device>device, <_EccCounterType>counter_type)
    check_status(__status__)


cpdef device_set_driver_model(intptr_t device, int driver_model, unsigned int flags):
    """Set the driver model for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        driver_model (DriverModel): The target driver model.
        flags (unsigned int): Flags that change the default behavior.

    .. seealso:: `nvmlDeviceSetDriverModel`
    """
    with nogil:
        __status__ = nvmlDeviceSetDriverModel(<Device>device, <_DriverModel>driver_model, flags)
    check_status(__status__)


cpdef device_set_gpu_locked_clocks(intptr_t device, unsigned int min_gpu_clock_m_hz, unsigned int max_gpu_clock_m_hz):
    """Set clocks that device will lock to.

    Args:
        device (intptr_t): The identifier of the target device.
        min_gpu_clock_m_hz (unsigned int): Requested minimum gpu clock in MHz.
        max_gpu_clock_m_hz (unsigned int): Requested maximum gpu clock in MHz.

    .. seealso:: `nvmlDeviceSetGpuLockedClocks`
    """
    with nogil:
        __status__ = nvmlDeviceSetGpuLockedClocks(<Device>device, min_gpu_clock_m_hz, max_gpu_clock_m_hz)
    check_status(__status__)


cpdef device_reset_gpu_locked_clocks(intptr_t device):
    """Resets the gpu clock to the default value.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceResetGpuLockedClocks`
    """
    with nogil:
        __status__ = nvmlDeviceResetGpuLockedClocks(<Device>device)
    check_status(__status__)


cpdef device_set_memory_locked_clocks(intptr_t device, unsigned int min_mem_clock_m_hz, unsigned int max_mem_clock_m_hz):
    """Set memory clocks that device will lock to.

    Args:
        device (intptr_t): The identifier of the target device.
        min_mem_clock_m_hz (unsigned int): Requested minimum memory clock in MHz.
        max_mem_clock_m_hz (unsigned int): Requested maximum memory clock in MHz.

    .. seealso:: `nvmlDeviceSetMemoryLockedClocks`
    """
    with nogil:
        __status__ = nvmlDeviceSetMemoryLockedClocks(<Device>device, min_mem_clock_m_hz, max_mem_clock_m_hz)
    check_status(__status__)


cpdef device_reset_memory_locked_clocks(intptr_t device):
    """Resets the memory clock to the default value.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceResetMemoryLockedClocks`
    """
    with nogil:
        __status__ = nvmlDeviceResetMemoryLockedClocks(<Device>device)
    check_status(__status__)


cpdef device_set_auto_boosted_clocks_enabled(intptr_t device, int enabled):
    """Try to set the current state of Auto Boosted clocks on a device.

    Args:
        device (intptr_t): The identifier of the target device.
        enabled (EnableState): What state to try to set Auto Boosted clocks of the target device to.

    .. seealso:: `nvmlDeviceSetAutoBoostedClocksEnabled`
    """
    with nogil:
        __status__ = nvmlDeviceSetAutoBoostedClocksEnabled(<Device>device, <_EnableState>enabled)
    check_status(__status__)


cpdef device_set_default_auto_boosted_clocks_enabled(intptr_t device, int enabled, unsigned int flags):
    """Try to set the default state of Auto Boosted clocks on a device. This is the default state that Auto Boosted clocks will return to when no compute running processes (e.g. CUDA application which have an active context) are running.

    Args:
        device (intptr_t): The identifier of the target device.
        enabled (EnableState): What state to try to set default Auto Boosted clocks of the target device to.
        flags (unsigned int): Flags that change the default behavior. Currently Unused.

    .. seealso:: `nvmlDeviceSetDefaultAutoBoostedClocksEnabled`
    """
    with nogil:
        __status__ = nvmlDeviceSetDefaultAutoBoostedClocksEnabled(<Device>device, <_EnableState>enabled, flags)
    check_status(__status__)


cpdef device_set_default_fan_speed_v2(intptr_t device, unsigned int fan):
    """Sets the speed of the fan control policy to default.

    Args:
        device (intptr_t): The identifier of the target device.
        fan (unsigned int): The index of the fan, starting at zero.

    .. seealso:: `nvmlDeviceSetDefaultFanSpeed_v2`
    """
    with nogil:
        __status__ = nvmlDeviceSetDefaultFanSpeed_v2(<Device>device, fan)
    check_status(__status__)


cpdef device_set_fan_control_policy(intptr_t device, unsigned int fan, unsigned int policy):
    """Sets current fan control policy.

    Args:
        device (intptr_t): The identifier of the target ``device``.
        fan (unsigned int): The index of the fan, starting at zero.
        policy (unsigned int): The fan control ``policy`` to set.

    .. seealso:: `nvmlDeviceSetFanControlPolicy`
    """
    with nogil:
        __status__ = nvmlDeviceSetFanControlPolicy(<Device>device, fan, <nvmlFanControlPolicy_t>policy)
    check_status(__status__)


cpdef device_set_temperature_threshold(intptr_t device, int threshold_type, intptr_t temp):
    """Sets the temperature threshold for the GPU with the specified threshold type in degrees C.

    Args:
        device (intptr_t): The identifier of the target device.
        threshold_type (TemperatureThresholds): The type of threshold value to be set.
        temp (intptr_t): Reference which hold the value to be set.

    .. seealso:: `nvmlDeviceSetTemperatureThreshold`
    """
    with nogil:
        __status__ = nvmlDeviceSetTemperatureThreshold(<Device>device, <_TemperatureThresholds>threshold_type, <int*>temp)
    check_status(__status__)


cpdef device_set_power_management_limit(intptr_t device, unsigned int limit):
    """Set new power limit of this device.

    Args:
        device (intptr_t): The identifier of the target device.
        limit (unsigned int): Power management limit in milliwatts to set.

    .. seealso:: `nvmlDeviceSetPowerManagementLimit`
    """
    with nogil:
        __status__ = nvmlDeviceSetPowerManagementLimit(<Device>device, limit)
    check_status(__status__)


cpdef device_set_gpu_operation_mode(intptr_t device, int mode):
    """Sets new GOM. See ``nvmlGpuOperationMode_t`` for details.

    Args:
        device (intptr_t): The identifier of the target device.
        mode (GpuOperationMode): Target GOM.

    .. seealso:: `nvmlDeviceSetGpuOperationMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetGpuOperationMode(<Device>device, <_GpuOperationMode>mode)
    check_status(__status__)


cpdef device_set_api_restriction(intptr_t device, int api_type, int is_restricted):
    """Changes the root/admin restructions on certain APIs. See ``nvmlRestrictedAPI_t`` for the list of supported APIs. This method can be used by a root/admin user to give non-root/admin access to certain otherwise-restricted APIs. The new setting lasts for the lifetime of the NVIDIA driver; it is not persistent. See ``nvmlDeviceGetAPIRestriction`` to query the current restriction settings.

    Args:
        device (intptr_t): The identifier of the target device.
        api_type (RestrictedAPI): Target API type for this operation.
        is_restricted (EnableState): The target restriction.

    .. seealso:: `nvmlDeviceSetAPIRestriction`
    """
    with nogil:
        __status__ = nvmlDeviceSetAPIRestriction(<Device>device, <_RestrictedAPI>api_type, <_EnableState>is_restricted)
    check_status(__status__)


cpdef device_set_fan_speed_v2(intptr_t device, unsigned int fan, unsigned int speed):
    """Sets the speed of a specified fan.

    Args:
        device (intptr_t): The identifier of the target device.
        fan (unsigned int): The index of the fan, starting at zero.
        speed (unsigned int): The target speed of the fan [0-100] in % of max speed.

    .. seealso:: `nvmlDeviceSetFanSpeed_v2`
    """
    with nogil:
        __status__ = nvmlDeviceSetFanSpeed_v2(<Device>device, fan, speed)
    check_status(__status__)


cpdef device_set_accounting_mode(intptr_t device, int mode):
    """Enables or disables per process accounting.

    Args:
        device (intptr_t): The identifier of the target device.
        mode (EnableState): The target accounting mode.

    .. seealso:: `nvmlDeviceSetAccountingMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetAccountingMode(<Device>device, <_EnableState>mode)
    check_status(__status__)


cpdef device_clear_accounting_pids(intptr_t device):
    """Clears accounting information about all processes that have already terminated.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceClearAccountingPids`
    """
    with nogil:
        __status__ = nvmlDeviceClearAccountingPids(<Device>device)
    check_status(__status__)


cpdef device_set_power_management_limit_v2(intptr_t device, intptr_t power_value):
    """Set new power limit of this device.

    Args:
        device (intptr_t): The identifier of the target device.
        power_value (intptr_t): Power management limit in milliwatts to set.

    .. seealso:: `nvmlDeviceSetPowerManagementLimit_v2`
    """
    with nogil:
        __status__ = nvmlDeviceSetPowerManagementLimit_v2(<Device>device, <nvmlPowerValue_v2_t*>power_value)
    check_status(__status__)


cpdef int device_get_nvlink_state(intptr_t device, unsigned int link) except? -1:
    """Retrieves the state of the device's NvLink for the link specified.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.

    Returns:
        int: ``nvmlEnableState_t`` where NVML_FEATURE_ENABLED indicates that the link is active and NVML_FEATURE_DISABLED indicates it is inactive.

    .. seealso:: `nvmlDeviceGetNvLinkState`
    """
    cdef _EnableState is_active
    with nogil:
        __status__ = nvmlDeviceGetNvLinkState(<Device>device, link, &is_active)
    check_status(__status__)
    return <int>is_active


cpdef unsigned int device_get_nvlink_version(intptr_t device, unsigned int link) except? 0:
    """Retrieves the version of the device's NvLink for the link specified.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.

    Returns:
        unsigned int: Requested NvLink version from nvmlNvlinkVersion_t.

    .. seealso:: `nvmlDeviceGetNvLinkVersion`
    """
    cdef unsigned int version
    with nogil:
        __status__ = nvmlDeviceGetNvLinkVersion(<Device>device, link, &version)
    check_status(__status__)
    return version


cpdef unsigned int device_get_nvlink_capability(intptr_t device, unsigned int link, int capability) except? 0:
    """Retrieves the requested capability from the device's NvLink for the link specified Please refer to the ``nvmlNvLinkCapability_t`` structure for the specific caps that can be queried The return value should be treated as a boolean.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.
        capability (NvLinkCapability): Specifies the ``nvmlNvLinkCapability_t`` to be queried.

    Returns:
        unsigned int: A boolean for the queried capability indicating that feature is available.

    .. seealso:: `nvmlDeviceGetNvLinkCapability`
    """
    cdef unsigned int cap_result
    with nogil:
        __status__ = nvmlDeviceGetNvLinkCapability(<Device>device, link, <_NvLinkCapability>capability, &cap_result)
    check_status(__status__)
    return cap_result


cpdef object device_get_nvlink_remote_pci_info_v2(intptr_t device, unsigned int link):
    """Retrieves the PCI information for the remote node on a NvLink link Note: pciSubSystemId is not filled in this function and is indeterminate.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.

    Returns:
        nvmlPciInfo_t: ``nvmlPciInfo_t`` of the remote node for the specified link.

    .. seealso:: `nvmlDeviceGetNvLinkRemotePciInfo_v2`
    """
    cdef PciInfo pci_py = PciInfo()
    cdef nvmlPciInfo_t *pci = <nvmlPciInfo_t *><intptr_t>(pci_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetNvLinkRemotePciInfo_v2(<Device>device, link, pci)
    check_status(__status__)
    return pci_py


cpdef unsigned long long device_get_nvlink_error_counter(intptr_t device, unsigned int link, int counter) except? 0:
    """Retrieves the specified error counter value Please refer to ``nvmlNvLinkErrorCounter_t`` for error counters that are available.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.
        counter (NvLinkErrorCounter): Specifies the NvLink counter to be queried.

    Returns:
        unsigned long long: Returned counter value.

    .. seealso:: `nvmlDeviceGetNvLinkErrorCounter`
    """
    cdef unsigned long long counter_value
    with nogil:
        __status__ = nvmlDeviceGetNvLinkErrorCounter(<Device>device, link, <_NvLinkErrorCounter>counter, &counter_value)
    check_status(__status__)
    return counter_value


cpdef device_reset_nvlink_error_counters(intptr_t device, unsigned int link):
    """Resets all error counters to zero Please refer to ``nvmlNvLinkErrorCounter_t`` for the list of error counters that are reset.

    Args:
        device (intptr_t): The identifier of the target device.
        link (unsigned int): Specifies the NvLink link to be queried.

    .. seealso:: `nvmlDeviceResetNvLinkErrorCounters`
    """
    with nogil:
        __status__ = nvmlDeviceResetNvLinkErrorCounters(<Device>device, link)
    check_status(__status__)


cpdef int device_get_nvlink_remote_device_type(intptr_t device, unsigned int link) except? -1:
    """Get the NVLink device type of the remote device connected over the given link.

    Args:
        device (intptr_t): The device handle of the target GPU.
        link (unsigned int): The NVLink link index on the target GPU.

    Returns:
        int: Pointer in which the output remote device type is returned.

    .. seealso:: `nvmlDeviceGetNvLinkRemoteDeviceType`
    """
    cdef _IntNvLinkDeviceType p_nv_link_device_type
    with nogil:
        __status__ = nvmlDeviceGetNvLinkRemoteDeviceType(<Device>device, link, &p_nv_link_device_type)
    check_status(__status__)
    return <int>p_nv_link_device_type


cpdef device_set_nvlink_device_low_power_threshold(intptr_t device, intptr_t info):
    """Set NvLink Low Power Threshold for device.

    Args:
        device (intptr_t): The identifier of the target device.
        info (intptr_t): Reference to ``nvmlNvLinkPowerThres_t`` struct input parameters.

    .. seealso:: `nvmlDeviceSetNvLinkDeviceLowPowerThreshold`
    """
    with nogil:
        __status__ = nvmlDeviceSetNvLinkDeviceLowPowerThreshold(<Device>device, <nvmlNvLinkPowerThres_t*>info)
    check_status(__status__)


cpdef system_set_nvlink_bw_mode(unsigned int nvlink_bw_mode):
    """Set the global nvlink bandwith mode.

    Args:
        nvlink_bw_mode (unsigned int): nvlink bandwidth mode.

    .. seealso:: `nvmlSystemSetNvlinkBwMode`
    """
    with nogil:
        __status__ = nvmlSystemSetNvlinkBwMode(nvlink_bw_mode)
    check_status(__status__)


cpdef unsigned int system_get_nvlink_bw_mode() except? 0:
    """Get the global nvlink bandwith mode.

    Returns:
        unsigned int: reference of nvlink bandwidth mode.

    .. seealso:: `nvmlSystemGetNvlinkBwMode`
    """
    cdef unsigned int nvlink_bw_mode
    with nogil:
        __status__ = nvmlSystemGetNvlinkBwMode(&nvlink_bw_mode)
    check_status(__status__)
    return nvlink_bw_mode


cpdef object device_get_nvlink_supported_bw_modes(intptr_t device):
    """Get the supported NvLink Reduced Bandwidth Modes of the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlNvlinkSupportedBwModes_v1_t: Reference to ``nvmlNvlinkSupportedBwModes_t``.

    .. seealso:: `nvmlDeviceGetNvlinkSupportedBwModes`
    """
    cdef NvlinkSupportedBwModes_v1 supported_bw_mode_py = NvlinkSupportedBwModes_v1()
    cdef nvmlNvlinkSupportedBwModes_t *supported_bw_mode = <nvmlNvlinkSupportedBwModes_t *><intptr_t>(supported_bw_mode_py._get_ptr())
    supported_bw_mode.version = sizeof(nvmlNvlinkSupportedBwModes_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetNvlinkSupportedBwModes(<Device>device, supported_bw_mode)
    check_status(__status__)
    return supported_bw_mode_py


cpdef object device_get_nvlink_bw_mode(intptr_t device):
    """Get the NvLink Reduced Bandwidth Mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlNvlinkGetBwMode_v1_t: Reference to ``nvmlNvlinkGetBwMode_t``.

    .. seealso:: `nvmlDeviceGetNvlinkBwMode`
    """
    cdef NvlinkGetBwMode_v1 get_bw_mode_py = NvlinkGetBwMode_v1()
    cdef nvmlNvlinkGetBwMode_t *get_bw_mode = <nvmlNvlinkGetBwMode_t *><intptr_t>(get_bw_mode_py._get_ptr())
    get_bw_mode.version = sizeof(nvmlNvlinkGetBwMode_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetNvlinkBwMode(<Device>device, get_bw_mode)
    check_status(__status__)
    return get_bw_mode_py


cpdef device_set_nvlink_bw_mode(intptr_t device, intptr_t set_bw_mode):
    """Set the NvLink Reduced Bandwidth Mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        set_bw_mode (intptr_t): Reference to ``nvmlNvlinkSetBwMode_t``.

    .. seealso:: `nvmlDeviceSetNvlinkBwMode`
    """
    set_bw_mode.version = sizeof(nvmlNvlinkSetBwMode_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceSetNvlinkBwMode(<Device>device, <nvmlNvlinkSetBwMode_t*>set_bw_mode)
    check_status(__status__)


cpdef intptr_t event_set_create() except? 0:
    """Create an empty set of events. Event set should be freed by ``nvmlEventSetFree``.

    Returns:
        intptr_t: Reference in which to return the event handle.

    .. seealso:: `nvmlEventSetCreate`
    """
    cdef EventSet set
    with nogil:
        __status__ = nvmlEventSetCreate(&set)
    check_status(__status__)
    return <intptr_t>set


cpdef device_register_events(intptr_t device, unsigned long long event_types, intptr_t set):
    """Starts recording of events on a specified devices and add the events to specified ``nvmlEventSet_t``.

    Args:
        device (intptr_t): The identifier of the target device.
        event_types (unsigned long long): Bitmask of ``Event Types`` to record.
        set (intptr_t): Set to which add new event types.

    .. seealso:: `nvmlDeviceRegisterEvents`
    """
    with nogil:
        __status__ = nvmlDeviceRegisterEvents(<Device>device, event_types, <EventSet>set)
    check_status(__status__)


cpdef unsigned long long device_get_supported_event_types(intptr_t device) except? 0:
    """Returns information about events supported on device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned long long: Reference in which to return bitmask of supported events.

    .. seealso:: `nvmlDeviceGetSupportedEventTypes`
    """
    cdef unsigned long long event_types
    with nogil:
        __status__ = nvmlDeviceGetSupportedEventTypes(<Device>device, &event_types)
    check_status(__status__)
    return event_types


cpdef object event_set_wait_v2(intptr_t set, unsigned int timeoutms):
    """Waits on events and delivers events.

    Args:
        set (intptr_t): Reference to set of events to wait on.
        timeoutms (unsigned int): Maximum amount of wait time in milliseconds for registered event.

    Returns:
        nvmlEventData_t: Reference in which to return event data.

    .. seealso:: `nvmlEventSetWait_v2`
    """
    cdef EventData data_py = EventData()
    cdef nvmlEventData_t *data = <nvmlEventData_t *><intptr_t>(data_py._get_ptr())
    with nogil:
        __status__ = nvmlEventSetWait_v2(<EventSet>set, data, timeoutms)
    check_status(__status__)
    return data_py


cpdef event_set_free(intptr_t set):
    """Releases events in the set.

    Args:
        set (intptr_t): Reference to events to be released.

    .. seealso:: `nvmlEventSetFree`
    """
    with nogil:
        __status__ = nvmlEventSetFree(<EventSet>set)
    check_status(__status__)


cpdef system_event_set_create(intptr_t request):
    """Create an empty set of system events. Event set should be freed by ``nvmlSystemEventSetFree``.

    Args:
        request (intptr_t): Reference to nvmlSystemEventSetCreateRequest_t.

    .. seealso:: `nvmlSystemEventSetCreate`
    """
    with nogil:
        __status__ = nvmlSystemEventSetCreate(<nvmlSystemEventSetCreateRequest_t*>request)
    check_status(__status__)


cpdef system_event_set_free(intptr_t request):
    """Releases system event set.

    Args:
        request (intptr_t): Reference to nvmlSystemEventSetFreeRequest_t.

    .. seealso:: `nvmlSystemEventSetFree`
    """
    with nogil:
        __status__ = nvmlSystemEventSetFree(<nvmlSystemEventSetFreeRequest_t*>request)
    check_status(__status__)


cpdef system_register_events(intptr_t request):
    """Starts recording of events on system and add the events to specified ``nvmlSystemEventSet_t``.

    Args:
        request (intptr_t): Reference to the struct nvmlSystemRegisterEventRequest_t.

    .. seealso:: `nvmlSystemRegisterEvents`
    """
    with nogil:
        __status__ = nvmlSystemRegisterEvents(<nvmlSystemRegisterEventRequest_t*>request)
    check_status(__status__)


cpdef system_event_set_wait(intptr_t request):
    """Waits on system events and delivers events.

    Args:
        request (intptr_t): Reference in which to nvmlSystemEventSetWaitRequest_t.

    .. seealso:: `nvmlSystemEventSetWait`
    """
    with nogil:
        __status__ = nvmlSystemEventSetWait(<nvmlSystemEventSetWaitRequest_t*>request)
    check_status(__status__)


cpdef device_modify_drain_state(intptr_t pci_info, int new_state):
    """Modify the drain state of a GPU. This method forces a GPU to no longer accept new incoming requests. Any new NVML process will no longer see this GPU. Persistence mode for this GPU must be turned off before this call is made. Must be called as administrator. For Linux only.

    Args:
        pci_info (intptr_t): The PCI address of the GPU drain state to be modified.
        new_state (EnableState): The drain state that should be entered, see ``nvmlEnableState_t``.

    .. seealso:: `nvmlDeviceModifyDrainState`
    """
    with nogil:
        __status__ = nvmlDeviceModifyDrainState(<nvmlPciInfo_t*>pci_info, <_EnableState>new_state)
    check_status(__status__)


cpdef int device_query_drain_state(intptr_t pci_info) except? -1:
    """Query the drain state of a GPU. This method is used to check if a GPU is in a currently draining state. For Linux only.

    Args:
        pci_info (intptr_t): The PCI address of the GPU drain state to be queried.

    Returns:
        int: The current drain state for this GPU, see ``nvmlEnableState_t``.

    .. seealso:: `nvmlDeviceQueryDrainState`
    """
    cdef _EnableState current_state
    with nogil:
        __status__ = nvmlDeviceQueryDrainState(<nvmlPciInfo_t*>pci_info, &current_state)
    check_status(__status__)
    return <int>current_state


cpdef device_remove_gpu_v2(intptr_t pci_info, int gpu_state, int link_state):
    """This method will remove the specified GPU from the view of both NVML and the NVIDIA kernel driver as long as no other processes are attached. If other processes are attached, this call will return NVML_ERROR_IN_USE and the GPU will be returned to its original "draining" state. Note: the only situation where a process can still be attached after :func:`device_modify_drain_state` is called to initiate the draining state is if that process was using, and is still using, a GPU before the call was made. Also note, persistence mode counts as an attachment to the GPU thus it must be disabled prior to this call.

    Args:
        pci_info (intptr_t): The PCI address of the GPU to be removed.
        gpu_state (DetachGpuState): Whether the GPU is to be removed, from the OS see ``nvmlDetachGpuState_t``.
        link_state (PcieLinkState): Requested upstream PCIe link state, see ``nvmlPcieLinkState_t``.

    .. seealso:: `nvmlDeviceRemoveGpu_v2`
    """
    with nogil:
        __status__ = nvmlDeviceRemoveGpu_v2(<nvmlPciInfo_t*>pci_info, <_DetachGpuState>gpu_state, <_PcieLinkState>link_state)
    check_status(__status__)


cpdef device_discover_gpus(intptr_t pci_info):
    """Request the OS and the NVIDIA kernel driver to rediscover a portion of the PCI subsystem looking for GPUs that were previously removed. The portion of the PCI tree can be narrowed by specifying a domain, bus, and device. If all are zeroes then the entire PCI tree will be searched. Please note that for long-running NVML processes the enumeration will change based on how many GPUs are discovered and where they are inserted in bus order.

    Args:
        pci_info (intptr_t): The PCI tree to be searched. Only the domain, bus, and device fields are used in this call.

    .. seealso:: `nvmlDeviceDiscoverGpus`
    """
    with nogil:
        __status__ = nvmlDeviceDiscoverGpus(<nvmlPciInfo_t*>pci_info)
    check_status(__status__)


cpdef int device_get_virtualization_mode(intptr_t device) except? -1:
    """This method is used to get the virtualization mode corresponding to the GPU.

    Args:
        device (intptr_t): Identifier of the target device.

    Returns:
        int: Reference to virtualization mode. One of NVML_GPU_VIRTUALIZATION_?.

    .. seealso:: `nvmlDeviceGetVirtualizationMode`
    """
    cdef _GpuVirtualizationMode p_virtual_mode
    with nogil:
        __status__ = nvmlDeviceGetVirtualizationMode(<Device>device, &p_virtual_mode)
    check_status(__status__)
    return <int>p_virtual_mode


cpdef int device_get_host_vgpu_mode(intptr_t device) except? -1:
    """Queries if SR-IOV host operation is supported on a vGPU supported device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        int: Reference in which to return the current vGPU mode.

    .. seealso:: `nvmlDeviceGetHostVgpuMode`
    """
    cdef _HostVgpuMode p_host_vgpu_mode
    with nogil:
        __status__ = nvmlDeviceGetHostVgpuMode(<Device>device, &p_host_vgpu_mode)
    check_status(__status__)
    return <int>p_host_vgpu_mode


cpdef device_set_virtualization_mode(intptr_t device, int virtual_mode):
    """This method is used to set the virtualization mode corresponding to the GPU.

    Args:
        device (intptr_t): Identifier of the target device.
        virtual_mode (GpuVirtualizationMode): virtualization mode. One of NVML_GPU_VIRTUALIZATION_?.

    .. seealso:: `nvmlDeviceSetVirtualizationMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetVirtualizationMode(<Device>device, <_GpuVirtualizationMode>virtual_mode)
    check_status(__status__)


cpdef object device_get_vgpu_heterogeneous_mode(intptr_t device):
    """Get the vGPU heterogeneous mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlVgpuHeterogeneousMode_v1_t: Pointer to the caller-provided structure of nvmlVgpuHeterogeneousMode_t.

    .. seealso:: `nvmlDeviceGetVgpuHeterogeneousMode`
    """
    cdef VgpuHeterogeneousMode_v1 p_heterogeneous_mode_py = VgpuHeterogeneousMode_v1()
    cdef nvmlVgpuHeterogeneousMode_t *p_heterogeneous_mode = <nvmlVgpuHeterogeneousMode_t *><intptr_t>(p_heterogeneous_mode_py._get_ptr())
    p_heterogeneous_mode.version = sizeof(nvmlVgpuHeterogeneousMode_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetVgpuHeterogeneousMode(<Device>device, p_heterogeneous_mode)
    check_status(__status__)
    return p_heterogeneous_mode_py


cpdef device_set_vgpu_heterogeneous_mode(intptr_t device, intptr_t p_heterogeneous_mode):
    """Enable or disable vGPU heterogeneous mode for the device.

    Args:
        device (intptr_t): Identifier of the target device.
        p_heterogeneous_mode (intptr_t): Pointer to the caller-provided structure of nvmlVgpuHeterogeneousMode_t.

    .. seealso:: `nvmlDeviceSetVgpuHeterogeneousMode`
    """
    with nogil:
        __status__ = nvmlDeviceSetVgpuHeterogeneousMode(<Device>device, <const nvmlVgpuHeterogeneousMode_t*>p_heterogeneous_mode)
    check_status(__status__)


cpdef object vgpu_instance_get_placement_id(unsigned int vgpu_instance):
    """Query the placement ID of active vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        nvmlVgpuPlacementId_v1_t: Pointer to vGPU placement ID structure ``nvmlVgpuPlacementId_t``.

    .. seealso:: `nvmlVgpuInstanceGetPlacementId`
    """
    cdef VgpuPlacementId_v1 p_placement_py = VgpuPlacementId_v1()
    cdef nvmlVgpuPlacementId_t *p_placement = <nvmlVgpuPlacementId_t *><intptr_t>(p_placement_py._get_ptr())
    p_placement.version = sizeof(nvmlVgpuPlacementId_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlVgpuInstanceGetPlacementId(<nvmlVgpuInstance_t>vgpu_instance, p_placement)
    check_status(__status__)
    return p_placement_py


cpdef object device_get_vgpu_type_supported_placements(intptr_t device, unsigned int vgpu_type_id):
    """Query the supported vGPU placement ID of the vGPU type.

    Args:
        device (intptr_t): Identifier of the target device.
        vgpu_type_id (unsigned int): Handle to vGPU type. The vGPU type ID.

    Returns:
        nvmlVgpuPlacementList_v2_t: Pointer to the vGPU placement structure ``nvmlVgpuPlacementList_t``.

    .. seealso:: `nvmlDeviceGetVgpuTypeSupportedPlacements`
    """
    cdef VgpuPlacementList_v2 p_placement_list_py = VgpuPlacementList_v2()
    cdef nvmlVgpuPlacementList_t *p_placement_list = <nvmlVgpuPlacementList_t *><intptr_t>(p_placement_list_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetVgpuTypeSupportedPlacements(<Device>device, <nvmlVgpuTypeId_t>vgpu_type_id, p_placement_list)
    check_status(__status__)
    return p_placement_list_py


cpdef unsigned long long vgpu_type_get_gsp_heap_size(unsigned int vgpu_type_id) except? 0:
    """Retrieve the static GSP heap size of the vGPU type in bytes.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned long long: Reference to return the GSP heap size value.

    .. seealso:: `nvmlVgpuTypeGetGspHeapSize`
    """
    cdef unsigned long long gsp_heap_size
    with nogil:
        __status__ = nvmlVgpuTypeGetGspHeapSize(<nvmlVgpuTypeId_t>vgpu_type_id, &gsp_heap_size)
    check_status(__status__)
    return gsp_heap_size


cpdef unsigned long long vgpu_type_get_fb_reservation(unsigned int vgpu_type_id) except? 0:
    """Retrieve the static framebuffer reservation of the vGPU type in bytes.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned long long: Reference to return the framebuffer reservation.

    .. seealso:: `nvmlVgpuTypeGetFbReservation`
    """
    cdef unsigned long long fb_reservation
    with nogil:
        __status__ = nvmlVgpuTypeGetFbReservation(<nvmlVgpuTypeId_t>vgpu_type_id, &fb_reservation)
    check_status(__status__)
    return fb_reservation


cpdef object vgpu_instance_get_runtime_state_size(unsigned int vgpu_instance):
    """Retrieve the currently used runtime state size of the vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        nvmlVgpuRuntimeState_v1_t: Pointer to the vGPU runtime state's structure ``nvmlVgpuRuntimeState_t``.

    .. seealso:: `nvmlVgpuInstanceGetRuntimeStateSize`
    """
    cdef VgpuRuntimeState_v1 p_state_py = VgpuRuntimeState_v1()
    cdef nvmlVgpuRuntimeState_t *p_state = <nvmlVgpuRuntimeState_t *><intptr_t>(p_state_py._get_ptr())
    p_state.version = sizeof(nvmlVgpuRuntimeState_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlVgpuInstanceGetRuntimeStateSize(<nvmlVgpuInstance_t>vgpu_instance, p_state)
    check_status(__status__)
    return p_state_py


cpdef device_set_vgpu_capabilities(intptr_t device, int capability, int state):
    """Set the desirable vGPU capability of a device.

    Args:
        device (intptr_t): The identifier of the target device.
        capability (DeviceVgpuCapability): Specifies the ``nvmlDeviceVgpuCapability_t`` to be set.
        state (EnableState): The target capability mode.

    .. seealso:: `nvmlDeviceSetVgpuCapabilities`
    """
    with nogil:
        __status__ = nvmlDeviceSetVgpuCapabilities(<Device>device, <_DeviceVgpuCapability>capability, <_EnableState>state)
    check_status(__status__)


cpdef object device_get_grid_licensable_features_v4(intptr_t device):
    """Retrieve the vGPU Software licensable features.

    Args:
        device (intptr_t): Identifier of the target device.

    Returns:
        nvmlGridLicensableFeatures_t: Pointer to structure in which vGPU software licensable features are returned.

    .. seealso:: `nvmlDeviceGetGridLicensableFeatures_v4`
    """
    cdef GridLicensableFeatures p_grid_licensable_features_py = GridLicensableFeatures()
    cdef nvmlGridLicensableFeatures_t *p_grid_licensable_features = <nvmlGridLicensableFeatures_t *><intptr_t>(p_grid_licensable_features_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetGridLicensableFeatures_v4(<Device>device, p_grid_licensable_features)
    check_status(__status__)
    return p_grid_licensable_features_py


cpdef unsigned int get_vgpu_driver_capabilities(int capability) except? 0:
    """Retrieve the requested vGPU driver capability.

    Args:
        capability (VgpuDriverCapability): Specifies the ``nvmlVgpuDriverCapability_t`` to be queried.

    Returns:
        unsigned int: A boolean for the queried capability indicating that feature is supported.

    .. seealso:: `nvmlGetVgpuDriverCapabilities`
    """
    cdef unsigned int cap_result
    with nogil:
        __status__ = nvmlGetVgpuDriverCapabilities(<_VgpuDriverCapability>capability, &cap_result)
    check_status(__status__)
    return cap_result


cpdef unsigned int device_get_vgpu_capabilities(intptr_t device, int capability) except? 0:
    """Retrieve the requested vGPU capability for GPU.

    Args:
        device (intptr_t): The identifier of the target device.
        capability (DeviceVgpuCapability): Specifies the ``nvmlDeviceVgpuCapability_t`` to be queried.

    Returns:
        unsigned int: Specifies that the queried capability is supported, and also returns capability's data.

    .. seealso:: `nvmlDeviceGetVgpuCapabilities`
    """
    cdef unsigned int cap_result
    with nogil:
        __status__ = nvmlDeviceGetVgpuCapabilities(<Device>device, <_DeviceVgpuCapability>capability, &cap_result)
    check_status(__status__)
    return cap_result


cpdef str vgpu_type_get_class(unsigned int vgpu_type_id):
    """Retrieve the class of a vGPU type. It will not exceed 64 characters in length (including the NUL terminator). See ``nvmlConstants.NVML_DEVICE_NAME_BUFFER_SIZE``.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    .. seealso:: `nvmlVgpuTypeGetClass`
    """
    cdef unsigned int[1] size = [0]
    with nogil:
        __status__ = nvmlVgpuTypeGetClass(<nvmlVgpuTypeId_t>vgpu_type_id, NULL, <unsigned int*>size)
    check_status_size(__status__)
    if size[0] == 0:
        return ""
    cdef bytes _vgpu_type_class_ = bytes(size[0])
    cdef char* vgpu_type_class = _vgpu_type_class_
    with nogil:
        __status__ = nvmlVgpuTypeGetClass(<nvmlVgpuTypeId_t>vgpu_type_id, vgpu_type_class, <unsigned int*>size)
    check_status(__status__)
    return cpython.PyUnicode_FromString(vgpu_type_class)


cpdef str vgpu_type_get_name(unsigned int vgpu_type_id):
    """Retrieve the vGPU type name.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    .. seealso:: `nvmlVgpuTypeGetName`
    """
    cdef unsigned int size = 64
    cdef char[64] vgpu_type_name
    with nogil:
        __status__ = nvmlVgpuTypeGetName(<nvmlVgpuTypeId_t>vgpu_type_id, vgpu_type_name, <unsigned int*>size)
    check_status(__status__)
    return cpython.PyUnicode_FromString(vgpu_type_name)


cpdef unsigned int vgpu_type_get_gpu_instance_profile_id(unsigned int vgpu_type_id) except? 0:
    """Retrieve the GPU Instance Profile ID for the given vGPU type ID. The API will return a valid GPU Instance Profile ID for the MIG capable vGPU types, else INVALID_GPU_INSTANCE_PROFILE_ID is returned.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned int: GPU Instance Profile ID.

    .. seealso:: `nvmlVgpuTypeGetGpuInstanceProfileId`
    """
    cdef unsigned int gpu_instance_profile_id
    with nogil:
        __status__ = nvmlVgpuTypeGetGpuInstanceProfileId(<nvmlVgpuTypeId_t>vgpu_type_id, &gpu_instance_profile_id)
    check_status(__status__)
    return gpu_instance_profile_id


cpdef tuple vgpu_type_get_device_id(unsigned int vgpu_type_id):
    """Retrieve the device ID of a vGPU type.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        A 2-tuple containing:

        - unsigned long long: Device ID and vendor ID of the device contained in single 32 bit value.
        - unsigned long long: Subsystem ID and subsystem vendor ID of the device contained in single 32 bit value.

    .. seealso:: `nvmlVgpuTypeGetDeviceID`
    """
    cdef unsigned long long device_id
    cdef unsigned long long subsystem_id
    with nogil:
        __status__ = nvmlVgpuTypeGetDeviceID(<nvmlVgpuTypeId_t>vgpu_type_id, &device_id, &subsystem_id)
    check_status(__status__)
    return (device_id, subsystem_id)


cpdef unsigned long long vgpu_type_get_framebuffer_size(unsigned int vgpu_type_id) except? 0:
    """Retrieve the vGPU framebuffer size in bytes.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned long long: Pointer to framebuffer size in bytes.

    .. seealso:: `nvmlVgpuTypeGetFramebufferSize`
    """
    cdef unsigned long long fb_size
    with nogil:
        __status__ = nvmlVgpuTypeGetFramebufferSize(<nvmlVgpuTypeId_t>vgpu_type_id, &fb_size)
    check_status(__status__)
    return fb_size


cpdef unsigned int vgpu_type_get_num_display_heads(unsigned int vgpu_type_id) except? 0:
    """Retrieve count of vGPU's supported display heads.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned int: Pointer to number of display heads.

    .. seealso:: `nvmlVgpuTypeGetNumDisplayHeads`
    """
    cdef unsigned int num_display_heads
    with nogil:
        __status__ = nvmlVgpuTypeGetNumDisplayHeads(<nvmlVgpuTypeId_t>vgpu_type_id, &num_display_heads)
    check_status(__status__)
    return num_display_heads


cpdef tuple vgpu_type_get_resolution(unsigned int vgpu_type_id, unsigned int display_ind_ex):
    """Retrieve vGPU display head's maximum supported resolution.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.
        display_ind_ex (unsigned int): Zero-based index of display head.

    Returns:
        A 2-tuple containing:

        - unsigned int: Pointer to maximum number of pixels in X dimension.
        - unsigned int: Pointer to maximum number of pixels in Y dimension.

    .. seealso:: `nvmlVgpuTypeGetResolution`
    """
    cdef unsigned int xdim
    cdef unsigned int ydim
    with nogil:
        __status__ = nvmlVgpuTypeGetResolution(<nvmlVgpuTypeId_t>vgpu_type_id, display_ind_ex, &xdim, &ydim)
    check_status(__status__)
    return (xdim, ydim)


cpdef vgpu_type_get_license(unsigned int vgpu_type_id, intptr_t vgpu_type_license_string, unsigned int size):
    """Retrieve license requirements for a vGPU type.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.
        vgpu_type_license_string (intptr_t): Pointer to buffer to return license info.
        size (unsigned int): Size of ``vgpu_type_license_string`` buffer.

    .. seealso:: `nvmlVgpuTypeGetLicense`
    """
    with nogil:
        __status__ = nvmlVgpuTypeGetLicense(<nvmlVgpuTypeId_t>vgpu_type_id, <char*>vgpu_type_license_string, size)
    check_status(__status__)


cpdef unsigned int vgpu_type_get_frame_rate_limit(unsigned int vgpu_type_id) except? 0:
    """Retrieve the static frame rate limit value of the vGPU type.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned int: Reference to return the frame rate limit value.

    .. seealso:: `nvmlVgpuTypeGetFrameRateLimit`
    """
    cdef unsigned int frame_rate_limit
    with nogil:
        __status__ = nvmlVgpuTypeGetFrameRateLimit(<nvmlVgpuTypeId_t>vgpu_type_id, &frame_rate_limit)
    check_status(__status__)
    return frame_rate_limit


cpdef unsigned int vgpu_type_get_max_instances(intptr_t device, unsigned int vgpu_type_id) except? 0:
    """Retrieve the maximum number of vGPU instances creatable on a device for given vGPU type.

    Args:
        device (intptr_t): The identifier of the target device.
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned int: Pointer to get the max number of vGPU instances that can be created on a deicve for given vgpu_type_id.

    .. seealso:: `nvmlVgpuTypeGetMaxInstances`
    """
    cdef unsigned int vgpu_instance_count
    with nogil:
        __status__ = nvmlVgpuTypeGetMaxInstances(<Device>device, <nvmlVgpuTypeId_t>vgpu_type_id, &vgpu_instance_count)
    check_status(__status__)
    return vgpu_instance_count


cpdef unsigned int vgpu_type_get_max_instances_per_vm(unsigned int vgpu_type_id) except? 0:
    """Retrieve the maximum number of vGPU instances supported per VM for given vGPU type.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        unsigned int: Pointer to get the max number of vGPU instances supported per VM for given ``vgpu_type_id``.

    .. seealso:: `nvmlVgpuTypeGetMaxInstancesPerVm`
    """
    cdef unsigned int vgpu_instance_count_per_vm
    with nogil:
        __status__ = nvmlVgpuTypeGetMaxInstancesPerVm(<nvmlVgpuTypeId_t>vgpu_type_id, &vgpu_instance_count_per_vm)
    check_status(__status__)
    return vgpu_instance_count_per_vm


cpdef object vgpu_type_get_bar1_info(unsigned int vgpu_type_id):
    """Retrieve the BAR1 info for given vGPU type.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.

    Returns:
        nvmlVgpuTypeBar1Info_v1_t: Pointer to the vGPU type BAR1 information structure ``nvmlVgpuTypeBar1Info_t``.

    .. seealso:: `nvmlVgpuTypeGetBAR1Info`
    """
    cdef VgpuTypeBar1Info_v1 bar1info_py = VgpuTypeBar1Info_v1()
    cdef nvmlVgpuTypeBar1Info_t *bar1info = <nvmlVgpuTypeBar1Info_t *><intptr_t>(bar1info_py._get_ptr())
    bar1info.version = sizeof(nvmlVgpuTypeBar1Info_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlVgpuTypeGetBAR1Info(<nvmlVgpuTypeId_t>vgpu_type_id, bar1info)
    check_status(__status__)
    return bar1info_py


cpdef str vgpu_instance_get_uuid(unsigned int vgpu_instance):
    """Retrieve the UUID of a vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetUUID`
    """
    cdef unsigned int size = 80
    cdef char[80] uuid
    with nogil:
        __status__ = nvmlVgpuInstanceGetUUID(<nvmlVgpuInstance_t>vgpu_instance, uuid, size)
    check_status(__status__)
    return cpython.PyUnicode_FromString(uuid)


cpdef str vgpu_instance_get_vm_driver_version(unsigned int vgpu_instance):
    """Retrieve the NVIDIA driver version installed in the VM associated with a vGPU.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetVmDriverVersion`
    """
    cdef unsigned int length = 80
    cdef char[80] version
    with nogil:
        __status__ = nvmlVgpuInstanceGetVmDriverVersion(<nvmlVgpuInstance_t>vgpu_instance, version, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(version)


cpdef unsigned long long vgpu_instance_get_fb_usage(unsigned int vgpu_instance) except? 0:
    """Retrieve the framebuffer usage in bytes.

    Args:
        vgpu_instance (unsigned int): The identifier of the target instance.

    Returns:
        unsigned long long: Pointer to framebuffer usage in bytes.

    .. seealso:: `nvmlVgpuInstanceGetFbUsage`
    """
    cdef unsigned long long fb_usage
    with nogil:
        __status__ = nvmlVgpuInstanceGetFbUsage(<nvmlVgpuInstance_t>vgpu_instance, &fb_usage)
    check_status(__status__)
    return fb_usage


cpdef unsigned int vgpu_instance_get_license_status(unsigned int vgpu_instance) except? 0:
    """[Deprecated].

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        unsigned int: Reference to return the licensing status.

    .. seealso:: `nvmlVgpuInstanceGetLicenseStatus`
    """
    cdef unsigned int licensed
    with nogil:
        __status__ = nvmlVgpuInstanceGetLicenseStatus(<nvmlVgpuInstance_t>vgpu_instance, &licensed)
    check_status(__status__)
    return licensed


cpdef unsigned int vgpu_instance_get_type(unsigned int vgpu_instance) except? 0:
    """Retrieve the vGPU type of a vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        unsigned int: Reference to return the vgpuTypeId.

    .. seealso:: `nvmlVgpuInstanceGetType`
    """
    cdef nvmlVgpuTypeId_t vgpu_type_id
    with nogil:
        __status__ = nvmlVgpuInstanceGetType(<nvmlVgpuInstance_t>vgpu_instance, &vgpu_type_id)
    check_status(__status__)
    return <unsigned int>vgpu_type_id


cpdef unsigned int vgpu_instance_get_frame_rate_limit(unsigned int vgpu_instance) except? 0:
    """Retrieve the frame rate limit set for the vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        unsigned int: Reference to return the frame rate limit.

    .. seealso:: `nvmlVgpuInstanceGetFrameRateLimit`
    """
    cdef unsigned int frame_rate_limit
    with nogil:
        __status__ = nvmlVgpuInstanceGetFrameRateLimit(<nvmlVgpuInstance_t>vgpu_instance, &frame_rate_limit)
    check_status(__status__)
    return frame_rate_limit


cpdef int vgpu_instance_get_ecc_mode(unsigned int vgpu_instance) except? -1:
    """Retrieve the current ECC mode of vGPU instance.

    Args:
        vgpu_instance (unsigned int): The identifier of the target vGPU instance.

    Returns:
        int: Reference in which to return the current ECC mode.

    .. seealso:: `nvmlVgpuInstanceGetEccMode`
    """
    cdef _EnableState ecc_mode
    with nogil:
        __status__ = nvmlVgpuInstanceGetEccMode(<nvmlVgpuInstance_t>vgpu_instance, &ecc_mode)
    check_status(__status__)
    return <int>ecc_mode


cpdef unsigned int vgpu_instance_get_encoder_capacity(unsigned int vgpu_instance) except? 0:
    """Retrieve the encoder capacity of a vGPU instance, as a percentage of maximum encoder capacity with valid values in the range 0-100.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        unsigned int: Reference to an unsigned int for the encoder capacity.

    .. seealso:: `nvmlVgpuInstanceGetEncoderCapacity`
    """
    cdef unsigned int encoder_capacity
    with nogil:
        __status__ = nvmlVgpuInstanceGetEncoderCapacity(<nvmlVgpuInstance_t>vgpu_instance, &encoder_capacity)
    check_status(__status__)
    return encoder_capacity


cpdef vgpu_instance_set_encoder_capacity(unsigned int vgpu_instance, unsigned int encoder_capacity):
    """Set the encoder capacity of a vGPU instance, as a percentage of maximum encoder capacity with valid values in the range 0-100.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.
        encoder_capacity (unsigned int): Unsigned int for the encoder capacity value.

    .. seealso:: `nvmlVgpuInstanceSetEncoderCapacity`
    """
    with nogil:
        __status__ = nvmlVgpuInstanceSetEncoderCapacity(<nvmlVgpuInstance_t>vgpu_instance, encoder_capacity)
    check_status(__status__)


cpdef tuple vgpu_instance_get_encoder_stats(unsigned int vgpu_instance):
    """Retrieves the current encoder statistics of a vGPU Instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        A 3-tuple containing:

        - unsigned int: Reference to an unsigned int for count of active encoder sessions.
        - unsigned int: Reference to an unsigned int for trailing average FPS of all active sessions.
        - unsigned int: Reference to an unsigned int for encode latency in microseconds.

    .. seealso:: `nvmlVgpuInstanceGetEncoderStats`
    """
    cdef unsigned int session_count
    cdef unsigned int average_fps
    cdef unsigned int average_latency
    with nogil:
        __status__ = nvmlVgpuInstanceGetEncoderStats(<nvmlVgpuInstance_t>vgpu_instance, &session_count, &average_fps, &average_latency)
    check_status(__status__)
    return (session_count, average_fps, average_latency)


cpdef object vgpu_instance_get_encoder_sessions(unsigned int vgpu_instance):
    """Retrieves information about all active encoder sessions on a vGPU Instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetEncoderSessions`
    """
    cdef unsigned int[1] session_count = [0]
    with nogil:
        __status__ = nvmlVgpuInstanceGetEncoderSessions(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>session_count, NULL)
    check_status_size(__status__)
    cdef EncoderSessionInfo session_info = EncoderSessionInfo(session_count[0])
    cdef nvmlEncoderSessionInfo_t *session_info_ptr = <nvmlEncoderSessionInfo_t *><intptr_t>(session_info._get_ptr())
    if session_count[0] == 0:
        return session_info
    with nogil:
        __status__ = nvmlVgpuInstanceGetEncoderSessions(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>session_count, session_info_ptr)
    check_status(__status__)
    return session_info


cpdef object vgpu_instance_get_fbc_stats(unsigned int vgpu_instance):
    """Retrieves the active frame buffer capture sessions statistics of a vGPU Instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        nvmlFBCStats_t: Reference to nvmlFBCStats_t structure containing NvFBC stats.

    .. seealso:: `nvmlVgpuInstanceGetFBCStats`
    """
    cdef FBCStats fbc_stats_py = FBCStats()
    cdef nvmlFBCStats_t *fbc_stats = <nvmlFBCStats_t *><intptr_t>(fbc_stats_py._get_ptr())
    with nogil:
        __status__ = nvmlVgpuInstanceGetFBCStats(<nvmlVgpuInstance_t>vgpu_instance, fbc_stats)
    check_status(__status__)
    return fbc_stats_py


cpdef object vgpu_instance_get_fbc_sessions(unsigned int vgpu_instance):
    """Retrieves information about active frame buffer capture sessions on a vGPU Instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetFBCSessions`
    """
    cdef unsigned int[1] session_count = [0]
    with nogil:
        __status__ = nvmlVgpuInstanceGetFBCSessions(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>session_count, NULL)
    check_status_size(__status__)
    cdef FBCSessionInfo session_info = FBCSessionInfo(session_count[0])
    cdef nvmlFBCSessionInfo_t *session_info_ptr = <nvmlFBCSessionInfo_t *><intptr_t>(session_info._get_ptr())
    if session_count[0] == 0:
        return session_info
    with nogil:
        __status__ = nvmlVgpuInstanceGetFBCSessions(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>session_count, session_info_ptr)
    check_status(__status__)
    return session_info


cpdef unsigned int vgpu_instance_get_gpu_instance_id(unsigned int vgpu_instance) except? 0:
    """Retrieve the GPU Instance ID for the given vGPU Instance. The API will return a valid GPU Instance ID for MIG backed vGPU Instance, else INVALID_GPU_INSTANCE_ID is returned.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        unsigned int: GPU Instance ID.

    .. seealso:: `nvmlVgpuInstanceGetGpuInstanceId`
    """
    cdef unsigned int gpu_instance_id
    with nogil:
        __status__ = nvmlVgpuInstanceGetGpuInstanceId(<nvmlVgpuInstance_t>vgpu_instance, &gpu_instance_id)
    check_status(__status__)
    return gpu_instance_id


cpdef str vgpu_instance_get_gpu_pci_id(unsigned int vgpu_instance):
    """Retrieves the PCI Id of the given vGPU Instance i.e. the PCI Id of the GPU as seen inside the VM.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetGpuPciId`
    """
    cdef unsigned int[1] length = [0]
    with nogil:
        __status__ = nvmlVgpuInstanceGetGpuPciId(<nvmlVgpuInstance_t>vgpu_instance, NULL, <unsigned int*>length)
    check_status_size(__status__)
    if length[0] == 0:
        return ""
    cdef bytes _vgpu_pci_id_ = bytes(length[0])
    cdef char* vgpu_pci_id = _vgpu_pci_id_
    with nogil:
        __status__ = nvmlVgpuInstanceGetGpuPciId(<nvmlVgpuInstance_t>vgpu_instance, vgpu_pci_id, <unsigned int*>length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(vgpu_pci_id)


cpdef unsigned int vgpu_type_get_capabilities(unsigned int vgpu_type_id, int capability) except? 0:
    """Retrieve the requested capability for a given vGPU type. Refer to the ``nvmlVgpuCapability_t`` structure for the specific capabilities that can be queried. The return value in ``capResult`` should be treated as a boolean, with a non-zero value indicating that the capability is supported.

    Args:
        vgpu_type_id (unsigned int): Handle to vGPU type.
        capability (VgpuCapability): Specifies the ``nvmlVgpuCapability_t`` to be queried.

    Returns:
        unsigned int: A boolean for the queried capability indicating that feature is supported.

    .. seealso:: `nvmlVgpuTypeGetCapabilities`
    """
    cdef unsigned int cap_result
    with nogil:
        __status__ = nvmlVgpuTypeGetCapabilities(<nvmlVgpuTypeId_t>vgpu_type_id, <_VgpuCapability>capability, &cap_result)
    check_status(__status__)
    return cap_result


cpdef str vgpu_instance_get_mdev_uuid(unsigned int vgpu_instance):
    """Retrieve the MDEV UUID of a vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetMdevUUID`
    """
    cdef unsigned int size = 80
    cdef char[80] mdev_uuid
    with nogil:
        __status__ = nvmlVgpuInstanceGetMdevUUID(<nvmlVgpuInstance_t>vgpu_instance, mdev_uuid, size)
    check_status(__status__)
    return cpython.PyUnicode_FromString(mdev_uuid)


cpdef object vgpu_type_get_max_instances_per_gpu_instance():
    """Retrieve the maximum number of vGPU instances per GPU instance for given vGPU type.

    Returns:
        nvmlVgpuTypeMaxInstance_v1_t: Pointer to the caller-provided structure of nvmlVgpuTypeMaxInstance_t.

    .. seealso:: `nvmlVgpuTypeGetMaxInstancesPerGpuInstance`
    """
    cdef VgpuTypeMaxInstance_v1 p_max_instance_py = VgpuTypeMaxInstance_v1()
    cdef nvmlVgpuTypeMaxInstance_t *p_max_instance = <nvmlVgpuTypeMaxInstance_t *><intptr_t>(p_max_instance_py._get_ptr())
    p_max_instance.version = sizeof(nvmlVgpuTypeMaxInstance_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlVgpuTypeGetMaxInstancesPerGpuInstance(p_max_instance)
    check_status(__status__)
    return p_max_instance_py


cpdef gpu_instance_set_vgpu_scheduler_state(intptr_t gpu_instance, intptr_t p_scheduler):
    """Set vGPU scheduler state for the given GPU instance.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.
        p_scheduler (intptr_t): Pointer to the caller-provided structure of nvmlVgpuSchedulerState_t.

    .. seealso:: `nvmlGpuInstanceSetVgpuSchedulerState`
    """
    with nogil:
        __status__ = nvmlGpuInstanceSetVgpuSchedulerState(<GpuInstance>gpu_instance, <nvmlVgpuSchedulerState_t*>p_scheduler)
    check_status(__status__)


cpdef object gpu_instance_get_vgpu_scheduler_state(intptr_t gpu_instance):
    """Returns the vGPU scheduler state for the given GPU instance. The information returned in ``nvmlVgpuSchedulerStateInfo_t`` is not relevant if the BEST EFFORT policy is set.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.

    Returns:
        nvmlVgpuSchedulerStateInfo_v1_t: Reference in which ``pSchedulerStateInfo`` is returned.

    .. seealso:: `nvmlGpuInstanceGetVgpuSchedulerState`
    """
    cdef VgpuSchedulerStateInfo_v1 p_scheduler_state_info_py = VgpuSchedulerStateInfo_v1()
    cdef nvmlVgpuSchedulerStateInfo_t *p_scheduler_state_info = <nvmlVgpuSchedulerStateInfo_t *><intptr_t>(p_scheduler_state_info_py._get_ptr())
    p_scheduler_state_info.version = sizeof(nvmlVgpuSchedulerState_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlGpuInstanceGetVgpuSchedulerState(<GpuInstance>gpu_instance, p_scheduler_state_info)
    check_status(__status__)
    return p_scheduler_state_info_py


cpdef object gpu_instance_get_vgpu_scheduler_log(intptr_t gpu_instance):
    """Returns the vGPU scheduler logs for the given GPU instance. ``pSchedulerLogInfo`` points to a caller-allocated structure to contain the logs. The number of elements returned will never exceed ``NVML_SCHEDULER_SW_MAX_LOG_ENTRIES``.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.

    Returns:
        nvmlVgpuSchedulerLogInfo_v1_t: Reference in which ``pSchedulerLogInfo`` is written.

    .. seealso:: `nvmlGpuInstanceGetVgpuSchedulerLog`
    """
    cdef VgpuSchedulerLogInfo_v1 p_scheduler_log_info_py = VgpuSchedulerLogInfo_v1()
    cdef nvmlVgpuSchedulerLogInfo_t *p_scheduler_log_info = <nvmlVgpuSchedulerLogInfo_t *><intptr_t>(p_scheduler_log_info_py._get_ptr())
    p_scheduler_log_info.version = sizeof(nvmlVgpuSchedulerLogInfo_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlGpuInstanceGetVgpuSchedulerLog(<GpuInstance>gpu_instance, p_scheduler_log_info)
    check_status(__status__)
    return p_scheduler_log_info_py


cpdef object gpu_instance_get_vgpu_heterogeneous_mode(intptr_t gpu_instance):
    """Get the vGPU heterogeneous mode for the GPU instance.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.

    Returns:
        nvmlVgpuHeterogeneousMode_v1_t: Pointer to the caller-provided structure of nvmlVgpuHeterogeneousMode_t.

    .. seealso:: `nvmlGpuInstanceGetVgpuHeterogeneousMode`
    """
    cdef VgpuHeterogeneousMode_v1 p_heterogeneous_mode_py = VgpuHeterogeneousMode_v1()
    cdef nvmlVgpuHeterogeneousMode_t *p_heterogeneous_mode = <nvmlVgpuHeterogeneousMode_t *><intptr_t>(p_heterogeneous_mode_py._get_ptr())
    p_heterogeneous_mode.version = sizeof(nvmlVgpuHeterogeneousMode_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlGpuInstanceGetVgpuHeterogeneousMode(<GpuInstance>gpu_instance, p_heterogeneous_mode)
    check_status(__status__)
    return p_heterogeneous_mode_py


cpdef gpu_instance_set_vgpu_heterogeneous_mode(intptr_t gpu_instance, intptr_t p_heterogeneous_mode):
    """Enable or disable vGPU heterogeneous mode for the GPU instance.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.
        p_heterogeneous_mode (intptr_t): Pointer to the caller-provided structure of nvmlVgpuHeterogeneousMode_t.

    .. seealso:: `nvmlGpuInstanceSetVgpuHeterogeneousMode`
    """
    with nogil:
        __status__ = nvmlGpuInstanceSetVgpuHeterogeneousMode(<GpuInstance>gpu_instance, <const nvmlVgpuHeterogeneousMode_t*>p_heterogeneous_mode)
    check_status(__status__)


cpdef str device_get_pgpu_metadata_string(intptr_t device):
    """Returns the properties of the physical GPU indicated by the device in an ascii-encoded string format.

    Args:
        device (intptr_t): The identifier of the target device.

    .. seealso:: `nvmlDeviceGetPgpuMetadataString`
    """
    cdef unsigned int[1] buffer_size = [0]
    with nogil:
        __status__ = nvmlDeviceGetPgpuMetadataString(<Device>device, NULL, <unsigned int*>buffer_size)
    check_status_size(__status__)
    if buffer_size[0] == 0:
        return ""
    cdef bytes _pgpu_metadata_ = bytes(buffer_size[0])
    cdef char* pgpu_metadata = _pgpu_metadata_
    with nogil:
        __status__ = nvmlDeviceGetPgpuMetadataString(<Device>device, pgpu_metadata, <unsigned int*>buffer_size)
    check_status(__status__)
    return cpython.PyUnicode_FromString(pgpu_metadata)


cpdef object device_get_vgpu_scheduler_log(intptr_t device):
    """Returns the vGPU Software scheduler logs. ``pSchedulerLog`` points to a caller-allocated structure to contain the logs. The number of elements returned will never exceed ``NVML_SCHEDULER_SW_MAX_LOG_ENTRIES``.

    Args:
        device (intptr_t): The identifier of the target ``device``.

    Returns:
        nvmlVgpuSchedulerLog_t: Reference in which ``pSchedulerLog`` is written.

    .. seealso:: `nvmlDeviceGetVgpuSchedulerLog`
    """
    cdef VgpuSchedulerLog p_scheduler_log_py = VgpuSchedulerLog()
    cdef nvmlVgpuSchedulerLog_t *p_scheduler_log = <nvmlVgpuSchedulerLog_t *><intptr_t>(p_scheduler_log_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetVgpuSchedulerLog(<Device>device, p_scheduler_log)
    check_status(__status__)
    return p_scheduler_log_py


cpdef object device_get_vgpu_scheduler_state(intptr_t device):
    """Returns the vGPU scheduler state. The information returned in ``nvmlVgpuSchedulerGetState_t`` is not relevant if the BEST EFFORT policy is set.

    Args:
        device (intptr_t): The identifier of the target ``device``.

    Returns:
        nvmlVgpuSchedulerGetState_t: Reference in which ``pSchedulerState`` is returned.

    .. seealso:: `nvmlDeviceGetVgpuSchedulerState`
    """
    cdef VgpuSchedulerGetState p_scheduler_state_py = VgpuSchedulerGetState()
    cdef nvmlVgpuSchedulerGetState_t *p_scheduler_state = <nvmlVgpuSchedulerGetState_t *><intptr_t>(p_scheduler_state_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetVgpuSchedulerState(<Device>device, p_scheduler_state)
    check_status(__status__)
    return p_scheduler_state_py


cpdef object device_get_vgpu_scheduler_capabilities(intptr_t device):
    """Returns the vGPU scheduler capabilities. The list of supported vGPU schedulers returned in ``nvmlVgpuSchedulerCapabilities_t`` is from the NVML_VGPU_SCHEDULER_POLICY_*. This list enumerates the supported scheduler policies if the engine is Graphics type. The other values in ``nvmlVgpuSchedulerCapabilities_t`` are also applicable if the engine is Graphics type. For other engine types, it is BEST EFFORT policy. If ARR is supported and enabled, scheduling frequency and averaging factor are applicable else timeSlice is applicable.

    Args:
        device (intptr_t): The identifier of the target ``device``.

    Returns:
        nvmlVgpuSchedulerCapabilities_t: Reference in which ``pCapabilities`` is written.

    .. seealso:: `nvmlDeviceGetVgpuSchedulerCapabilities`
    """
    cdef VgpuSchedulerCapabilities p_capabilities_py = VgpuSchedulerCapabilities()
    cdef nvmlVgpuSchedulerCapabilities_t *p_capabilities = <nvmlVgpuSchedulerCapabilities_t *><intptr_t>(p_capabilities_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetVgpuSchedulerCapabilities(<Device>device, p_capabilities)
    check_status(__status__)
    return p_capabilities_py


cpdef device_set_vgpu_scheduler_state(intptr_t device, intptr_t p_scheduler_state):
    """Sets the vGPU scheduler state.

    Args:
        device (intptr_t): The identifier of the target ``device``.
        p_scheduler_state (intptr_t): vGPU ``p_scheduler_state`` to set.

    .. seealso:: `nvmlDeviceSetVgpuSchedulerState`
    """
    with nogil:
        __status__ = nvmlDeviceSetVgpuSchedulerState(<Device>device, <nvmlVgpuSchedulerSetState_t*>p_scheduler_state)
    check_status(__status__)


cpdef set_vgpu_version(intptr_t vgpu_version):
    """Override the preset range of vGPU versions supported by the NVIDIA vGPU Manager with a range set by an administrator.

    Args:
        vgpu_version (intptr_t): Pointer to a caller-supplied range of supported vGPU versions.

    .. seealso:: `nvmlSetVgpuVersion`
    """
    with nogil:
        __status__ = nvmlSetVgpuVersion(<nvmlVgpuVersion_t*>vgpu_version)
    check_status(__status__)


cpdef tuple device_get_vgpu_utilization(intptr_t device, unsigned long long last_seen_time_stamp):
    """Retrieves current utilization for vGPUs on a physical GPU (device).

    Args:
        device (intptr_t): The identifier for the target device.
        last_seen_time_stamp (unsigned long long): Return only samples with timestamp greater than last_seen_time_stamp.

    Returns:
        A 3-tuple containing:

        - int: Pointer to caller-supplied buffer to hold the type of returned sample values.
        - unsigned int: Pointer to caller-supplied array size, and returns number of vGPU instances.
        - nvmlVgpuInstanceUtilizationSample_t: Pointer to caller-supplied buffer in which vGPU utilization samples are returned.

    .. seealso:: `nvmlDeviceGetVgpuUtilization`
    """
    cdef _ValueType sample_val_type
    cdef unsigned int vgpu_instance_samples_count
    cdef nvmlVgpuInstanceUtilizationSample_t utilization_samples
    with nogil:
        __status__ = nvmlDeviceGetVgpuUtilization(<Device>device, last_seen_time_stamp, &sample_val_type, &vgpu_instance_samples_count, &utilization_samples)
    check_status(__status__)
    return (<int>sample_val_type, vgpu_instance_samples_count, utilization_samples)


cpdef tuple device_get_vgpu_process_utilization(intptr_t device, unsigned long long last_seen_time_stamp):
    """Retrieves current utilization for processes running on vGPUs on a physical GPU (device).

    Args:
        device (intptr_t): The identifier for the target device.
        last_seen_time_stamp (unsigned long long): Return only samples with timestamp greater than last_seen_time_stamp.

    Returns:
        A 2-tuple containing:

        - unsigned int: Pointer to caller-supplied array size, and returns number of processes running on vGPU instances.
        - nvmlVgpuProcessUtilizationSample_t: Pointer to caller-supplied buffer in which vGPU sub process utilization samples are returned.

    .. seealso:: `nvmlDeviceGetVgpuProcessUtilization`
    """
    cdef unsigned int vgpu_process_samples_count
    cdef nvmlVgpuProcessUtilizationSample_t utilization_samples
    with nogil:
        __status__ = nvmlDeviceGetVgpuProcessUtilization(<Device>device, last_seen_time_stamp, &vgpu_process_samples_count, &utilization_samples)
    check_status(__status__)
    return (vgpu_process_samples_count, utilization_samples)


cpdef int vgpu_instance_get_accounting_mode(unsigned int vgpu_instance) except? -1:
    """Queries the state of per process accounting mode on vGPU.

    Args:
        vgpu_instance (unsigned int): The identifier of the target vGPU instance.

    Returns:
        int: Reference in which to return the current accounting mode.

    .. seealso:: `nvmlVgpuInstanceGetAccountingMode`
    """
    cdef _EnableState mode
    with nogil:
        __status__ = nvmlVgpuInstanceGetAccountingMode(<nvmlVgpuInstance_t>vgpu_instance, &mode)
    check_status(__status__)
    return <int>mode


cpdef object vgpu_instance_get_accounting_pids(unsigned int vgpu_instance):
    """Queries list of processes running on vGPU that can be queried for accounting stats. The list of processes returned can be in running or terminated state.

    Args:
        vgpu_instance (unsigned int): The identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceGetAccountingPids`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlVgpuInstanceGetAccountingPids(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>count, NULL)
    check_status_size(__status__)
    if count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(unsigned int), format="I", mode="c")[:0]
    cdef view.array pids = view.array(shape=(count[0],), itemsize=sizeof(unsigned int), format="I", mode="c")
    cdef unsigned int *pids_ptr = <unsigned int *>(pids.data)
    with nogil:
        __status__ = nvmlVgpuInstanceGetAccountingPids(<nvmlVgpuInstance_t>vgpu_instance, <unsigned int*>count, pids_ptr)
    check_status(__status__)
    return pids


cpdef object vgpu_instance_get_accounting_stats(unsigned int vgpu_instance, unsigned int pid):
    """Queries process's accounting stats.

    Args:
        vgpu_instance (unsigned int): The identifier of the target vGPU instance.
        pid (unsigned int): Process Id of the target process to query stats for.

    Returns:
        nvmlAccountingStats_t: Reference in which to return the process's accounting stats.

    .. seealso:: `nvmlVgpuInstanceGetAccountingStats`
    """
    cdef AccountingStats stats_py = AccountingStats()
    cdef nvmlAccountingStats_t *stats = <nvmlAccountingStats_t *><intptr_t>(stats_py._get_ptr())
    with nogil:
        __status__ = nvmlVgpuInstanceGetAccountingStats(<nvmlVgpuInstance_t>vgpu_instance, pid, stats)
    check_status(__status__)
    return stats_py


cpdef vgpu_instance_clear_accounting_pids(unsigned int vgpu_instance):
    """Clears accounting information of the vGPU instance that have already terminated.

    Args:
        vgpu_instance (unsigned int): The identifier of the target vGPU instance.

    .. seealso:: `nvmlVgpuInstanceClearAccountingPids`
    """
    with nogil:
        __status__ = nvmlVgpuInstanceClearAccountingPids(<nvmlVgpuInstance_t>vgpu_instance)
    check_status(__status__)


cpdef object vgpu_instance_get_license_info_v2(unsigned int vgpu_instance):
    """Query the license information of the vGPU instance.

    Args:
        vgpu_instance (unsigned int): Identifier of the target vGPU instance.

    Returns:
        nvmlVgpuLicenseInfo_t: Pointer to vGPU license information structure.

    .. seealso:: `nvmlVgpuInstanceGetLicenseInfo_v2`
    """
    cdef VgpuLicenseInfo license_info_py = VgpuLicenseInfo()
    cdef nvmlVgpuLicenseInfo_t *license_info = <nvmlVgpuLicenseInfo_t *><intptr_t>(license_info_py._get_ptr())
    with nogil:
        __status__ = nvmlVgpuInstanceGetLicenseInfo_v2(<nvmlVgpuInstance_t>vgpu_instance, license_info)
    check_status(__status__)
    return license_info_py


cpdef unsigned int get_excluded_device_count() except? 0:
    """Retrieves the number of excluded GPU devices in the system.

    Returns:
        unsigned int: Reference in which to return the number of excluded devices.

    .. seealso:: `nvmlGetExcludedDeviceCount`
    """
    cdef unsigned int device_count
    with nogil:
        __status__ = nvmlGetExcludedDeviceCount(&device_count)
    check_status(__status__)
    return device_count


cpdef object get_excluded_device_info_by_index(unsigned int ind_ex):
    """Acquire the device information for an excluded GPU device, based on its ind_ex.

    Args:
        ind_ex (unsigned int): The ind_ex of the target GPU, >= 0 and < ``deviceCount``.

    Returns:
        nvmlExcludedDeviceInfo_t: Reference in which to return the device information.

    .. seealso:: `nvmlGetExcludedDeviceInfoByIndex`
    """
    cdef ExcludedDeviceInfo info_py = ExcludedDeviceInfo()
    cdef nvmlExcludedDeviceInfo_t *info = <nvmlExcludedDeviceInfo_t *><intptr_t>(info_py._get_ptr())
    with nogil:
        __status__ = nvmlGetExcludedDeviceInfoByIndex(ind_ex, info)
    check_status(__status__)
    return info_py


cpdef int device_set_mig_mode(intptr_t device, unsigned int mode) except? -1:
    """Set MIG mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.
        mode (unsigned int): The mode to be set, ``NVML_DEVICE_MIG_DISABLE`` or ``NVML_DEVICE_MIG_ENABLE``.

    Returns:
        int: The activationStatus status.

    .. seealso:: `nvmlDeviceSetMigMode`
    """
    cdef _Return activation_status
    with nogil:
        __status__ = nvmlDeviceSetMigMode(<Device>device, mode, &activation_status)
    check_status(__status__)
    return <int>activation_status


cpdef tuple device_get_mig_mode(intptr_t device):
    """Get MIG mode for the device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        A 2-tuple containing:

        - unsigned int: Returns the current mode, ``NVML_DEVICE_MIG_DISABLE`` or ``NVML_DEVICE_MIG_ENABLE``.
        - unsigned int: Returns the pending mode, ``NVML_DEVICE_MIG_DISABLE`` or ``NVML_DEVICE_MIG_ENABLE``.

    .. seealso:: `nvmlDeviceGetMigMode`
    """
    cdef unsigned int current_mode
    cdef unsigned int pending_mode
    with nogil:
        __status__ = nvmlDeviceGetMigMode(<Device>device, &current_mode, &pending_mode)
    check_status(__status__)
    return (current_mode, pending_mode)


cpdef object device_get_gpu_instance_profile_info_v(intptr_t device, unsigned int profile):
    """Versioned wrapper around ``nvmlDeviceGetGpuInstanceProfileInfo`` that accepts a versioned ``nvmlGpuInstanceProfileInfo_v2_t`` or later output structure.

    Args:
        device (intptr_t): The identifier of the target device.
        profile (unsigned int): One of the NVML_GPU_INSTANCE_PROFILE_*.

    Returns:
        nvmlGpuInstanceProfileInfo_v2_t: Returns detailed profile information.

    .. seealso:: `nvmlDeviceGetGpuInstanceProfileInfoV`
    """
    cdef GpuInstanceProfileInfo_v2 info_py = GpuInstanceProfileInfo_v2()
    cdef nvmlGpuInstanceProfileInfo_v2_t *info = <nvmlGpuInstanceProfileInfo_v2_t *><intptr_t>(info_py._get_ptr())
    info.version = sizeof(nvmlGpuInstanceProfileInfo_v3_t) | (3 << 24)
    with nogil:
        __status__ = nvmlDeviceGetGpuInstanceProfileInfoV(<Device>device, profile, info)
    check_status(__status__)
    return info_py


cpdef object device_get_gpu_instance_possible_placements_v2(intptr_t device, unsigned int profile_id):
    """Get GPU instance placements.

    Args:
        device (intptr_t): The identifier of the target device.
        profile_id (unsigned int): The GPU instance profile ID. See ``nvmlDeviceGetGpuInstanceProfileInfo``.

    .. seealso:: `nvmlDeviceGetGpuInstancePossiblePlacements_v2`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlDeviceGetGpuInstancePossiblePlacements_v2(<Device>device, profile_id, NULL, <unsigned int*>count)
    check_status_size(__status__)
    cdef GpuInstancePlacement placements = GpuInstancePlacement(count[0])
    cdef nvmlGpuInstancePlacement_t *placements_ptr = <nvmlGpuInstancePlacement_t *><intptr_t>(placements._get_ptr())
    if count[0] == 0:
        return placements
    with nogil:
        __status__ = nvmlDeviceGetGpuInstancePossiblePlacements_v2(<Device>device, profile_id, placements_ptr, <unsigned int*>count)
    check_status(__status__)
    return placements


cpdef unsigned int device_get_gpu_instance_remaining_capacity(intptr_t device, unsigned int profile_id) except? 0:
    """Get GPU instance profile capacity.

    Args:
        device (intptr_t): The identifier of the target device.
        profile_id (unsigned int): The GPU instance profile ID. See ``nvmlDeviceGetGpuInstanceProfileInfo``.

    Returns:
        unsigned int: Returns remaining instance count for the profile ID.

    .. seealso:: `nvmlDeviceGetGpuInstanceRemainingCapacity`
    """
    cdef unsigned int count
    with nogil:
        __status__ = nvmlDeviceGetGpuInstanceRemainingCapacity(<Device>device, profile_id, &count)
    check_status(__status__)
    return count


cpdef intptr_t device_create_gpu_instance(intptr_t device, unsigned int profile_id) except? 0:
    """Create GPU instance.

    Args:
        device (intptr_t): The identifier of the target device.
        profile_id (unsigned int): The GPU instance profile ID. See ``nvmlDeviceGetGpuInstanceProfileInfo``.

    Returns:
        intptr_t: Returns the GPU instance handle.

    .. seealso:: `nvmlDeviceCreateGpuInstance`
    """
    cdef GpuInstance gpu_instance
    with nogil:
        __status__ = nvmlDeviceCreateGpuInstance(<Device>device, profile_id, &gpu_instance)
    check_status(__status__)
    return <intptr_t>gpu_instance


cpdef intptr_t device_create_gpu_instance_with_placement(intptr_t device, unsigned int profile_id, intptr_t placement) except? 0:
    """Create GPU instance with the specified placement.

    Args:
        device (intptr_t): The identifier of the target device.
        profile_id (unsigned int): The GPU instance profile ID. See ``nvmlDeviceGetGpuInstanceProfileInfo``.
        placement (intptr_t): The requested placement. See ``nvmlDeviceGetGpuInstancePossiblePlacements_v2``.

    Returns:
        intptr_t: Returns the GPU instance handle.

    .. seealso:: `nvmlDeviceCreateGpuInstanceWithPlacement`
    """
    cdef GpuInstance gpu_instance
    with nogil:
        __status__ = nvmlDeviceCreateGpuInstanceWithPlacement(<Device>device, profile_id, <const nvmlGpuInstancePlacement_t*>placement, &gpu_instance)
    check_status(__status__)
    return <intptr_t>gpu_instance


cpdef gpu_instance_destroy(intptr_t gpu_instance):
    """Destroy GPU instance.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.

    .. seealso:: `nvmlGpuInstanceDestroy`
    """
    with nogil:
        __status__ = nvmlGpuInstanceDestroy(<GpuInstance>gpu_instance)
    check_status(__status__)


cpdef intptr_t device_get_gpu_instance_by_id(intptr_t device, unsigned int id) except? 0:
    """Get GPU instances for given instance ID.

    Args:
        device (intptr_t): The identifier of the target device.
        id (unsigned int): The GPU instance ID.

    Returns:
        intptr_t: Returns GPU instance.

    .. seealso:: `nvmlDeviceGetGpuInstanceById`
    """
    cdef GpuInstance gpu_instance
    with nogil:
        __status__ = nvmlDeviceGetGpuInstanceById(<Device>device, id, &gpu_instance)
    check_status(__status__)
    return <intptr_t>gpu_instance


cpdef object gpu_instance_get_info(intptr_t gpu_instance):
    """Get GPU instance information.

    Args:
        gpu_instance (intptr_t): The GPU instance handle.

    Returns:
        nvmlGpuInstanceInfo_t: Return GPU instance information.

    .. seealso:: `nvmlGpuInstanceGetInfo`
    """
    cdef GpuInstanceInfo info_py = GpuInstanceInfo()
    cdef nvmlGpuInstanceInfo_t *info = <nvmlGpuInstanceInfo_t *><intptr_t>(info_py._get_ptr())
    with nogil:
        __status__ = nvmlGpuInstanceGetInfo(<GpuInstance>gpu_instance, info)
    check_status(__status__)
    return info_py


cpdef object gpu_instance_get_compute_instance_profile_info_v(intptr_t gpu_instance, unsigned int profile, unsigned int eng_profile):
    """Versioned wrapper around ``nvmlGpuInstanceGetComputeInstanceProfileInfo`` that accepts a versioned ``nvmlComputeInstanceProfileInfo_v2_t`` or later output structure.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        profile (unsigned int): One of the NVML_COMPUTE_INSTANCE_PROFILE_*.
        eng_profile (unsigned int): One of the NVML_COMPUTE_INSTANCE_ENGINE_PROFILE_*.

    Returns:
        nvmlComputeInstanceProfileInfo_v2_t: Returns detailed profile information.

    .. seealso:: `nvmlGpuInstanceGetComputeInstanceProfileInfoV`
    """
    cdef ComputeInstanceProfileInfo_v2 info_py = ComputeInstanceProfileInfo_v2()
    cdef nvmlComputeInstanceProfileInfo_v2_t *info = <nvmlComputeInstanceProfileInfo_v2_t *><intptr_t>(info_py._get_ptr())
    info.version = sizeof(nvmlComputeInstanceProfileInfo_v2_t) | (2 << 24)
    with nogil:
        __status__ = nvmlGpuInstanceGetComputeInstanceProfileInfoV(<GpuInstance>gpu_instance, profile, eng_profile, info)
    check_status(__status__)
    return info_py


cpdef unsigned int gpu_instance_get_compute_instance_remaining_capacity(intptr_t gpu_instance, unsigned int profile_id) except? 0:
    """Get compute instance profile capacity.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        profile_id (unsigned int): The compute instance profile ID. See ``nvmlGpuInstanceGetComputeInstanceProfileInfo``.

    Returns:
        unsigned int: Returns remaining instance count for the profile ID.

    .. seealso:: `nvmlGpuInstanceGetComputeInstanceRemainingCapacity`
    """
    cdef unsigned int count
    with nogil:
        __status__ = nvmlGpuInstanceGetComputeInstanceRemainingCapacity(<GpuInstance>gpu_instance, profile_id, &count)
    check_status(__status__)
    return count


cpdef object gpu_instance_get_compute_instance_possible_placements(intptr_t gpu_instance, unsigned int profile_id):
    """Get compute instance placements.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        profile_id (unsigned int): The compute instance profile ID. See ``nvmlGpuInstanceGetComputeInstanceProfileInfo``.

    .. seealso:: `nvmlGpuInstanceGetComputeInstancePossiblePlacements`
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlGpuInstanceGetComputeInstancePossiblePlacements(<GpuInstance>gpu_instance, profile_id, NULL, <unsigned int*>count)
    check_status_size(__status__)
    cdef ComputeInstancePlacement placements = ComputeInstancePlacement(count[0])
    cdef nvmlComputeInstancePlacement_t *placements_ptr = <nvmlComputeInstancePlacement_t *><intptr_t>(placements._get_ptr())
    if count[0] == 0:
        return placements
    with nogil:
        __status__ = nvmlGpuInstanceGetComputeInstancePossiblePlacements(<GpuInstance>gpu_instance, profile_id, placements_ptr, <unsigned int*>count)
    check_status(__status__)
    return placements


cpdef intptr_t gpu_instance_create_compute_instance(intptr_t gpu_instance, unsigned int profile_id) except? 0:
    """Create compute instance.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        profile_id (unsigned int): The compute instance profile ID. See ``nvmlGpuInstanceGetComputeInstanceProfileInfo``.

    Returns:
        intptr_t: Returns the compute instance handle.

    .. seealso:: `nvmlGpuInstanceCreateComputeInstance`
    """
    cdef ComputeInstance compute_instance
    with nogil:
        __status__ = nvmlGpuInstanceCreateComputeInstance(<GpuInstance>gpu_instance, profile_id, &compute_instance)
    check_status(__status__)
    return <intptr_t>compute_instance


cpdef intptr_t gpu_instance_create_compute_instance_with_placement(intptr_t gpu_instance, unsigned int profile_id, intptr_t placement) except? 0:
    """Create compute instance with the specified placement.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        profile_id (unsigned int): The compute instance profile ID. See ``nvmlGpuInstanceGetComputeInstanceProfileInfo``.
        placement (intptr_t): The requested placement. See ``nvmlGpuInstanceGetComputeInstancePossiblePlacements``.

    Returns:
        intptr_t: Returns the compute instance handle.

    .. seealso:: `nvmlGpuInstanceCreateComputeInstanceWithPlacement`
    """
    cdef ComputeInstance compute_instance
    with nogil:
        __status__ = nvmlGpuInstanceCreateComputeInstanceWithPlacement(<GpuInstance>gpu_instance, profile_id, <const nvmlComputeInstancePlacement_t*>placement, &compute_instance)
    check_status(__status__)
    return <intptr_t>compute_instance


cpdef compute_instance_destroy(intptr_t compute_instance):
    """Destroy compute instance.

    Args:
        compute_instance (intptr_t): The compute instance handle.

    .. seealso:: `nvmlComputeInstanceDestroy`
    """
    with nogil:
        __status__ = nvmlComputeInstanceDestroy(<ComputeInstance>compute_instance)
    check_status(__status__)


cpdef intptr_t gpu_instance_get_compute_instance_by_id(intptr_t gpu_instance, unsigned int id) except? 0:
    """Get compute instance for given instance ID.

    Args:
        gpu_instance (intptr_t): The identifier of the target GPU instance.
        id (unsigned int): The compute instance ID.

    Returns:
        intptr_t: Returns compute instance.

    .. seealso:: `nvmlGpuInstanceGetComputeInstanceById`
    """
    cdef ComputeInstance compute_instance
    with nogil:
        __status__ = nvmlGpuInstanceGetComputeInstanceById(<GpuInstance>gpu_instance, id, &compute_instance)
    check_status(__status__)
    return <intptr_t>compute_instance


cpdef object compute_instance_get_info_v2(intptr_t compute_instance):
    """Get compute instance information.

    Args:
        compute_instance (intptr_t): The compute instance handle.

    Returns:
        nvmlComputeInstanceInfo_t: Return compute instance information.

    .. seealso:: `nvmlComputeInstanceGetInfo_v2`
    """
    cdef ComputeInstanceInfo info_py = ComputeInstanceInfo()
    cdef nvmlComputeInstanceInfo_t *info = <nvmlComputeInstanceInfo_t *><intptr_t>(info_py._get_ptr())
    with nogil:
        __status__ = nvmlComputeInstanceGetInfo_v2(<ComputeInstance>compute_instance, info)
    check_status(__status__)
    return info_py


cpdef unsigned int device_is_mig_device_handle(intptr_t device) except? 0:
    """Test if the given handle refers to a MIG device.

    Args:
        device (intptr_t): NVML handle to test.

    Returns:
        unsigned int: True when handle refers to a MIG device.

    .. seealso:: `nvmlDeviceIsMigDeviceHandle`
    """
    cdef unsigned int is_mig_device
    with nogil:
        __status__ = nvmlDeviceIsMigDeviceHandle(<Device>device, &is_mig_device)
    check_status(__status__)
    return is_mig_device


cpdef unsigned int device_get_gpu_instance_id(intptr_t device) except? 0:
    """Get GPU instance ID for the given MIG device handle.

    Args:
        device (intptr_t): Target MIG device handle.

    Returns:
        unsigned int: GPU instance ID.

    .. seealso:: `nvmlDeviceGetGpuInstanceId`
    """
    cdef unsigned int id
    with nogil:
        __status__ = nvmlDeviceGetGpuInstanceId(<Device>device, &id)
    check_status(__status__)
    return id


cpdef unsigned int device_get_compute_instance_id(intptr_t device) except? 0:
    """Get compute instance ID for the given MIG device handle.

    Args:
        device (intptr_t): Target MIG device handle.

    Returns:
        unsigned int: Compute instance ID.

    .. seealso:: `nvmlDeviceGetComputeInstanceId`
    """
    cdef unsigned int id
    with nogil:
        __status__ = nvmlDeviceGetComputeInstanceId(<Device>device, &id)
    check_status(__status__)
    return id


cpdef unsigned int device_get_max_mig_device_count(intptr_t device) except? 0:
    """Get the maximum number of MIG devices that can exist under a given parent NVML device.

    Args:
        device (intptr_t): Target device handle.

    Returns:
        unsigned int: Count of MIG devices.

    .. seealso:: `nvmlDeviceGetMaxMigDeviceCount`
    """
    cdef unsigned int count
    with nogil:
        __status__ = nvmlDeviceGetMaxMigDeviceCount(<Device>device, &count)
    check_status(__status__)
    return count


cpdef intptr_t device_get_mig_device_handle_by_index(intptr_t device, unsigned int ind_ex) except? 0:
    """Get MIG device handle for the given ind_ex under its parent NVML device.

    Args:
        device (intptr_t): Reference to the parent GPU device handle.
        ind_ex (unsigned int): Index of the MIG device.

    Returns:
        intptr_t: Reference to the MIG device handle.

    .. seealso:: `nvmlDeviceGetMigDeviceHandleByIndex`
    """
    cdef Device mig_device
    with nogil:
        __status__ = nvmlDeviceGetMigDeviceHandleByIndex(<Device>device, ind_ex, &mig_device)
    check_status(__status__)
    return <intptr_t>mig_device


cpdef intptr_t device_get_device_handle_from_mig_device_handle(intptr_t mig_device) except? 0:
    """Get parent device handle from a MIG device handle.

    Args:
        mig_device (intptr_t): MIG device handle.

    Returns:
        intptr_t: Device handle.

    .. seealso:: `nvmlDeviceGetDeviceHandleFromMigDeviceHandle`
    """
    cdef Device device
    with nogil:
        __status__ = nvmlDeviceGetDeviceHandleFromMigDeviceHandle(<Device>mig_device, &device)
    check_status(__status__)
    return <intptr_t>device


cpdef gpm_sample_get(intptr_t device, intptr_t gpm_sample):
    """Read a sample of GPM metrics into the provided ``gpm_sample`` buffer. After two samples are gathered, you can call nvmlGpmMetricGet on those samples to retrive metrics.

    Args:
        device (intptr_t): Device to get samples for.
        gpm_sample (intptr_t): Buffer to read samples into.

    .. seealso:: `nvmlGpmSampleGet`
    """
    with nogil:
        __status__ = nvmlGpmSampleGet(<Device>device, <GpmSample>gpm_sample)
    check_status(__status__)


cpdef gpm_mig_sample_get(intptr_t device, unsigned int gpu_instance_id, intptr_t gpm_sample):
    """Read a sample of GPM metrics into the provided ``gpm_sample`` buffer for a MIG GPU Instance.

    Args:
        device (intptr_t): Device to get samples for.
        gpu_instance_id (unsigned int): MIG GPU Instance ID.
        gpm_sample (intptr_t): Buffer to read samples into.

    .. seealso:: `nvmlGpmMigSampleGet`
    """
    with nogil:
        __status__ = nvmlGpmMigSampleGet(<Device>device, gpu_instance_id, <GpmSample>gpm_sample)
    check_status(__status__)


cpdef object gpm_query_device_support(intptr_t device):
    """Indicate whether the supplied device supports GPM.

    Args:
        device (intptr_t): NVML device to query for.

    Returns:
        nvmlGpmSupport_t: Structure to indicate GPM support ``nvmlGpmSupport_t``. Indicates GPM support per system for the supplied device.

    .. seealso:: `nvmlGpmQueryDeviceSupport`
    """
    cdef GpmSupport gpm_support_py = GpmSupport()
    cdef nvmlGpmSupport_t *gpm_support = <nvmlGpmSupport_t *><intptr_t>(gpm_support_py._get_ptr())
    gpm_support.version = 1
    with nogil:
        __status__ = nvmlGpmQueryDeviceSupport(<Device>device, gpm_support)
    check_status(__status__)
    return gpm_support_py


cpdef unsigned int gpm_query_if_streaming_enabled(intptr_t device) except? 0:
    """Get GPM stream state.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        unsigned int: Returns GPM stream state NVML_FEATURE_DISABLED or NVML_FEATURE_ENABLED.

    .. seealso:: `nvmlGpmQueryIfStreamingEnabled`
    """
    cdef unsigned int state
    with nogil:
        __status__ = nvmlGpmQueryIfStreamingEnabled(<Device>device, &state)
    check_status(__status__)
    return state


cpdef gpm_set_streaming_enabled(intptr_t device, unsigned int state):
    """Set GPM stream state.

    Args:
        device (intptr_t): The identifier of the target device.
        state (unsigned int): GPM stream state, NVML_FEATURE_DISABLED or NVML_FEATURE_ENABLED.

    .. seealso:: `nvmlGpmSetStreamingEnabled`
    """
    with nogil:
        __status__ = nvmlGpmSetStreamingEnabled(<Device>device, state)
    check_status(__status__)


cpdef object device_get_capabilities(intptr_t device):
    """Get device capabilities.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlDeviceCapabilities_v1_t: Returns GPU's capabilities.

    .. seealso:: `nvmlDeviceGetCapabilities`
    """
    cdef DeviceCapabilities_v1 caps_py = DeviceCapabilities_v1()
    cdef nvmlDeviceCapabilities_t *caps = <nvmlDeviceCapabilities_t *><intptr_t>(caps_py._get_ptr())
    caps.version = sizeof(nvmlDeviceCapabilities_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetCapabilities(<Device>device, caps)
    check_status(__status__)
    return caps_py


cpdef device_workload_power_profile_clear_requested_profiles(intptr_t device, intptr_t requested_profiles):
    """Clear Requested Performance Profiles.

    Args:
        device (intptr_t): The identifier of the target device.
        requested_profiles (intptr_t): Reference to struct ``nvmlWorkloadPowerProfileRequestedProfiles_v1_t``.

    .. seealso:: `nvmlDeviceWorkloadPowerProfileClearRequestedProfiles`
    """
    with nogil:
        __status__ = nvmlDeviceWorkloadPowerProfileClearRequestedProfiles(<Device>device, <nvmlWorkloadPowerProfileRequestedProfiles_t*>requested_profiles)
    check_status(__status__)


cpdef device_power_smoothing_activate_preset_profile(intptr_t device, intptr_t profile):
    """Activiate a specific preset profile for datacenter power smoothing. The API only sets the active preset profile based on the input profileId, and ignores the other parameters of the structure. Requires root/admin permissions.

    Args:
        device (intptr_t): The identifier of the target device.
        profile (intptr_t): Reference to ``nvmlPowerSmoothingProfile_v1_t``. Note that only ``profile->profileId`` is used and the rest of the structure is ignored.

    .. seealso:: `nvmlDevicePowerSmoothingActivatePresetProfile`
    """
    with nogil:
        __status__ = nvmlDevicePowerSmoothingActivatePresetProfile(<Device>device, <nvmlPowerSmoothingProfile_t*>profile)
    check_status(__status__)


cpdef device_power_smoothing_update_preset_profile_param(intptr_t device, intptr_t profile):
    """Update the value of a specific profile parameter contained within ``nvmlPowerSmoothingProfile_v1_t``. Requires root/admin permissions.

    Args:
        device (intptr_t): The identifier of the target device.
        profile (intptr_t): Reference to ``nvmlPowerSmoothingProfile_v1_t`` struct.

    .. seealso:: `nvmlDevicePowerSmoothingUpdatePresetProfileParam`
    """
    with nogil:
        __status__ = nvmlDevicePowerSmoothingUpdatePresetProfileParam(<Device>device, <nvmlPowerSmoothingProfile_t*>profile)
    check_status(__status__)


cpdef device_power_smoothing_set_state(intptr_t device, intptr_t state):
    """Enable or disable the Power Smoothing Feature. Requires root/admin permissions.

    Args:
        device (intptr_t): The identifier of the target device.
        state (intptr_t): Reference to ``nvmlPowerSmoothingState_v1_t``.

    .. seealso:: `nvmlDevicePowerSmoothingSetState`
    """
    with nogil:
        __status__ = nvmlDevicePowerSmoothingSetState(<Device>device, <nvmlPowerSmoothingState_t*>state)
    check_status(__status__)


cpdef object device_get_addressing_mode(intptr_t device):
    """Get the addressing mode for a given GPU. Addressing modes can be one of:.

    Args:
        device (intptr_t): The device handle.

    Returns:
        nvmlDeviceAddressingMode_v1_t: Pointer to addressing mode of the device.

    .. seealso:: `nvmlDeviceGetAddressingMode`
    """
    cdef DeviceAddressingMode_v1 mode_py = DeviceAddressingMode_v1()
    cdef nvmlDeviceAddressingMode_t *mode = <nvmlDeviceAddressingMode_t *><intptr_t>(mode_py._get_ptr())
    mode.version = sizeof(nvmlDeviceAddressingMode_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetAddressingMode(<Device>device, mode)
    check_status(__status__)
    return mode_py


cpdef object device_get_repair_status(intptr_t device):
    """Get the repair status for TPC/Channel repair.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlRepairStatus_v1_t: Reference to ``nvmlRepairStatus_t``.

    .. seealso:: `nvmlDeviceGetRepairStatus`
    """
    cdef RepairStatus_v1 repair_status_py = RepairStatus_v1()
    cdef nvmlRepairStatus_t *repair_status = <nvmlRepairStatus_t *><intptr_t>(repair_status_py._get_ptr())
    repair_status.version = sizeof(nvmlRepairStatus_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetRepairStatus(<Device>device, repair_status)
    check_status(__status__)
    return repair_status_py


cpdef object device_get_power_mizer_mode_v1(intptr_t device):
    """Retrieves current power mizer mode on this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlDevicePowerMizerModes_v1_t: Reference in which to return the power mizer mode.

    .. seealso:: `nvmlDeviceGetPowerMizerMode_v1`
    """
    cdef DevicePowerMizerModes_v1 power_mizer_mode_py = DevicePowerMizerModes_v1()
    cdef nvmlDevicePowerMizerModes_v1_t *power_mizer_mode = <nvmlDevicePowerMizerModes_v1_t *><intptr_t>(power_mizer_mode_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetPowerMizerMode_v1(<Device>device, power_mizer_mode)
    check_status(__status__)
    return power_mizer_mode_py


cpdef device_set_power_mizer_mode_v1(intptr_t device, intptr_t power_mizer_mode):
    """Sets the new power mizer mode.

    Args:
        device (intptr_t): The identifier of the target device.
        power_mizer_mode (intptr_t): Reference in which to set the power mizer mode.

    .. seealso:: `nvmlDeviceSetPowerMizerMode_v1`
    """
    with nogil:
        __status__ = nvmlDeviceSetPowerMizerMode_v1(<Device>device, <nvmlDevicePowerMizerModes_v1_t*>power_mizer_mode)
    check_status(__status__)


cpdef object device_get_pdi(intptr_t device):
    """Retrieves the Per Device Identifier (PDI) associated with this device.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlPdi_v1_t: Reference to the caller-provided structure to return the GPU PDI.

    .. seealso:: `nvmlDeviceGetPdi`
    """
    cdef Pdi_v1 pdi_py = Pdi_v1()
    cdef nvmlPdi_t *pdi = <nvmlPdi_t *><intptr_t>(pdi_py._get_ptr())
    pdi.version = sizeof(nvmlPdi_v1_t) | (1 << 24)
    with nogil:
        __status__ = nvmlDeviceGetPdi(<Device>device, pdi)
    check_status(__status__)
    return pdi_py


cpdef device_read_write_prm_v1(intptr_t device, intptr_t buffer):
    """Read or write a GPU PRM register. The input is assumed to be in TLV format in network byte order.

    Args:
        device (intptr_t): Identifer of target GPU device.
        buffer (intptr_t): Structure holding the input data in TLV format as well as the PRM register contents in TLV format (in the case of a successful read operation). Note: the input data and any returned data shall be in network byte order.

    .. seealso:: `nvmlDeviceReadWritePRM_v1`
    """
    with nogil:
        __status__ = nvmlDeviceReadWritePRM_v1(<Device>device, <nvmlPRMTLV_v1_t*>buffer)
    check_status(__status__)


cpdef object device_get_gpu_instance_profile_info_by_id_v(intptr_t device, unsigned int profile_id):
    """GPU instance profile query function that accepts profile ID, instead of profile name. It accepts a versioned ``nvmlGpuInstanceProfileInfo_v2_t`` or later output structure.

    Args:
        device (intptr_t): The identifier of the target device.
        profile_id (unsigned int): One of the profile IDs.

    Returns:
        nvmlGpuInstanceProfileInfo_v2_t: Returns detailed profile information.

    .. seealso:: `nvmlDeviceGetGpuInstanceProfileInfoByIdV`
    """
    cdef GpuInstanceProfileInfo_v2 info_py = GpuInstanceProfileInfo_v2()
    cdef nvmlGpuInstanceProfileInfo_v2_t *info = <nvmlGpuInstanceProfileInfo_v2_t *><intptr_t>(info_py._get_ptr())
    info.version = sizeof(nvmlGpuInstanceProfileInfo_v3_t) | (3 << 24)
    with nogil:
        __status__ = nvmlDeviceGetGpuInstanceProfileInfoByIdV(<Device>device, profile_id, info)
    check_status(__status__)
    return info_py


cpdef object device_get_unrepairable_memory_flag_v1(intptr_t device):
    """Get the unrepairable memory flag for a given GPU.

    Args:
        device (intptr_t): The identifier of the target device.

    Returns:
        nvmlUnrepairableMemoryStatus_v1_t: Reference to ``nvmlUnrepairableMemoryStatus_v1_t``.

    .. seealso:: `nvmlDeviceGetUnrepairableMemoryFlag_v1`
    """
    cdef UnrepairableMemoryStatus_v1 unrepairable_memory_status_py = UnrepairableMemoryStatus_v1()
    cdef nvmlUnrepairableMemoryStatus_v1_t *unrepairable_memory_status = <nvmlUnrepairableMemoryStatus_v1_t *><intptr_t>(unrepairable_memory_status_py._get_ptr())
    with nogil:
        __status__ = nvmlDeviceGetUnrepairableMemoryFlag_v1(<Device>device, unrepairable_memory_status)
    check_status(__status__)
    return unrepairable_memory_status_py


cpdef device_read_prm_counters_v1(intptr_t device, intptr_t counter_list):
    """Read a list of GPU PRM Counters.

    Args:
        device (intptr_t): Identifer of target GPU device.
        counter_list (intptr_t): Structure holding the input parameters as well as the retrieved counter values.

    .. seealso:: `nvmlDeviceReadPRMCounters_v1`
    """
    with nogil:
        __status__ = nvmlDeviceReadPRMCounters_v1(<Device>device, <nvmlPRMCounterList_v1_t*>counter_list)
    check_status(__status__)


cpdef device_set_rusd_settings_v1(intptr_t device, intptr_t settings):
    """Set Read-only user shared data (RUSD) settings for GPU. Requires root/admin permissions.

    Args:
        device (intptr_t): The identifier of the target device.
        settings (intptr_t): Reference to nvmlRusdSettings_t struct.

    .. seealso:: `nvmlDeviceSetRusdSettings_v1`
    """
    with nogil:
        __status__ = nvmlDeviceSetRusdSettings_v1(<Device>device, <nvmlRusdSettings_v1_t*>settings)
    check_status(__status__)


cpdef object system_get_topology_gpu_set(unsigned int cpuNumber):
    """Retrieve the set of GPUs that have a CPU affinity with the given CPU number

    Args:
        cpuNumber (unsigned int): The CPU number

    Returns:
        array: An array of device handles for GPUs found with affinity to  cpuNumber
    """
    cdef unsigned int[1] count = [0]
    with nogil:
        __status__ = nvmlSystemGetTopologyGpuSet(cpuNumber, <unsigned int*>count, NULL)
    check_status_size(__status__)
    if count[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(intptr_t), format="i", mode="c")[:0]
    cdef view.array deviceArray = view.array(shape=(count[0],), itemsize=sizeof(intptr_t), format="i", mode="c")
    with nogil:
        __status__ = nvmlSystemGetTopologyGpuSet(cpuNumber, <unsigned int*>count, <nvmlDevice_t *>deviceArray.data)
    check_status(__status__)
    return deviceArray


cpdef str system_get_driver_branch():
    """Retrieves the driver branch of the NVIDIA driver installed on the system.

    Returns:
        str: driver branch.
    """
    cdef nvmlSystemDriverBranchInfo_t info
    # Calculation copied from the macro NVML_STRUCT_VERSION in nvml.h
    # Needs to be updated if the version of the nvmlSystemDriverBranchInfo_t
    # struct changes in the future.
    info.version = sizeof(nvmlSystemDriverBranchInfo_v1_t) | (1 << 24)
    cdef unsigned int length = 80
    with nogil:
        __status__ = nvmlSystemGetDriverBranch(&info, length)
    check_status(__status__)
    return cpython.PyUnicode_FromString(info.branch)


cpdef object unit_get_devices(intptr_t unit):
    """Retrieves the set of GPU devices that are attached to the specified unit.

    Args:
        unit (Unit): The identifier of the target unit.

    Returns:
        array: An array of device handles for GPUs attached to the unit.
    """
    cdef unsigned int[1] deviceCount = [0]
    with nogil:
        __status__ = nvmlUnitGetDevices(<nvmlUnit_t *>unit, <unsigned int*>deviceCount, NULL)
    check_status_size(__status__)
    if deviceCount[0] == 0:
        return view.array(shape=(1,), itemsize=sizeof(intptr_t), format="i", mode="c")[:0]
    cdef view.array deviceArray = view.array(shape=(deviceCount[0],), itemsize=sizeof(intptr_t), format="i", mode="c")
    with nogil:
        __status__ = nvmlUnitGetDevices(<nvmlUnit_t *>unit, <unsigned int*>deviceCount, <nvmlDevice_t *>deviceArray.data)
    check_status(__status__)
    return deviceArray


cpdef object device_get_topology_nearest_gpus(intptr_t device, unsigned int level):
    """Retrieve the set of GPUs that are nearest to a given device at a specific interconnectivity level

    Args:
        device (Device): The identifier of the first device
        level (GpuTopo